/* $Id: plot.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include <time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "xfinans.h"
#include "plotp.h"
#include "plot.h"
#include "post.h"
#include "gregor.h"
#include "xfError.h"
#include "konto.h"
#include "country.h"
#include "str.h"
#include "window.h"
#include "datoPrint.h"
#include "date.h"
#include "focus.h"

#define CHARW 6
#define PLT_FILE "fplot.plt"
#define PLOT_TYPE "steps"    /* steps, lines, points  etc */

#undef BUTW
#define BUTW 65

static Widget plotShell, plotForm, 
  plot1Label, plot2Label, 
  plot1In, plot2In,
  plotOk, plotAdd, plotAvg, plotCancel;

static int active=0;

static int activeGnuplot=0;
FILE *gnuplot;

long currentFra=0, currentTil=0;
int antalGrafer=0;

char file[MAX_KONTI][KONTO_NAME_LENGTH+15];

void createPlotWidgets(void) {
  static int done=0;
  
  if(done)
    return;
  done=1;

  plotShell = XtVaCreatePopupShell (
				     "plotShell",
				     transientShellWidgetClass,
				     topLevel,
				     XtNtitle, PLOT_TITLE,
				     NULL );
  
  plotForm = XtVaCreateManagedWidget(
				   "plotForm",
				   formWidgetClass,
				   plotShell,
				   NULL);
  
  plot1Label = XtVaCreateManagedWidget(
				     "plot1Label",
				     labelWidgetClass,
				     plotForm,
				     XtNlabel, FROM_DATE ,
				     NULL);

  plot1In = XtVaCreateManagedWidget(
				    "plot1In",
				    asciiTextWidgetClass,
				    plotForm,
				    XtNeditType, XawtextEdit,
				    XtNwidth, DATEWIDTH,
				    XtNfromHoriz, plot1Label,
				    NULL);

  plot2Label = XtVaCreateManagedWidget(
				     "plot2Label",
				     labelWidgetClass,
				     plotForm,
				     XtNlabel, TO_DATE,
				     XtNfromVert, plot1Label,
				     NULL);

  plot2In = XtVaCreateManagedWidget(
				    "plot2In",
				    asciiTextWidgetClass,
				    plotForm,
				    XtNeditType, XawtextEdit,
				    XtNwidth, DATEWIDTH,
				    XtNfromHoriz, plot2Label,
				    XtNfromVert, plot1Label,
				    NULL);

  plotAdd = XtVaCreateManagedWidget(
				    "plotAdd",
				    commandWidgetClass,
				    plotForm,
				    XtNlabel, PLOT_LABEL,
				    XtNwidth, BUTW,
				    XtNfromVert, plot2Label,
				    NULL);

  plotOk = XtVaCreateManagedWidget(
				   "plotOk",
				   commandWidgetClass,
				   plotForm,
				   XtNlabel, RESET,
				   XtNwidth, BUTW,
				   XtNfromVert, plot2Label,
				   XtNfromHoriz, plotAdd,
				   NULL);

  plotAvg = XtVaCreateManagedWidget(
				    "plotAvg",
				    commandWidgetClass,
				    plotForm,
				    XtNlabel, AVERAGE,
				    XtNwidth, BUTW,
				    XtNfromVert, plotOk,
				    NULL);

  plotCancel = XtVaCreateManagedWidget(
				    "plotCancel",
				    commandWidgetClass,
				    plotForm,
				    XtNlabel, CLOSE,
				    XtNwidth, BUTW,
				    XtNfromVert, plotOk,
				    XtNfromHoriz, plotAvg,
				    NULL);
  
  saveFocusInfo(plot1In, plot2In, plotShell, plotAdd, 1);
  saveFocusInfo(plot2In, plot1In, plotShell, plotAdd, 0);
  
  addPlotCallBack();
}

void addPlotCallBack(void) {
  XtAddCallback(plotOk, XtNcallback, PlotOk, topLevel);
  XtAddCallback(plotAdd, XtNcallback, PlotAdd, topLevel);
  XtAddCallback(plotAvg, XtNcallback, PlotAvg, topLevel);
  XtAddCallback(plotCancel, XtNcallback, PlotCancel, topLevel);
}

/* ========================================================== */     
char *underscore(char *s) {  /* erstat space mv. med '_' i navne, saa 
				de kan anvendes som filnavne */
  int i=0;
  while( *(s+i) ) {
    switch( *(s+i) ) {
    case ' ':
    case ',':
    case '-':
    case '*':
    case '+':
    case '?':
    case '&':
    case ';':
    case ':':
    case '/':
    case '\\':
      *(s+i)='_';
      break;
    default:
      break;
    }
    i++;
  }
  return s;
}

void PlotPopup(Widget w, XtPointer client_data, XtPointer call_data)
{
  Position x,y;
  Dimension width, height;
  String p;
  int i;
  
  if(active) {
    PlotCancel(w, client_data, call_data);
    return;
  }

  createPlotWidgets();
  
  XtTranslateCoords(topLevel,(Position)25, (Position)50,
		    &x, &y);
  
  XtVaSetValues(plotShell, XtNx, x,
		XtNy, y,
		NULL );

  active=1;

  XtPopup(plotShell, XtGrabNone);
  updateMarkWithText(PLOT_LABEL,active);
  jumpTo(plot1In);
}

void doPlot(long fra, long til) {
  FILE *p, *d;
  char *fn;
  int i;

  if( !activeGnuplot )
    return;

  if( aktKontoType()!=ALM ) {
    xfError(ERR_CANT_PLOT, NONFATAL,"can't plot");
    return;
  }

  fn=file[antalGrafer-1];

  if(fra>til && til!=0) {
    xfError(ERR_PLOT_DATE, NONFATAL,"plot");
    return;
  }

  if( (d=fopen(fn, "w"))==NULL ) {
    xfError(ERR_CANT_WRITE_FILE, NONFATAL,"can't write");
    return;
  }
  if( (p=fopen(PLT_FILE, "w"))==NULL ) {
    xfError(ERR_CANT_WRITE_FILE, NONFATAL,"can't write");
    fclose(d);
    return;
  }

  if( writePlotData(fra,til,d)==0 ) {  
    fclose(d);   /* hvis ingen data */
    fclose(p);
    if(antalGrafer>0)
      antalGrafer--;
    xfError(ERR_NO_PLOT_DATA, NONFATAL,"plot");
    return;
  }

  fprintf(p, "set xtic 0,30\nset xlabel \"%s\"\n", DAYS);
  fprintf(p, "plot '%s' with %s %d", file[0], PLOT_TYPE, 1);
  for(i=1; i<antalGrafer; i++)
    fprintf(p, ", '%s' with %s %d", file[i], PLOT_TYPE, i+1);

  fprintf(p, "\n");

  fclose(d);
  fclose(p);

  fprintf(gnuplot, "load \"%s\"\n", PLT_FILE);
  fflush(gnuplot);

  return;
}

void addPlot(int type) {
  if( !active || !activeGnuplot ) {
    return;
  }
  if( antalGrafer>=MAX_KONTI-1 )
    return;
  if( aktKontoType()!=ALM ) {
    xfError(ERR_CANT_PLOT, NONFATAL, "can't plot");
    return;
  }

  if( type==BALANCE )
    sprintf(file[antalGrafer], "%s.%d", getKontoName(aktKonto()), antalGrafer+1);
  else
    sprintf(file[antalGrafer], "%s_avg.%d", getKontoName(aktKonto()), antalGrafer+1);

  underscore(file[antalGrafer]);

  antalGrafer++;

  if( type==BALANCE )
    doPlot(currentFra, currentTil);
}

void PlotOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  long f, t;
  String p;
  char text[256];
  int i;

           /* first remove existing plot files */
  for(i=0; i<antalGrafer; i++) {
    unlink(file[i]);
  }

  antalGrafer=0;
  if(aktKonto()<0) {
    return;
  }

  sprintf(file[antalGrafer], "%s.%d", getKontoName(aktKonto()), antalGrafer+1);
  underscore(file[antalGrafer]);
  antalGrafer++;

  XtVaGetValues(plot1In, 
                XtNstring, &p,
                NULL); 

  zeroAddStrncpy(text,p,255);
  if( strlen(text)>0 )
    f=parseDate(text);
  else
    f=0;

  XtVaGetValues(plot2In, 
                XtNstring, &p,
                NULL); 

  zeroAddStrncpy(text,p,255);

  if( strlen(text)>0 )
    t=parseDate(text);
  else
    t=0;

  if( !activeGnuplot ) {
    if( (gnuplot=popen("gnuplot", "w"))==NULL ) {
      xfError(ERR_NO_GNUPLOT, NONFATAL, "no gnuplot");
      return;
    } else 
      activeGnuplot=1;
  }

  currentFra=f; currentTil=t;
  doPlot(f,t);
}

void PlotAdd(Widget w, XtPointer client_data, XtPointer call_data) {
  if( antalGrafer==0 )
    PlotOk(w,client_data,call_data);
  else
    addPlot(BALANCE);
}

void lukGnuplot(void) {
  int i;
  
  for(i=0; i<antalGrafer; i++) {
    unlink(file[i]);
  }

  if(activeGnuplot) {
    fprintf(gnuplot, "exit\n");
    fclose(gnuplot);
    activeGnuplot=0;
  }
}

void PlotCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  lukGnuplot();
  active=0;
  antalGrafer=0;
  XtPopdown(plotShell);
  updateMarkWithText(PLOT_LABEL,active);
}

void PlotAvg(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int f,t;
  String p;
  char text[256];
  double avg;

  XtVaGetValues(plot1In, 
                XtNstring, &p,
                NULL); 

  zeroAddStrncpy(text,p,255);
  if( strlen(text)>0 )
    f=parseDate(text);
  else
    f=0;

  XtVaGetValues(plot2In, 
                XtNstring, &p,
                NULL); 

  zeroAddStrncpy(text,p,255);

  if( strlen(text)>0 )
    t=parseDate(text);
  else
    t=0;

  if(f>=t || f==0 || t==0 ) {
    xfError(ERR_AVG_DATE, NONFATAL,"avg.");
    return;
  }

  avg=computeAverage(f,t);

  if( antalGrafer==0 )
    PlotOk(w,client_data,call_data);

  addPlot(AVG);
  doPlotAvg(f,t,avg);
}

void doPlotAvg(long fra, long til, double avg) {
  FILE *p, *d;
  char *fn;
  int i;

  if( !activeGnuplot )
    return;

  fn=file[antalGrafer-1];

  if(fra>til || til==0 || fra==0) {
    xfError(ERR_AVG_DATE, NONFATAL,"avg.");
    return;
  }

  if( (d=fopen(fn, "w"))==NULL ) {
    xfError(ERR_CANT_WRITE_FILE, NONFATAL,"can't write");
    return;
  }
  if( (p=fopen(PLT_FILE, "w"))==NULL ) {
    xfError(ERR_CANT_WRITE_FILE, NONFATAL,"can't write");
    fclose(d);
    return;
  }

  fprintf(d, "%d %9.2f\n", 0, avg);
  fprintf(d, "%d %9.2f\n", rentedage(fra,til), avg);

  fprintf(p, "set xtic 0,30\nset xlabel \"%s\"\n", DAYS);
  fprintf(p, "plot '%s' with %s %d", file[0], PLOT_TYPE, 1);
  for(i=1; i<antalGrafer; i++)
    fprintf(p, ", '%s' with %s %d", file[i], PLOT_TYPE, i+1);

  fprintf(p, "\n");

  fclose(d);
  fclose(p);

  fprintf(gnuplot, "load \"%s\"\n", PLT_FILE);
  fflush(gnuplot);

  return;
}
