/* $Id: opretKonto.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include <time.h>
#include <string.h>

#include "opretKontop.h"
#include "opretKonto.h"
#include "konto.h"
#include "xfinans.h"
#include "xfError.h"
#include "country.h"
#include "str.h"
#include "datoPrint.h"
#include "date.h"
#include "focus.h"

void createOpretKontoWidgets(void) {
  static int done=0;
  
  if(done)
    return;
  done=1;

  opretKonShell = XtVaCreatePopupShell (
					"opretKonShell",
					transientShellWidgetClass,
					topLevel,
					XtNtitle, CREATE_ACCOUNT_TITLE,
					NULL );
  
  opretKonForm = XtVaCreateManagedWidget(
				   "opretKonForm",
				   formWidgetClass,
				   opretKonShell,
				   NULL);
  
  opretKonFilLabel = XtVaCreateManagedWidget(
					   "opretKonFilLabel",
					   labelWidgetClass,
					   opretKonForm,
					   XtNlabel, FILE_NAME,
					   NULL);
  
  opretKonFilIn = XtVaCreateManagedWidget(
					  "opretKonFilIn",
					  asciiTextWidgetClass,
					  opretKonForm,
					  XtNeditType, XawtextEdit,
					  XtNwidth, 20*6+3,
					  XtNfromHoriz, opretKonFilLabel,
					  NULL);
  
  opretKonNavnLabel = XtVaCreateManagedWidget(
					    "opretKonNavnLabel",
					    labelWidgetClass,
					    opretKonForm,
					    XtNlabel, NAME,
					    XtNfromVert, opretKonFilLabel,
					    NULL);

  opretKonNavnIn = XtVaCreateManagedWidget(
					   "opretKonNavnIn",
					   asciiTextWidgetClass,
					   opretKonForm,
					   XtNeditType, XawtextEdit,
					   XtNwidth, KONTO_NAME_LENGTH*6+3,
					   XtNfromHoriz, opretKonNavnLabel,
					   XtNfromVert, opretKonFilLabel,
					   NULL);

  opretKonKnrLabel = XtVaCreateManagedWidget(
					    "opretKonKnrLabel",
					    labelWidgetClass,
					    opretKonForm,
					    XtNlabel, NUMBER,
					    XtNfromVert, opretKonNavnLabel,
					    NULL);

  opretKonKnrIn = XtVaCreateManagedWidget(
					  "opretKonKnrIn",
					  asciiTextWidgetClass,
					  opretKonForm,
					  XtNeditType, XawtextEdit,
					  XtNwidth, KONTO_NR_LENGTH*6+3,
					  XtNfromHoriz, opretKonKnrLabel,
					  XtNfromVert, opretKonNavnLabel,
					  NULL);

  opretKonOk = XtVaCreateManagedWidget(
				       "opretKonOk",
				       commandWidgetClass,
				       opretKonForm,
				       XtNfromVert, opretKonKnrLabel,
				       XtNlabel, CONFIRM_LABEL,
				       XtNwidth, BUTW,
				       NULL);
  
  saveFocusInfo(opretKonFilIn, opretKonNavnIn, opretKonShell, opretKonOk, 1);
  saveFocusInfo(opretKonNavnIn, opretKonKnrIn, opretKonShell, opretKonOk, 0);
  saveFocusInfo(opretKonKnrIn, opretKonFilIn,  opretKonShell, opretKonOk, 0);

  opretKonCancel = XtVaCreateManagedWidget(
					   "opretKonCancel",
					   commandWidgetClass,
					   opretKonForm,
					   XtNfromVert, opretKonKnrLabel,
					   XtNfromHoriz, opretKonOk,
					   XtNlabel, CANCEL_LABEL,
					   NULL);

  addOpretKontoCallBack();
}

void addOpretKontoCallBack(void) {
  XtAddCallback(opretKonCancel, XtNcallback, OpretKonCancel, topLevel);
  XtAddCallback(opretKonOk, XtNcallback, OpretKonOk, topLevel);
}

/* ========================================================== */     
void OpretKonPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Position x,y;
  Dimension width, height;

  createOpretKontoWidgets();

  XtTranslateCoords(topLevel, (Position)80, (Position)20,
		    &x, &y);
  
  XtVaSetValues(opretKonShell, XtNx, x,
		XtNy, y,
		NULL );

  XtSetSensitive(opretKonto,FALSE); 
  XtPopup(opretKonShell, XtGrabNone);
  jumpTo(opretKonFilIn);
}

void OpretKonOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  char navn[128], knr[128], fil[128];
  String p;

  XtVaGetValues(opretKonFilIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(fil,p,127);

  XtVaGetValues(opretKonNavnIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(navn,p,127);

  XtVaGetValues(opretKonKnrIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(knr,p,127);

  if( strlen(fil)==0 || (strlen(navn)==0 && strlen(knr)==0) ) {
    xfError(MUST_FILL_FIELDS, NONFATAL,"create");
    return;
  }

  XtPopdown(opretKonShell);
  XtSetSensitive(opretKonto, TRUE); 

  nyKonto(indxOfKontoSelection(),fil,navn,knr,dateString(today()));
  opdaterKontoList();
}

void OpretKonCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(opretKonShell);
  XtSetSensitive(opretKonto, TRUE); 
}
