/* $Id: konto.c,v 4.4 1996/07/20 18:07:36 lupus Exp lupus $ */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "xfinans.h"
#include "xfError.h"
#include "konto_io.h"
#include "konto.h"
#include "post.h"
#include "date.h"
#include "str.h"
#include "country.h"
#include "programConfig.h"
#include "allocmem.h"
#include "transNum.h"

static struct basale_konto_data konti[MAX_KONTI];
static int antalKonti;
static int aktuelKonto=-1;    /* index paa den valgte konto */

static char *kontoString[MAX_KONTI];   /* array af strings, der gives til
					  brugerfladen */

void init(void) {
  int i;
  antalKonti=hent_konto_data(konti);   /* indlaes data fra fil */
  for(i=0;i<MAX_KONTI;i++)
    kontoString[i]=0;
}

/*
void test(void) {
  int i;
  for(i=0; i<antalKonti; i++)
    printf("%s  %s\n", konti[i].name,konti[i].nr); 
}
*/

char **kontoStrings(void) {                     /* lav tekst at vise i
						   vinduet */
  char buf[KONTO_NAME_LENGTH+KONTO_NR_LENGTH+5];
  int i;
  freeKontoStrings();
  for(i=0;i<MAX_KONTI;i++)
    kontoString[i]=0;
  for(i=0; i<antalKonti; i++) {
    sprintf(buf, "%s  %s", konti[i].name,konti[i].nr);
    kontoString[i]=(char *)AllocateMemory(strlen(buf)+1);
    strcpy(kontoString[i], buf);
  }
  return kontoString;
}

char **currentKontoStrings() {
  return kontoString;
}

static void freeKontoStrings(void) {
  int i=0;
  while(kontoString[i])
    free(kontoString[i++]);
}

char *getKontoName(int indx) {
   return konti[indx].name;
}

char *getKontoFileName(int indx) {
   return konti[indx].file_name;
}

char *getKontoNr(int indx) {
   return konti[indx].nr;
}

/* ******** */

int getKontoIndex(char *string)
{
char **allStrings;
int index;

	allStrings = currentKontoStrings();  /* get a copy of the pointers to 
						the account strings in the 
						main window account list */
	index = 0;
	while (allStrings[index] != NULL)
	{
		/*
		printf("compare >%s< with >%s< index %i\n",allStrings[index],string,index);
		*/
		if (strcmp(allStrings[index],string) == 0)
		{
			break;
		}
		else
		{
			index++;
		}
	}
	if (allStrings[index] == NULL)
	{
		index = -1;
	}
	return(index);
}

int kontoType(int indx) 
{
#if EXPERIMENTAL
  if( strstr(konti[indx].file_name, ".akt")!=NULL )
    return AKTIE;
  if( strstr(konti[indx].file_name, ".pan")!=NULL )
    return PANTEBREV;
#endif
  return ALM;
}

int aktKontoType(void)   /* typen af den aktuelle konto */
{
  return kontoType(aktuelKonto);
}

void loadKonto(int indx) {
  aktuelKonto=indx;
  loadPoster(konti[indx].file_name);
  saveTransactionNumber(currentTransactionNumber()); 
                  /* in case we have read a file 
	  		       in the old format */
} 

void writeAllTransactionsToFile(char *filename) {
  FILE *f;
  int i;
  int prevAccount;

  if( !(f=fopen(filename,"w")) ) {
    xfError(ERR_CANT_WRITE_FILE, NONFATAL, "can't write");
    return;
  }

  prevAccount=aktuelKonto;
  for(i=0; i<antalKonti; i++) {
    loadKonto(i);
    writeTransactionsToFile(f);
  }
  fclose(f);

  aktuelKonto=prevAccount;
  if(aktuelKonto>=0)
    loadKonto(aktuelKonto);
  else
    clearPoster();
}

void saveKonto(void) {
  savePoster(konti[aktuelKonto].file_name);
}

int aktKonto(void) {
  return aktuelKonto;
}

void sletKonto(int nr) {
  int i;
  if(nr<0 || nr>=antalKonti)
    return;
  if( nr==aktuelKonto ) {
    aktuelKonto=-1;
    clearPoster();
    opdaterPostList();
  }
  for(i=nr; i<antalKonti-1; i++) {
    konti[i]=konti[i+1];
  }
  antalKonti--;
  gem_konto_data(konti, antalKonti);
}

void nyKonto(int nr, char *filnavn, char *navn, char *knr, char *dato) {
  int i, d;
  FILE *ny;

  if(antalKonti>=MAX_KONTI-1) {
    xfError(ERR_MAX_ACCOUNTS, NONFATAL,"max accounts");
    return;
  }
  if(nr<0)
    nr=antalKonti;

  if(strlen(filnavn)<1 || (strlen(navn)<1 && strlen(knr)<1) )
    return;

  if( (ny=fopen(filnavn,"r"))==NULL) {   /* hvis kontoen ikke findes i forvejen */
    if( (ny=fopen(filnavn,"w"))==NULL) {  /* hvis filen ikke kan oprettes */
      xfError(ERR_CANT_CREATE, NONFATAL,"can't create");
      return;
    }
  }
  fclose(ny);
  
  for(i=antalKonti-1; i>=nr; i--)
    konti[i+1]=konti[i];

  zeroAddStrncpy(konti[nr].file_name,filnavn,FILE_NAME_LENGTH-1);
  zeroAddStrncpy(konti[nr].name,navn,KONTO_NAME_LENGTH-1);
  zeroAddStrncpy(konti[nr].nr,knr,KONTO_NR_LENGTH-1);
  d=parseDate(dato);
  konti[nr].oprettet=year(d)*10000+month(d)*100+day(d);
  antalKonti++;
  gem_konto_data(konti, antalKonti);
}

int numberOfAccounts() {
  return antalKonti;
}
