/* $Id: focus.h,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#ifndef FOCUS_H
#define FOCUS_H

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#define FRAME_Y_OFFSET 25
#define FRAME_X_OFFSET 5
#define X_OFFSET 1
#define Y_OFFSET 12

typedef struct {
  Widget from;    /* entry field that looses focus by a "next" action 
                     happening in this field */
  Widget to;      /* entry field that receives the focus    */
  Widget root;
  Widget confirmButton; /* "button" activated upon confirm action 
			   (using XtCallCallbacks) */
  int group;      /* logical group of related entry fields  */
} focus_pair;

void initFocus();
int newGroup();
int currentGroup();
void saveFocusInfo(Widget from, Widget to, 
		   Widget root, Widget confirm, int newgroup);
void jumpNext(Widget currentField);
void jumpPrev(Widget currentField);
void jumpTo(Widget field);
void confirmAction(Widget field);
void setFocusMethod(int focusMeth);

static void setFocus(Widget root, Widget target, int group);
static focus_pair *nextField(Widget currentField);
static focus_pair *prevField(Widget currentField);

#endif /* FOCUS_H */
