/* $Id: fileView.c,v 4.3 1996/01/12 14:11:53 lupus Exp $ */

#include "fileViewp.h"
#include "fileView.h"
#include "country.h"
#include "programConfig.h"

#if CATEGORY_SUPPORT

static Widget fileViewShell, fileViewPane, fileViewBox,
  fileViewText, fileViewClose;

static int popup=0;
static int editable=0;

void createFileViewWidgets(void) {
  static int done=0;
  
  if(done)
    return;
  done=1;

  fileViewShell = XtVaCreatePopupShell (
				      "fileViewShell",
				      transientShellWidgetClass,
				      topLevel,
				      XtNtitle, "fileView",
				      NULL );
  
  fileViewPane = XtVaCreateManagedWidget(
				       "fileViewPane",
				       panedWidgetClass,
				       fileViewShell,
				       XtNheight, 340,
				       XtNwidth, 490,
				       NULL);
  
  fileViewBox = XtVaCreateManagedWidget(
				   "fileViewBox",
				   boxWidgetClass,
				   fileViewPane,
				   NULL);

  fileViewClose = XtVaCreateManagedWidget(
				     "fileViewClose",
				     commandWidgetClass,
				     fileViewBox,
				     XtNlabel, CLOSE,
				     XtNwidth, 55,
				     NULL);

  fileViewText = XtVaCreateManagedWidget(
				     "fileViewText",
				     asciiTextWidgetClass,
				     fileViewPane,
				     /*XtNeditType, XawtextRead,*/
				     XtNeditType, XawtextEdit,
				     /*XtNdisplayCaret, False,*/
				     XtNscrollVertical, XawtextScrollWhenNeeded,
				     XtNtype, XawAsciiFile,
				     XtNstring, "finans.bkd",
				     NULL);

  XtAddCallback(fileViewClose, XtNcallback, FileViewClose, topLevel);
}

/* ========================================================== */     
void FileViewPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  if( !popup ) {
    createFileViewWidgets();

    XtPopup(fileViewShell, XtGrabNone);
    popup=1;
  }
}

void FileViewClose(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  if( editable )
    XawAsciiSave(XawTextGetSource(fileViewText));
  
  XtPopdown(fileViewShell);
  popup=0;
}

void FileViewDisplay(char *filename, char *title, int allowEdit) {
  createFileViewWidgets();

  if( popup && editable )
    XawAsciiSave(XawTextGetSource(fileViewText)); /* save previous
						     contents that might 
						     have changed */

  XtVaSetValues(fileViewShell,
		XtNtitle, title,
		NULL);
  
  XtVaSetValues(fileViewText,
		XtNstring, filename,
		NULL);

  editable=allowEdit;

  if(editable) {
    XtVaSetValues(fileViewText, 
		  XtNeditType, XawtextEdit,
		  XtNdisplayCaret, True, 
		  NULL);
  }
  else {
    XtVaSetValues(fileViewText, 
		  XtNeditType, XawtextRead, 
		  XtNdisplayCaret, False, 
		  NULL);
  }

  FileViewPopup(NULL, NULL, NULL);
}

#endif
