/* $Id: datoPrint.c,v 4.12 1996/06/15 19:33:07 lupus Exp lupus $ */

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "datoPrint.h"
#include "date.h"
#include "xfError.h"
#include "config.h"
#include "country.h"

static char datoBuf[80];
extern int fourDigitYearDisplay;  /* in config.c */

char *dateString(const Date date) {
  int y,m,d;

  y=(fourDigitYearDisplay) ? year(date):year(date)%100;
  m=month(date);
  d=day(date);

  switch(get_date_format()) {
  case yymmdd:
    sprintf(datoBuf, "%02d%02d%02d", year(date)%100, m, d);
    return datoBuf;
  case ddmmyy:
    sprintf(datoBuf, "%02d%02d%02d", d, m, year(date)%100);
    return datoBuf;
  case mmddyy:
    sprintf(datoBuf, "%02d%02d%02d", m, d, year(date)%100);
    return datoBuf;
  case dd_mm_yy:
    sprintf(datoBuf, "%2d/%2d/%2d", d, m, year(date)%100);
    return datoBuf;
  case mm_dd_yy:
    sprintf(datoBuf, "%2d/%2d/%2d", m, d, year(date)%100);
    return datoBuf;
  case userdefined:
    switch(getDateOrder()) {
    case yymmdd:
      sprintf(datoBuf, getDateFormatString(), y, m, d);
      break;
    case ddmmyy:
      sprintf(datoBuf, getDateFormatString(), d, m, y);
      break;
    case mmddyy:
      sprintf(datoBuf, getDateFormatString(), m, d, y); 
      break;
    }
    return datoBuf;
  }
}

Date parseDate(char *datestring) {
  Date res;
  int y, m, d;
  switch(get_date_format()) {
  case yymmdd:
    sscanf(datestring, "%02d%02d%02d", &y, &m, &d); 
    break;
  case ddmmyy:
    sscanf(datestring, "%02d%02d%02d", &d, &m, &y); 
    break;
  case mmddyy:
    sscanf(datestring, "%02d%02d%02d", &m, &d, &y); 
    break;
  case dd_mm_yy:
    sscanf(datestring, "%02d/%02d/%02d", &d, &m, &y); 
    break;
  case mm_dd_yy:
    sscanf(datestring, "%02d/%02d/%02d", &m, &d, &y); 
    break;
  case userdefined:
    switch(getDateOrder()) {
    case yymmdd:
      sscanf(datestring, getDateFormatString(), &y, &m, &d); 
      break;
    case ddmmyy:
      sscanf(datestring, getDateFormatString(), &d, &m, &y); 
      break;
    case mmddyy:
      sscanf(datestring, getDateFormatString(), &m, &d, &y); 
      break;
    }
    break;
  }
  if(y<0) y=0; /* just to take care of some of the worst results */
  if(m<0) m=0; /*  of a mismatch in format/input to sscanf       */
  if(d<0) d=0;

  res=makedate(y,m,d);
  
  if(res==0)
    xfError(WARN_STRANGE_DATE, NONFATAL, "strange date");
  return res;
}

char *datoPrint(void) {
  char buf[80];

  zeroAddStrncpy(buf, dateString(today()), 79);
  
  sprintf(datoBuf, "Ver 5.9      %s", buf);
  return datoBuf;
}


/* Versioner: 
                  Prae-versionsnummer: Foerste xfinans er udviklet
		  i juleferien 1993, dele af koden er overtaget direkte fra
		  DOS-version 4.4 (bl.a. datastrukturer, fil-I/O, 
		  renteberegning mv.)
   931231   1.1   Initiel version. Opret og Slet konto er indtil videre kun
                  implementeret som dummy-knapper.
   940102   1.2   Mindre forbedringer, ny post kan gives start-vaerdi, danske
                  bogstaver kan "indtastes".
   940104   1.3   Slet alt-knap paa postering-popup. 
                  Overfoer kan gives startvaerdi.
                  Dags-dato knap tilfoejet postering-popup
   940105   1.4   Udskriv check-funktion implementeret
   940115   1.5   Dags dato og versionsnummer skrives i hjoernet, 
                  fancy icon lavet.
                  Opret og Slet konto er nu implementeret.
   940117   1.6   Alle poster/skaermfuld toggle-knap tilfoejet
   940125   1.6 revision 1 "Resources" flyttet fra application-def. file
		  til koden.
   940130   1.7   Forbedring af CLIST-implementationen (bruger nu memcpy() 
                  og strcpy() -> betydelig mere effektivt)
		  Grum fejl rettet: Det var den forkerte postering, der blev
		  slettet af "ret post" i bestemte tilfaelde
   940201   1.8   Udskriv check sker nu til fil i stedet for til /dev/lp
   940303   2.0   Nyt 3D-look gennem ny version af Xaw-biblioteket (Xaw3d)
   940404   2.1   Nye kontoformer: - Pantebrev, beregning af amortisations-
                                     ydelse.
				   - Aktier, beregning af kursvaerdi og
                                     kursgevinst
		  Disse konti skelnes fra alm. konti ved extensionen 
		  paa deres filnavn (.pan hhv .akt), som dermed har 
		  faaet en semantisk betydning.
   940506   2.2   Plus/Minus knapper til dato-indtastning
   940522   2.4   Hoved-vinduet forbedret med en "pane"-tingest
   940603   2.5   Antal poster der vises tilpasses nu stoerrelsen af vinduet
   940607   2.6   Nu to versioner: Een til Postscript-udskrift, een til text
                  Text-versionen skriver til printeren via "lpr -Plp xf.txt",
		  postscript gaar stadig til filen xf.ps.
		  De to versioner bygges ved at saette POSTSCRIPT i post.c
		  til hhv 0 eller 1
   940608   2.6 revision 1   Postscript-versionen skriver nu ogsaa ud, via
                             lpr -Plw xf.ps
   940612   2.7   Check-udskrivning sker nu til 'checkConfig'-fil, der via
                  Perl-scriptet 'check' kan skrives ud paa printeren
		  ('check | lpr -Praw')
   940614   2.7 revision 1   Check-script forbedret, saaledes at vi er
                             uafh. af "kartotek"-filen. At udskrive:
			     'check cconfig | lpr -Praw'.
   940615   2.8   Posterings-soegning implementeret			    
   940720   2.9   Month+/Month- knapper til dato-indtastning.
   940728   2.9 revision 1  Valgte Posteringer laegges nu i X-cut buffer 0,
                  saa de umiddelbart kan klikkes over i andre vinuder.
		  F.eks. til mit Perl-script, der kan regne posteringer sammen.
   940801   3.0   Info-popupvindue tilfjet, manualen skrevet.
   940819   3.0 revision 1  Danske bogstaver er nu helt "normale" ved 
                  indtastning, pga. tilfoejelse til app.-defaults-filen.
		  Ligeledes virker nu <delete>, <home>, <end>, <page-up>
		  og <page-down>-tasterne.
   940821   3.0 revision 2  Xfinans-logoet indsat paa udskrifter i 
                  ps-versionen
   940822   3.1   Printer-valg+PS/ascii-konfiguration-popup-vindue 
                  Forbedret PostScript-udskriftlayout.
   940825   3.1 revision 1  Paa udskrifter skrives nu i foerste linie
                  hvad kontoens saldo var foer udskriftens foerste 
		  postering.
   940903   3.2   "accelerators" tilfoejet: tasten 'q' virker nu som "hot-key"
                  for afslutning af programmet, naar tasten aktiveres et sted
		  i hovedvinduet. 
   941105   3.3   Saldo-oversigt tilfoejet
   941106   3.3 revision1  Saldo-oversigten opdateres nu ogsaa korrekt
                  i forbindelse med overfoersler.
   950101   3.4   Fejlmeddelelser vises nu i et popup-vindue.
   950103   3.5   Plot via Gnuplot
   950104   3.6   Redesign af det gamle soege-vindue (som nu er funktions-
                  vindue. Redesign af plot-kontrol-vinduet. Konti tilfoejes
		  nu kun til saldo-oversigten via "vaelg"-knappen.
		  Hotkeys til saldo-visning (s) og plot (p).
		  Der kan nu soeges paa regulaere udtryk, ikke blot ord.
   950130   3.7   Tilbage til almindelig s{\o}gning.
                  Internationalisering
		  Diverse optimeringer, oprydninger, subtile fejl rettet
   950228   4.0   Der sker nu ikke ulykker, naar der tastes <return>
                  i et input-felt. Nu ignoreres <return>; det ville vaere 
		  smart, hvis fokus kunne "warpes" til det naeste felt.
		  "Rigtig" menu tilfoejet; anvendes til at vaelge udskrift,
		  soegning, renteberegning, plot, og saldo-liste.
   950301   4.1   Soege-vinduet opdateres nu loebende, naar kontoen 
                  editeres. Dog: Naar soege- eller saldo-vinduet har
                  vaeret lukket, og derefter aabnes igen, er det ikke 
                  noedvendigvis konsistent med kontoen, foer kontoen 
		  genaabnes eller der soeges paany.
   950302   4.1 revision 1  'Alle poster' flyttet ind paa menuen - med 
                  "flueben" til at indikere aktuel tilstand.
   950304   4.1 revision 2  Forbedret robusthed - for smaa eller store
                  data skulle nu haandteres korrekt.
   950305   4.1 revision 3  Stadig bedre robusthed - alle 'malloc' kald
                  checkes nu for succes.
   950311   4.2   Menu til printer-type-valg.
   950312   4.2 revision 1  Flueben saettes nu fra starten, paa printer-
                  type-valg-menuen.   
   950316   4.3   Fejl rettet; strncpy kaldes nu via zeroAddStrncpy
   950317   4.3 revision 1  Tilrettet app-defaults file
   950318   4.3 revision 2  Forsoeger nu at leve op til PostScript DSC
   950319   4.3 revision 3  Sidenumre paa PS-prints, stoerre bundmargin.
                  Advarsel + korrekt opfoersel gives ved indtastning 
		  af >= max posteringer
   950325   4.4   Kontonummer paa udskrifter. Rename af div. funktioner i
                  clist.
   950327   4.4 revision 1  "committed" transaktioner indfoert.
   950328   4.4 revision 2  Nu fjernes temporaere plot-filer automatisk.
                            Forbedret main-menu struktur.
   950329   RCS v 2.1
   950331   4.5   Hypertext-help
   950401   4.5 revision 1  Context-sensitive help
   950403   4.6   Improved "show committed" layout
   950405   4.6 revision 1  Double click transaction to edit
   950414   4.6 revision 2  The working directory can be specified with 
                            the environment variable XFINANSDIR.
			    Transfer now works "correctly", also
			    when given a text.
   950429   4.7   Average balance can be displayed on plots
   950524   4.8   Mark indicates menu-activating buttons.
   950527   4.9   Extended configurability: Date formats, number of 
                  columns.
   950529   4.9 revision 1  Printer configuration moved to options menu.
                            Updated print layout (with respect to 
                            configurable date format and number of columns).
   950601   4.9 revision 2  Warn about "strange" date values.
   950605   5.0   Set zero feature
   950609   5.1   Header line naming the columns of the transaction list
                  User defined date format
                  Selectable currency format (number of decimals)
   950629   5.2   New date-handling functions; 4 digit years in the 
                  native date format
   950701   5.2 revision 1  Income/payment buttons
   950703   5.2 revision 2  Repeat-period on transactions
                            Transaction numbers
   950705   5.3   Keyboard controlable input focus.
   950720   5.4   Categories added - experimental state only.
                  The account-create-bug introduced in 5.2 fixed.
   950813   5.5   New transactions are now entered in the list according
                  to date (increasing), amount (decreasing), and text
                  (lexically increasing).
   950825   5.5 revision 1  Bug concerning transfer of a negative amount 
                            fixed. Compile option for signed transactions
			    in two-column mode.
   950830   5.6   Sorting function added to the search-window.
   950831   5.6 revision 1  Header lines added to search window 
                            and line-printed transaction lists.
                            Search/sort window is now updated when it's
			    (re)opened.
   950908   5.6 revision 2  Clear-buttons added to search window input fields.
   950911   5.6 revision 3  Date assumed within +/- 50 years of current date 
                            when year<100.
   951001   5.7   Recurring transactions.
   951104   5.7 revision 1  New recur.transac. file-format.
   951118   5.7 revision 2  Adjusted the alignment of the transaction
                            header.
   960109   5.8   Various improvements to the category mechanisms.
   960615   5.9   Mechanism for limiting the shown transactions to those 
                  within a given period introduced.
   960720   5.9 revision 1  "Add all" button for the balance list 
                            introduced.

   Soli Deo Gloria.

*/
