/*  $Id: date.h,v 4.3 1996/01/14 16:34:08 lupus Exp lupus $  */

/*
 * date.h
 * internal format conversion and arithmetic on date objects.
 *
 *  year, month, day <-> date conversion.
 *  date arithmatic.
 *
 * none of the code in this file depends on the external date
 * format -- that's why parseDate() is still in the datoPrint
 * section.  after figuring out the year, month and day all
 * parseDate() does is return makedate( year, month, day).
 */

#ifndef DATE_H
#define DATE_H

#define incr( a ) incrDay( (a) )	/* backward compatability */
#define decr( a ) decrDay( (a) )	/* ditto */

typedef long Date;

/*
	break date down into useful pieces.
*/

int year  ( const Date date );	/* year, including century */
int month ( const Date date );	/* 1..12 */
int day   ( const Date date );	/* 1..{28|29|30|31} */

/*
	to generate Date's from values
*/
Date makedate( int year, int month, int day );

/* 
	incr == increase
	decr == decrease
*/
Date incrDay        ( const Date date ); /* one day */
Date decrDay        ( const Date date );
Date incrWk         ( const Date date ); /* 7 days */
Date decrWk         ( const Date date );
Date incrMon        ( const Date date ); /* month, same date w/in month */
Date decrMon        ( const Date date );
Date incrEnding     ( const Date date ); /* month ending */
Date decrEnding     ( const Date date );
Date incrQuarter    ( const Date date ); /* same date + 3 months */
Date decrQuarter    ( const Date date );
Date incrQending    ( const Date date ); /* month ending + 3 months */
Date decrQending    ( const Date date );
Date incrHalfyear   ( const Date date ); /* 6 months, same date w/in month */
Date decrHalfyear   ( const Date date );
Date incrHalfending ( const Date date ); /* month ending + 6 mos */
Date decrHalfending ( const Date date );
Date incrYear       ( const Date date ); /* one year */
Date decrYear       ( const Date date );
Date incrPayday     ( const Date date ); /* 1st, 15th */
Date decrPayday     ( const Date date );


Date today( void );			/* assumes TZ set */
int this_year( void );
int this_century( void );	        /* ditto, less likely to matter */

int leapyear( const int year );	
int lastday(const Date date); /* the last day in the month of "date" */

            /* add/sub "periodLenght" "periodUnit"s to date: */
Date nextDate(Date date, int periodUnit, int periodLength);
Date prevDate(Date date, int periodUnit, int periodLength);

static long min( const long a, const long b );

#endif /*  DATE_H */

