/* Functions to provide compatibility with older X libs.
   Copyright 1998 Gene McCulley <mcculley@cuspy.com>, Cuspy Solutions, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <stdarg.h>
#include "open_app.h"
#include <X11/Shell.h>

#if XtSpecificationRelease < 6

Widget XtVaOpenApplication(XtAppContext *app_context_return,
                           String application_class,
                           XrmOptionDescRec *options,
                           Cardinal num_options,
                           int *argc_in_out,
                           String *argv_in_out,
                           String *fallback_resources,
                           WidgetClass widget_class,
                           ...)
{
  XtAppContext context;
  Display *display;
  va_list args;
  Widget shell;

  XtToolkitInitialize();
  context = XtCreateApplicationContext();
  if (app_context_return)
    *app_context_return = context;

  if (fallback_resources)
    XtAppSetFallbackResources(context, fallback_resources);

  display = XtOpenDisplay(context, NULL, NULL, application_class, options,
                          num_options, argc_in_out, argv_in_out);
  if (!display) {
    fprintf(stderr, "Failed to open the display.\n");
    exit(1);
  }

  va_start(args, widget_class);
  shell = XtVaAppCreateShell(NULL, NULL, applicationShellWidgetClass, display,
                             args);
  va_end(args);

  return shell;
}

#endif
