/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ProjectHelper {
    private static SAXParserFactory parserFactory = null;
    private Parser parser;
    private Project project;
    private File buildFile;
    private Locator locator;

    private ProjectHelper(Project project, File buildFile) {
        this.project = project;
        this.buildFile = buildFile;
    }

    private void configure(Object target, AttributeList attrs) throws BuildException {
        if (target instanceof TaskAdapter) {
            target = ((TaskAdapter)target).getProxy();
        }
        IntrospectionHelper ih = IntrospectionHelper.getHelper(target.getClass());
        int i = 0;
        while (i < attrs.getLength()) {
            String value = ProjectHelper.replaceProperties(attrs.getValue(i), this.project.getProperties());
            try {
                ih.setAttribute(this.project, target, attrs.getName(i).toLowerCase(), value);
            }
            catch (BuildException be) {
                if (attrs.getName(i).equals("id")) {
                    this.project.addReference(attrs.getValue(i), target);
                }
                be.setLocation(new Location(this.buildFile.toString(), this.locator.getLineNumber(), this.locator.getColumnNumber()));
                throw be;
            }
            ++i;
        }
    }

    public static void configureProject(Project project, File buildFile) throws BuildException {
        new ProjectHelper(project, buildFile).parse();
    }

    private static SAXParserFactory getParserFactory() {
        if (parserFactory == null) {
            parserFactory = SAXParserFactory.newInstance();
        }
        return parserFactory;
    }

    private void parse() throws BuildException {
        try {
            this.parser = ProjectHelper.getParserFactory().newSAXParser().getParser();
            this.parser.setDocumentHandler(new RootHandler());
            this.parser.parse(new InputSource(new FileReader(this.buildFile)));
        }
        catch (ParserConfigurationException exc) {
            throw new BuildException("Parser has not been configured correctly", exc);
        }
        catch (SAXParseException exc) {
            Location location = new Location(this.buildFile.toString(), exc.getLineNumber(), exc.getColumnNumber());
            Exception t = exc.getException();
            if (t instanceof BuildException) {
                BuildException be = (BuildException)t;
                if (be.getLocation() == Location.UNKNOWN_LOCATION) {
                    be.setLocation(location);
                }
                throw be;
            }
            throw new BuildException(exc.getMessage(), t, location);
        }
        catch (SAXException exc) {
            Exception t = exc.getException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(exc.getMessage(), t);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException("File \"" + this.buildFile.toString() + "\" not found");
        }
        catch (IOException exc) {
            throw new BuildException("Error reading project file", exc);
        }
    }

    public static String replaceProperties(String value, Hashtable keys) throws BuildException {
        int pos;
        StringBuffer sb = new StringBuffer();
        boolean i = false;
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                sb.append(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                sb.append('$');
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                sb.append(value.charAt(pos + 1));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new BuildException("Syntax error in prop: " + value);
            }
            String n = value.substring(pos + 2, endName);
            String v = keys.containsKey(n) ? (String)keys.get(n) : "${" + n + "}";
            sb.append(v);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            sb.append(value.substring(prev));
        }
        return sb.toString();
    }

    private class AbstractHandler
    extends HandlerBase {
        protected DocumentHandler parentHandler;

        public AbstractHandler(DocumentHandler parentHandler) {
            this.parentHandler = parentHandler;
            ProjectHelper.this.parser.setDocumentHandler(this);
        }

        public void characters(char[] buf, int start, int end) throws SAXParseException {
            String s = new String(buf, start, end).trim();
            if (s.length() > 0) {
                throw new SAXParseException("Unexpected text \"" + s + "\"", ProjectHelper.this.locator);
            }
        }

        public void endElement(String name) throws SAXException {
            ProjectHelper.this.parser.setDocumentHandler(this.parentHandler);
        }

        public void startElement(String tag, AttributeList attrs) throws SAXParseException {
            throw new SAXParseException("Unexpected element \"" + tag + "\"", ProjectHelper.this.locator);
        }
    }

    private class RootHandler
    extends HandlerBase {
        RootHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            ProjectHelper.this.locator = locator;
        }

        public void startElement(String tag, AttributeList attrs) throws SAXParseException {
            if (!tag.equals("project")) {
                throw new SAXParseException("Config file is not of expected XML type", ProjectHelper.this.locator);
            }
            new ProjectHandler(this).init(tag, attrs);
        }
    }

    private class ProjectHandler
    extends AbstractHandler {
        public ProjectHandler(DocumentHandler parentHandler) {
            super(parentHandler);
        }

        private void handleProperty(String name, AttributeList attrs) throws SAXParseException {
            new TaskHandler(this, null).init(name, attrs);
        }

        private void handleTarget(String tag, AttributeList attrs) throws SAXParseException {
            new TargetHandler(this).init(tag, attrs);
        }

        private void handleTaskdef(String name, AttributeList attrs) throws SAXParseException {
            new TaskHandler(this, null).init(name, attrs);
        }

        public void init(String tag, AttributeList attrs) throws SAXParseException {
            String def = null;
            String name = null;
            String id = null;
            String baseDir = new File(ProjectHelper.this.buildFile.getAbsolutePath()).getParent();
            int i = 0;
            while (i < attrs.getLength()) {
                String key = attrs.getName(i);
                String value = attrs.getValue(i);
                if (key.equals("default")) {
                    def = value;
                } else if (key.equals("name")) {
                    name = value;
                } else if (key.equals("id")) {
                    id = value;
                } else if (key.equals("basedir")) {
                    baseDir = value;
                } else {
                    throw new SAXParseException("Unexpected attribute \"" + attrs.getName(i) + "\"", ProjectHelper.this.locator);
                }
                ++i;
            }
            ProjectHelper.this.project.setDefaultTarget(def);
            ProjectHelper.this.project.setName(name);
            if (name != null) {
                ProjectHelper.this.project.addReference(name, ProjectHelper.this.project);
            }
            if (id != null) {
                ProjectHelper.this.project.addReference(id, ProjectHelper.this.project);
            }
            if (ProjectHelper.this.project.getProperty("basedir") != null) {
                ProjectHelper.this.project.setBasedir(ProjectHelper.this.project.getProperty("basedir"));
            } else {
                ProjectHelper.this.project.setBasedir(baseDir);
            }
        }

        public void startElement(String name, AttributeList attrs) throws SAXParseException {
            if (name.equals("taskdef")) {
                this.handleTaskdef(name, attrs);
            } else if (name.equals("property")) {
                this.handleProperty(name, attrs);
            } else if (name.equals("target")) {
                this.handleTarget(name, attrs);
            } else {
                throw new SAXParseException("Unexpected element \"" + name + "\"", ProjectHelper.this.locator);
            }
        }
    }

    private class TargetHandler
    extends AbstractHandler {
        private Target target;

        public TargetHandler(DocumentHandler parentHandler) {
            super(parentHandler);
        }

        public void init(String tag, AttributeList attrs) throws SAXParseException {
            String name = null;
            String depends = "";
            String ifCond = null;
            String unlessCond = null;
            String id = null;
            int i = 0;
            while (i < attrs.getLength()) {
                String key = attrs.getName(i);
                String value = attrs.getValue(i);
                if (key.equals("name")) {
                    name = value;
                } else if (key.equals("depends")) {
                    depends = value;
                } else if (key.equals("if")) {
                    ifCond = value;
                } else if (key.equals("unless")) {
                    unlessCond = value;
                } else if (key.equals("id")) {
                    id = value;
                } else {
                    throw new SAXParseException("Unexpected attribute \"" + key + "\"", ProjectHelper.this.locator);
                }
                ++i;
            }
            if (name == null) {
                throw new SAXParseException("target element appears without a name attribute", ProjectHelper.this.locator);
            }
            this.target = new Target();
            this.target.setName(name);
            this.target.setIf(ifCond);
            this.target.setUnless(unlessCond);
            ProjectHelper.this.project.addTarget(name, this.target);
            if (id != null && !id.equals("")) {
                ProjectHelper.this.project.addReference(id, this.target);
            }
            if (depends.length() > 0) {
                StringTokenizer tok = new StringTokenizer(depends, ",", false);
                while (tok.hasMoreTokens()) {
                    this.target.addDependency(tok.nextToken().trim());
                }
            }
        }

        public void startElement(String name, AttributeList attrs) throws SAXParseException {
            new TaskHandler(this, this.target).init(name, attrs);
        }
    }

    private class TaskHandler
    extends AbstractHandler {
        private Target target;
        private Task task;

        public TaskHandler(DocumentHandler parentHandler, Target target) {
            super(parentHandler);
            this.target = target;
        }

        public void characters(char[] buf, int start, int end) throws SAXParseException {
            String text = new String(buf, start, end).trim();
            if (text.length() == 0) {
                return;
            }
            IntrospectionHelper ih = IntrospectionHelper.getHelper(this.task.getClass());
            try {
                ih.addText(this.task, text);
            }
            catch (BuildException exc) {
                throw new SAXParseException(exc.getMessage(), ProjectHelper.this.locator, exc);
            }
        }

        public void init(String tag, AttributeList attrs) throws SAXParseException {
            this.task = ProjectHelper.this.project.createTask(tag);
            ProjectHelper.this.configure(this.task, attrs);
            this.task.setLocation(new Location(ProjectHelper.this.buildFile.toString(), ProjectHelper.this.locator.getLineNumber(), ProjectHelper.this.locator.getColumnNumber()));
            this.task.init();
            if (this.target != null) {
                this.task.setOwningTarget(this.target);
                this.target.addTask(this.task);
            }
        }

        public void startElement(String name, AttributeList attrs) throws SAXParseException {
            new NestedElementHandler(this, this.task).init(name, attrs);
        }
    }

    private class NestedElementHandler
    extends AbstractHandler {
        private DocumentHandler parentHandler;
        private Object target;
        private Object child;

        public NestedElementHandler(DocumentHandler parentHandler, Object target) {
            super(parentHandler);
            this.target = target;
        }

        public void characters(char[] buf, int start, int end) throws SAXParseException {
            String text = new String(buf, start, end).trim();
            if (text.length() == 0) {
                return;
            }
            IntrospectionHelper ih = IntrospectionHelper.getHelper(this.child.getClass());
            try {
                ih.addText(this.child, text);
            }
            catch (BuildException exc) {
                throw new SAXParseException(exc.getMessage(), ProjectHelper.this.locator, exc);
            }
        }

        public void init(String propType, AttributeList attrs) throws SAXParseException {
            Class<?> targetClass = this.target.getClass();
            IntrospectionHelper ih = IntrospectionHelper.getHelper(targetClass);
            try {
                this.child = ih.createElement(this.target, propType.toLowerCase());
                ProjectHelper.this.configure(this.child, attrs);
            }
            catch (BuildException exc) {
                throw new SAXParseException(exc.getMessage(), ProjectHelper.this.locator, exc);
            }
        }

        public void startElement(String name, AttributeList attrs) throws SAXParseException {
            new NestedElementHandler(this, this.child).init(name, attrs);
        }
    }
}

