/*
	$Id: rtconfig.h,v 1.7 1999/10/03 21:18:03 crosser Exp $

	$Log: rtconfig.h,v $
	Revision 1.7  1999/10/03 21:18:03  crosser
	First (probably) working version with new run time config parser.
	Also added listenq parameter (backlog size for listen()) and
	renamed wtest to whoson (and with man page).  Release 2.00beta1.
	
	Revision 1.6  1999/08/19 17:22:15  crosser
	Move to new config scheme (does not work yet)
	
	Revision 1.5  1999/08/09 06:27:32  crosser
	Prelimenary work to change config reader
	
	Revision 1.4  1999/07/30 23:25:09  crosser
	Automakifying clenups

	Revision 1.3  1998/07/05 19:06:15  crosser
	Fix installation

	Revision 1.2  1998/07/05 00:26:18  crosser
	Change copyright

	Revision 1.1  1998/07/01 05:01:22  crosser
	Initial revision

*/

/*
	WHAT IS IT:
		Implementation of experimental "whoson" protocol
	AUTHOR:
		Eugene G. Crosser <crosser@average.org>
	COPYRIGHT:
		Public domain
*/

/* whoson runtime configuration */

#ifndef RTCONFIG_H
#define RTCONFIG_H

#ifndef DEFAULT_CONFIG 
#define DEFAULT_CONFIG "/etc/whoson.conf"
#endif

#ifndef offsetof
#define offsetof(type, mem) ((size_t) \
	((char *)&((type *)0)->mem - (char *)(type *)0))
#endif

struct _cfgdesc {
	enum {cf_bool,cf_int,cf_addr,cf_str,cf_perm}
		cf_type;
	char    *cf_key;
	int	cf_val_offset;
	int	cf_val_size;
};

struct _cfgrec {
	char *name;
	struct _cfgdesc *cfgdesc;
	union {
		struct _evdesc (*init) (void *priv);
		int (*connector) (void *priv,char *buf);
	} root;
};

struct _servdesc {
	struct _servdesc *next;
	void *priv;
	union {
		struct _evdesc (*init) (void *priv);
		int (*connector) (void *priv,char *buf);
	} root;
};

extern struct _cfgrec wso_cfglist[];

struct _servdesc *wso_read_config(char *fn,int do_server);

#endif
