=begin
= test for WebUnit::Parser
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_parser.rb,v 1.6 2004/04/29 12:34:06 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestParser < WebUnit::TestCase

    def test_xhtml
      html = <<-EOS
      <meta value=""/>
      <meta value="">      
      <link value=""/>      
      <link value="">            
      <p class="a"/>
      <p class="b" />
      <p class="c">
      <p/>
      <p>      
      <hr/>
      <hr>      
      <area/>
      <area>
      <img src="a"/>      
      <img src="a">
      <input type="a"/>
      <input type="a">      
      EOS
      response = Response::html( html )
    end
      
    def test_nest_tables
      html = <<-EOS
      <table border=1>
        <tr><td>
          <table border=2>
            <tr><td>
            </td></tr>            
          </table>
        </td></tr>
      </table>
      EOS
      response = Response::html( html )
    end
    
  end

end
