=begin
= test for WebUnit::Cookies
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_cookie.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestCookies < WebUnit::TestCase

    def setup
      super
      Cookies::clear
    end

    def test_Cookies

      url = @urlbase + "webunit/cookie.cgi"
      response = Response::get( url )

      assert_equals( [], Cookies::list )

      form = response.form
      form.params['key'].value = 'name1'
      form.params['value'].value = 'value1'
      response = form.submit
      assert_title( 'WebUnit::Cookies', response )

      assert_equals( %w( name1 ), Cookies::list )

      response = form.submit
      assert_title( 'WebUnit::Cookies', response )

      table = response.table
      assert_equals( "name1", table.at(1,1).data )
      assert_equals( "value1", table.at(1,2).data )

      Cookies::clear
      Cookies::add( 'NAME', 'AAA' )

      response = form.submit
      assert_title( 'WebUnit::Cookies', response )

      table = response.table
      assert_equals( "NAME", table.at(1,1).data )
      assert_equals( "AAA", table.at(1,2).data )

    end

    def test_s_clear # and instance method 'clear'

      line = "name1=value1; path=/"
      hash = Cookies::update( line )
      assert_equals( %w( name1 ), Cookies::list )
      Cookies::clear
      assert_equals( [], Cookies::list )

    end

    def test_s_add # and instance method 'add'

      line = "name1=value1; path=/"
      Cookies::add( 'name1', 'value1' )
      hash = Cookies::instance.cookies[%w( name1 / )]
      assert_equals( 'name1', hash['name'] )
      assert_equals( 'value1', hash['value'] )

    end

    def test_s_list # and instance method 'list'

      line = "name1=value1; path=/"
      hash = Cookies::update( line )
      assert_equals( %w( name1 ), Cookies::list )

      line = "name2=value2; path=/aaa"
      hash = Cookies::update( line )
      assert_equals( [], %w( name1 name2 ) - Cookies::list )

    end

    def test_s_has? # and instance method 'has?'

      line = "name1=value1; path=/"
      hash = Cookies::update( line )
      assert_equals( true, Cookies::has?( 'name1' ) )
      assert_equals( false, Cookies::has?( 'name2' ) )

    end

    def test_s_update # and instance method 'update'

      line = "name1=value1; path=/"
      Cookies::update( line )
      hash = Cookies::instance.cookies[%w( name1 / )]
      assert_equals( {'name'=>'name1','value'=>'value1', 'path'=>'/' }, hash )

    end

    def test_s_header # and instance method 'header'

      line = "name1=value1; path=/aaa"
      Cookies::update( line )

      header = Cookies::header( '/aaa' )
      assert_equals( {'Cookie'=>'name1=value1'}, header )

      header = Cookies::header( '/' )
      assert_equals( {}, header )

    end

    def test_accessor

      assert_instance_of( Hash, Cookies::instance.cookies )
      Cookies::instance.cookies = {}
      assert_exception( ArgumentError ){
        Cookies::instance.cookies = nil
      }

    end

  end

end
