=begin
= test for WebUnit::assert
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_assert.rb,v 1.2 2004/02/11 04:26:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestAssert < WebUnit::TestCase

    def initialize( method, name=self.class.name )
      super
      url = @urlbase + "webunit/assert.html"
      @response = Response::get( url )
      assert_title( 'WebUnit:assert', @response )
    end

    def test_assert_urls
      assert_exception( WebUnit::AssertionFailedError ){
        assert_urls( nil, "webunit/xxxxx.html" )
      }
      assert_exception( WebUnit::AssertionFailedError ){
        assert_urls( "webunit/xxxxx.html", nil )
      }
      url = @urlbase + "webunit/test_assert.html"
      assert_urls( @urlbase + "webunit/test_assert.html", url )
      assert_urls( "webunit/test_assert.html", url )
      assert_exception( WebUnit::AssertionFailedError ){
        assert_urls( "webunit/xxxxx.html", url )
      }
      assert_exception( WebUnit::AssertionFailedError ){
        assert_urls( @urlbase + "webunit/xxxxx.html", url )
      }
      url = 'http://test/webunit/test_assert.html'
      assert_urls( 'http://test:80/webunit/test_assert.html', url )
      assert_urls( url, 'http://test:80/webunit/test_assert.html' )
    end

    def test_assert_title
      assert_title( 'WebUnit:assert', @response )
      assert_exception( WebUnit::AssertionFailedError ){
        assert_title( 'xxxxx', @response )
      }
    end

    def test_assert_input

      # text, password, file, textarea, hidden
      # submit, reset
      form = @response.forms[0]
      i = -1
      assert_input( 'name_text', 'text', 'TEXT', form.parameters[i+=1] )
      assert_exception( WebUnit::AssertionFailedError ){
        assert_input( 'xname_text', 'text', 'TEXT', form.parameters[i] )
      }
      assert_exception( WebUnit::AssertionFailedError ){
        assert_input( 'name_text', 'xtext', 'TEXT', form.parameters[i] )
      }
      assert_exception( WebUnit::AssertionFailedError ){
        assert_input( 'name_text', 'text', 'xTEXT', form.parameters[i] )
      }

      assert_input( 'name_pass', 'password', 'PASS', form.parameters[i+=1] )
      assert_input( 'name_file', 'file', nil, form.parameters[i+=1] )
      assert_input( 'name_hidden', 'hidden', 'HIDDEN', form.parameters[i+=1] )
      assert_input( 'name_area', 'textarea', "T\nA", form.parameters[i+=1] )

      assert_input( 'name_submit', 'submit', nil, form.parameters[i+=1] )
      assert_input( 'name_reset', 'reset', nil, form.parameters[i+=1] )

      # checkbox, radio
      # submit, reset
      form = @response.forms[1]
      i = -1
      assert_input( 'name_check', 'checkbox', "a", form.parameters[i+=1] )
      assert_equals( 'off', form.parameters[i].stat )
      assert_input( 'name_check', 'checkbox', "b", form.parameters[i+=1] )
      assert_equals( 'on', form.parameters[i].stat )

      assert_input( 'name_radio', 'radio', "a", form.parameters[i+=1] )
      assert_equals( 'off', form.parameters[i].stat )
      assert_input( 'name_radio', 'radio', "b", form.parameters[i+=1] )
      assert_equals( 'on', form.parameters[i].stat )

      assert_input( 'name_submit', 'submit', 'SUBMIT', form.parameters[i+=1] )
      assert_input( 'name_reset', 'reset', 'RESET', form.parameters[i+=1] )

    end

    def test_assert_select_option

      form = @response.forms[2]
      i = -1
      assert_input( 'name_select', 'select', 'bbb', form.parameters[i+=1] )

      options = form.params['name_select'].options

      assert_select_option( 'aaa', 'AAA', false, options[0] )
      assert_exception( WebUnit::AssertionFailedError ){
        assert_select_option( 'aaa', 'AAA', true, options[0] )
      }

      assert_select_option( 'bbb', 'BBB', true, options[1] )
      assert_exception( WebUnit::AssertionFailedError ){
        assert_select_option( 'aaa', 'BBB', true, options[1] )
      }
      assert_exception( WebUnit::AssertionFailedError ){
        assert_select_option( 'bbb', 'AAA', true, options[1] )
      }
      assert_exception( WebUnit::AssertionFailedError ){
        assert_select_option( 'bbb', 'BBB', false, options[1] )
      }

      assert_select_option( 'CCC', 'CCC', false, options[2] )
      assert_select_option( 'CCC', nil, false, options[2] )

      options = form.params['no_selection'].options
      assert_select_option( 'aaa', 'AAA', true, options[0] )

    end

    def test_assert_include

      elem = HtmlElem::new 'tag'
      elem.append 'xxxxx'
      assert_equals( 'xxxxx', elem.data )
      assert_include( 'xxxxx', elem )

      table = @response.tables[3]

      assert_equals( 'aaaaa', table.at(1,1).data )
      assert_include( 'aaaaa', table.at(1,1) )
      assert_exception( WebUnit::AssertionFailedError ){
        assert_include( 'aaaa', table.at(1,1) )
      }
      assert_exception( WebUnit::AssertionFailedError ){
        assert_include( 'aaaaa', table.at(1,2) )
      }

      assert_exception( WebUnit::AssertionFailedError ){
        assert_equals( 'bbbbb', table.at(1,2).data )
      }
      assert_include( 'bbbbb', table.at(1,2) )
      assert_exception( WebUnit::AssertionFailedError ){
        assert_equals( 'bbbb', table.at(1,2) )
      }

    end

    def test_assert_attrs

      hash = { 'name'=>'name1', 'size'=>'30' }
      elem = HtmlElem::new( 'tag', hash )
      assert_attrs( hash, elem )

      hash = { 'size'=>'25' }
      assert_exception( WebUnit::AssertionFailedError ){
        assert_attrs( hash, elem )
      }

    end

  end

end
