/*
 * gcstat.c -- Implementation of gc_statistics_proc for Scheme
 *
 * (C) m.b (Matthias Blume); May 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: gcstat.c,v 2.6 1994/11/12 22:20:31 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: gcstat.c,v 2.6 1994/11/12 22:20:31 blume Exp $")

# include <stdio.h>

# include "storage.h"
# include "Cont.h"
# include "Code.h"
# include "Numeric.h"
# include "Vector.h"
# include "Boolean.h"
# include "speccont.h"
# include "mode.h"
# include "except.h"

# define CLK2MS(clk) ((long) ((clk)*1000.0/CLOCKS_PER_SEC))

enum {
  HANDLER_IDX,
  N_IDX,
  MIN_IDX,
  PMIN_IDX,
  T_IDX,
  U_IDX,
  C_IDX,
  STAT_VECT_LEN
};

void MEM_gc_statistics (MEM_cnt n, MEM_cnt t, MEM_cnt u, clock_t c)
{
  void *gcmode = ScmMode (SCM_GC_STRATEGY_MODE);
  void *tmp;
  ScmVector *vect;
  static MEM_cnt previous_min = 0;
  long lclk;

  lclk = CLK2MS (c);

  if (gcmode == &ScmTrue || gcmode == NULL) {
    if (gcmode == &ScmTrue)
      fprintf (stderr, "GC: found %lu active objects in %ld Milliseconds\n"
	               "    memory usage: %lu of %lu heap elements (%lu%%)\n",
	       (unsigned long) n,
	       lclk,
	       (unsigned long) u, (unsigned long) t,
	       t == 0 ? 100 : (unsigned long) ((u * 100) / t));
    if (MEM_min_heap_size < previous_min) {
      previous_min = MEM_min_heap_size;
      reset ("Reset due to memory allocation problem");
    }
    if (2 * u > MEM_min_heap_size)
      MEM_min_heap_size = 2 * u;
  } else {
    vect = NewScmVector (STAT_VECT_LEN);
    Push (vect);
    gcmode = ScmMode (SCM_GC_STRATEGY_MODE);
    vect = PEEK ();
    vect->array [HANDLER_IDX] = gcmode;
    tmp = ScmLongToNumber (n);
    vect = PEEK ();
    vect->array [N_IDX] = tmp;
    tmp = ScmLongToNumber (MEM_min_heap_size);
    vect = PEEK ();
    vect->array [MIN_IDX] = tmp;
    tmp = ScmLongToNumber (previous_min);
    vect = PEEK ();
    vect->array [PMIN_IDX] = tmp;
    tmp = ScmLongToNumber (t);
    vect = PEEK ();
    vect->array [T_IDX] = tmp;
    tmp = ScmLongToNumber (u);
    vect = PEEK ();
    vect->array [U_IDX] = tmp;
    tmp = ScmLongToNumber (CLK2MS (c));
    vect = POP ();
    vect->array [C_IDX] = tmp;
    ScmRegisterInterrupt (SCM_VM_GC_STRAT_CONT, vect);
  }
  previous_min = MEM_min_heap_size;
}
