/*
 * contr-prim.c -- Implementation of Scheme's control features
 *
 * (C) m.b (Matthias Blume); Jun 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: contr-prim.c,v 2.7 1994/11/12 22:18:26 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: contr-prim.c,v 2.7 1994/11/12 22:18:26 blume Exp $")

# include "Cont.h"
# include "Procedure.h"
# include "Primitive.h"
# include "Promise.h"
# include "Boolean.h"
# include "Code.h"
# include "Cons.h"
# include "Vector.h"
# include "except.h"
# include "type.h"

# include "builtins.tab"

/*ARGSUSED*/
unsigned ScmPrimitiveProcedureP (unsigned argcnt)
{
  MEM_descriptor d;
  void *tmp;

  tmp = PEEK ();
  d = ScmTypeOf (tmp);
  SET_TOP (d == ScmType (Procedure) || d == ScmType (Primitive) ||
	   d == ScmType (Cont) || d == ScmType (CCont)
	   ? &ScmTrue : &ScmFalse);
  return 0;
}

unsigned ScmPrimitiveApply (unsigned argcnt)
{
  unsigned int len, i, top;
  void *tmp;

  if (argcnt < 2)
    error ("wrong argcnt to primitive procedure apply");
  /*
   * hacking... its a little bit tricky
   */
  top = ScmCC->top;
  len = ScmListLength (POS (top - argcnt));
  if (len > 1) {
    for (i = 1; i < len; i++)
      Push (NULL);
    top += len - 1;
    tmp = POS (top + 1 - argcnt - len);
    for (i = 1; i < argcnt; i++)
      POS (top - i) = POS (top + 1 - len - i);
    for (i = 0; i < len; i++) {
      POS (top - argcnt - i) = ((ScmCons *) tmp)->car;
      tmp = ((ScmCons *) tmp)->cdr;
    }
  } else if (len == 1)
    POS (top - argcnt) = ((ScmCons *) POS (top - argcnt))->car;
  else {
    for (i = argcnt; i > 1; i--)
      POS (top - i) = POS (top + 1 - i);
    ScmCC->top--;
  }
  return len + argcnt - 1;
}

static unsigned next_map_step (void)
{
  int not_empty = 0, empty = 0;
  unsigned i;
  ScmVector *vect = ScmCC->u.c.environ;

  for (i = 1; (not_empty == 0 || empty == 0)
		&& i < vect->length - 1; i++)
    if (ScmTypeOf (vect->array [i]) == ScmType (Cons))
      not_empty = 1;
    else
      empty = 1;
  if (not_empty) {
    if (empty)
      error ("mismatching lists for primitive procedure map");
    for (i = vect->length - 2; i >= 1; i--) {
      Push (((ScmCons *) vect->array [i])->car);
      vect = ScmCC->u.c.environ;
      vect->array [i] = ((ScmCons *) vect->array [i])->cdr;
    }
    Push (vect->array [0]);
    return vect->length - 1;
  } else {
    Push (ScmReverseIP2 (vect->array [vect->length - 1], &ScmNil));
    ScmRevertToFatherContinuation (1);
    return 0;
  }
}

unsigned ScmPrimitiveMap (unsigned argcnt)
{
  ScmVector *vect;
  unsigned i;

  if (argcnt < 2)
    error ("bad arg cnt to primitive procedure map");
  SCM_NEW_VECTOR (vect, argcnt + 1);
  for (i = 0; i < argcnt; i++)
    vect->array [i] = POP ();
  vect->array [i] = &ScmNil;
  ScmPushPrimitiveContinuation (vect, argcnt);
  return next_map_step ();
}

unsigned ScmPrimitiveMapC (void)
{
  ScmVector *vect;
  ScmCons *cons;

  SCM_NEW (cons, Cons);
  vect = ScmCC->u.c.environ;
  cons->car = POP ();
  cons->cdr = vect->array [vect->length - 1];
  vect->array [vect->length - 1] = cons;
  return next_map_step ();
}

static unsigned next_for_each_step (void)
{
  int not_last = 0, last = 0;
  unsigned i;
  ScmVector *vect = ScmCC->u.c.environ;
  unsigned len = vect->length;

  for (i = len - 1; i >= 1; i--) {
    Push (((ScmCons *) vect->array [i])->car);
    vect = ScmCC->u.c.environ;
    vect->array [i] = ((ScmCons *) vect->array [i])->cdr;
  }
  Push (vect->array [0]);
  vect = ScmCC->u.c.environ;
  for (i = 1; (not_last == 0 || last == 0)
		&& i < len; i++)
    if (ScmTypeOf (vect->array [i]) == ScmType (Cons))
      not_last = 1;
    else
      last = 1;
  if (not_last) {
    if (last)
      error ("mismatching lists for primitive procedure for-each");
  } else
    ScmRevertToFatherContinuation (len);
  return len;
}

unsigned ScmPrimitiveForEach (unsigned argcnt)
{
  ScmVector *vect;
  unsigned i;
  int not_empty = 0, empty = 0;

  if (argcnt < 2)
    error ("bad arg cnt to primitive procedure for-each");
  SCM_NEW_VECTOR (vect, argcnt);
  for (i = 0; i < argcnt; i++)
    vect->array [i] = POP ();
  for (i = 1; (not_empty == 0 || empty == 0) && i < argcnt; i++)
    if (ScmTypeOf (vect->array [i]) == ScmType (Cons))
      not_empty = 1;
    else
      empty = 1;
  if (not_empty) {
    if (empty)
      error ("mismatching lists for primitive procedure for-each");
    ScmPushPrimitiveContinuation (vect, argcnt);
    return next_for_each_step ();
  } else {
    Push (&ScmFalse);
    return 0;
  }
}

unsigned ScmPrimitiveForEachC (void)
{
  (void) POP ();
  return next_for_each_step ();
}

/*ARGSUSED*/
unsigned ScmPrimitiveForce (unsigned argcnt)
{
  ScmPromise *prom = PEEK ();
  ScmProcedure *proc;

  if (ScmTypeOf (prom) != ScmType (Promise))
    return 0;
  if (prom->env == &ScmTrue) {
    SET_TOP (prom->code_or_value);
    return 0;
  }
  (void) POP ();
  ScmPushPrimitiveContinuation (prom, 1);
  SCM_NEW (proc, Procedure);
  prom = ScmCC->u.c.environ;
  proc->env = prom->env;
  proc->code = prom->code_or_value;
  Push (proc);
  return 1;
}

unsigned ScmPrimitiveForceC (void)
{
  ScmPromise *prom = ScmCC->u.c.environ;

  if (prom->env == &ScmTrue)
    SET_TOP (prom->code_or_value);
  else {
    prom->code_or_value = PEEK ();
    prom->env = &ScmTrue;
  }
  ScmRevertToFatherContinuation (1);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveCallCC (unsigned argcnt)
{
  void *tmp;

  ScmPushContinuation (2);
  PUSH (ScmCC->father);
  tmp = CPOP (ScmCC->father);
  PUSH (tmp);
  ScmContSetShared (ScmCC->father);
  ScmRevertToFatherContinuation (2);
  return 2;
}
