(define (fv-functor varset-mod optutil-mod error-mod)

  (module fv-sig ()

    (use scheme-sig)
    (use ee-sig)
    (use varset-mod varset-sig)
    (use optutil-mod optutil-sig)
    (use error-mod error-sig)

    (define (fv-info exp)
      (case (ee-type exp)
	((global integrable quote) '())
	((local) (list exp))
	(else (ee-info exp))))

    ;; sets of free variables
    (define (generic-freevar exp recursive-freevar)

      (define (freevar exp)
	(define (let-label body)
	  (varset+ (varset++ (map (bindapp recursive-freevar) (car body)))
		   (varset- (recursive-freevar (cadr body))
			    (list->varset (map car (car body))))))
	(let ((body (ee-body exp)))
	  (case (ee-type exp)
	    ((quote global integrable) '())
	    ((set!) (recursive-freevar (cadr body)))
	    ((local) (list exp))
	    ((if app) (varset++ (map recursive-freevar body)))
	    ((letrec)
	     (varset- (varset+
		       (varset++ (map (bindapp recursive-freevar) (car body)))
		       (recursive-freevar (cadr body)))
		      (list->varset (map car (car body)))))
	    ((lambda)
	     (varset- (recursive-freevar (caddr body))
		      (list->varset (cadr body))))
	    ((vlambda)
	     (varset- (recursive-freevar (cadddr body))
		      (list->varset (cons (caddr body) (cadr body)))))
	    ((delay) (recursive-freevar (cadr body)))
	    ((goto) (varset++ (map recursive-freevar (cdr body))))
	    ((label) (let-label (cdr body)))
	    ((let) (let-label body))
	    (else (bug "freevar: funny expression type")))))
      (freevar exp))

    (define (freevar exp)
      (let ((r (generic-freevar exp freevar)))
	(if (or (eq? (ee-type exp) 'lambda)
		(eq? (ee-type exp) 'vlambda))
	    (ee-info! exp r))
	r))

    (define (cheap-freevar exp)
      (generic-freevar exp fv-info))))
