(define (clos-functor lgi-mod aux-mod varset-mod fv-mod optutil-mod)

  (module clos-sig ()

    (use scheme-sig)
    (use ee-sig)
    (use lgi-mod lgi-sig)
    (use aux-mod aux-sig)
    (use varset-mod varset-sig)
    (use fv-mod fv-sig)
    (use optutil-mod optutil-sig)

    (define i-ref (integrable 'ref))
    (define i-deref (integrable 'deref))
    (define i-assign (integrable 'assign))
    (define i-closure (integrable 'closure))
    (define i-get-closure (integrable 'get-closure))
    (define i-set-closure (integrable 'set-closure))

    (define (is-integrable-ref? exp)
      (and (integrable? exp)
	   (eq? (integrable-symbol exp) 'ref)))

    (define (is-ref? exp)
      (and (eq? (ee-type exp) 'app)
	   (is-integrable-ref? (car (ee-body exp)))))

    (define (is-susp? exp)
      (memv (ee-type exp) '(lambda vlambda delay)))

    (define (build-asgn e l f s new-cl)
      (define (loop l r)
	(if (pair? l)
	    (loop
	     (cdr l)
	     (let ((v (new-local s)))
	       (ee 'let
		   (list
		    (list (list v (ee 'app
				      (list i-assign
					    (caar l)
					    (new-cl (f (cadar l)))))))
		    r))))
	    r))
      (loop l e))

    (define (build-all-asgn e ref-l other-l new-cl)
      (build-asgn
       (build-asgn e ref-l ref-cont 'letrec-ref new-cl)
       other-l identity 'letrec-other new-cl))

    (define (build-refs e l)
      (if (pair? l)
	  (build-refs
	   (ee 'let
	       (list (list (list (car l)
				 (ee 'app
				     (list i-ref (ee 'quote #f)))))
		     e))
	   (cdr l))
	  e))

    (define (ref-cont e) (cadr (ee-body e)))

    (define (cl exp d-lst c-map)
      ;; exp - expression to convert
      ;; d-lst - list of locals, which now have to be DEREFed
      ;; c-map - closure-map: ((<var> <clos-var> . <idx>) ...)

      (define (loc->fetch1 l)
	(cond ((assq l c-map)
	       =>
	       (lambda (a)
		 (ee 'app
		     (list i-get-closure
			   (cadr a) (ee 'quote (cddr a))))))
	      (else l)))

      (define (fetch1->fetch2 l f1)
	(if (memq l d-lst)
	    (ee 'app (list i-deref f1))
	    f1))

      (define (same-cl exp) (cl exp d-lst c-map))

      (define (range low high)
	(do ((l '() (cons i l))
	     (i (- high 1) (- i 1)))
	    ((< i low) l)))

      (define (map-constructor fv base-l base-il base)
	(let* ((fv-il (range base (+ base (length fv))))
	       (all-l (append base-l fv))
	       (all-il (append base-il fv-il)))
	  (lambda (cv)
	    (append
	     (map (lambda (v i)
		    (cons v (cons cv i)))
		  all-l all-il)
	     c-map))))

      (define (lambda-f b f)
	(list (car b) (cadr b) (f (caddr b))))

      (define (vlambda-f b f)
	(list (car b) (cadr b) (caddr b) (f (cadddr b))))

      (define (delay-f b f)
	(list (car b) (f (cadr b))))

      (define (simple-susp t exp f)
	(let* ((cv (new-local 'closure))
	       (fv (fv-info exp))
	       (con (map-constructor fv '() '() 0))
	       (n-c-map (con cv))
	       (b (ee-body exp)))
	  (ee t
	      (cons cv
		    (cons
		     (if (eq? c-map n-c-map)
			 (ee 'quote #f)
			 (ee 'app
			     (cons i-closure
				   (cons (ee 'quote 0)
					 (map loc->fetch1 fv)))))
		     (f b (lambda (x) (cl x d-lst n-c-map))))))))

      (define (make-rec-susp rcv con n-d-lst)
	(lambda (t exp f)
	  (let* ((cv (new-local 'closure))
		 (n-c-map (con cv))
		 (b (ee-body exp)))
	    (ee t
		(cons cv
		      (cons rcv
			    (f b (lambda (x) (cl x n-d-lst n-c-map)))))))))

      (define (3-way-split bl k)	; letrec bindings
	;; * all suspensions will share a closure
	;; * ref cells will be allocated before closure creation and
	;;   initialized after
	;; * for all others there will be an implicit ref cell
	(let loop
	    ((l bl)
	     (susp-l '())
	     (ref-l '())
	     (other-l '()))
	  (cond ((not (pair? l))
		 (k susp-l ref-l other-l))
		((is-susp? (cadar l))
		 (loop (cdr l) (cons (car l) susp-l) ref-l other-l))
		((is-ref? (cadar l))
		 (loop (cdr l) susp-l (cons (car l) ref-l) other-l))
		(else
		 (loop (cdr l) susp-l ref-l (cons (car l) other-l))))))

      (case (ee-type exp)
	((local) (fetch1->fetch2 exp (loc->fetch1 exp)))
	((lambda) (simple-susp 'clambda exp lambda-f))
	((vlambda) (simple-susp 'cvlambda exp vlambda-f))
	((delay) (simple-susp 'cdelay exp delay-f))
	((letrec)
	 (let ((b (ee-body exp)))
	   (3-way-split
	    (car b)
	    (lambda (susp-l ref-l other-l)
	      (let ((n-d-lst (append (map car other-l) d-lst))
		    (base (length susp-l)))
		(build-refs
		 (if (zero? base)
		     ;; don't have to construct letrec closure:
		     (let ((new-cl (lambda (exp)
				     (cl exp n-d-lst c-map))))
		       (build-all-asgn
			(new-cl (cadr b)) ref-l other-l new-cl))
		     ;; have to construct letrec closure:
		     (let* ((rcv (new-local 'rclosure))
			    (susp-vars (map car susp-l))
			    (susp-vals (map cadr susp-l))
			    (susp-fv (varset-
				      (varset++ (map fv-info susp-vals))
				      (list->varset susp-vars)))
			    (il (range 0 base))
			    (con (map-constructor susp-fv susp-vars il base))
			    (inner-cl (lambda (exp)
					(cl exp n-d-lst c-map)))
			    (inner
			     (build-all-asgn
			      (inner-cl (cadr b)) ref-l other-l inner-cl))
			    (rec-susp
			     (make-rec-susp rcv con n-d-lst)))
		       (let loop
			   ((e inner)
			    (varl susp-vars)
			    (vall susp-vals)
			    (il il))
			 (if (not (pair? varl))
			     (ee 'let
				 (list
				  (list
				   (list rcv
					 (ee 'app
					     (cons
					      i-closure
					      (cons
					       (ee 'quote base)
					       (map loc->fetch1 susp-fv))))))
				  e))
			     (loop
			      (let* ((dummy (new-local 'letrec-ignore))
				     (var (car varl))
				     (val (car vall))
				     (i (car il))
				     (n-val
				      (case (ee-type val)
					((lambda)
					 (rec-susp 'clambda val lambda-f))
					((vlambda)
					 (rec-susp 'cvlambda val vlambda-f))
					(else
					 (rec-susp 'cdelay val delay-f)))))
				(ee 'let
				    (list
				     (list (list var n-val))
				     (ee 'let
					 (list
					  (list
					   (list dummy
						 (ee 'app
						     (list
						      i-set-closure
						      rcv (ee 'quote i) var))))
					  e)))))
			      (cdr varl)
			      (cdr vall)
			      (cdr il))))))
		 (map car (append other-l ref-l))))))))
	(else (generic same-cl exp))))

    (define (closures exp) (cl exp '() '()))))
