/*
 * Numeric.h -- Declarations for Scheme's numeric data types
 *
 * (C) m.b (Matthias Blume); May 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: Numeric.h,v 2.8 1994/09/01 20:12:59 blume Exp $
 */

# ifndef NUMERIC_H_
# define NUMERIC_H_

# include "storage.h"

typedef struct ScmFixnum ScmFixnum;
DCL_MEM_TYPE (Fixnum);

typedef struct ScmFraction ScmFraction;
DCL_MEM_TYPE (Fraction);

typedef struct ScmReal ScmReal;
DCL_MEM_TYPE (Real);

typedef struct ScmComplex ScmComplex;
DCL_MEM_TYPE (Complex);

typedef struct ScmSFixnum ScmSFixnum;
DCL_MEM_TYPE (SFixnum);

extern long ScmNumberToLong (void *, const char *);
extern unsigned long ScmNumberToULong (void *, const char *);
extern void *ScmLongToNumber (long);

extern unsigned int ScmNumberToUShort (void *, const char *);
/* get only the last ``big digit'' (or less) of a non-negative number */

extern int ScmNumberIsEven (void *, const char *);
extern void *ScmAtan2 (void *, void *);

/* string (need not be NUL-terminated), length, default-base */
extern void *ScmParseNumberString (const char *s, int l, int b);

extern void ScmQuotRem (void *x, void *y, void **q, void **r, const char *s);
/* q == NULL -> no quotient, r == NULL -> no remainder */

extern void *ScmNewRealComplex (double re, double im);

extern char *ScmUnparseNumber (void *x, int base);
/* returns a pointer to static memory */

# ifndef DEFAULT_SFIXNUM_RANGE
# define DEFAULT_SFIXNUM_RANGE 1024
# endif

# ifdef ADJUSTABLE_SFIXNUM_RANGE
extern void ScmInitSFixnums (unsigned range); /* (-range+1)..(range-1) */
# endif

# endif
