/*
 * Module.c -- Implementation of Scheme Modules
 *
 * (C) m.b (Matthias Blume); Sep 1994 PU/CS
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: Module.c,v 1.4 1994/11/12 22:13:50 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: Module.c,v 1.4 1994/11/12 22:13:50 blume Exp $")

# include <stdio.h>

# include "storext.h"
# include "Module.h"
# include "identifier.h"
# include "type.h"

static MEM_cnt measure (void *vmod)
{
  ScmModule *mod = (ScmModule *) vmod;

  return MEM_UNITS (sizeof (ScmModule) + (mod->length - 1) * sizeof (void *));
}

static void iterator (void *vmod, MEM_visitor proc, void *cd)
{
  ScmModule *mod = (ScmModule *) vmod;
  unsigned long i;

  i = mod->length;
  (*proc) ((void *)&mod->signature, cd);
  (*proc) ((void *)&mod->exports, cd);
  while(i--)
    (*proc) ((void *)&mod->array[i], cd);
}

static void dumper (void *vmod, FILE *file)
{
  MEM_dump_ul (((ScmModule *)vmod)->length, file);
}

static void *excavator (FILE *file)
{
  unsigned long length;
  ScmModule *mod;

  length = MEM_restore_ul (file);
  SCM_NEW_MODULE (mod, length);
  return mod;
}

static void display (void *vvect, putc_proc pp, void *cd)
{
  putc_string ("#<Module>", pp, cd);
}

MEM_VECTOR (Module,
	    0, measure,
	    iterator, dumper, excavator, MEM_NULL_revisor,
	    MEM_NULL_task, MEM_NULL_task, MEM_NULL_task,
	    EXT (SCM_NO_NUMBER,
		 cannot_cvt_real, display, display, NULL_eq, NULL_eq));
