/*
* ArmyFormation.h, part of VCMI engine
*
* Authors: listed in file AUTHORS in main folder
*
* License: GNU General Public License v2.0 or later
* Full text of license available in license.txt file, in main folder
*
*/
#pragma once

#include "../AIUtility.h"

#include "../../../lib/GameConstants.h"
#include "../../../lib/VCMI_Lib.h"

namespace NKAI
{

struct HeroPtr;
class AIGateway;
class FuzzyHelper;
class Nullkiller;

class DLL_EXPORT ArmyFormation
{
private:
	std::shared_ptr<CCallback> cb; //this is enough, but we downcast from CCallback

public:
	ArmyFormation(std::shared_ptr<CCallback> CB, const Nullkiller * ai): cb(CB) {}

	void rearrangeArmyForSiege(const CGTownInstance * town, const CGHeroInstance * attacker);

	void rearrangeArmyForWhirlpool(const CGHeroInstance * hero);

	void addSingleCreatureStacks(const CGHeroInstance * hero);
};

}
