README.certs
============

1. X.509 Certs and key files
----------------------------

In this directory you will find:

* a) rootCA_cert.pem -- ECC root CA PEM file; almost 10 years valid
* b) rootCA_key.pem -- encypted corresponding key file for signing - password 12345
* c) rootCA_key.pem.plain -- unencypted corresponding key file for signing

* d) ::1_cert.pem -- ECC IPv6 localhost PEM cert
* e) ::1_key.pem -- encrypted corresponding key file for authentication - password 1234
* f) ::1_key.pem.plain -- unencrypted corresponding key file for authentication

* g) 127.0.0.1_cert.pem -- ECC IPv4 localhost PEM cert
* h) 127.0.0.1_key.pem -- encrypted corresponding key file for authentication - password 1234
* i) 127.0.0.1_key.pem.plain -- unencrypted corresponding key file for authentication

* j) localhost_cert.pem -- ECC generic localhost PEM cert
* k) localhost.pem -- encrypted corresponding key file for authentication - password 1234
* l) localhost.pem -- unencrypted corresponding key file for authentication

* m) chain6.pem -- chained ::1_cert.pam + rootCA_cert.pem
* n) chain4.pem -- chained 127.0.0.1_cert.pam + rootCA_cert.pem

* o) dh2048.pem -- Diffie-Hellman parameter file with 2048 bit

All x509 certs are generated by means of the ECC prime256v1 algorithm.
CA cert validity: About 10 years from August 2024.
Other certs validity is about 5 years starting at August 2024.

Note: The certs are correctly chained and verify ok.


2. Usage
--------

These x509 certs and key files are provided to allow an initial
setup and test of UCSPI-SSL's sslserver and companions.

The use of ECC signatures requires OpenSSL > 1.1.1 or LibreSSL > 3.3.1.

3. rootCA_cert.pem
------------------

```
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            50:a2:a4:9d:6a:94:1a:2a:1f:b4:72:c5:43:a1:f7:af:60:39:00:12
        Signature Algorithm: ecdsa-with-SHA256
        Issuer: C = US, ST = New York, L = Brooklyn, O = ucspi-ssl research laboratory, CN = ucspi-ssl research ca
        Validity
            Not Before: Aug  5 14:38:21 2024 GMT
            Not After : Sep  2 14:38:21 2034 GMT
        Subject: C = US, ST = New York, L = Brooklyn, O = ucspi-ssl research laboratory, CN = ucspi-ssl research ca
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (256 bit)
                pub:
                    04:4b:71:8b:eb:e4:ad:8a:8a:34:8d:d4:02:a8:8a:
                    ea:a1:f5:b8:cc:11:1a:56:bc:2d:fc:b4:fd:87:05:
                    06:d7:73:0a:29:87:2b:32:e1:8e:fa:f3:fa:30:18:
                    90:5f:da:1f:9b:95:85:62:97:58:40:f9:2c:16:f2:
                    65:de:7d:06:1a
                ASN1 OID: prime256v1
                NIST CURVE: P-256
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                C7:CF:20:CF:22:E3:4D:24:6A:57:91:17:AF:9F:45:C3:C1:BB:D5:01
            X509v3 Authority Key Identifier: 
                C7:CF:20:CF:22:E3:4D:24:6A:57:91:17:AF:9F:45:C3:C1:BB:D5:01
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: ecdsa-with-SHA256
    Signature Value:
        30:45:02:21:00:fa:89:10:cf:27:2e:e0:a2:fd:6e:8b:f2:b4:
        55:dc:a3:df:4c:ce:60:7b:4f:d4:2b:ff:be:2f:ce:7e:8d:6d:
        f2:02:20:60:5d:49:c4:0f:ab:94:c9:da:5a:42:71:ba:53:e0:
        5f:b5:14:5e:02:51:1e:ce:42:0d:1f:8d:6d:6c:01:78:a1
-----BEGIN CERTIFICATE-----
MIICSzCCAfGgAwIBAgIUUKKknWqUGioftHLFQ6H3r2A5ABIwCgYIKoZIzj0EAwIw
ezELMAkGA1UEBhMCVVMxETAPBgNVBAgTCE5ldyBZb3JrMREwDwYDVQQHEwhCcm9v
a2x5bjEmMCQGA1UEChMddWNzcGktc3NsIHJlc2VhcmNoIGxhYm9yYXRvcnkxHjAc
BgNVBAMTFXVjc3BpLXNzbCByZXNlYXJjaCBjYTAeFw0yNDA4MDUxNDM4MjFaFw0z
NDA5MDIxNDM4MjFaMHsxCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhOZXcgWW9yazER
MA8GA1UEBxMIQnJvb2tseW4xJjAkBgNVBAoTHXVjc3BpLXNzbCByZXNlYXJjaCBs
YWJvcmF0b3J5MR4wHAYDVQQDExV1Y3NwaS1zc2wgcmVzZWFyY2ggY2EwWTATBgcq
hkjOPQIBBggqhkjOPQMBBwNCAARLcYvr5K2KijSN1AKoiuqh9bjMERpWvC38tP2H
BQbXcwophysy4Y768/owGJBf2h+blYVil1hA+SwW8mXefQYao1MwUTAdBgNVHQ4E
FgQUx88gzyLjTSRqV5EXr59Fw8G71QEwHwYDVR0jBBgwFoAUx88gzyLjTSRqV5EX
r59Fw8G71QEwDwYDVR0TAQH/BAUwAwEB/zAKBggqhkjOPQQDAgNIADBFAiEA+okQ
zycu4KL9bovytFXco99MzmB7T9Qr/74vzn6NbfICIGBdScQPq5TJ2lpCcbpT4F+1
FF4CUR7OQg0fjW1sAXih
-----END CERTIFICATE-----
```

4. ::1_cert.pem
---------------

```
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            7b:e4:29:a6:5f:61:57:58:34:f4:8f:ac:e7:02:02:6d:cf:56:a2:69
        Signature Algorithm: ecdsa-with-SHA256
        Issuer: C = US, ST = New York, L = Brooklyn, O = ucspi-ssl research laboratory, CN = ucspi-ssl research ca
        Validity
            Not Before: Aug  6 12:51:18 2024 GMT
            Not After : Oct 19 12:51:18 2029 GMT
        Subject: C = US, ST = New York, L = Brooklyn, O = ucspi-ssl research laboratory, CN = loopback
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (256 bit)
                pub:
                    04:d4:b8:cc:b5:d6:1f:8b:21:db:27:74:71:f9:6b:
                    1a:84:a9:cd:8e:ab:cb:c7:41:bd:7d:a6:2e:4c:20:
                    fe:e0:e6:ea:1e:c9:a3:94:23:d7:73:8b:ac:a9:ba:
                    da:49:b7:f2:89:99:d4:a6:3c:72:50:bd:13:4d:9f:
                    29:bd:95:08:a3
                ASN1 OID: prime256v1
                NIST CURVE: P-256
        X509v3 extensions:
            X509v3 Basic Constraints: 
                CA:FALSE
            X509v3 Key Usage: 
                Digital Signature, Key Encipherment
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication
            X509v3 Subject Alternative Name: 
                IP Address:0:0:0:0:0:0:0:1, DNS:localhost
            X509v3 Authority Key Identifier: 
                keyid:C7:CF:20:CF:22:E3:4D:24:6A:57:91:17:AF:9F:45:C3:C1:BB:D5:01
                DirName:/C=US/ST=New York/L=Brooklyn/O=ucspi-ssl research laboratory/CN=ucspi-ssl research ca
                serial:50:A2:A4:9D:6A:94:1A:2A:1F:B4:72:C5:43:A1:F7:AF:60:39:00:12
            X509v3 Subject Key Identifier: 
                4A:5C:A6:33:82:20:43:5B:85:1C:AF:1F:39:C0:FE:2E:70:89:EA:FB
    Signature Algorithm: ecdsa-with-SHA256
    Signature Value:
        30:46:02:21:00:fe:f8:b0:7d:bb:aa:78:22:f0:ba:3a:3b:18:
        17:17:97:23:20:93:2c:d0:08:47:39:8b:fc:18:fe:c5:10:43:
        5c:02:21:00:d6:90:74:99:cc:e7:ee:b1:8e:5d:9f:19:f3:dd:
        d0:0c:a1:a8:1f:b5:25:89:7f:e1:43:a4:e7:03:6f:aa:7d:f2
Trusted Uses:
  TLS Web Server Authentication
No Rejected Uses.
-----BEGIN CERTIFICATE-----
MIIDITCCAsagAwIBAgIUe+Qppl9hV1g09I+s5wICbc9WomkwCgYIKoZIzj0EAwIw
ezELMAkGA1UEBhMCVVMxETAPBgNVBAgTCE5ldyBZb3JrMREwDwYDVQQHEwhCcm9v
a2x5bjEmMCQGA1UEChMddWNzcGktc3NsIHJlc2VhcmNoIGxhYm9yYXRvcnkxHjAc
BgNVBAMTFXVjc3BpLXNzbCByZXNlYXJjaCBjYTAeFw0yNDA4MDYxMjUxMThaFw0y
OTEwMTkxMjUxMThaMG4xCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhOZXcgWW9yazER
MA8GA1UEBxMIQnJvb2tseW4xJjAkBgNVBAoTHXVjc3BpLXNzbCByZXNlYXJjaCBs
YWJvcmF0b3J5MREwDwYDVQQDEwhsb29wYmFjazBZMBMGByqGSM49AgEGCCqGSM49
AwEHA0IABNS4zLXWH4sh2yd0cflrGoSpzY6ry8dBvX2mLkwg/uDm6h7Jo5Qj13OL
rKm62km38omZ1KY8clC9E02fKb2VCKOjggEzMIIBLzAJBgNVHRMEAjAAMAsGA1Ud
DwQEAwIFoDATBgNVHSUEDDAKBggrBgEFBQcDATAmBgNVHREEHzAdhxAAAAAAAAAA
AAAAAAAAAAABgglsb2NhbGhvc3QwgbgGA1UdIwSBsDCBrYAUx88gzyLjTSRqV5EX
r59Fw8G71QGhf6R9MHsxCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhOZXcgWW9yazER
MA8GA1UEBxMIQnJvb2tseW4xJjAkBgNVBAoTHXVjc3BpLXNzbCByZXNlYXJjaCBs
YWJvcmF0b3J5MR4wHAYDVQQDExV1Y3NwaS1zc2wgcmVzZWFyY2ggY2GCFFCipJ1q
lBoqH7RyxUOh969gOQASMB0GA1UdDgQWBBRKXKYzgiBDW4Ucrx85wP4ucInq+zAK
BggqhkjOPQQDAgNJADBGAiEA/viwfbuqeCLwujo7GBcXlyMgkyzQCEc5i/wY/sUQ
Q1wCIQDWkHSZzOfusY5dnxnz3dAMoagftSWJf+FDpOcDb6p98g==
-----END CERTIFICATE-----
```

5. 127.0.0.1_cert.pem
---------------------

```
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            7b:e4:29:a6:5f:61:57:58:34:f4:8f:ac:e7:02:02:6d:cf:56:a2:67
        Signature Algorithm: ecdsa-with-SHA256
        Issuer: C = US, ST = New York, L = Brooklyn, O = ucspi-ssl research laboratory, CN = ucspi-ssl research ca
        Validity
            Not Before: Aug  6 10:33:29 2024 GMT
            Not After : Oct 19 10:33:29 2029 GMT
        Subject: C = US, ST = New York, L = Brooklyn, O = ucspi-ssl research laboratory, CN = loopback
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (256 bit)
                pub:
                    04:d9:3a:ef:91:70:4c:b0:cd:7d:fc:f0:4c:38:a8:
                    ad:b6:70:d5:ef:53:4b:6e:c9:9c:52:6a:a7:5c:85:
                    aa:74:ae:b9:a7:d7:69:6b:98:66:3c:09:e9:bf:b5:
                    68:71:23:8c:82:55:25:c7:e8:4e:91:7c:e1:98:f4:
                    97:d1:d7:7f:1d
                ASN1 OID: prime256v1
                NIST CURVE: P-256
        X509v3 extensions:
            X509v3 Basic Constraints: 
                CA:FALSE
            X509v3 Key Usage: 
                Digital Signature, Key Encipherment
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication
            X509v3 Subject Alternative Name: 
                IP Address:127.0.0.1, DNS:localhost
            X509v3 Authority Key Identifier: 
                DirName:/C=US/ST=New York/L=Brooklyn/O=ucspi-ssl research laboratory/CN=ucspi-ssl research ca
                serial:50:A2:A4:9D:6A:94:1A:2A:1F:B4:72:C5:43:A1:F7:AF:60:39:00:12
            X509v3 Subject Key Identifier: 
                9D:A3:0E:87:F0:C6:D3:79:20:F0:3F:60:11:B6:23:91:95:05:17:6F
    Signature Algorithm: ecdsa-with-SHA256
    Signature Value:
        30:45:02:20:73:e6:29:11:d9:1e:fd:ca:95:2a:6c:b6:95:a0:
        41:84:d3:bf:e6:5d:0f:6a:c5:9a:50:e4:87:d9:15:97:59:8c:
        02:21:00:9f:f4:60:d1:bf:cc:70:40:7b:a1:92:42:e5:8b:b3:
        8f:06:ec:3e:56:e7:a7:5f:25:a3:c3:19:f7:74:9f:d6:f5
Trusted Uses:
  TLS Web Server Authentication
No Rejected Uses.
-----BEGIN CERTIFICATE-----
MIIC/jCCAqSgAwIBAgIUe+Qppl9hV1g09I+s5wICbc9WomcwCgYIKoZIzj0EAwIw
ezELMAkGA1UEBhMCVVMxETAPBgNVBAgTCE5ldyBZb3JrMREwDwYDVQQHEwhCcm9v
a2x5bjEmMCQGA1UEChMddWNzcGktc3NsIHJlc2VhcmNoIGxhYm9yYXRvcnkxHjAc
BgNVBAMTFXVjc3BpLXNzbCByZXNlYXJjaCBjYTAeFw0yNDA4MDYxMDMzMjlaFw0y
OTEwMTkxMDMzMjlaMG4xCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhOZXcgWW9yazER
MA8GA1UEBxMIQnJvb2tseW4xJjAkBgNVBAoTHXVjc3BpLXNzbCByZXNlYXJjaCBs
YWJvcmF0b3J5MREwDwYDVQQDEwhsb29wYmFjazBZMBMGByqGSM49AgEGCCqGSM49
AwEHA0IABNk675FwTLDNffzwTDiorbZw1e9TS27JnFJqp1yFqnSuuafXaWuYZjwJ
6b+1aHEjjIJVJcfoTpF84Zj0l9HXfx2jggERMIIBDTAJBgNVHRMEAjAAMAsGA1Ud
DwQEAwIFoDATBgNVHSUEDDAKBggrBgEFBQcDATAaBgNVHREEEzARhwR/AAABggls
b2NhbGhvc3QwgaIGA1UdIwSBmjCBl6F/pH0wezELMAkGA1UEBhMCVVMxETAPBgNV
BAgTCE5ldyBZb3JrMREwDwYDVQQHEwhCcm9va2x5bjEmMCQGA1UEChMddWNzcGkt
c3NsIHJlc2VhcmNoIGxhYm9yYXRvcnkxHjAcBgNVBAMTFXVjc3BpLXNzbCByZXNl
YXJjaCBjYYIUUKKknWqUGioftHLFQ6H3r2A5ABIwHQYDVR0OBBYEFJ2jDofwxtN5
IPA/YBG2I5GVBRdvMAoGCCqGSM49BAMCA0gAMEUCIHPmKRHZHv3KlSpstpWgQYTT
v+ZdD2rFmlDkh9kVl1mMAiEAn/Rg0b/McEB7oZJC5YuzjwbsPlbnp18lo8MZ93Sf
1vU=
-----END CERTIFICATE-----
```

6. localhost_cert.pem
---------------------

```
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            7b:e4:29:a6:5f:61:57:58:34:f4:8f:ac:e7:02:02:6d:cf:56:a2:6a
        Signature Algorithm: ecdsa-with-SHA256
        Issuer: C = US, ST = New York, L = Brooklyn, O = ucspi-ssl research laboratory, CN = ucspi-ssl research ca
        Validity
            Not Before: Aug  6 13:12:04 2024 GMT
            Not After : Oct 19 13:12:04 2029 GMT
        Subject: C = US, ST = New York, L = Brooklyn, O = ucspi-ssl research laboratory, CN = localhost
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (256 bit)
                pub:
                    04:89:df:10:d7:9e:04:26:e6:fc:fc:19:cc:07:c1:
                    e1:38:49:03:74:90:7e:2c:4a:11:92:45:a5:b0:79:
                    5f:b6:01:1f:68:3b:1f:76:53:1a:f0:df:53:ed:3d:
                    f2:6b:57:7e:c4:5f:9b:ee:32:3f:7d:ed:66:a9:01:
                    46:bc:50:51:ca
                ASN1 OID: prime256v1
                NIST CURVE: P-256
        X509v3 extensions:
            X509v3 Basic Constraints: 
                CA:FALSE
            X509v3 Key Usage: 
                Digital Signature, Key Encipherment
            X509v3 Extended Key Usage: 
                TLS Web Client Authentication
            X509v3 Subject Alternative Name: 
                DNS:localhost, IP Address:0.0.0.0, IP Address:0:0:0:0:0:0:0:0
            X509v3 Authority Key Identifier: 
                DirName:/C=US/ST=New York/L=Brooklyn/O=ucspi-ssl research laboratory/CN=ucspi-ssl research ca
                serial:50:A2:A4:9D:6A:94:1A:2A:1F:B4:72:C5:43:A1:F7:AF:60:39:00:12
            X509v3 Subject Key Identifier: 
                B7:EA:5B:5A:EF:18:E8:80:43:FC:3B:F5:A2:12:B6:B2:14:94:9F:5B
    Signature Algorithm: ecdsa-with-SHA256
    Signature Value:
        30:45:02:21:00:b5:60:54:9b:59:c1:0b:0b:4d:91:0c:9c:64:
        a2:41:1f:71:49:8d:c4:75:38:ab:ad:0b:95:ae:2a:86:ea:50:
        89:02:20:05:0d:54:c4:98:99:76:7a:e4:73:74:73:58:87:de:
        a8:28:25:4f:f7:a1:c8:0a:9a:c5:48:e9:0a:48:80:14:07
Trusted Uses:
  TLS Web Server Authentication
No Rejected Uses.
-----BEGIN CERTIFICATE-----
MIIDETCCAregAwIBAgIUe+Qppl9hV1g09I+s5wICbc9WomowCgYIKoZIzj0EAwIw
ezELMAkGA1UEBhMCVVMxETAPBgNVBAgTCE5ldyBZb3JrMREwDwYDVQQHEwhCcm9v
a2x5bjEmMCQGA1UEChMddWNzcGktc3NsIHJlc2VhcmNoIGxhYm9yYXRvcnkxHjAc
BgNVBAMTFXVjc3BpLXNzbCByZXNlYXJjaCBjYTAeFw0yNDA4MDYxMzEyMDRaFw0y
OTEwMTkxMzEyMDRaMG8xCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhOZXcgWW9yazER
MA8GA1UEBxMIQnJvb2tseW4xJjAkBgNVBAoTHXVjc3BpLXNzbCByZXNlYXJjaCBs
YWJvcmF0b3J5MRIwEAYDVQQDEwlsb2NhbGhvc3QwWTATBgcqhkjOPQIBBggqhkjO
PQMBBwNCAASJ3xDXngQm5vz8GcwHweE4SQN0kH4sShGSRaWweV+2AR9oOx92Uxrw
31PtPfJrV37EX5vuMj997WapAUa8UFHKo4IBIzCCAR8wCQYDVR0TBAIwADALBgNV
HQ8EBAMCBaAwEwYDVR0lBAwwCgYIKwYBBQUHAwIwLAYDVR0RBCUwI4IJbG9jYWxo
b3N0hwQAAAAAhxAAAAAAAAAAAAAAAAAAAAAAMIGiBgNVHSMEgZowgZehf6R9MHsx
CzAJBgNVBAYTAlVTMREwDwYDVQQIEwhOZXcgWW9yazERMA8GA1UEBxMIQnJvb2ts
eW4xJjAkBgNVBAoTHXVjc3BpLXNzbCByZXNlYXJjaCBsYWJvcmF0b3J5MR4wHAYD
VQQDExV1Y3NwaS1zc2wgcmVzZWFyY2ggY2GCFFCipJ1qlBoqH7RyxUOh969gOQAS
MB0GA1UdDgQWBBS36lta7xjogEP8O/WiErayFJSfWzAKBggqhkjOPQQDAgNIADBF
AiEAtWBUm1nBCwtNkQycZKJBH3FJjcR1OKutC5WuKobqUIkCIAUNVMSYmXZ65HN0
c1iH3qgoJU/3ocgKmsVI6QpIgBQH
-----END CERTIFICATE-----
```

