#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1219
#define LARGE_STATE_COUNT 76
#define SYMBOL_COUNT 186
#define ALIAS_COUNT 1
#define TOKEN_COUNT 87
#define EXTERNAL_TOKEN_COUNT 14
#define FIELD_COUNT 10
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 25

enum {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym_COMMA = 3,
  anon_sym_LPAREN = 4,
  anon_sym_RPAREN = 5,
  anon_sym_PLUS = 6,
  anon_sym_DOT_PLUS = 7,
  anon_sym_DASH = 8,
  anon_sym_DOT_DASH = 9,
  anon_sym_STAR = 10,
  anon_sym_DOT_STAR = 11,
  anon_sym_SLASH = 12,
  anon_sym_DOT_SLASH = 13,
  anon_sym_BSLASH = 14,
  anon_sym_DOT_BSLASH = 15,
  anon_sym_CARET = 16,
  anon_sym_DOT_CARET = 17,
  anon_sym_PIPE = 18,
  anon_sym_AMP = 19,
  anon_sym_DOT = 20,
  anon_sym_TILDE = 21,
  anon_sym_QMARK = 22,
  anon_sym_AT = 23,
  anon_sym_LT = 24,
  anon_sym_LT_EQ = 25,
  anon_sym_EQ_EQ = 26,
  anon_sym_TILDE_EQ = 27,
  anon_sym_GT_EQ = 28,
  anon_sym_GT = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_DOT_SQUOTE = 32,
  anon_sym_SQUOTE = 33,
  anon_sym_LBRACK = 34,
  aux_sym_matrix_token1 = 35,
  anon_sym_RBRACK = 36,
  anon_sym_LBRACE = 37,
  anon_sym_RBRACE = 38,
  anon_sym_EQ = 39,
  anon_sym_COLON = 40,
  sym_return_statement = 41,
  sym_continue_statement = 42,
  sym_break_statement = 43,
  anon_sym_elseif = 44,
  anon_sym_else = 45,
  anon_sym_if = 46,
  anon_sym_end = 47,
  anon_sym_for = 48,
  anon_sym_parfor = 49,
  anon_sym_while = 50,
  anon_sym_case = 51,
  anon_sym_otherwise = 52,
  anon_sym_switch = 53,
  anon_sym_global = 54,
  anon_sym_persistent = 55,
  anon_sym_arguments = 56,
  anon_sym_function = 57,
  anon_sym_get_DOT = 58,
  anon_sym_set_DOT = 59,
  anon_sym_endfunction = 60,
  anon_sym_properties = 61,
  anon_sym_methods = 62,
  anon_sym_events = 63,
  anon_sym_enumeration = 64,
  anon_sym_classdef = 65,
  anon_sym_catch = 66,
  anon_sym_try = 67,
  sym_number = 68,
  anon_sym_true = 69,
  anon_sym_false = 70,
  anon_sym_LF = 71,
  anon_sym_CR = 72,
  sym_comment = 73,
  sym_line_continuation = 74,
  sym_command_name = 75,
  sym_command_argument = 76,
  sym__single_quote_string_start = 77,
  sym__single_quote_string_end = 78,
  sym__double_quote_string_start = 79,
  sym__double_quote_string_end = 80,
  sym_formatting_sequence = 81,
  sym_escape_sequence = 82,
  sym_string_content = 83,
  sym__entry_delimiter = 84,
  sym__multioutput_variable_start = 85,
  sym_error_sentinel = 86,
  sym_source_file = 87,
  aux_sym__block = 88,
  sym_block = 89,
  sym__statement = 90,
  sym__expression = 91,
  sym_parenthesis = 92,
  sym__binary_expression = 93,
  sym_binary_operator = 94,
  sym_unary_operator = 95,
  sym_indirect_access = 96,
  sym_field_expression = 97,
  sym_not_operator = 98,
  sym_metaclass_operator = 99,
  sym_handle_operator = 100,
  sym_comparison_operator = 101,
  sym_boolean_operator = 102,
  sym_postfix_operator = 103,
  sym_string = 104,
  sym_row = 105,
  sym_matrix = 106,
  sym_cell = 107,
  sym_ignored_argument = 108,
  sym_assignment = 109,
  sym_multioutput_variable = 110,
  sym_spread_operator = 111,
  sym_arguments = 112,
  sym__args = 113,
  sym_function_call = 114,
  sym_command = 115,
  sym__range_element = 116,
  sym_range = 117,
  sym_elseif_clause = 118,
  sym_else_clause = 119,
  sym_if_statement = 120,
  sym_iterator = 121,
  sym_parfor_options = 122,
  sym_for_statement = 123,
  sym_while_statement = 124,
  sym_case_clause = 125,
  sym_otherwise_clause = 126,
  sym_switch_statement = 127,
  sym__lambda_arguments = 128,
  sym_lambda = 129,
  sym_global_operator = 130,
  sym_persistent_operator = 131,
  sym__argument_attributes = 132,
  sym_arguments_statement = 133,
  sym_function_output = 134,
  sym_function_arguments = 135,
  sym_function_definition = 136,
  sym__function_definition_with_end = 137,
  sym_attribute = 138,
  sym_attributes = 139,
  sym_superclasses = 140,
  sym_dimensions = 141,
  sym_validation_functions = 142,
  sym_default_value = 143,
  sym_property_name = 144,
  sym_property = 145,
  sym_properties = 146,
  sym_function_signature = 147,
  sym_methods = 148,
  sym_events = 149,
  sym__enum_value = 150,
  sym_enum = 151,
  sym_enumeration = 152,
  sym_class_definition = 153,
  sym_catch_clause = 154,
  sym_try_statement = 155,
  sym_boolean = 156,
  sym__end_of_line = 157,
  aux_sym_source_file_repeat1 = 158,
  aux_sym__block_repeat1 = 159,
  aux_sym_field_expression_repeat1 = 160,
  aux_sym_handle_operator_repeat1 = 161,
  aux_sym_string_repeat1 = 162,
  aux_sym_row_repeat1 = 163,
  aux_sym_matrix_repeat1 = 164,
  aux_sym_multioutput_variable_repeat1 = 165,
  aux_sym_arguments_repeat1 = 166,
  aux_sym_arguments_repeat2 = 167,
  aux_sym_command_repeat1 = 168,
  aux_sym_elseif_clause_repeat1 = 169,
  aux_sym_if_statement_repeat1 = 170,
  aux_sym_switch_statement_repeat1 = 171,
  aux_sym__lambda_arguments_repeat1 = 172,
  aux_sym_global_operator_repeat1 = 173,
  aux_sym__argument_attributes_repeat1 = 174,
  aux_sym_arguments_statement_repeat1 = 175,
  aux_sym_function_definition_repeat1 = 176,
  aux_sym_attributes_repeat1 = 177,
  aux_sym_superclasses_repeat1 = 178,
  aux_sym_dimensions_repeat1 = 179,
  aux_sym_validation_functions_repeat1 = 180,
  aux_sym_methods_repeat1 = 181,
  aux_sym_events_repeat1 = 182,
  aux_sym_enum_repeat1 = 183,
  aux_sym_enumeration_repeat1 = 184,
  aux_sym_class_definition_repeat1 = 185,
  alias_sym_superclass = 186,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_PLUS] = "+",
  [anon_sym_DOT_PLUS] = ".+",
  [anon_sym_DASH] = "-",
  [anon_sym_DOT_DASH] = ".-",
  [anon_sym_STAR] = "*",
  [anon_sym_DOT_STAR] = ".*",
  [anon_sym_SLASH] = "/",
  [anon_sym_DOT_SLASH] = "./",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_DOT_BSLASH] = ".\\",
  [anon_sym_CARET] = "^",
  [anon_sym_DOT_CARET] = ".^",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_DOT] = ".",
  [anon_sym_TILDE] = "~",
  [anon_sym_QMARK] = "\?",
  [anon_sym_AT] = "@",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_DOT_SQUOTE] = ".'",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_LBRACK] = "[",
  [aux_sym_matrix_token1] = "matrix_token1",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_EQ] = "=",
  [anon_sym_COLON] = ":",
  [sym_return_statement] = "return_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_break_statement] = "break_statement",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_end] = "end",
  [anon_sym_for] = "for",
  [anon_sym_parfor] = "parfor",
  [anon_sym_while] = "while",
  [anon_sym_case] = "case",
  [anon_sym_otherwise] = "otherwise",
  [anon_sym_switch] = "switch",
  [anon_sym_global] = "global",
  [anon_sym_persistent] = "persistent",
  [anon_sym_arguments] = "arguments",
  [anon_sym_function] = "function",
  [anon_sym_get_DOT] = "get.",
  [anon_sym_set_DOT] = "set.",
  [anon_sym_endfunction] = "endfunction",
  [anon_sym_properties] = "properties",
  [anon_sym_methods] = "methods",
  [anon_sym_events] = "events",
  [anon_sym_enumeration] = "enumeration",
  [anon_sym_classdef] = "classdef",
  [anon_sym_catch] = "catch",
  [anon_sym_try] = "try",
  [sym_number] = "number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_LF] = "\n",
  [anon_sym_CR] = "\r",
  [sym_comment] = "comment",
  [sym_line_continuation] = "line_continuation",
  [sym_command_name] = "command_name",
  [sym_command_argument] = "command_argument",
  [sym__single_quote_string_start] = "'",
  [sym__single_quote_string_end] = "'",
  [sym__double_quote_string_start] = "\"",
  [sym__double_quote_string_end] = "\"",
  [sym_formatting_sequence] = "formatting_sequence",
  [sym_escape_sequence] = "escape_sequence",
  [sym_string_content] = "string_content",
  [sym__entry_delimiter] = "_entry_delimiter",
  [sym__multioutput_variable_start] = "[",
  [sym_error_sentinel] = "error_sentinel",
  [sym_source_file] = "source_file",
  [aux_sym__block] = "_block",
  [sym_block] = "block",
  [sym__statement] = "_statement",
  [sym__expression] = "_expression",
  [sym_parenthesis] = "parenthesis",
  [sym__binary_expression] = "_binary_expression",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_indirect_access] = "indirect_access",
  [sym_field_expression] = "field_expression",
  [sym_not_operator] = "not_operator",
  [sym_metaclass_operator] = "metaclass_operator",
  [sym_handle_operator] = "handle_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_postfix_operator] = "postfix_operator",
  [sym_string] = "string",
  [sym_row] = "row",
  [sym_matrix] = "matrix",
  [sym_cell] = "cell",
  [sym_ignored_argument] = "ignored_argument",
  [sym_assignment] = "assignment",
  [sym_multioutput_variable] = "multioutput_variable",
  [sym_spread_operator] = "spread_operator",
  [sym_arguments] = "arguments",
  [sym__args] = "_args",
  [sym_function_call] = "function_call",
  [sym_command] = "command",
  [sym__range_element] = "_range_element",
  [sym_range] = "range",
  [sym_elseif_clause] = "elseif_clause",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_iterator] = "iterator",
  [sym_parfor_options] = "parfor_options",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_case_clause] = "case_clause",
  [sym_otherwise_clause] = "otherwise_clause",
  [sym_switch_statement] = "switch_statement",
  [sym__lambda_arguments] = "_lambda_arguments",
  [sym_lambda] = "lambda",
  [sym_global_operator] = "global_operator",
  [sym_persistent_operator] = "persistent_operator",
  [sym__argument_attributes] = "attributes",
  [sym_arguments_statement] = "arguments_statement",
  [sym_function_output] = "function_output",
  [sym_function_arguments] = "function_arguments",
  [sym_function_definition] = "function_definition",
  [sym__function_definition_with_end] = "function_definition",
  [sym_attribute] = "attribute",
  [sym_attributes] = "attributes",
  [sym_superclasses] = "superclasses",
  [sym_dimensions] = "dimensions",
  [sym_validation_functions] = "validation_functions",
  [sym_default_value] = "default_value",
  [sym_property_name] = "property_name",
  [sym_property] = "property",
  [sym_properties] = "properties",
  [sym_function_signature] = "function_signature",
  [sym_methods] = "methods",
  [sym_events] = "events",
  [sym__enum_value] = "_enum_value",
  [sym_enum] = "enum",
  [sym_enumeration] = "enumeration",
  [sym_class_definition] = "class_definition",
  [sym_catch_clause] = "catch_clause",
  [sym_try_statement] = "try_statement",
  [sym_boolean] = "boolean",
  [sym__end_of_line] = "_end_of_line",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym__block_repeat1] = "_block_repeat1",
  [aux_sym_field_expression_repeat1] = "field_expression_repeat1",
  [aux_sym_handle_operator_repeat1] = "handle_operator_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_row_repeat1] = "row_repeat1",
  [aux_sym_matrix_repeat1] = "matrix_repeat1",
  [aux_sym_multioutput_variable_repeat1] = "multioutput_variable_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_arguments_repeat2] = "arguments_repeat2",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_elseif_clause_repeat1] = "elseif_clause_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym__lambda_arguments_repeat1] = "_lambda_arguments_repeat1",
  [aux_sym_global_operator_repeat1] = "global_operator_repeat1",
  [aux_sym__argument_attributes_repeat1] = "_argument_attributes_repeat1",
  [aux_sym_arguments_statement_repeat1] = "arguments_statement_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_attributes_repeat1] = "attributes_repeat1",
  [aux_sym_superclasses_repeat1] = "superclasses_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_validation_functions_repeat1] = "validation_functions_repeat1",
  [aux_sym_methods_repeat1] = "methods_repeat1",
  [aux_sym_events_repeat1] = "events_repeat1",
  [aux_sym_enum_repeat1] = "enum_repeat1",
  [aux_sym_enumeration_repeat1] = "enumeration_repeat1",
  [aux_sym_class_definition_repeat1] = "class_definition_repeat1",
  [alias_sym_superclass] = "superclass",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DOT_PLUS] = anon_sym_DOT_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DOT_DASH] = anon_sym_DOT_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_DOT_STAR] = anon_sym_DOT_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DOT_SLASH] = anon_sym_DOT_SLASH,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_DOT_BSLASH] = anon_sym_DOT_BSLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_DOT_CARET] = anon_sym_DOT_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_DOT_SQUOTE] = anon_sym_DOT_SQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [aux_sym_matrix_token1] = aux_sym_matrix_token1,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_return_statement] = sym_return_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_break_statement] = sym_break_statement,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_parfor] = anon_sym_parfor,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_otherwise] = anon_sym_otherwise,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_persistent] = anon_sym_persistent,
  [anon_sym_arguments] = anon_sym_arguments,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_get_DOT] = anon_sym_get_DOT,
  [anon_sym_set_DOT] = anon_sym_set_DOT,
  [anon_sym_endfunction] = anon_sym_endfunction,
  [anon_sym_properties] = anon_sym_properties,
  [anon_sym_methods] = anon_sym_methods,
  [anon_sym_events] = anon_sym_events,
  [anon_sym_enumeration] = anon_sym_enumeration,
  [anon_sym_classdef] = anon_sym_classdef,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_try] = anon_sym_try,
  [sym_number] = sym_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR] = anon_sym_CR,
  [sym_comment] = sym_comment,
  [sym_line_continuation] = sym_line_continuation,
  [sym_command_name] = sym_command_name,
  [sym_command_argument] = sym_command_argument,
  [sym__single_quote_string_start] = anon_sym_SQUOTE,
  [sym__single_quote_string_end] = anon_sym_SQUOTE,
  [sym__double_quote_string_start] = sym__double_quote_string_start,
  [sym__double_quote_string_end] = sym__double_quote_string_start,
  [sym_formatting_sequence] = sym_formatting_sequence,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_string_content] = sym_string_content,
  [sym__entry_delimiter] = sym__entry_delimiter,
  [sym__multioutput_variable_start] = anon_sym_LBRACK,
  [sym_error_sentinel] = sym_error_sentinel,
  [sym_source_file] = sym_source_file,
  [aux_sym__block] = aux_sym__block,
  [sym_block] = sym_block,
  [sym__statement] = sym__statement,
  [sym__expression] = sym__expression,
  [sym_parenthesis] = sym_parenthesis,
  [sym__binary_expression] = sym__binary_expression,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_indirect_access] = sym_indirect_access,
  [sym_field_expression] = sym_field_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_metaclass_operator] = sym_metaclass_operator,
  [sym_handle_operator] = sym_handle_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_postfix_operator] = sym_postfix_operator,
  [sym_string] = sym_string,
  [sym_row] = sym_row,
  [sym_matrix] = sym_matrix,
  [sym_cell] = sym_cell,
  [sym_ignored_argument] = sym_ignored_argument,
  [sym_assignment] = sym_assignment,
  [sym_multioutput_variable] = sym_multioutput_variable,
  [sym_spread_operator] = sym_spread_operator,
  [sym_arguments] = sym_arguments,
  [sym__args] = sym__args,
  [sym_function_call] = sym_function_call,
  [sym_command] = sym_command,
  [sym__range_element] = sym__range_element,
  [sym_range] = sym_range,
  [sym_elseif_clause] = sym_elseif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_iterator] = sym_iterator,
  [sym_parfor_options] = sym_parfor_options,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_case_clause] = sym_case_clause,
  [sym_otherwise_clause] = sym_otherwise_clause,
  [sym_switch_statement] = sym_switch_statement,
  [sym__lambda_arguments] = sym__lambda_arguments,
  [sym_lambda] = sym_lambda,
  [sym_global_operator] = sym_global_operator,
  [sym_persistent_operator] = sym_persistent_operator,
  [sym__argument_attributes] = sym_attributes,
  [sym_arguments_statement] = sym_arguments_statement,
  [sym_function_output] = sym_function_output,
  [sym_function_arguments] = sym_function_arguments,
  [sym_function_definition] = sym_function_definition,
  [sym__function_definition_with_end] = sym_function_definition,
  [sym_attribute] = sym_attribute,
  [sym_attributes] = sym_attributes,
  [sym_superclasses] = sym_superclasses,
  [sym_dimensions] = sym_dimensions,
  [sym_validation_functions] = sym_validation_functions,
  [sym_default_value] = sym_default_value,
  [sym_property_name] = sym_property_name,
  [sym_property] = sym_property,
  [sym_properties] = sym_properties,
  [sym_function_signature] = sym_function_signature,
  [sym_methods] = sym_methods,
  [sym_events] = sym_events,
  [sym__enum_value] = sym__enum_value,
  [sym_enum] = sym_enum,
  [sym_enumeration] = sym_enumeration,
  [sym_class_definition] = sym_class_definition,
  [sym_catch_clause] = sym_catch_clause,
  [sym_try_statement] = sym_try_statement,
  [sym_boolean] = sym_boolean,
  [sym__end_of_line] = sym__end_of_line,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym__block_repeat1] = aux_sym__block_repeat1,
  [aux_sym_field_expression_repeat1] = aux_sym_field_expression_repeat1,
  [aux_sym_handle_operator_repeat1] = aux_sym_handle_operator_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_row_repeat1] = aux_sym_row_repeat1,
  [aux_sym_matrix_repeat1] = aux_sym_matrix_repeat1,
  [aux_sym_multioutput_variable_repeat1] = aux_sym_multioutput_variable_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_arguments_repeat2] = aux_sym_arguments_repeat2,
  [aux_sym_command_repeat1] = aux_sym_command_repeat1,
  [aux_sym_elseif_clause_repeat1] = aux_sym_elseif_clause_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym__lambda_arguments_repeat1] = aux_sym__lambda_arguments_repeat1,
  [aux_sym_global_operator_repeat1] = aux_sym_global_operator_repeat1,
  [aux_sym__argument_attributes_repeat1] = aux_sym__argument_attributes_repeat1,
  [aux_sym_arguments_statement_repeat1] = aux_sym_arguments_statement_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_attributes_repeat1] = aux_sym_attributes_repeat1,
  [aux_sym_superclasses_repeat1] = aux_sym_superclasses_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym_validation_functions_repeat1] = aux_sym_validation_functions_repeat1,
  [aux_sym_methods_repeat1] = aux_sym_methods_repeat1,
  [aux_sym_events_repeat1] = aux_sym_events_repeat1,
  [aux_sym_enum_repeat1] = aux_sym_enum_repeat1,
  [aux_sym_enumeration_repeat1] = aux_sym_enumeration_repeat1,
  [aux_sym_class_definition_repeat1] = aux_sym_class_definition_repeat1,
  [alias_sym_superclass] = alias_sym_superclass,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_matrix_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_parfor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_otherwise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_persistent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_arguments] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endfunction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_properties] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_methods] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_events] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enumeration] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_classdef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_command_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__single_quote_string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__single_quote_string_end] = {
    .visible = true,
    .named = false,
  },
  [sym__double_quote_string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__double_quote_string_end] = {
    .visible = true,
    .named = false,
  },
  [sym_formatting_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym__entry_delimiter] = {
    .visible = false,
    .named = true,
  },
  [sym__multioutput_variable_start] = {
    .visible = true,
    .named = false,
  },
  [sym_error_sentinel] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__block] = {
    .visible = false,
    .named = false,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesis] = {
    .visible = true,
    .named = true,
  },
  [sym__binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_indirect_access] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_metaclass_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_handle_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_row] = {
    .visible = true,
    .named = true,
  },
  [sym_matrix] = {
    .visible = true,
    .named = true,
  },
  [sym_cell] = {
    .visible = true,
    .named = true,
  },
  [sym_ignored_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_multioutput_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__args] = {
    .visible = false,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym__range_element] = {
    .visible = false,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_iterator] = {
    .visible = true,
    .named = true,
  },
  [sym_parfor_options] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_otherwise_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__lambda_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_global_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_persistent_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__argument_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_output] = {
    .visible = true,
    .named = true,
  },
  [sym_function_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__function_definition_with_end] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_superclasses] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym_validation_functions] = {
    .visible = true,
    .named = true,
  },
  [sym_default_value] = {
    .visible = true,
    .named = true,
  },
  [sym_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_property] = {
    .visible = true,
    .named = true,
  },
  [sym_properties] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_methods] = {
    .visible = true,
    .named = true,
  },
  [sym_events] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_value] = {
    .visible = false,
    .named = true,
  },
  [sym_enum] = {
    .visible = true,
    .named = true,
  },
  [sym_enumeration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym__end_of_line] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_handle_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_row_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_matrix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multioutput_variable_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_elseif_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__lambda_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__argument_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_superclasses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_validation_functions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_methods_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_events_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumeration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_superclass] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_argument = 1,
  field_arguments = 2,
  field_condition = 3,
  field_expression = 4,
  field_field = 5,
  field_left = 6,
  field_name = 7,
  field_object = 8,
  field_operand = 9,
  field_right = 10,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_condition] = "condition",
  [field_expression] = "expression",
  [field_field] = "field",
  [field_left] = "left",
  [field_name] = "name",
  [field_object] = "object",
  [field_operand] = "operand",
  [field_right] = "right",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 6, .length = 1},
  [8] = {.index = 7, .length = 1},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 1},
  [11] = {.index = 10, .length = 2},
  [12] = {.index = 12, .length = 2},
  [13] = {.index = 14, .length = 1},
  [14] = {.index = 15, .length = 1},
  [15] = {.index = 16, .length = 2},
  [16] = {.index = 2, .length = 1},
  [17] = {.index = 2, .length = 1},
  [18] = {.index = 18, .length = 1},
  [19] = {.index = 19, .length = 1},
  [20] = {.index = 20, .length = 1},
  [21] = {.index = 21, .length = 1},
  [22] = {.index = 22, .length = 2},
  [23] = {.index = 24, .length = 1},
  [24] = {.index = 25, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_operand, 1},
  [1] =
    {field_operand, 0},
  [2] =
    {field_name, 0},
  [3] =
    {field_field, 1, .inherited = true},
    {field_object, 0},
  [5] =
    {field_name, 0, .inherited = true},
  [6] =
    {field_condition, 1},
  [7] =
    {field_name, 1},
  [8] =
    {field_argument, 0},
  [9] =
    {field_field, 1},
  [10] =
    {field_left, 0},
    {field_right, 2},
  [12] =
    {field_field, 0, .inherited = true},
    {field_field, 1, .inherited = true},
  [14] =
    {field_expression, 3},
  [15] =
    {field_name, 2},
  [16] =
    {field_argument, 0},
    {field_argument, 1, .inherited = true},
  [18] =
    {field_expression, 4},
  [19] =
    {field_arguments, 1},
  [20] =
    {field_name, 3},
  [21] =
    {field_argument, 1},
  [22] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [24] =
    {field_argument, 1, .inherited = true},
  [25] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [6] = {
    [0] = sym_identifier,
  },
  [16] = {
    [2] = alias_sym_superclass,
  },
  [17] = {
    [0] = sym_identifier,
    [2] = alias_sym_superclass,
  },
  [18] = {
    [2] = sym_arguments,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__lambda_arguments, 2,
    sym__lambda_arguments,
    sym_arguments,
  sym_property_name, 2,
    sym_property_name,
    alias_sym_superclass,
  sym_boolean, 2,
    sym_boolean,
    sym_identifier,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 49,
  [51] = 51,
  [52] = 47,
  [53] = 48,
  [54] = 51,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 46,
  [59] = 55,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 56,
  [64] = 64,
  [65] = 62,
  [66] = 66,
  [67] = 60,
  [68] = 66,
  [69] = 64,
  [70] = 45,
  [71] = 57,
  [72] = 61,
  [73] = 73,
  [74] = 57,
  [75] = 61,
  [76] = 76,
  [77] = 76,
  [78] = 76,
  [79] = 76,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 92,
  [96] = 96,
  [97] = 92,
  [98] = 92,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 112,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 119,
  [125] = 103,
  [126] = 102,
  [127] = 103,
  [128] = 102,
  [129] = 129,
  [130] = 102,
  [131] = 103,
  [132] = 104,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 119,
  [137] = 119,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 104,
  [147] = 109,
  [148] = 110,
  [149] = 111,
  [150] = 135,
  [151] = 116,
  [152] = 82,
  [153] = 81,
  [154] = 86,
  [155] = 90,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 160,
  [168] = 161,
  [169] = 166,
  [170] = 170,
  [171] = 171,
  [172] = 160,
  [173] = 173,
  [174] = 159,
  [175] = 161,
  [176] = 159,
  [177] = 177,
  [178] = 166,
  [179] = 160,
  [180] = 180,
  [181] = 159,
  [182] = 160,
  [183] = 166,
  [184] = 184,
  [185] = 159,
  [186] = 161,
  [187] = 84,
  [188] = 76,
  [189] = 80,
  [190] = 76,
  [191] = 76,
  [192] = 76,
  [193] = 193,
  [194] = 194,
  [195] = 89,
  [196] = 91,
  [197] = 93,
  [198] = 88,
  [199] = 199,
  [200] = 96,
  [201] = 99,
  [202] = 202,
  [203] = 94,
  [204] = 204,
  [205] = 87,
  [206] = 92,
  [207] = 207,
  [208] = 92,
  [209] = 92,
  [210] = 210,
  [211] = 211,
  [212] = 163,
  [213] = 213,
  [214] = 92,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 184,
  [219] = 219,
  [220] = 164,
  [221] = 177,
  [222] = 222,
  [223] = 173,
  [224] = 222,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 222,
  [236] = 219,
  [237] = 180,
  [238] = 219,
  [239] = 222,
  [240] = 234,
  [241] = 241,
  [242] = 76,
  [243] = 243,
  [244] = 216,
  [245] = 80,
  [246] = 246,
  [247] = 231,
  [248] = 76,
  [249] = 217,
  [250] = 234,
  [251] = 233,
  [252] = 76,
  [253] = 233,
  [254] = 216,
  [255] = 232,
  [256] = 230,
  [257] = 229,
  [258] = 228,
  [259] = 232,
  [260] = 227,
  [261] = 226,
  [262] = 225,
  [263] = 263,
  [264] = 264,
  [265] = 222,
  [266] = 266,
  [267] = 216,
  [268] = 268,
  [269] = 246,
  [270] = 219,
  [271] = 231,
  [272] = 272,
  [273] = 241,
  [274] = 219,
  [275] = 241,
  [276] = 216,
  [277] = 217,
  [278] = 225,
  [279] = 216,
  [280] = 216,
  [281] = 263,
  [282] = 282,
  [283] = 219,
  [284] = 226,
  [285] = 227,
  [286] = 228,
  [287] = 229,
  [288] = 230,
  [289] = 219,
  [290] = 232,
  [291] = 233,
  [292] = 292,
  [293] = 263,
  [294] = 234,
  [295] = 216,
  [296] = 83,
  [297] = 246,
  [298] = 222,
  [299] = 232,
  [300] = 234,
  [301] = 301,
  [302] = 217,
  [303] = 303,
  [304] = 304,
  [305] = 233,
  [306] = 85,
  [307] = 234,
  [308] = 308,
  [309] = 216,
  [310] = 310,
  [311] = 219,
  [312] = 222,
  [313] = 246,
  [314] = 219,
  [315] = 142,
  [316] = 231,
  [317] = 241,
  [318] = 318,
  [319] = 282,
  [320] = 222,
  [321] = 222,
  [322] = 219,
  [323] = 233,
  [324] = 219,
  [325] = 234,
  [326] = 233,
  [327] = 232,
  [328] = 230,
  [329] = 229,
  [330] = 222,
  [331] = 222,
  [332] = 232,
  [333] = 216,
  [334] = 233,
  [335] = 234,
  [336] = 228,
  [337] = 227,
  [338] = 76,
  [339] = 219,
  [340] = 226,
  [341] = 341,
  [342] = 342,
  [343] = 225,
  [344] = 232,
  [345] = 345,
  [346] = 222,
  [347] = 222,
  [348] = 348,
  [349] = 349,
  [350] = 216,
  [351] = 263,
  [352] = 219,
  [353] = 216,
  [354] = 216,
  [355] = 231,
  [356] = 86,
  [357] = 357,
  [358] = 76,
  [359] = 80,
  [360] = 82,
  [361] = 76,
  [362] = 76,
  [363] = 84,
  [364] = 76,
  [365] = 81,
  [366] = 76,
  [367] = 99,
  [368] = 368,
  [369] = 90,
  [370] = 370,
  [371] = 84,
  [372] = 94,
  [373] = 92,
  [374] = 374,
  [375] = 93,
  [376] = 88,
  [377] = 91,
  [378] = 92,
  [379] = 379,
  [380] = 92,
  [381] = 87,
  [382] = 92,
  [383] = 383,
  [384] = 89,
  [385] = 385,
  [386] = 96,
  [387] = 129,
  [388] = 119,
  [389] = 145,
  [390] = 92,
  [391] = 144,
  [392] = 101,
  [393] = 141,
  [394] = 140,
  [395] = 139,
  [396] = 123,
  [397] = 102,
  [398] = 120,
  [399] = 138,
  [400] = 379,
  [401] = 87,
  [402] = 379,
  [403] = 100,
  [404] = 92,
  [405] = 103,
  [406] = 114,
  [407] = 102,
  [408] = 133,
  [409] = 113,
  [410] = 142,
  [411] = 119,
  [412] = 93,
  [413] = 116,
  [414] = 104,
  [415] = 88,
  [416] = 108,
  [417] = 102,
  [418] = 103,
  [419] = 107,
  [420] = 106,
  [421] = 379,
  [422] = 115,
  [423] = 379,
  [424] = 96,
  [425] = 99,
  [426] = 379,
  [427] = 105,
  [428] = 119,
  [429] = 112,
  [430] = 103,
  [431] = 102,
  [432] = 135,
  [433] = 134,
  [434] = 118,
  [435] = 111,
  [436] = 92,
  [437] = 103,
  [438] = 110,
  [439] = 122,
  [440] = 379,
  [441] = 91,
  [442] = 109,
  [443] = 112,
  [444] = 104,
  [445] = 121,
  [446] = 119,
  [447] = 94,
  [448] = 143,
  [449] = 89,
  [450] = 92,
  [451] = 142,
  [452] = 86,
  [453] = 85,
  [454] = 81,
  [455] = 82,
  [456] = 83,
  [457] = 457,
  [458] = 83,
  [459] = 459,
  [460] = 90,
  [461] = 82,
  [462] = 81,
  [463] = 463,
  [464] = 104,
  [465] = 85,
  [466] = 86,
  [467] = 141,
  [468] = 109,
  [469] = 103,
  [470] = 103,
  [471] = 90,
  [472] = 102,
  [473] = 138,
  [474] = 102,
  [475] = 115,
  [476] = 114,
  [477] = 113,
  [478] = 108,
  [479] = 145,
  [480] = 144,
  [481] = 101,
  [482] = 104,
  [483] = 118,
  [484] = 140,
  [485] = 123,
  [486] = 139,
  [487] = 121,
  [488] = 109,
  [489] = 103,
  [490] = 110,
  [491] = 107,
  [492] = 102,
  [493] = 111,
  [494] = 100,
  [495] = 106,
  [496] = 105,
  [497] = 133,
  [498] = 104,
  [499] = 134,
  [500] = 135,
  [501] = 110,
  [502] = 116,
  [503] = 143,
  [504] = 112,
  [505] = 122,
  [506] = 112,
  [507] = 119,
  [508] = 116,
  [509] = 135,
  [510] = 103,
  [511] = 129,
  [512] = 102,
  [513] = 119,
  [514] = 120,
  [515] = 111,
  [516] = 119,
  [517] = 119,
  [518] = 122,
  [519] = 102,
  [520] = 143,
  [521] = 112,
  [522] = 111,
  [523] = 104,
  [524] = 129,
  [525] = 102,
  [526] = 133,
  [527] = 100,
  [528] = 134,
  [529] = 105,
  [530] = 103,
  [531] = 106,
  [532] = 107,
  [533] = 119,
  [534] = 108,
  [535] = 113,
  [536] = 114,
  [537] = 139,
  [538] = 140,
  [539] = 119,
  [540] = 115,
  [541] = 141,
  [542] = 101,
  [543] = 144,
  [544] = 145,
  [545] = 104,
  [546] = 103,
  [547] = 109,
  [548] = 138,
  [549] = 135,
  [550] = 112,
  [551] = 102,
  [552] = 103,
  [553] = 110,
  [554] = 123,
  [555] = 103,
  [556] = 118,
  [557] = 102,
  [558] = 121,
  [559] = 119,
  [560] = 119,
  [561] = 116,
  [562] = 120,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 104,
  [569] = 564,
  [570] = 566,
  [571] = 565,
  [572] = 110,
  [573] = 566,
  [574] = 565,
  [575] = 566,
  [576] = 564,
  [577] = 564,
  [578] = 565,
  [579] = 566,
  [580] = 109,
  [581] = 564,
  [582] = 565,
  [583] = 564,
  [584] = 116,
  [585] = 565,
  [586] = 111,
  [587] = 104,
  [588] = 566,
  [589] = 135,
  [590] = 590,
  [591] = 110,
  [592] = 119,
  [593] = 593,
  [594] = 119,
  [595] = 135,
  [596] = 109,
  [597] = 111,
  [598] = 116,
  [599] = 119,
  [600] = 112,
  [601] = 112,
  [602] = 112,
  [603] = 86,
  [604] = 90,
  [605] = 605,
  [606] = 606,
  [607] = 81,
  [608] = 82,
  [609] = 609,
  [610] = 86,
  [611] = 82,
  [612] = 612,
  [613] = 613,
  [614] = 81,
  [615] = 86,
  [616] = 612,
  [617] = 90,
  [618] = 612,
  [619] = 612,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 81,
  [624] = 624,
  [625] = 622,
  [626] = 90,
  [627] = 627,
  [628] = 82,
  [629] = 622,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 89,
  [639] = 88,
  [640] = 640,
  [641] = 96,
  [642] = 642,
  [643] = 643,
  [644] = 99,
  [645] = 94,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 91,
  [650] = 84,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 93,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 83,
  [678] = 156,
  [679] = 679,
  [680] = 85,
  [681] = 679,
  [682] = 682,
  [683] = 157,
  [684] = 684,
  [685] = 679,
  [686] = 679,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 689,
  [694] = 691,
  [695] = 689,
  [696] = 689,
  [697] = 697,
  [698] = 689,
  [699] = 697,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 708,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 708,
  [716] = 716,
  [717] = 708,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 708,
  [738] = 738,
  [739] = 739,
  [740] = 731,
  [741] = 733,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 779,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 802,
  [803] = 801,
  [804] = 804,
  [805] = 804,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 801,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 801,
  [814] = 802,
  [815] = 801,
  [816] = 801,
  [817] = 817,
  [818] = 801,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 800,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 802,
  [833] = 822,
  [834] = 804,
  [835] = 835,
  [836] = 821,
  [837] = 801,
  [838] = 838,
  [839] = 839,
  [840] = 801,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 801,
  [847] = 847,
  [848] = 848,
  [849] = 842,
  [850] = 850,
  [851] = 851,
  [852] = 799,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 829,
  [860] = 821,
  [861] = 861,
  [862] = 862,
  [863] = 822,
  [864] = 864,
  [865] = 831,
  [866] = 866,
  [867] = 867,
  [868] = 821,
  [869] = 869,
  [870] = 870,
  [871] = 801,
  [872] = 801,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 822,
  [878] = 878,
  [879] = 851,
  [880] = 801,
  [881] = 881,
  [882] = 831,
  [883] = 804,
  [884] = 800,
  [885] = 802,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 750,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 778,
  [906] = 783,
  [907] = 907,
  [908] = 908,
  [909] = 784,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 792,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 791,
  [925] = 925,
  [926] = 926,
  [927] = 777,
  [928] = 928,
  [929] = 774,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 911,
  [941] = 930,
  [942] = 942,
  [943] = 651,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 911,
  [954] = 954,
  [955] = 930,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 911,
  [961] = 773,
  [962] = 962,
  [963] = 788,
  [964] = 786,
  [965] = 965,
  [966] = 785,
  [967] = 967,
  [968] = 968,
  [969] = 969,
  [970] = 970,
  [971] = 911,
  [972] = 972,
  [973] = 973,
  [974] = 974,
  [975] = 975,
  [976] = 930,
  [977] = 977,
  [978] = 978,
  [979] = 979,
  [980] = 719,
  [981] = 981,
  [982] = 982,
  [983] = 983,
  [984] = 930,
  [985] = 985,
  [986] = 986,
  [987] = 987,
  [988] = 988,
  [989] = 989,
  [990] = 990,
  [991] = 991,
  [992] = 992,
  [993] = 993,
  [994] = 994,
  [995] = 995,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 996,
  [1016] = 998,
  [1017] = 987,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 996,
  [1022] = 998,
  [1023] = 1018,
  [1024] = 1019,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1019,
  [1032] = 1030,
  [1033] = 1028,
  [1034] = 1034,
  [1035] = 1025,
  [1036] = 1018,
  [1037] = 998,
  [1038] = 1038,
  [1039] = 996,
  [1040] = 1040,
  [1041] = 1012,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 996,
  [1045] = 998,
  [1046] = 1046,
  [1047] = 1028,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1028,
  [1051] = 1030,
  [1052] = 1018,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1019,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1030,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1060,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1061,
  [1068] = 1068,
  [1069] = 1066,
  [1070] = 1070,
  [1071] = 1061,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1060,
  [1079] = 1079,
  [1080] = 1066,
  [1081] = 1061,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 684,
  [1086] = 1060,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1066,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1077,
  [1093] = 1063,
  [1094] = 1061,
  [1095] = 1065,
  [1096] = 1060,
  [1097] = 1066,
  [1098] = 687,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1060,
  [1105] = 1082,
  [1106] = 1106,
  [1107] = 1060,
  [1108] = 1087,
  [1109] = 1060,
  [1110] = 1060,
  [1111] = 1060,
  [1112] = 1112,
  [1113] = 1100,
  [1114] = 1114,
  [1115] = 1075,
  [1116] = 1060,
  [1117] = 1074,
  [1118] = 1118,
  [1119] = 1060,
  [1120] = 1064,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1068,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1070,
  [1127] = 1072,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1060,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1138,
  [1140] = 1140,
  [1141] = 1136,
  [1142] = 1136,
  [1143] = 1135,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1136,
  [1148] = 1138,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1135,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1149,
  [1156] = 1136,
  [1157] = 1138,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1136,
  [1162] = 1138,
  [1163] = 1163,
  [1164] = 1159,
  [1165] = 1165,
  [1166] = 1136,
  [1167] = 1138,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1135,
  [1173] = 1149,
  [1174] = 1138,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1149,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1136,
  [1181] = 1159,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1149,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1159,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 973,
  [1194] = 1194,
  [1195] = 1136,
  [1196] = 1135,
  [1197] = 1137,
  [1198] = 1136,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1136,
  [1202] = 1202,
  [1203] = 1136,
  [1204] = 1138,
  [1205] = 950,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1136,
  [1209] = 1209,
  [1210] = 1210,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1150,
  [1216] = 1216,
  [1217] = 1158,
  [1218] = 1218,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(16);
      if (lookahead == '&') ADVANCE(35);
      if (lookahead == '\'') ADVANCE(53);
      if (lookahead == '(') ADVANCE(19);
      if (lookahead == ')') ADVANCE(20);
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '+') ADVANCE(21);
      if (lookahead == ',') ADVANCE(18);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(38);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '<') ADVANCE(44);
      if (lookahead == '=') ADVANCE(61);
      if (lookahead == '>') ADVANCE(49);
      if (lookahead == '?') ADVANCE(42);
      if (lookahead == '@') ADVANCE(43);
      if (lookahead == '[') ADVANCE(54);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == ']') ADVANCE(57);
      if (lookahead == '^') ADVANCE(31);
      if (lookahead == 'g') ADVANCE(71);
      if (lookahead == 's') ADVANCE(72);
      if (lookahead == '{') ADVANCE(58);
      if (lookahead == '|') ADVANCE(33);
      if (lookahead == '}') ADVANCE(59);
      if (lookahead == '~') ADVANCE(41);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(76);
      if (lookahead == '\r') ADVANCE(77);
      if (lookahead == '&') ADVANCE(35);
      if (lookahead == '(') ADVANCE(19);
      if (lookahead == '+') ADVANCE(21);
      if (lookahead == ',') ADVANCE(18);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '<') ADVANCE(44);
      if (lookahead == '=') ADVANCE(61);
      if (lookahead == '>') ADVANCE(49);
      if (lookahead == '?') ADVANCE(42);
      if (lookahead == '@') ADVANCE(43);
      if (lookahead == '[') ADVANCE(54);
      if (lookahead == '{') ADVANCE(58);
      if (lookahead == '|') ADVANCE(10);
      if (lookahead == '~') ADVANCE(41);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(1)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(76);
      if (lookahead == '\r') ADVANCE(77);
      if (lookahead == '&') ADVANCE(34);
      if (lookahead == '(') ADVANCE(19);
      if (lookahead == '+') ADVANCE(21);
      if (lookahead == ',') ADVANCE(18);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '=') ADVANCE(60);
      if (lookahead == '?') ADVANCE(42);
      if (lookahead == '@') ADVANCE(43);
      if (lookahead == '[') ADVANCE(54);
      if (lookahead == '{') ADVANCE(58);
      if (lookahead == '~') ADVANCE(40);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 3:
      if (lookahead == '&') ADVANCE(35);
      if (lookahead == '\'') ADVANCE(53);
      if (lookahead == '(') ADVANCE(19);
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '+') ADVANCE(21);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(37);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(44);
      if (lookahead == '=') ADVANCE(8);
      if (lookahead == '>') ADVANCE(49);
      if (lookahead == '@') ADVANCE(43);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == ']') ADVANCE(57);
      if (lookahead == '^') ADVANCE(31);
      if (lookahead == '{') ADVANCE(58);
      if (lookahead == '|') ADVANCE(33);
      if (lookahead == '}') ADVANCE(59);
      if (lookahead == '~') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(3)
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(56);
      END_STATE();
    case 4:
      if (lookahead == '&') ADVANCE(50);
      END_STATE();
    case 5:
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '(') ADVANCE(19);
      if (lookahead == ')') ADVANCE(20);
      if (lookahead == ',') ADVANCE(18);
      if (lookahead == '.') ADVANCE(36);
      if (lookahead == '<') ADVANCE(44);
      if (lookahead == '=') ADVANCE(8);
      if (lookahead == '>') ADVANCE(49);
      if (lookahead == '{') ADVANCE(58);
      if (lookahead == '|') ADVANCE(10);
      if (lookahead == '}') ADVANCE(59);
      if (lookahead == '~') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '.') ADVANCE(36);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(44);
      if (lookahead == '=') ADVANCE(8);
      if (lookahead == '>') ADVANCE(49);
      if (lookahead == ']') ADVANCE(57);
      if (lookahead == '|') ADVANCE(10);
      if (lookahead == '}') ADVANCE(59);
      if (lookahead == '~') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(6)
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(56);
      END_STATE();
    case 7:
      if (lookahead == '(') ADVANCE(19);
      if (lookahead == '+') ADVANCE(21);
      if (lookahead == ',') ADVANCE(18);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(12);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '?') ADVANCE(42);
      if (lookahead == '@') ADVANCE(43);
      if (lookahead == '[') ADVANCE(54);
      if (lookahead == ']') ADVANCE(57);
      if (lookahead == '{') ADVANCE(58);
      if (lookahead == '}') ADVANCE(59);
      if (lookahead == '~') ADVANCE(40);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(7)
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 8:
      if (lookahead == '=') ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 10:
      if (lookahead == '|') ADVANCE(51);
      END_STATE();
    case 11:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      END_STATE();
    case 12:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 13:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      END_STATE();
    case 14:
      if (eof) ADVANCE(16);
      if (lookahead == '\n') ADVANCE(76);
      if (lookahead == '\r') ADVANCE(77);
      if (lookahead == '&') ADVANCE(35);
      if (lookahead == '\'') ADVANCE(53);
      if (lookahead == '(') ADVANCE(19);
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '+') ADVANCE(21);
      if (lookahead == ',') ADVANCE(18);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(38);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '<') ADVANCE(44);
      if (lookahead == '=') ADVANCE(61);
      if (lookahead == '>') ADVANCE(49);
      if (lookahead == '?') ADVANCE(42);
      if (lookahead == '@') ADVANCE(43);
      if (lookahead == '[') ADVANCE(54);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == '^') ADVANCE(31);
      if (lookahead == '{') ADVANCE(58);
      if (lookahead == '|') ADVANCE(33);
      if (lookahead == '~') ADVANCE(41);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(14)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 15:
      if (eof) ADVANCE(16);
      if (lookahead == '(') ADVANCE(19);
      if (lookahead == ')') ADVANCE(20);
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '+') ADVANCE(21);
      if (lookahead == ',') ADVANCE(18);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '=') ADVANCE(60);
      if (lookahead == '?') ADVANCE(42);
      if (lookahead == '@') ADVANCE(43);
      if (lookahead == '[') ADVANCE(54);
      if (lookahead == ']') ADVANCE(57);
      if (lookahead == '{') ADVANCE(58);
      if (lookahead == '}') ADVANCE(59);
      if (lookahead == '~') ADVANCE(40);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_DOT_PLUS);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_DOT_DASH);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_DOT_STAR);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_DOT_SLASH);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_DOT_BSLASH);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DOT_CARET);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(51);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(50);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '\'') ADVANCE(52);
      if (lookahead == '*') ADVANCE(26);
      if (lookahead == '+') ADVANCE(22);
      if (lookahead == '-') ADVANCE(24);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(32);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '\'') ADVANCE(52);
      if (lookahead == '*') ADVANCE(26);
      if (lookahead == '+') ADVANCE(22);
      if (lookahead == '-') ADVANCE(24);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(48);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_DOT_SQUOTE);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(aux_sym_matrix_token1);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym_matrix_token1);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(56);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(46);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_get_DOT);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_set_DOT);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(11);
      if (lookahead == 'i' ||
          lookahead == 'j') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(11);
      if (lookahead == 'i' ||
          lookahead == 'j') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'i' ||
          lookahead == 'j') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(76);
      if (lookahead == '\r') ADVANCE(77);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(76);
      if (lookahead == '\r') ADVANCE(77);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'g') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'm') ADVANCE(8);
      if (lookahead == 'o') ADVANCE(9);
      if (lookahead == 'p') ADVANCE(10);
      if (lookahead == 'r') ADVANCE(11);
      if (lookahead == 's') ADVANCE(12);
      if (lookahead == 't') ADVANCE(13);
      if (lookahead == 'w') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'r') ADVANCE(15);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(17);
      if (lookahead == 'l') ADVANCE(18);
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 4:
      if (lookahead == 'l') ADVANCE(20);
      if (lookahead == 'n') ADVANCE(21);
      if (lookahead == 'v') ADVANCE(22);
      END_STATE();
    case 5:
      if (lookahead == 'a') ADVANCE(23);
      if (lookahead == 'o') ADVANCE(24);
      if (lookahead == 'u') ADVANCE(25);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(26);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(27);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(28);
      END_STATE();
    case 9:
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 12:
      if (lookahead == 'w') ADVANCE(34);
      END_STATE();
    case 13:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(36);
      END_STATE();
    case 15:
      if (lookahead == 'g') ADVANCE(37);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 17:
      if (lookahead == 's') ADVANCE(39);
      if (lookahead == 't') ADVANCE(40);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(41);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(42);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 21:
      if (lookahead == 'd') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(46);
      END_STATE();
    case 23:
      if (lookahead == 'l') ADVANCE(47);
      END_STATE();
    case 24:
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 25:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 29:
      if (lookahead == 'h') ADVANCE(52);
      END_STATE();
    case 30:
      if (lookahead == 'r') ADVANCE(53);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(58);
      if (lookahead == 'y') ADVANCE(59);
      END_STATE();
    case 36:
      if (lookahead == 'i') ADVANCE(60);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(61);
      END_STATE();
    case 38:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 40:
      if (lookahead == 'c') ADVANCE(64);
      END_STATE();
    case 41:
      if (lookahead == 's') ADVANCE(65);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_end);
      if (lookahead == 'f') ADVANCE(68);
      END_STATE();
    case 45:
      if (lookahead == 'm') ADVANCE(69);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 47:
      if (lookahead == 's') ADVANCE(71);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 49:
      if (lookahead == 'c') ADVANCE(72);
      END_STATE();
    case 50:
      if (lookahead == 'b') ADVANCE(73);
      END_STATE();
    case 51:
      if (lookahead == 'h') ADVANCE(74);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 53:
      if (lookahead == 'f') ADVANCE(76);
      END_STATE();
    case 54:
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 55:
      if (lookahead == 'p') ADVANCE(78);
      END_STATE();
    case 56:
      if (lookahead == 'u') ADVANCE(79);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 60:
      if (lookahead == 'l') ADVANCE(82);
      END_STATE();
    case 61:
      if (lookahead == 'm') ADVANCE(83);
      END_STATE();
    case 62:
      if (lookahead == 'k') ADVANCE(84);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 64:
      if (lookahead == 'h') ADVANCE(85);
      END_STATE();
    case 65:
      if (lookahead == 's') ADVANCE(86);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(87);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(88);
      END_STATE();
    case 68:
      if (lookahead == 'u') ADVANCE(89);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 70:
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(93);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(94);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(95);
      END_STATE();
    case 75:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 77:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 80:
      if (lookahead == 'c') ADVANCE(101);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(103);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 86:
      if (lookahead == 'd') ADVANCE(104);
      END_STATE();
    case 87:
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 88:
      if (lookahead == 'f') ADVANCE(106);
      END_STATE();
    case 89:
      if (lookahead == 'n') ADVANCE(107);
      END_STATE();
    case 90:
      if (lookahead == 'r') ADVANCE(108);
      END_STATE();
    case 91:
      if (lookahead == 's') ADVANCE(109);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(110);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(111);
      END_STATE();
    case 95:
      if (lookahead == 'd') ADVANCE(112);
      END_STATE();
    case 96:
      if (lookahead == 'w') ADVANCE(113);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(114);
      END_STATE();
    case 98:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 99:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 100:
      if (lookahead == 'n') ADVANCE(117);
      END_STATE();
    case 101:
      if (lookahead == 'h') ADVANCE(118);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 103:
      if (lookahead == 'n') ADVANCE(119);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 105:
      if (lookahead == 'u') ADVANCE(121);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 107:
      if (lookahead == 'c') ADVANCE(122);
      END_STATE();
    case 108:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_events);
      END_STATE();
    case 110:
      if (lookahead == 'o') ADVANCE(124);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 112:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 113:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_parfor);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(127);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(128);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_return_statement);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 120:
      if (lookahead == 'f') ADVANCE(130);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(133);
      END_STATE();
    case 124:
      if (lookahead == 'n') ADVANCE(134);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_methods);
      END_STATE();
    case 126:
      if (lookahead == 's') ADVANCE(135);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 128:
      if (lookahead == 'i') ADVANCE(137);
      END_STATE();
    case 129:
      if (lookahead == 's') ADVANCE(138);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_classdef);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_continue_statement);
      END_STATE();
    case 132:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 133:
      if (lookahead == 'i') ADVANCE(140);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 135:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 136:
      if (lookahead == 'n') ADVANCE(142);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_arguments);
      END_STATE();
    case 139:
      if (lookahead == 'o') ADVANCE(144);
      END_STATE();
    case 140:
      if (lookahead == 'o') ADVANCE(145);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_otherwise);
      END_STATE();
    case 142:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 143:
      if (lookahead == 's') ADVANCE(147);
      END_STATE();
    case 144:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 145:
      if (lookahead == 'n') ADVANCE(149);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_persistent);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_properties);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_endfunction);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_enumeration);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 15, .external_lex_state = 2},
  [2] = {.lex_state = 14, .external_lex_state = 2},
  [3] = {.lex_state = 14, .external_lex_state = 2},
  [4] = {.lex_state = 14, .external_lex_state = 2},
  [5] = {.lex_state = 2, .external_lex_state = 2},
  [6] = {.lex_state = 2, .external_lex_state = 2},
  [7] = {.lex_state = 2, .external_lex_state = 2},
  [8] = {.lex_state = 2, .external_lex_state = 2},
  [9] = {.lex_state = 2, .external_lex_state = 2},
  [10] = {.lex_state = 2, .external_lex_state = 2},
  [11] = {.lex_state = 2, .external_lex_state = 2},
  [12] = {.lex_state = 2, .external_lex_state = 2},
  [13] = {.lex_state = 2, .external_lex_state = 2},
  [14] = {.lex_state = 2, .external_lex_state = 2},
  [15] = {.lex_state = 2, .external_lex_state = 2},
  [16] = {.lex_state = 2, .external_lex_state = 2},
  [17] = {.lex_state = 2, .external_lex_state = 2},
  [18] = {.lex_state = 2, .external_lex_state = 2},
  [19] = {.lex_state = 2, .external_lex_state = 2},
  [20] = {.lex_state = 2, .external_lex_state = 2},
  [21] = {.lex_state = 15, .external_lex_state = 2},
  [22] = {.lex_state = 15, .external_lex_state = 2},
  [23] = {.lex_state = 15, .external_lex_state = 2},
  [24] = {.lex_state = 15, .external_lex_state = 2},
  [25] = {.lex_state = 15, .external_lex_state = 2},
  [26] = {.lex_state = 15, .external_lex_state = 2},
  [27] = {.lex_state = 15, .external_lex_state = 2},
  [28] = {.lex_state = 15, .external_lex_state = 2},
  [29] = {.lex_state = 15, .external_lex_state = 2},
  [30] = {.lex_state = 15, .external_lex_state = 2},
  [31] = {.lex_state = 15, .external_lex_state = 2},
  [32] = {.lex_state = 15, .external_lex_state = 2},
  [33] = {.lex_state = 15, .external_lex_state = 2},
  [34] = {.lex_state = 15, .external_lex_state = 2},
  [35] = {.lex_state = 15, .external_lex_state = 2},
  [36] = {.lex_state = 15, .external_lex_state = 2},
  [37] = {.lex_state = 15, .external_lex_state = 2},
  [38] = {.lex_state = 15, .external_lex_state = 2},
  [39] = {.lex_state = 15, .external_lex_state = 2},
  [40] = {.lex_state = 15, .external_lex_state = 2},
  [41] = {.lex_state = 15, .external_lex_state = 2},
  [42] = {.lex_state = 15, .external_lex_state = 2},
  [43] = {.lex_state = 15, .external_lex_state = 2},
  [44] = {.lex_state = 15, .external_lex_state = 2},
  [45] = {.lex_state = 15, .external_lex_state = 2},
  [46] = {.lex_state = 15, .external_lex_state = 2},
  [47] = {.lex_state = 15, .external_lex_state = 2},
  [48] = {.lex_state = 15, .external_lex_state = 2},
  [49] = {.lex_state = 15, .external_lex_state = 2},
  [50] = {.lex_state = 15, .external_lex_state = 2},
  [51] = {.lex_state = 15, .external_lex_state = 2},
  [52] = {.lex_state = 15, .external_lex_state = 2},
  [53] = {.lex_state = 15, .external_lex_state = 2},
  [54] = {.lex_state = 15, .external_lex_state = 2},
  [55] = {.lex_state = 15, .external_lex_state = 2},
  [56] = {.lex_state = 15, .external_lex_state = 2},
  [57] = {.lex_state = 15, .external_lex_state = 2},
  [58] = {.lex_state = 15, .external_lex_state = 2},
  [59] = {.lex_state = 15, .external_lex_state = 2},
  [60] = {.lex_state = 15, .external_lex_state = 2},
  [61] = {.lex_state = 15, .external_lex_state = 2},
  [62] = {.lex_state = 15, .external_lex_state = 2},
  [63] = {.lex_state = 15, .external_lex_state = 2},
  [64] = {.lex_state = 15, .external_lex_state = 2},
  [65] = {.lex_state = 15, .external_lex_state = 2},
  [66] = {.lex_state = 15, .external_lex_state = 2},
  [67] = {.lex_state = 15, .external_lex_state = 2},
  [68] = {.lex_state = 15, .external_lex_state = 2},
  [69] = {.lex_state = 15, .external_lex_state = 2},
  [70] = {.lex_state = 15, .external_lex_state = 2},
  [71] = {.lex_state = 15, .external_lex_state = 2},
  [72] = {.lex_state = 15, .external_lex_state = 2},
  [73] = {.lex_state = 15, .external_lex_state = 2},
  [74] = {.lex_state = 15, .external_lex_state = 2},
  [75] = {.lex_state = 15, .external_lex_state = 2},
  [76] = {.lex_state = 14, .external_lex_state = 2},
  [77] = {.lex_state = 14, .external_lex_state = 2},
  [78] = {.lex_state = 14, .external_lex_state = 2},
  [79] = {.lex_state = 14, .external_lex_state = 2},
  [80] = {.lex_state = 14, .external_lex_state = 2},
  [81] = {.lex_state = 14, .external_lex_state = 2},
  [82] = {.lex_state = 14, .external_lex_state = 2},
  [83] = {.lex_state = 14, .external_lex_state = 2},
  [84] = {.lex_state = 14, .external_lex_state = 2},
  [85] = {.lex_state = 14, .external_lex_state = 2},
  [86] = {.lex_state = 14, .external_lex_state = 2},
  [87] = {.lex_state = 14, .external_lex_state = 2},
  [88] = {.lex_state = 14, .external_lex_state = 2},
  [89] = {.lex_state = 14, .external_lex_state = 2},
  [90] = {.lex_state = 14, .external_lex_state = 2},
  [91] = {.lex_state = 14, .external_lex_state = 2},
  [92] = {.lex_state = 14, .external_lex_state = 2},
  [93] = {.lex_state = 14, .external_lex_state = 2},
  [94] = {.lex_state = 14, .external_lex_state = 2},
  [95] = {.lex_state = 14, .external_lex_state = 2},
  [96] = {.lex_state = 14, .external_lex_state = 2},
  [97] = {.lex_state = 14, .external_lex_state = 2},
  [98] = {.lex_state = 14, .external_lex_state = 2},
  [99] = {.lex_state = 14, .external_lex_state = 2},
  [100] = {.lex_state = 14, .external_lex_state = 2},
  [101] = {.lex_state = 14, .external_lex_state = 2},
  [102] = {.lex_state = 14, .external_lex_state = 2},
  [103] = {.lex_state = 14, .external_lex_state = 2},
  [104] = {.lex_state = 14, .external_lex_state = 2},
  [105] = {.lex_state = 14, .external_lex_state = 2},
  [106] = {.lex_state = 14, .external_lex_state = 2},
  [107] = {.lex_state = 14, .external_lex_state = 2},
  [108] = {.lex_state = 14, .external_lex_state = 2},
  [109] = {.lex_state = 14, .external_lex_state = 2},
  [110] = {.lex_state = 14, .external_lex_state = 2},
  [111] = {.lex_state = 14, .external_lex_state = 2},
  [112] = {.lex_state = 14, .external_lex_state = 2},
  [113] = {.lex_state = 14, .external_lex_state = 2},
  [114] = {.lex_state = 14, .external_lex_state = 2},
  [115] = {.lex_state = 14, .external_lex_state = 2},
  [116] = {.lex_state = 14, .external_lex_state = 2},
  [117] = {.lex_state = 14, .external_lex_state = 2},
  [118] = {.lex_state = 14, .external_lex_state = 2},
  [119] = {.lex_state = 14, .external_lex_state = 2},
  [120] = {.lex_state = 14, .external_lex_state = 2},
  [121] = {.lex_state = 14, .external_lex_state = 2},
  [122] = {.lex_state = 14, .external_lex_state = 2},
  [123] = {.lex_state = 14, .external_lex_state = 2},
  [124] = {.lex_state = 14, .external_lex_state = 2},
  [125] = {.lex_state = 14, .external_lex_state = 2},
  [126] = {.lex_state = 14, .external_lex_state = 2},
  [127] = {.lex_state = 14, .external_lex_state = 2},
  [128] = {.lex_state = 14, .external_lex_state = 2},
  [129] = {.lex_state = 14, .external_lex_state = 2},
  [130] = {.lex_state = 14, .external_lex_state = 2},
  [131] = {.lex_state = 14, .external_lex_state = 2},
  [132] = {.lex_state = 14, .external_lex_state = 2},
  [133] = {.lex_state = 14, .external_lex_state = 2},
  [134] = {.lex_state = 14, .external_lex_state = 2},
  [135] = {.lex_state = 14, .external_lex_state = 2},
  [136] = {.lex_state = 14, .external_lex_state = 2},
  [137] = {.lex_state = 14, .external_lex_state = 2},
  [138] = {.lex_state = 14, .external_lex_state = 2},
  [139] = {.lex_state = 14, .external_lex_state = 2},
  [140] = {.lex_state = 14, .external_lex_state = 2},
  [141] = {.lex_state = 14, .external_lex_state = 2},
  [142] = {.lex_state = 14, .external_lex_state = 2},
  [143] = {.lex_state = 14, .external_lex_state = 2},
  [144] = {.lex_state = 14, .external_lex_state = 2},
  [145] = {.lex_state = 14, .external_lex_state = 2},
  [146] = {.lex_state = 14, .external_lex_state = 2},
  [147] = {.lex_state = 14, .external_lex_state = 2},
  [148] = {.lex_state = 14, .external_lex_state = 2},
  [149] = {.lex_state = 14, .external_lex_state = 2},
  [150] = {.lex_state = 14, .external_lex_state = 2},
  [151] = {.lex_state = 14, .external_lex_state = 2},
  [152] = {.lex_state = 1, .external_lex_state = 2},
  [153] = {.lex_state = 1, .external_lex_state = 2},
  [154] = {.lex_state = 1, .external_lex_state = 2},
  [155] = {.lex_state = 1, .external_lex_state = 2},
  [156] = {.lex_state = 14, .external_lex_state = 2},
  [157] = {.lex_state = 2, .external_lex_state = 2},
  [158] = {.lex_state = 7, .external_lex_state = 3},
  [159] = {.lex_state = 15, .external_lex_state = 3},
  [160] = {.lex_state = 15, .external_lex_state = 3},
  [161] = {.lex_state = 15, .external_lex_state = 3},
  [162] = {.lex_state = 7, .external_lex_state = 3},
  [163] = {.lex_state = 7, .external_lex_state = 4},
  [164] = {.lex_state = 15, .external_lex_state = 2},
  [165] = {.lex_state = 7, .external_lex_state = 3},
  [166] = {.lex_state = 15, .external_lex_state = 3},
  [167] = {.lex_state = 15, .external_lex_state = 3},
  [168] = {.lex_state = 15, .external_lex_state = 3},
  [169] = {.lex_state = 15, .external_lex_state = 3},
  [170] = {.lex_state = 15, .external_lex_state = 3},
  [171] = {.lex_state = 7, .external_lex_state = 3},
  [172] = {.lex_state = 15, .external_lex_state = 3},
  [173] = {.lex_state = 15, .external_lex_state = 2},
  [174] = {.lex_state = 15, .external_lex_state = 3},
  [175] = {.lex_state = 15, .external_lex_state = 3},
  [176] = {.lex_state = 15, .external_lex_state = 3},
  [177] = {.lex_state = 15, .external_lex_state = 2},
  [178] = {.lex_state = 15, .external_lex_state = 3},
  [179] = {.lex_state = 15, .external_lex_state = 3},
  [180] = {.lex_state = 15, .external_lex_state = 2},
  [181] = {.lex_state = 15, .external_lex_state = 3},
  [182] = {.lex_state = 15, .external_lex_state = 3},
  [183] = {.lex_state = 15, .external_lex_state = 3},
  [184] = {.lex_state = 15, .external_lex_state = 2},
  [185] = {.lex_state = 15, .external_lex_state = 3},
  [186] = {.lex_state = 15, .external_lex_state = 3},
  [187] = {.lex_state = 14, .external_lex_state = 5},
  [188] = {.lex_state = 14, .external_lex_state = 5},
  [189] = {.lex_state = 14, .external_lex_state = 5},
  [190] = {.lex_state = 14, .external_lex_state = 5},
  [191] = {.lex_state = 14, .external_lex_state = 5},
  [192] = {.lex_state = 14, .external_lex_state = 5},
  [193] = {.lex_state = 15, .external_lex_state = 3},
  [194] = {.lex_state = 15, .external_lex_state = 3},
  [195] = {.lex_state = 14, .external_lex_state = 5},
  [196] = {.lex_state = 14, .external_lex_state = 5},
  [197] = {.lex_state = 14, .external_lex_state = 5},
  [198] = {.lex_state = 14, .external_lex_state = 5},
  [199] = {.lex_state = 15, .external_lex_state = 3},
  [200] = {.lex_state = 14, .external_lex_state = 5},
  [201] = {.lex_state = 14, .external_lex_state = 5},
  [202] = {.lex_state = 15, .external_lex_state = 3},
  [203] = {.lex_state = 14, .external_lex_state = 5},
  [204] = {.lex_state = 15, .external_lex_state = 3},
  [205] = {.lex_state = 14, .external_lex_state = 5},
  [206] = {.lex_state = 14, .external_lex_state = 5},
  [207] = {.lex_state = 15, .external_lex_state = 3},
  [208] = {.lex_state = 14, .external_lex_state = 5},
  [209] = {.lex_state = 14, .external_lex_state = 5},
  [210] = {.lex_state = 15, .external_lex_state = 3},
  [211] = {.lex_state = 14, .external_lex_state = 5},
  [212] = {.lex_state = 15, .external_lex_state = 3},
  [213] = {.lex_state = 15, .external_lex_state = 3},
  [214] = {.lex_state = 14, .external_lex_state = 5},
  [215] = {.lex_state = 15, .external_lex_state = 3},
  [216] = {.lex_state = 15, .external_lex_state = 3},
  [217] = {.lex_state = 15, .external_lex_state = 3},
  [218] = {.lex_state = 15, .external_lex_state = 2},
  [219] = {.lex_state = 15, .external_lex_state = 3},
  [220] = {.lex_state = 15, .external_lex_state = 2},
  [221] = {.lex_state = 15, .external_lex_state = 2},
  [222] = {.lex_state = 15, .external_lex_state = 3},
  [223] = {.lex_state = 15, .external_lex_state = 2},
  [224] = {.lex_state = 15, .external_lex_state = 3},
  [225] = {.lex_state = 15, .external_lex_state = 3},
  [226] = {.lex_state = 15, .external_lex_state = 3},
  [227] = {.lex_state = 15, .external_lex_state = 3},
  [228] = {.lex_state = 15, .external_lex_state = 3},
  [229] = {.lex_state = 15, .external_lex_state = 3},
  [230] = {.lex_state = 15, .external_lex_state = 3},
  [231] = {.lex_state = 15, .external_lex_state = 3},
  [232] = {.lex_state = 15, .external_lex_state = 3},
  [233] = {.lex_state = 15, .external_lex_state = 3},
  [234] = {.lex_state = 15, .external_lex_state = 3},
  [235] = {.lex_state = 15, .external_lex_state = 3},
  [236] = {.lex_state = 15, .external_lex_state = 3},
  [237] = {.lex_state = 15, .external_lex_state = 2},
  [238] = {.lex_state = 15, .external_lex_state = 3},
  [239] = {.lex_state = 15, .external_lex_state = 3},
  [240] = {.lex_state = 15, .external_lex_state = 3},
  [241] = {.lex_state = 15, .external_lex_state = 3},
  [242] = {.lex_state = 3, .external_lex_state = 6},
  [243] = {.lex_state = 15, .external_lex_state = 3},
  [244] = {.lex_state = 15, .external_lex_state = 3},
  [245] = {.lex_state = 3, .external_lex_state = 6},
  [246] = {.lex_state = 15, .external_lex_state = 3},
  [247] = {.lex_state = 15, .external_lex_state = 3},
  [248] = {.lex_state = 3, .external_lex_state = 6},
  [249] = {.lex_state = 15, .external_lex_state = 3},
  [250] = {.lex_state = 15, .external_lex_state = 3},
  [251] = {.lex_state = 15, .external_lex_state = 3},
  [252] = {.lex_state = 3, .external_lex_state = 6},
  [253] = {.lex_state = 15, .external_lex_state = 3},
  [254] = {.lex_state = 15, .external_lex_state = 3},
  [255] = {.lex_state = 15, .external_lex_state = 3},
  [256] = {.lex_state = 15, .external_lex_state = 3},
  [257] = {.lex_state = 15, .external_lex_state = 3},
  [258] = {.lex_state = 15, .external_lex_state = 3},
  [259] = {.lex_state = 15, .external_lex_state = 3},
  [260] = {.lex_state = 15, .external_lex_state = 3},
  [261] = {.lex_state = 15, .external_lex_state = 3},
  [262] = {.lex_state = 15, .external_lex_state = 3},
  [263] = {.lex_state = 15, .external_lex_state = 3},
  [264] = {.lex_state = 15, .external_lex_state = 3},
  [265] = {.lex_state = 15, .external_lex_state = 3},
  [266] = {.lex_state = 0, .external_lex_state = 5},
  [267] = {.lex_state = 15, .external_lex_state = 3},
  [268] = {.lex_state = 15, .external_lex_state = 3},
  [269] = {.lex_state = 15, .external_lex_state = 3},
  [270] = {.lex_state = 15, .external_lex_state = 3},
  [271] = {.lex_state = 15, .external_lex_state = 3},
  [272] = {.lex_state = 15, .external_lex_state = 3},
  [273] = {.lex_state = 15, .external_lex_state = 3},
  [274] = {.lex_state = 15, .external_lex_state = 3},
  [275] = {.lex_state = 15, .external_lex_state = 3},
  [276] = {.lex_state = 15, .external_lex_state = 3},
  [277] = {.lex_state = 15, .external_lex_state = 3},
  [278] = {.lex_state = 15, .external_lex_state = 3},
  [279] = {.lex_state = 15, .external_lex_state = 3},
  [280] = {.lex_state = 15, .external_lex_state = 3},
  [281] = {.lex_state = 15, .external_lex_state = 3},
  [282] = {.lex_state = 15, .external_lex_state = 3},
  [283] = {.lex_state = 15, .external_lex_state = 3},
  [284] = {.lex_state = 15, .external_lex_state = 3},
  [285] = {.lex_state = 15, .external_lex_state = 3},
  [286] = {.lex_state = 15, .external_lex_state = 3},
  [287] = {.lex_state = 15, .external_lex_state = 3},
  [288] = {.lex_state = 15, .external_lex_state = 3},
  [289] = {.lex_state = 15, .external_lex_state = 3},
  [290] = {.lex_state = 15, .external_lex_state = 3},
  [291] = {.lex_state = 15, .external_lex_state = 3},
  [292] = {.lex_state = 15, .external_lex_state = 3},
  [293] = {.lex_state = 15, .external_lex_state = 3},
  [294] = {.lex_state = 15, .external_lex_state = 3},
  [295] = {.lex_state = 15, .external_lex_state = 3},
  [296] = {.lex_state = 14, .external_lex_state = 5},
  [297] = {.lex_state = 15, .external_lex_state = 3},
  [298] = {.lex_state = 15, .external_lex_state = 3},
  [299] = {.lex_state = 15, .external_lex_state = 3},
  [300] = {.lex_state = 15, .external_lex_state = 3},
  [301] = {.lex_state = 15, .external_lex_state = 3},
  [302] = {.lex_state = 15, .external_lex_state = 3},
  [303] = {.lex_state = 15, .external_lex_state = 3},
  [304] = {.lex_state = 15, .external_lex_state = 3},
  [305] = {.lex_state = 15, .external_lex_state = 3},
  [306] = {.lex_state = 14, .external_lex_state = 5},
  [307] = {.lex_state = 15, .external_lex_state = 3},
  [308] = {.lex_state = 15, .external_lex_state = 3},
  [309] = {.lex_state = 15, .external_lex_state = 3},
  [310] = {.lex_state = 15, .external_lex_state = 3},
  [311] = {.lex_state = 15, .external_lex_state = 3},
  [312] = {.lex_state = 15, .external_lex_state = 3},
  [313] = {.lex_state = 15, .external_lex_state = 3},
  [314] = {.lex_state = 15, .external_lex_state = 3},
  [315] = {.lex_state = 14, .external_lex_state = 5},
  [316] = {.lex_state = 15, .external_lex_state = 3},
  [317] = {.lex_state = 15, .external_lex_state = 3},
  [318] = {.lex_state = 0, .external_lex_state = 5},
  [319] = {.lex_state = 15, .external_lex_state = 3},
  [320] = {.lex_state = 15, .external_lex_state = 3},
  [321] = {.lex_state = 15, .external_lex_state = 3},
  [322] = {.lex_state = 15, .external_lex_state = 3},
  [323] = {.lex_state = 15, .external_lex_state = 3},
  [324] = {.lex_state = 15, .external_lex_state = 3},
  [325] = {.lex_state = 15, .external_lex_state = 3},
  [326] = {.lex_state = 15, .external_lex_state = 3},
  [327] = {.lex_state = 15, .external_lex_state = 3},
  [328] = {.lex_state = 15, .external_lex_state = 3},
  [329] = {.lex_state = 15, .external_lex_state = 3},
  [330] = {.lex_state = 15, .external_lex_state = 3},
  [331] = {.lex_state = 15, .external_lex_state = 3},
  [332] = {.lex_state = 15, .external_lex_state = 3},
  [333] = {.lex_state = 15, .external_lex_state = 3},
  [334] = {.lex_state = 15, .external_lex_state = 3},
  [335] = {.lex_state = 15, .external_lex_state = 3},
  [336] = {.lex_state = 15, .external_lex_state = 3},
  [337] = {.lex_state = 15, .external_lex_state = 3},
  [338] = {.lex_state = 3, .external_lex_state = 6},
  [339] = {.lex_state = 15, .external_lex_state = 3},
  [340] = {.lex_state = 15, .external_lex_state = 3},
  [341] = {.lex_state = 15, .external_lex_state = 2},
  [342] = {.lex_state = 15, .external_lex_state = 3},
  [343] = {.lex_state = 15, .external_lex_state = 3},
  [344] = {.lex_state = 15, .external_lex_state = 3},
  [345] = {.lex_state = 15, .external_lex_state = 3},
  [346] = {.lex_state = 15, .external_lex_state = 3},
  [347] = {.lex_state = 15, .external_lex_state = 3},
  [348] = {.lex_state = 0, .external_lex_state = 5},
  [349] = {.lex_state = 0, .external_lex_state = 5},
  [350] = {.lex_state = 15, .external_lex_state = 3},
  [351] = {.lex_state = 15, .external_lex_state = 3},
  [352] = {.lex_state = 15, .external_lex_state = 3},
  [353] = {.lex_state = 15, .external_lex_state = 3},
  [354] = {.lex_state = 15, .external_lex_state = 3},
  [355] = {.lex_state = 15, .external_lex_state = 3},
  [356] = {.lex_state = 14, .external_lex_state = 5},
  [357] = {.lex_state = 0, .external_lex_state = 5},
  [358] = {.lex_state = 0, .external_lex_state = 5},
  [359] = {.lex_state = 0, .external_lex_state = 5},
  [360] = {.lex_state = 14, .external_lex_state = 5},
  [361] = {.lex_state = 0, .external_lex_state = 5},
  [362] = {.lex_state = 0, .external_lex_state = 5},
  [363] = {.lex_state = 3, .external_lex_state = 6},
  [364] = {.lex_state = 0, .external_lex_state = 5},
  [365] = {.lex_state = 14, .external_lex_state = 5},
  [366] = {.lex_state = 0, .external_lex_state = 5},
  [367] = {.lex_state = 3, .external_lex_state = 6},
  [368] = {.lex_state = 15, .external_lex_state = 2},
  [369] = {.lex_state = 14, .external_lex_state = 5},
  [370] = {.lex_state = 0, .external_lex_state = 5},
  [371] = {.lex_state = 0, .external_lex_state = 5},
  [372] = {.lex_state = 3, .external_lex_state = 6},
  [373] = {.lex_state = 3, .external_lex_state = 6},
  [374] = {.lex_state = 15, .external_lex_state = 2},
  [375] = {.lex_state = 3, .external_lex_state = 6},
  [376] = {.lex_state = 3, .external_lex_state = 6},
  [377] = {.lex_state = 3, .external_lex_state = 6},
  [378] = {.lex_state = 3, .external_lex_state = 6},
  [379] = {.lex_state = 0, .external_lex_state = 5},
  [380] = {.lex_state = 3, .external_lex_state = 6},
  [381] = {.lex_state = 3, .external_lex_state = 6},
  [382] = {.lex_state = 3, .external_lex_state = 6},
  [383] = {.lex_state = 15, .external_lex_state = 2},
  [384] = {.lex_state = 3, .external_lex_state = 6},
  [385] = {.lex_state = 15, .external_lex_state = 2},
  [386] = {.lex_state = 3, .external_lex_state = 6},
  [387] = {.lex_state = 14, .external_lex_state = 5},
  [388] = {.lex_state = 14, .external_lex_state = 5},
  [389] = {.lex_state = 14, .external_lex_state = 5},
  [390] = {.lex_state = 0, .external_lex_state = 5},
  [391] = {.lex_state = 14, .external_lex_state = 5},
  [392] = {.lex_state = 14, .external_lex_state = 5},
  [393] = {.lex_state = 14, .external_lex_state = 5},
  [394] = {.lex_state = 14, .external_lex_state = 5},
  [395] = {.lex_state = 14, .external_lex_state = 5},
  [396] = {.lex_state = 14, .external_lex_state = 5},
  [397] = {.lex_state = 14, .external_lex_state = 5},
  [398] = {.lex_state = 14, .external_lex_state = 5},
  [399] = {.lex_state = 14, .external_lex_state = 5},
  [400] = {.lex_state = 0, .external_lex_state = 5},
  [401] = {.lex_state = 0, .external_lex_state = 5},
  [402] = {.lex_state = 0, .external_lex_state = 5},
  [403] = {.lex_state = 14, .external_lex_state = 5},
  [404] = {.lex_state = 0, .external_lex_state = 5},
  [405] = {.lex_state = 14, .external_lex_state = 5},
  [406] = {.lex_state = 14, .external_lex_state = 5},
  [407] = {.lex_state = 14, .external_lex_state = 5},
  [408] = {.lex_state = 14, .external_lex_state = 5},
  [409] = {.lex_state = 14, .external_lex_state = 5},
  [410] = {.lex_state = 3, .external_lex_state = 6},
  [411] = {.lex_state = 14, .external_lex_state = 5},
  [412] = {.lex_state = 0, .external_lex_state = 5},
  [413] = {.lex_state = 14, .external_lex_state = 5},
  [414] = {.lex_state = 14, .external_lex_state = 5},
  [415] = {.lex_state = 0, .external_lex_state = 5},
  [416] = {.lex_state = 14, .external_lex_state = 5},
  [417] = {.lex_state = 14, .external_lex_state = 5},
  [418] = {.lex_state = 14, .external_lex_state = 5},
  [419] = {.lex_state = 14, .external_lex_state = 5},
  [420] = {.lex_state = 14, .external_lex_state = 5},
  [421] = {.lex_state = 0, .external_lex_state = 5},
  [422] = {.lex_state = 14, .external_lex_state = 5},
  [423] = {.lex_state = 0, .external_lex_state = 5},
  [424] = {.lex_state = 0, .external_lex_state = 5},
  [425] = {.lex_state = 0, .external_lex_state = 5},
  [426] = {.lex_state = 0, .external_lex_state = 5},
  [427] = {.lex_state = 14, .external_lex_state = 5},
  [428] = {.lex_state = 14, .external_lex_state = 5},
  [429] = {.lex_state = 14, .external_lex_state = 5},
  [430] = {.lex_state = 14, .external_lex_state = 5},
  [431] = {.lex_state = 14, .external_lex_state = 5},
  [432] = {.lex_state = 14, .external_lex_state = 5},
  [433] = {.lex_state = 14, .external_lex_state = 5},
  [434] = {.lex_state = 14, .external_lex_state = 5},
  [435] = {.lex_state = 14, .external_lex_state = 5},
  [436] = {.lex_state = 0, .external_lex_state = 5},
  [437] = {.lex_state = 14, .external_lex_state = 5},
  [438] = {.lex_state = 14, .external_lex_state = 5},
  [439] = {.lex_state = 14, .external_lex_state = 5},
  [440] = {.lex_state = 0, .external_lex_state = 5},
  [441] = {.lex_state = 0, .external_lex_state = 5},
  [442] = {.lex_state = 14, .external_lex_state = 5},
  [443] = {.lex_state = 14, .external_lex_state = 5},
  [444] = {.lex_state = 14, .external_lex_state = 5},
  [445] = {.lex_state = 14, .external_lex_state = 5},
  [446] = {.lex_state = 14, .external_lex_state = 5},
  [447] = {.lex_state = 0, .external_lex_state = 5},
  [448] = {.lex_state = 14, .external_lex_state = 5},
  [449] = {.lex_state = 0, .external_lex_state = 5},
  [450] = {.lex_state = 0, .external_lex_state = 5},
  [451] = {.lex_state = 0, .external_lex_state = 5},
  [452] = {.lex_state = 3, .external_lex_state = 6},
  [453] = {.lex_state = 3, .external_lex_state = 6},
  [454] = {.lex_state = 3, .external_lex_state = 6},
  [455] = {.lex_state = 3, .external_lex_state = 6},
  [456] = {.lex_state = 3, .external_lex_state = 6},
  [457] = {.lex_state = 0, .external_lex_state = 5},
  [458] = {.lex_state = 0, .external_lex_state = 5},
  [459] = {.lex_state = 0, .external_lex_state = 5},
  [460] = {.lex_state = 3, .external_lex_state = 6},
  [461] = {.lex_state = 0, .external_lex_state = 5},
  [462] = {.lex_state = 0, .external_lex_state = 5},
  [463] = {.lex_state = 14, .external_lex_state = 5},
  [464] = {.lex_state = 14, .external_lex_state = 5},
  [465] = {.lex_state = 0, .external_lex_state = 5},
  [466] = {.lex_state = 0, .external_lex_state = 5},
  [467] = {.lex_state = 3, .external_lex_state = 6},
  [468] = {.lex_state = 14, .external_lex_state = 5},
  [469] = {.lex_state = 3, .external_lex_state = 6},
  [470] = {.lex_state = 3, .external_lex_state = 6},
  [471] = {.lex_state = 0, .external_lex_state = 5},
  [472] = {.lex_state = 3, .external_lex_state = 6},
  [473] = {.lex_state = 3, .external_lex_state = 6},
  [474] = {.lex_state = 3, .external_lex_state = 6},
  [475] = {.lex_state = 3, .external_lex_state = 6},
  [476] = {.lex_state = 3, .external_lex_state = 6},
  [477] = {.lex_state = 3, .external_lex_state = 6},
  [478] = {.lex_state = 3, .external_lex_state = 6},
  [479] = {.lex_state = 3, .external_lex_state = 6},
  [480] = {.lex_state = 3, .external_lex_state = 6},
  [481] = {.lex_state = 3, .external_lex_state = 6},
  [482] = {.lex_state = 3, .external_lex_state = 6},
  [483] = {.lex_state = 3, .external_lex_state = 6},
  [484] = {.lex_state = 3, .external_lex_state = 6},
  [485] = {.lex_state = 3, .external_lex_state = 6},
  [486] = {.lex_state = 3, .external_lex_state = 6},
  [487] = {.lex_state = 3, .external_lex_state = 6},
  [488] = {.lex_state = 3, .external_lex_state = 6},
  [489] = {.lex_state = 3, .external_lex_state = 6},
  [490] = {.lex_state = 3, .external_lex_state = 6},
  [491] = {.lex_state = 3, .external_lex_state = 6},
  [492] = {.lex_state = 3, .external_lex_state = 6},
  [493] = {.lex_state = 3, .external_lex_state = 6},
  [494] = {.lex_state = 3, .external_lex_state = 6},
  [495] = {.lex_state = 3, .external_lex_state = 6},
  [496] = {.lex_state = 3, .external_lex_state = 6},
  [497] = {.lex_state = 3, .external_lex_state = 6},
  [498] = {.lex_state = 3, .external_lex_state = 6},
  [499] = {.lex_state = 3, .external_lex_state = 6},
  [500] = {.lex_state = 3, .external_lex_state = 6},
  [501] = {.lex_state = 14, .external_lex_state = 5},
  [502] = {.lex_state = 3, .external_lex_state = 6},
  [503] = {.lex_state = 3, .external_lex_state = 6},
  [504] = {.lex_state = 3, .external_lex_state = 6},
  [505] = {.lex_state = 3, .external_lex_state = 6},
  [506] = {.lex_state = 3, .external_lex_state = 6},
  [507] = {.lex_state = 3, .external_lex_state = 6},
  [508] = {.lex_state = 14, .external_lex_state = 5},
  [509] = {.lex_state = 14, .external_lex_state = 5},
  [510] = {.lex_state = 3, .external_lex_state = 6},
  [511] = {.lex_state = 3, .external_lex_state = 6},
  [512] = {.lex_state = 3, .external_lex_state = 6},
  [513] = {.lex_state = 3, .external_lex_state = 6},
  [514] = {.lex_state = 3, .external_lex_state = 6},
  [515] = {.lex_state = 14, .external_lex_state = 5},
  [516] = {.lex_state = 3, .external_lex_state = 6},
  [517] = {.lex_state = 3, .external_lex_state = 6},
  [518] = {.lex_state = 0, .external_lex_state = 5},
  [519] = {.lex_state = 0, .external_lex_state = 5},
  [520] = {.lex_state = 0, .external_lex_state = 5},
  [521] = {.lex_state = 0, .external_lex_state = 5},
  [522] = {.lex_state = 0, .external_lex_state = 5},
  [523] = {.lex_state = 0, .external_lex_state = 5},
  [524] = {.lex_state = 0, .external_lex_state = 5},
  [525] = {.lex_state = 0, .external_lex_state = 5},
  [526] = {.lex_state = 0, .external_lex_state = 5},
  [527] = {.lex_state = 0, .external_lex_state = 5},
  [528] = {.lex_state = 0, .external_lex_state = 5},
  [529] = {.lex_state = 0, .external_lex_state = 5},
  [530] = {.lex_state = 0, .external_lex_state = 5},
  [531] = {.lex_state = 0, .external_lex_state = 5},
  [532] = {.lex_state = 0, .external_lex_state = 5},
  [533] = {.lex_state = 0, .external_lex_state = 5},
  [534] = {.lex_state = 0, .external_lex_state = 5},
  [535] = {.lex_state = 0, .external_lex_state = 5},
  [536] = {.lex_state = 0, .external_lex_state = 5},
  [537] = {.lex_state = 0, .external_lex_state = 5},
  [538] = {.lex_state = 0, .external_lex_state = 5},
  [539] = {.lex_state = 0, .external_lex_state = 5},
  [540] = {.lex_state = 0, .external_lex_state = 5},
  [541] = {.lex_state = 0, .external_lex_state = 5},
  [542] = {.lex_state = 0, .external_lex_state = 5},
  [543] = {.lex_state = 0, .external_lex_state = 5},
  [544] = {.lex_state = 0, .external_lex_state = 5},
  [545] = {.lex_state = 0, .external_lex_state = 5},
  [546] = {.lex_state = 0, .external_lex_state = 5},
  [547] = {.lex_state = 0, .external_lex_state = 5},
  [548] = {.lex_state = 0, .external_lex_state = 5},
  [549] = {.lex_state = 0, .external_lex_state = 5},
  [550] = {.lex_state = 0, .external_lex_state = 5},
  [551] = {.lex_state = 0, .external_lex_state = 5},
  [552] = {.lex_state = 0, .external_lex_state = 5},
  [553] = {.lex_state = 0, .external_lex_state = 5},
  [554] = {.lex_state = 0, .external_lex_state = 5},
  [555] = {.lex_state = 0, .external_lex_state = 5},
  [556] = {.lex_state = 0, .external_lex_state = 5},
  [557] = {.lex_state = 0, .external_lex_state = 5},
  [558] = {.lex_state = 0, .external_lex_state = 5},
  [559] = {.lex_state = 0, .external_lex_state = 5},
  [560] = {.lex_state = 0, .external_lex_state = 5},
  [561] = {.lex_state = 0, .external_lex_state = 5},
  [562] = {.lex_state = 0, .external_lex_state = 5},
  [563] = {.lex_state = 0, .external_lex_state = 5},
  [564] = {.lex_state = 0, .external_lex_state = 5},
  [565] = {.lex_state = 0, .external_lex_state = 5},
  [566] = {.lex_state = 0, .external_lex_state = 5},
  [567] = {.lex_state = 0, .external_lex_state = 5},
  [568] = {.lex_state = 3, .external_lex_state = 6},
  [569] = {.lex_state = 0, .external_lex_state = 5},
  [570] = {.lex_state = 0, .external_lex_state = 5},
  [571] = {.lex_state = 0, .external_lex_state = 5},
  [572] = {.lex_state = 3, .external_lex_state = 6},
  [573] = {.lex_state = 0, .external_lex_state = 5},
  [574] = {.lex_state = 0, .external_lex_state = 5},
  [575] = {.lex_state = 0, .external_lex_state = 5},
  [576] = {.lex_state = 0, .external_lex_state = 5},
  [577] = {.lex_state = 0, .external_lex_state = 5},
  [578] = {.lex_state = 0, .external_lex_state = 5},
  [579] = {.lex_state = 0, .external_lex_state = 5},
  [580] = {.lex_state = 3, .external_lex_state = 6},
  [581] = {.lex_state = 0, .external_lex_state = 5},
  [582] = {.lex_state = 0, .external_lex_state = 5},
  [583] = {.lex_state = 0, .external_lex_state = 5},
  [584] = {.lex_state = 3, .external_lex_state = 6},
  [585] = {.lex_state = 0, .external_lex_state = 5},
  [586] = {.lex_state = 3, .external_lex_state = 6},
  [587] = {.lex_state = 0, .external_lex_state = 5},
  [588] = {.lex_state = 0, .external_lex_state = 5},
  [589] = {.lex_state = 3, .external_lex_state = 6},
  [590] = {.lex_state = 0, .external_lex_state = 5},
  [591] = {.lex_state = 0, .external_lex_state = 5},
  [592] = {.lex_state = 0, .external_lex_state = 5},
  [593] = {.lex_state = 0, .external_lex_state = 5},
  [594] = {.lex_state = 0, .external_lex_state = 5},
  [595] = {.lex_state = 0, .external_lex_state = 5},
  [596] = {.lex_state = 0, .external_lex_state = 5},
  [597] = {.lex_state = 0, .external_lex_state = 5},
  [598] = {.lex_state = 0, .external_lex_state = 5},
  [599] = {.lex_state = 0, .external_lex_state = 5},
  [600] = {.lex_state = 0, .external_lex_state = 5},
  [601] = {.lex_state = 0, .external_lex_state = 5},
  [602] = {.lex_state = 0, .external_lex_state = 5},
  [603] = {.lex_state = 1, .external_lex_state = 5},
  [604] = {.lex_state = 1, .external_lex_state = 5},
  [605] = {.lex_state = 14, .external_lex_state = 5},
  [606] = {.lex_state = 15, .external_lex_state = 5},
  [607] = {.lex_state = 1, .external_lex_state = 5},
  [608] = {.lex_state = 1, .external_lex_state = 5},
  [609] = {.lex_state = 2, .external_lex_state = 5},
  [610] = {.lex_state = 5, .external_lex_state = 5},
  [611] = {.lex_state = 6, .external_lex_state = 6},
  [612] = {.lex_state = 0, .external_lex_state = 5},
  [613] = {.lex_state = 14, .external_lex_state = 5},
  [614] = {.lex_state = 6, .external_lex_state = 6},
  [615] = {.lex_state = 6, .external_lex_state = 6},
  [616] = {.lex_state = 0, .external_lex_state = 5},
  [617] = {.lex_state = 5, .external_lex_state = 5},
  [618] = {.lex_state = 0, .external_lex_state = 5},
  [619] = {.lex_state = 0, .external_lex_state = 5},
  [620] = {.lex_state = 15, .external_lex_state = 5},
  [621] = {.lex_state = 15, .external_lex_state = 5},
  [622] = {.lex_state = 14, .external_lex_state = 5},
  [623] = {.lex_state = 5, .external_lex_state = 5},
  [624] = {.lex_state = 15, .external_lex_state = 5},
  [625] = {.lex_state = 14, .external_lex_state = 5},
  [626] = {.lex_state = 6, .external_lex_state = 6},
  [627] = {.lex_state = 3, .external_lex_state = 6},
  [628] = {.lex_state = 5, .external_lex_state = 5},
  [629] = {.lex_state = 14, .external_lex_state = 5},
  [630] = {.lex_state = 3, .external_lex_state = 6},
  [631] = {.lex_state = 14, .external_lex_state = 5},
  [632] = {.lex_state = 15, .external_lex_state = 5},
  [633] = {.lex_state = 15, .external_lex_state = 3},
  [634] = {.lex_state = 0, .external_lex_state = 5},
  [635] = {.lex_state = 0, .external_lex_state = 5},
  [636] = {.lex_state = 0, .external_lex_state = 5},
  [637] = {.lex_state = 14, .external_lex_state = 5},
  [638] = {.lex_state = 15, .external_lex_state = 5},
  [639] = {.lex_state = 15, .external_lex_state = 5},
  [640] = {.lex_state = 14, .external_lex_state = 5},
  [641] = {.lex_state = 15, .external_lex_state = 5},
  [642] = {.lex_state = 14, .external_lex_state = 5},
  [643] = {.lex_state = 0, .external_lex_state = 5},
  [644] = {.lex_state = 15, .external_lex_state = 5},
  [645] = {.lex_state = 15, .external_lex_state = 5},
  [646] = {.lex_state = 0, .external_lex_state = 5},
  [647] = {.lex_state = 3, .external_lex_state = 6},
  [648] = {.lex_state = 15, .external_lex_state = 5},
  [649] = {.lex_state = 15, .external_lex_state = 5},
  [650] = {.lex_state = 15, .external_lex_state = 5},
  [651] = {.lex_state = 2, .external_lex_state = 5},
  [652] = {.lex_state = 15, .external_lex_state = 5},
  [653] = {.lex_state = 0, .external_lex_state = 7},
  [654] = {.lex_state = 15, .external_lex_state = 5},
  [655] = {.lex_state = 14, .external_lex_state = 5},
  [656] = {.lex_state = 2, .external_lex_state = 5},
  [657] = {.lex_state = 0, .external_lex_state = 7},
  [658] = {.lex_state = 2, .external_lex_state = 5},
  [659] = {.lex_state = 0, .external_lex_state = 7},
  [660] = {.lex_state = 0, .external_lex_state = 7},
  [661] = {.lex_state = 0, .external_lex_state = 5},
  [662] = {.lex_state = 0, .external_lex_state = 5},
  [663] = {.lex_state = 0, .external_lex_state = 7},
  [664] = {.lex_state = 15, .external_lex_state = 5},
  [665] = {.lex_state = 15, .external_lex_state = 5},
  [666] = {.lex_state = 15, .external_lex_state = 5},
  [667] = {.lex_state = 15, .external_lex_state = 5},
  [668] = {.lex_state = 15, .external_lex_state = 5},
  [669] = {.lex_state = 15, .external_lex_state = 5},
  [670] = {.lex_state = 15, .external_lex_state = 5},
  [671] = {.lex_state = 15, .external_lex_state = 5},
  [672] = {.lex_state = 15, .external_lex_state = 5},
  [673] = {.lex_state = 15, .external_lex_state = 5},
  [674] = {.lex_state = 15, .external_lex_state = 5},
  [675] = {.lex_state = 15, .external_lex_state = 5},
  [676] = {.lex_state = 0, .external_lex_state = 5},
  [677] = {.lex_state = 15, .external_lex_state = 5},
  [678] = {.lex_state = 0, .external_lex_state = 5},
  [679] = {.lex_state = 0, .external_lex_state = 5},
  [680] = {.lex_state = 15, .external_lex_state = 5},
  [681] = {.lex_state = 0, .external_lex_state = 5},
  [682] = {.lex_state = 14, .external_lex_state = 5},
  [683] = {.lex_state = 14, .external_lex_state = 5},
  [684] = {.lex_state = 14, .external_lex_state = 5},
  [685] = {.lex_state = 0, .external_lex_state = 5},
  [686] = {.lex_state = 0, .external_lex_state = 5},
  [687] = {.lex_state = 14, .external_lex_state = 5},
  [688] = {.lex_state = 14, .external_lex_state = 5},
  [689] = {.lex_state = 0, .external_lex_state = 5},
  [690] = {.lex_state = 14, .external_lex_state = 5},
  [691] = {.lex_state = 15, .external_lex_state = 5},
  [692] = {.lex_state = 14, .external_lex_state = 5},
  [693] = {.lex_state = 0, .external_lex_state = 5},
  [694] = {.lex_state = 14, .external_lex_state = 5},
  [695] = {.lex_state = 0, .external_lex_state = 5},
  [696] = {.lex_state = 0, .external_lex_state = 5},
  [697] = {.lex_state = 14, .external_lex_state = 5},
  [698] = {.lex_state = 0, .external_lex_state = 5},
  [699] = {.lex_state = 14, .external_lex_state = 5},
  [700] = {.lex_state = 14, .external_lex_state = 5},
  [701] = {.lex_state = 14, .external_lex_state = 5},
  [702] = {.lex_state = 15, .external_lex_state = 5},
  [703] = {.lex_state = 15, .external_lex_state = 5},
  [704] = {.lex_state = 15, .external_lex_state = 5},
  [705] = {.lex_state = 14, .external_lex_state = 5},
  [706] = {.lex_state = 14, .external_lex_state = 5},
  [707] = {.lex_state = 15, .external_lex_state = 5},
  [708] = {.lex_state = 15, .external_lex_state = 5},
  [709] = {.lex_state = 15, .external_lex_state = 5},
  [710] = {.lex_state = 15, .external_lex_state = 5},
  [711] = {.lex_state = 0, .external_lex_state = 5},
  [712] = {.lex_state = 14, .external_lex_state = 5},
  [713] = {.lex_state = 15, .external_lex_state = 5},
  [714] = {.lex_state = 14, .external_lex_state = 5},
  [715] = {.lex_state = 15, .external_lex_state = 5},
  [716] = {.lex_state = 14, .external_lex_state = 5},
  [717] = {.lex_state = 15, .external_lex_state = 5},
  [718] = {.lex_state = 15, .external_lex_state = 5},
  [719] = {.lex_state = 2, .external_lex_state = 5},
  [720] = {.lex_state = 15, .external_lex_state = 5},
  [721] = {.lex_state = 14, .external_lex_state = 5},
  [722] = {.lex_state = 14, .external_lex_state = 5},
  [723] = {.lex_state = 15, .external_lex_state = 5},
  [724] = {.lex_state = 14, .external_lex_state = 5},
  [725] = {.lex_state = 14, .external_lex_state = 5},
  [726] = {.lex_state = 14, .external_lex_state = 5},
  [727] = {.lex_state = 15, .external_lex_state = 5},
  [728] = {.lex_state = 14, .external_lex_state = 5},
  [729] = {.lex_state = 14, .external_lex_state = 5},
  [730] = {.lex_state = 14, .external_lex_state = 5},
  [731] = {.lex_state = 14, .external_lex_state = 5},
  [732] = {.lex_state = 14, .external_lex_state = 5},
  [733] = {.lex_state = 14, .external_lex_state = 5},
  [734] = {.lex_state = 14, .external_lex_state = 5},
  [735] = {.lex_state = 15, .external_lex_state = 5},
  [736] = {.lex_state = 14, .external_lex_state = 5},
  [737] = {.lex_state = 15, .external_lex_state = 5},
  [738] = {.lex_state = 15, .external_lex_state = 5},
  [739] = {.lex_state = 14, .external_lex_state = 5},
  [740] = {.lex_state = 14, .external_lex_state = 5},
  [741] = {.lex_state = 14, .external_lex_state = 5},
  [742] = {.lex_state = 14, .external_lex_state = 5},
  [743] = {.lex_state = 14, .external_lex_state = 5},
  [744] = {.lex_state = 14, .external_lex_state = 5},
  [745] = {.lex_state = 14, .external_lex_state = 5},
  [746] = {.lex_state = 0, .external_lex_state = 7},
  [747] = {.lex_state = 15, .external_lex_state = 5},
  [748] = {.lex_state = 0, .external_lex_state = 7},
  [749] = {.lex_state = 14, .external_lex_state = 5},
  [750] = {.lex_state = 0, .external_lex_state = 7},
  [751] = {.lex_state = 15, .external_lex_state = 5},
  [752] = {.lex_state = 14, .external_lex_state = 5},
  [753] = {.lex_state = 15, .external_lex_state = 5},
  [754] = {.lex_state = 14, .external_lex_state = 5},
  [755] = {.lex_state = 15, .external_lex_state = 5},
  [756] = {.lex_state = 14, .external_lex_state = 5},
  [757] = {.lex_state = 0, .external_lex_state = 7},
  [758] = {.lex_state = 0, .external_lex_state = 5},
  [759] = {.lex_state = 14, .external_lex_state = 5},
  [760] = {.lex_state = 14, .external_lex_state = 8},
  [761] = {.lex_state = 14, .external_lex_state = 5},
  [762] = {.lex_state = 14, .external_lex_state = 8},
  [763] = {.lex_state = 14, .external_lex_state = 5},
  [764] = {.lex_state = 0, .external_lex_state = 7},
  [765] = {.lex_state = 15, .external_lex_state = 5},
  [766] = {.lex_state = 0, .external_lex_state = 7},
  [767] = {.lex_state = 14, .external_lex_state = 5},
  [768] = {.lex_state = 14, .external_lex_state = 5},
  [769] = {.lex_state = 14, .external_lex_state = 5},
  [770] = {.lex_state = 14, .external_lex_state = 5},
  [771] = {.lex_state = 0, .external_lex_state = 7},
  [772] = {.lex_state = 14, .external_lex_state = 8},
  [773] = {.lex_state = 0, .external_lex_state = 7},
  [774] = {.lex_state = 0, .external_lex_state = 7},
  [775] = {.lex_state = 0, .external_lex_state = 7},
  [776] = {.lex_state = 0, .external_lex_state = 7},
  [777] = {.lex_state = 0, .external_lex_state = 7},
  [778] = {.lex_state = 0, .external_lex_state = 7},
  [779] = {.lex_state = 0, .external_lex_state = 7},
  [780] = {.lex_state = 14, .external_lex_state = 5},
  [781] = {.lex_state = 14, .external_lex_state = 5},
  [782] = {.lex_state = 14, .external_lex_state = 5},
  [783] = {.lex_state = 0, .external_lex_state = 7},
  [784] = {.lex_state = 0, .external_lex_state = 7},
  [785] = {.lex_state = 0, .external_lex_state = 7},
  [786] = {.lex_state = 0, .external_lex_state = 7},
  [787] = {.lex_state = 14, .external_lex_state = 5},
  [788] = {.lex_state = 0, .external_lex_state = 7},
  [789] = {.lex_state = 15, .external_lex_state = 5},
  [790] = {.lex_state = 14, .external_lex_state = 5},
  [791] = {.lex_state = 0, .external_lex_state = 7},
  [792] = {.lex_state = 0, .external_lex_state = 7},
  [793] = {.lex_state = 14, .external_lex_state = 5},
  [794] = {.lex_state = 14, .external_lex_state = 5},
  [795] = {.lex_state = 15, .external_lex_state = 5},
  [796] = {.lex_state = 0, .external_lex_state = 7},
  [797] = {.lex_state = 0, .external_lex_state = 7},
  [798] = {.lex_state = 15, .external_lex_state = 5},
  [799] = {.lex_state = 0, .external_lex_state = 9},
  [800] = {.lex_state = 14, .external_lex_state = 5},
  [801] = {.lex_state = 15, .external_lex_state = 5},
  [802] = {.lex_state = 0, .external_lex_state = 10},
  [803] = {.lex_state = 15, .external_lex_state = 5},
  [804] = {.lex_state = 0, .external_lex_state = 9},
  [805] = {.lex_state = 0, .external_lex_state = 9},
  [806] = {.lex_state = 7, .external_lex_state = 6},
  [807] = {.lex_state = 7, .external_lex_state = 6},
  [808] = {.lex_state = 7, .external_lex_state = 6},
  [809] = {.lex_state = 15, .external_lex_state = 5},
  [810] = {.lex_state = 15, .external_lex_state = 5},
  [811] = {.lex_state = 15, .external_lex_state = 5},
  [812] = {.lex_state = 14, .external_lex_state = 5},
  [813] = {.lex_state = 15, .external_lex_state = 5},
  [814] = {.lex_state = 0, .external_lex_state = 10},
  [815] = {.lex_state = 15, .external_lex_state = 5},
  [816] = {.lex_state = 15, .external_lex_state = 5},
  [817] = {.lex_state = 14, .external_lex_state = 5},
  [818] = {.lex_state = 15, .external_lex_state = 5},
  [819] = {.lex_state = 14, .external_lex_state = 5},
  [820] = {.lex_state = 15, .external_lex_state = 5},
  [821] = {.lex_state = 0, .external_lex_state = 10},
  [822] = {.lex_state = 0, .external_lex_state = 9},
  [823] = {.lex_state = 14, .external_lex_state = 5},
  [824] = {.lex_state = 15, .external_lex_state = 5},
  [825] = {.lex_state = 14, .external_lex_state = 5},
  [826] = {.lex_state = 15, .external_lex_state = 5},
  [827] = {.lex_state = 15, .external_lex_state = 5},
  [828] = {.lex_state = 14, .external_lex_state = 5},
  [829] = {.lex_state = 14, .external_lex_state = 5},
  [830] = {.lex_state = 14, .external_lex_state = 5},
  [831] = {.lex_state = 14, .external_lex_state = 5},
  [832] = {.lex_state = 0, .external_lex_state = 10},
  [833] = {.lex_state = 0, .external_lex_state = 9},
  [834] = {.lex_state = 0, .external_lex_state = 9},
  [835] = {.lex_state = 15, .external_lex_state = 5},
  [836] = {.lex_state = 0, .external_lex_state = 10},
  [837] = {.lex_state = 15, .external_lex_state = 5},
  [838] = {.lex_state = 14, .external_lex_state = 5},
  [839] = {.lex_state = 14, .external_lex_state = 5},
  [840] = {.lex_state = 15, .external_lex_state = 5},
  [841] = {.lex_state = 14, .external_lex_state = 5},
  [842] = {.lex_state = 14, .external_lex_state = 5},
  [843] = {.lex_state = 15, .external_lex_state = 5},
  [844] = {.lex_state = 14, .external_lex_state = 5},
  [845] = {.lex_state = 15, .external_lex_state = 5},
  [846] = {.lex_state = 15, .external_lex_state = 5},
  [847] = {.lex_state = 15, .external_lex_state = 5},
  [848] = {.lex_state = 14, .external_lex_state = 5},
  [849] = {.lex_state = 14, .external_lex_state = 5},
  [850] = {.lex_state = 0, .external_lex_state = 5},
  [851] = {.lex_state = 14, .external_lex_state = 5},
  [852] = {.lex_state = 0, .external_lex_state = 10},
  [853] = {.lex_state = 14, .external_lex_state = 5},
  [854] = {.lex_state = 14, .external_lex_state = 5},
  [855] = {.lex_state = 14, .external_lex_state = 5},
  [856] = {.lex_state = 14, .external_lex_state = 5},
  [857] = {.lex_state = 14, .external_lex_state = 5},
  [858] = {.lex_state = 15, .external_lex_state = 5},
  [859] = {.lex_state = 14, .external_lex_state = 5},
  [860] = {.lex_state = 0, .external_lex_state = 10},
  [861] = {.lex_state = 14, .external_lex_state = 5},
  [862] = {.lex_state = 15, .external_lex_state = 5},
  [863] = {.lex_state = 0, .external_lex_state = 9},
  [864] = {.lex_state = 14, .external_lex_state = 5},
  [865] = {.lex_state = 14, .external_lex_state = 5},
  [866] = {.lex_state = 14, .external_lex_state = 5},
  [867] = {.lex_state = 15, .external_lex_state = 5},
  [868] = {.lex_state = 0, .external_lex_state = 10},
  [869] = {.lex_state = 15, .external_lex_state = 5},
  [870] = {.lex_state = 14, .external_lex_state = 5},
  [871] = {.lex_state = 15, .external_lex_state = 5},
  [872] = {.lex_state = 15, .external_lex_state = 5},
  [873] = {.lex_state = 14, .external_lex_state = 5},
  [874] = {.lex_state = 14, .external_lex_state = 5},
  [875] = {.lex_state = 14, .external_lex_state = 5},
  [876] = {.lex_state = 7, .external_lex_state = 6},
  [877] = {.lex_state = 0, .external_lex_state = 9},
  [878] = {.lex_state = 14, .external_lex_state = 5},
  [879] = {.lex_state = 14, .external_lex_state = 5},
  [880] = {.lex_state = 15, .external_lex_state = 5},
  [881] = {.lex_state = 7, .external_lex_state = 6},
  [882] = {.lex_state = 14, .external_lex_state = 5},
  [883] = {.lex_state = 0, .external_lex_state = 9},
  [884] = {.lex_state = 14, .external_lex_state = 5},
  [885] = {.lex_state = 0, .external_lex_state = 10},
  [886] = {.lex_state = 14, .external_lex_state = 5},
  [887] = {.lex_state = 14, .external_lex_state = 5},
  [888] = {.lex_state = 15, .external_lex_state = 5},
  [889] = {.lex_state = 14, .external_lex_state = 5},
  [890] = {.lex_state = 14, .external_lex_state = 5},
  [891] = {.lex_state = 15, .external_lex_state = 5},
  [892] = {.lex_state = 14, .external_lex_state = 5},
  [893] = {.lex_state = 15, .external_lex_state = 5},
  [894] = {.lex_state = 0, .external_lex_state = 5},
  [895] = {.lex_state = 14, .external_lex_state = 5},
  [896] = {.lex_state = 14, .external_lex_state = 5},
  [897] = {.lex_state = 15, .external_lex_state = 5},
  [898] = {.lex_state = 15, .external_lex_state = 5},
  [899] = {.lex_state = 15, .external_lex_state = 5},
  [900] = {.lex_state = 14, .external_lex_state = 5},
  [901] = {.lex_state = 15, .external_lex_state = 5},
  [902] = {.lex_state = 14, .external_lex_state = 5},
  [903] = {.lex_state = 15, .external_lex_state = 5},
  [904] = {.lex_state = 0, .external_lex_state = 5},
  [905] = {.lex_state = 14, .external_lex_state = 5},
  [906] = {.lex_state = 14, .external_lex_state = 5},
  [907] = {.lex_state = 15, .external_lex_state = 5},
  [908] = {.lex_state = 14, .external_lex_state = 5},
  [909] = {.lex_state = 14, .external_lex_state = 5},
  [910] = {.lex_state = 14, .external_lex_state = 5},
  [911] = {.lex_state = 0, .external_lex_state = 5},
  [912] = {.lex_state = 14, .external_lex_state = 5},
  [913] = {.lex_state = 14, .external_lex_state = 5},
  [914] = {.lex_state = 15, .external_lex_state = 5},
  [915] = {.lex_state = 14, .external_lex_state = 5},
  [916] = {.lex_state = 15, .external_lex_state = 5},
  [917] = {.lex_state = 14, .external_lex_state = 5},
  [918] = {.lex_state = 14, .external_lex_state = 5},
  [919] = {.lex_state = 14, .external_lex_state = 5},
  [920] = {.lex_state = 15, .external_lex_state = 5},
  [921] = {.lex_state = 14, .external_lex_state = 5},
  [922] = {.lex_state = 14, .external_lex_state = 5},
  [923] = {.lex_state = 15, .external_lex_state = 5},
  [924] = {.lex_state = 14, .external_lex_state = 5},
  [925] = {.lex_state = 14, .external_lex_state = 5},
  [926] = {.lex_state = 14, .external_lex_state = 5},
  [927] = {.lex_state = 14, .external_lex_state = 5},
  [928] = {.lex_state = 14, .external_lex_state = 5},
  [929] = {.lex_state = 14, .external_lex_state = 5},
  [930] = {.lex_state = 0, .external_lex_state = 5},
  [931] = {.lex_state = 0, .external_lex_state = 5},
  [932] = {.lex_state = 14, .external_lex_state = 5},
  [933] = {.lex_state = 0, .external_lex_state = 5},
  [934] = {.lex_state = 0, .external_lex_state = 5},
  [935] = {.lex_state = 14, .external_lex_state = 5},
  [936] = {.lex_state = 15, .external_lex_state = 5},
  [937] = {.lex_state = 14, .external_lex_state = 5},
  [938] = {.lex_state = 15, .external_lex_state = 5},
  [939] = {.lex_state = 14, .external_lex_state = 5},
  [940] = {.lex_state = 0, .external_lex_state = 5},
  [941] = {.lex_state = 0, .external_lex_state = 5},
  [942] = {.lex_state = 15, .external_lex_state = 5},
  [943] = {.lex_state = 15, .external_lex_state = 5},
  [944] = {.lex_state = 15, .external_lex_state = 5},
  [945] = {.lex_state = 0, .external_lex_state = 5},
  [946] = {.lex_state = 0, .external_lex_state = 5},
  [947] = {.lex_state = 15, .external_lex_state = 5},
  [948] = {.lex_state = 14, .external_lex_state = 5},
  [949] = {.lex_state = 14, .external_lex_state = 5},
  [950] = {.lex_state = 14, .external_lex_state = 5},
  [951] = {.lex_state = 14, .external_lex_state = 5},
  [952] = {.lex_state = 15, .external_lex_state = 5},
  [953] = {.lex_state = 0, .external_lex_state = 5},
  [954] = {.lex_state = 15, .external_lex_state = 5},
  [955] = {.lex_state = 0, .external_lex_state = 5},
  [956] = {.lex_state = 15, .external_lex_state = 5},
  [957] = {.lex_state = 14, .external_lex_state = 5},
  [958] = {.lex_state = 14, .external_lex_state = 5},
  [959] = {.lex_state = 14, .external_lex_state = 5},
  [960] = {.lex_state = 0, .external_lex_state = 5},
  [961] = {.lex_state = 14, .external_lex_state = 5},
  [962] = {.lex_state = 15, .external_lex_state = 5},
  [963] = {.lex_state = 14, .external_lex_state = 5},
  [964] = {.lex_state = 14, .external_lex_state = 5},
  [965] = {.lex_state = 14, .external_lex_state = 5},
  [966] = {.lex_state = 14, .external_lex_state = 5},
  [967] = {.lex_state = 0, .external_lex_state = 5},
  [968] = {.lex_state = 14, .external_lex_state = 5},
  [969] = {.lex_state = 15, .external_lex_state = 5},
  [970] = {.lex_state = 14, .external_lex_state = 5},
  [971] = {.lex_state = 0, .external_lex_state = 5},
  [972] = {.lex_state = 15, .external_lex_state = 5},
  [973] = {.lex_state = 14, .external_lex_state = 5},
  [974] = {.lex_state = 14, .external_lex_state = 5},
  [975] = {.lex_state = 7, .external_lex_state = 5},
  [976] = {.lex_state = 0, .external_lex_state = 5},
  [977] = {.lex_state = 7, .external_lex_state = 6},
  [978] = {.lex_state = 15, .external_lex_state = 5},
  [979] = {.lex_state = 15, .external_lex_state = 5},
  [980] = {.lex_state = 15, .external_lex_state = 5},
  [981] = {.lex_state = 14, .external_lex_state = 5},
  [982] = {.lex_state = 14, .external_lex_state = 5},
  [983] = {.lex_state = 0, .external_lex_state = 5},
  [984] = {.lex_state = 0, .external_lex_state = 5},
  [985] = {.lex_state = 0, .external_lex_state = 5},
  [986] = {.lex_state = 0, .external_lex_state = 5},
  [987] = {.lex_state = 0, .external_lex_state = 5},
  [988] = {.lex_state = 15, .external_lex_state = 5},
  [989] = {.lex_state = 0, .external_lex_state = 5},
  [990] = {.lex_state = 0, .external_lex_state = 5},
  [991] = {.lex_state = 15, .external_lex_state = 5},
  [992] = {.lex_state = 0, .external_lex_state = 5},
  [993] = {.lex_state = 15, .external_lex_state = 5},
  [994] = {.lex_state = 0, .external_lex_state = 5},
  [995] = {.lex_state = 15, .external_lex_state = 5},
  [996] = {.lex_state = 0, .external_lex_state = 5},
  [997] = {.lex_state = 0, .external_lex_state = 5},
  [998] = {.lex_state = 0, .external_lex_state = 5},
  [999] = {.lex_state = 0, .external_lex_state = 5},
  [1000] = {.lex_state = 15, .external_lex_state = 5},
  [1001] = {.lex_state = 0, .external_lex_state = 5},
  [1002] = {.lex_state = 15, .external_lex_state = 5},
  [1003] = {.lex_state = 0, .external_lex_state = 5},
  [1004] = {.lex_state = 0, .external_lex_state = 5},
  [1005] = {.lex_state = 0, .external_lex_state = 5},
  [1006] = {.lex_state = 15, .external_lex_state = 5},
  [1007] = {.lex_state = 0, .external_lex_state = 5},
  [1008] = {.lex_state = 0, .external_lex_state = 5},
  [1009] = {.lex_state = 7, .external_lex_state = 5},
  [1010] = {.lex_state = 15, .external_lex_state = 5},
  [1011] = {.lex_state = 15, .external_lex_state = 5},
  [1012] = {.lex_state = 0, .external_lex_state = 5},
  [1013] = {.lex_state = 0, .external_lex_state = 5},
  [1014] = {.lex_state = 0, .external_lex_state = 5},
  [1015] = {.lex_state = 0, .external_lex_state = 5},
  [1016] = {.lex_state = 0, .external_lex_state = 5},
  [1017] = {.lex_state = 0, .external_lex_state = 5},
  [1018] = {.lex_state = 7, .external_lex_state = 5},
  [1019] = {.lex_state = 7, .external_lex_state = 5},
  [1020] = {.lex_state = 15, .external_lex_state = 5},
  [1021] = {.lex_state = 0, .external_lex_state = 5},
  [1022] = {.lex_state = 0, .external_lex_state = 5},
  [1023] = {.lex_state = 7, .external_lex_state = 5},
  [1024] = {.lex_state = 7, .external_lex_state = 5},
  [1025] = {.lex_state = 0, .external_lex_state = 5},
  [1026] = {.lex_state = 0, .external_lex_state = 5},
  [1027] = {.lex_state = 0, .external_lex_state = 5},
  [1028] = {.lex_state = 7, .external_lex_state = 5},
  [1029] = {.lex_state = 15, .external_lex_state = 5},
  [1030] = {.lex_state = 7, .external_lex_state = 5},
  [1031] = {.lex_state = 7, .external_lex_state = 5},
  [1032] = {.lex_state = 7, .external_lex_state = 5},
  [1033] = {.lex_state = 7, .external_lex_state = 5},
  [1034] = {.lex_state = 0, .external_lex_state = 5},
  [1035] = {.lex_state = 0, .external_lex_state = 5},
  [1036] = {.lex_state = 7, .external_lex_state = 5},
  [1037] = {.lex_state = 0, .external_lex_state = 5},
  [1038] = {.lex_state = 15, .external_lex_state = 5},
  [1039] = {.lex_state = 0, .external_lex_state = 5},
  [1040] = {.lex_state = 15, .external_lex_state = 5},
  [1041] = {.lex_state = 0, .external_lex_state = 5},
  [1042] = {.lex_state = 0, .external_lex_state = 5},
  [1043] = {.lex_state = 0, .external_lex_state = 5},
  [1044] = {.lex_state = 0, .external_lex_state = 5},
  [1045] = {.lex_state = 0, .external_lex_state = 5},
  [1046] = {.lex_state = 15, .external_lex_state = 5},
  [1047] = {.lex_state = 7, .external_lex_state = 5},
  [1048] = {.lex_state = 15, .external_lex_state = 5},
  [1049] = {.lex_state = 0, .external_lex_state = 5},
  [1050] = {.lex_state = 7, .external_lex_state = 5},
  [1051] = {.lex_state = 7, .external_lex_state = 5},
  [1052] = {.lex_state = 7, .external_lex_state = 5},
  [1053] = {.lex_state = 15, .external_lex_state = 5},
  [1054] = {.lex_state = 15, .external_lex_state = 5},
  [1055] = {.lex_state = 7, .external_lex_state = 5},
  [1056] = {.lex_state = 0, .external_lex_state = 5},
  [1057] = {.lex_state = 15, .external_lex_state = 5},
  [1058] = {.lex_state = 0, .external_lex_state = 5},
  [1059] = {.lex_state = 7, .external_lex_state = 5},
  [1060] = {.lex_state = 15, .external_lex_state = 5},
  [1061] = {.lex_state = 15, .external_lex_state = 5},
  [1062] = {.lex_state = 15, .external_lex_state = 5},
  [1063] = {.lex_state = 15, .external_lex_state = 5},
  [1064] = {.lex_state = 15, .external_lex_state = 5},
  [1065] = {.lex_state = 15, .external_lex_state = 5},
  [1066] = {.lex_state = 15, .external_lex_state = 5},
  [1067] = {.lex_state = 15, .external_lex_state = 5},
  [1068] = {.lex_state = 15, .external_lex_state = 5},
  [1069] = {.lex_state = 15, .external_lex_state = 5},
  [1070] = {.lex_state = 15, .external_lex_state = 5},
  [1071] = {.lex_state = 15, .external_lex_state = 5},
  [1072] = {.lex_state = 15, .external_lex_state = 5},
  [1073] = {.lex_state = 0, .external_lex_state = 5},
  [1074] = {.lex_state = 15, .external_lex_state = 5},
  [1075] = {.lex_state = 15, .external_lex_state = 5},
  [1076] = {.lex_state = 15, .external_lex_state = 5},
  [1077] = {.lex_state = 15, .external_lex_state = 5},
  [1078] = {.lex_state = 15, .external_lex_state = 5},
  [1079] = {.lex_state = 15, .external_lex_state = 5},
  [1080] = {.lex_state = 15, .external_lex_state = 5},
  [1081] = {.lex_state = 15, .external_lex_state = 5},
  [1082] = {.lex_state = 15, .external_lex_state = 5},
  [1083] = {.lex_state = 15, .external_lex_state = 5},
  [1084] = {.lex_state = 0, .external_lex_state = 5},
  [1085] = {.lex_state = 0, .external_lex_state = 5},
  [1086] = {.lex_state = 15, .external_lex_state = 5},
  [1087] = {.lex_state = 15, .external_lex_state = 5},
  [1088] = {.lex_state = 0, .external_lex_state = 5},
  [1089] = {.lex_state = 15, .external_lex_state = 5},
  [1090] = {.lex_state = 15, .external_lex_state = 5},
  [1091] = {.lex_state = 15, .external_lex_state = 5},
  [1092] = {.lex_state = 15, .external_lex_state = 5},
  [1093] = {.lex_state = 15, .external_lex_state = 5},
  [1094] = {.lex_state = 15, .external_lex_state = 5},
  [1095] = {.lex_state = 15, .external_lex_state = 5},
  [1096] = {.lex_state = 15, .external_lex_state = 5},
  [1097] = {.lex_state = 15, .external_lex_state = 5},
  [1098] = {.lex_state = 0, .external_lex_state = 5},
  [1099] = {.lex_state = 15, .external_lex_state = 5},
  [1100] = {.lex_state = 15, .external_lex_state = 5},
  [1101] = {.lex_state = 15, .external_lex_state = 5},
  [1102] = {.lex_state = 15, .external_lex_state = 5},
  [1103] = {.lex_state = 15, .external_lex_state = 5},
  [1104] = {.lex_state = 15, .external_lex_state = 5},
  [1105] = {.lex_state = 15, .external_lex_state = 5},
  [1106] = {.lex_state = 15, .external_lex_state = 5},
  [1107] = {.lex_state = 15, .external_lex_state = 5},
  [1108] = {.lex_state = 15, .external_lex_state = 5},
  [1109] = {.lex_state = 15, .external_lex_state = 5},
  [1110] = {.lex_state = 15, .external_lex_state = 5},
  [1111] = {.lex_state = 15, .external_lex_state = 5},
  [1112] = {.lex_state = 15, .external_lex_state = 5},
  [1113] = {.lex_state = 15, .external_lex_state = 5},
  [1114] = {.lex_state = 15, .external_lex_state = 5},
  [1115] = {.lex_state = 15, .external_lex_state = 5},
  [1116] = {.lex_state = 15, .external_lex_state = 5},
  [1117] = {.lex_state = 15, .external_lex_state = 5},
  [1118] = {.lex_state = 15, .external_lex_state = 5},
  [1119] = {.lex_state = 15, .external_lex_state = 5},
  [1120] = {.lex_state = 15, .external_lex_state = 5},
  [1121] = {.lex_state = 0, .external_lex_state = 5},
  [1122] = {.lex_state = 15, .external_lex_state = 5},
  [1123] = {.lex_state = 15, .external_lex_state = 5},
  [1124] = {.lex_state = 15, .external_lex_state = 5},
  [1125] = {.lex_state = 15, .external_lex_state = 5},
  [1126] = {.lex_state = 15, .external_lex_state = 5},
  [1127] = {.lex_state = 15, .external_lex_state = 5},
  [1128] = {.lex_state = 15, .external_lex_state = 5},
  [1129] = {.lex_state = 15, .external_lex_state = 5},
  [1130] = {.lex_state = 15, .external_lex_state = 5},
  [1131] = {.lex_state = 15, .external_lex_state = 5},
  [1132] = {.lex_state = 0, .external_lex_state = 5},
  [1133] = {.lex_state = 15, .external_lex_state = 5},
  [1134] = {.lex_state = 0, .external_lex_state = 5},
  [1135] = {.lex_state = 0, .external_lex_state = 5},
  [1136] = {.lex_state = 0, .external_lex_state = 5},
  [1137] = {.lex_state = 0, .external_lex_state = 5},
  [1138] = {.lex_state = 15, .external_lex_state = 5},
  [1139] = {.lex_state = 15, .external_lex_state = 5},
  [1140] = {.lex_state = 0, .external_lex_state = 5},
  [1141] = {.lex_state = 0, .external_lex_state = 5},
  [1142] = {.lex_state = 0, .external_lex_state = 5},
  [1143] = {.lex_state = 0, .external_lex_state = 5},
  [1144] = {.lex_state = 15, .external_lex_state = 5},
  [1145] = {.lex_state = 15, .external_lex_state = 5},
  [1146] = {.lex_state = 15, .external_lex_state = 5},
  [1147] = {.lex_state = 0, .external_lex_state = 5},
  [1148] = {.lex_state = 15, .external_lex_state = 5},
  [1149] = {.lex_state = 0, .external_lex_state = 5},
  [1150] = {.lex_state = 15, .external_lex_state = 5},
  [1151] = {.lex_state = 0, .external_lex_state = 5},
  [1152] = {.lex_state = 15, .external_lex_state = 5},
  [1153] = {.lex_state = 15, .external_lex_state = 5},
  [1154] = {.lex_state = 0, .external_lex_state = 5},
  [1155] = {.lex_state = 0, .external_lex_state = 5},
  [1156] = {.lex_state = 0, .external_lex_state = 5},
  [1157] = {.lex_state = 15, .external_lex_state = 5},
  [1158] = {.lex_state = 15, .external_lex_state = 5},
  [1159] = {.lex_state = 0, .external_lex_state = 5},
  [1160] = {.lex_state = 15, .external_lex_state = 5},
  [1161] = {.lex_state = 0, .external_lex_state = 5},
  [1162] = {.lex_state = 15, .external_lex_state = 5},
  [1163] = {.lex_state = 15, .external_lex_state = 5},
  [1164] = {.lex_state = 0, .external_lex_state = 5},
  [1165] = {.lex_state = 15, .external_lex_state = 5},
  [1166] = {.lex_state = 0, .external_lex_state = 5},
  [1167] = {.lex_state = 15, .external_lex_state = 5},
  [1168] = {.lex_state = 0, .external_lex_state = 5},
  [1169] = {.lex_state = 15, .external_lex_state = 5},
  [1170] = {.lex_state = 0, .external_lex_state = 5},
  [1171] = {.lex_state = 15, .external_lex_state = 5},
  [1172] = {.lex_state = 0, .external_lex_state = 5},
  [1173] = {.lex_state = 0, .external_lex_state = 5},
  [1174] = {.lex_state = 15, .external_lex_state = 5},
  [1175] = {.lex_state = 15, .external_lex_state = 5},
  [1176] = {.lex_state = 15, .external_lex_state = 5},
  [1177] = {.lex_state = 0, .external_lex_state = 5},
  [1178] = {.lex_state = 15, .external_lex_state = 5},
  [1179] = {.lex_state = 15, .external_lex_state = 5},
  [1180] = {.lex_state = 0, .external_lex_state = 5},
  [1181] = {.lex_state = 0, .external_lex_state = 5},
  [1182] = {.lex_state = 15, .external_lex_state = 5},
  [1183] = {.lex_state = 15, .external_lex_state = 5},
  [1184] = {.lex_state = 15, .external_lex_state = 5},
  [1185] = {.lex_state = 0, .external_lex_state = 5},
  [1186] = {.lex_state = 15, .external_lex_state = 5},
  [1187] = {.lex_state = 0, .external_lex_state = 5},
  [1188] = {.lex_state = 15, .external_lex_state = 5},
  [1189] = {.lex_state = 0, .external_lex_state = 5},
  [1190] = {.lex_state = 0, .external_lex_state = 5},
  [1191] = {.lex_state = 15, .external_lex_state = 5},
  [1192] = {.lex_state = 15, .external_lex_state = 5},
  [1193] = {.lex_state = 15, .external_lex_state = 5},
  [1194] = {.lex_state = 15, .external_lex_state = 5},
  [1195] = {.lex_state = 0, .external_lex_state = 5},
  [1196] = {.lex_state = 0, .external_lex_state = 5},
  [1197] = {.lex_state = 0, .external_lex_state = 5},
  [1198] = {.lex_state = 0, .external_lex_state = 5},
  [1199] = {.lex_state = 15, .external_lex_state = 5},
  [1200] = {.lex_state = 0, .external_lex_state = 5},
  [1201] = {.lex_state = 0, .external_lex_state = 5},
  [1202] = {.lex_state = 15, .external_lex_state = 5},
  [1203] = {.lex_state = 0, .external_lex_state = 5},
  [1204] = {.lex_state = 15, .external_lex_state = 5},
  [1205] = {.lex_state = 15, .external_lex_state = 5},
  [1206] = {.lex_state = 15, .external_lex_state = 5},
  [1207] = {.lex_state = 0, .external_lex_state = 5},
  [1208] = {.lex_state = 0, .external_lex_state = 5},
  [1209] = {.lex_state = 0, .external_lex_state = 5},
  [1210] = {.lex_state = 15, .external_lex_state = 5},
  [1211] = {.lex_state = 15, .external_lex_state = 5},
  [1212] = {.lex_state = 0, .external_lex_state = 5},
  [1213] = {.lex_state = 15, .external_lex_state = 5},
  [1214] = {.lex_state = 15, .external_lex_state = 5},
  [1215] = {.lex_state = 15, .external_lex_state = 5},
  [1216] = {.lex_state = 15, .external_lex_state = 5},
  [1217] = {.lex_state = 15, .external_lex_state = 5},
  [1218] = {.lex_state = 15, .external_lex_state = 5},
};

enum {
  ts_external_token_comment = 0,
  ts_external_token_line_continuation = 1,
  ts_external_token_command_name = 2,
  ts_external_token_command_argument = 3,
  ts_external_token__single_quote_string_start = 4,
  ts_external_token__single_quote_string_end = 5,
  ts_external_token__double_quote_string_start = 6,
  ts_external_token__double_quote_string_end = 7,
  ts_external_token_formatting_sequence = 8,
  ts_external_token_escape_sequence = 9,
  ts_external_token_string_content = 10,
  ts_external_token__entry_delimiter = 11,
  ts_external_token__multioutput_variable_start = 12,
  ts_external_token_error_sentinel = 13,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_comment] = sym_comment,
  [ts_external_token_line_continuation] = sym_line_continuation,
  [ts_external_token_command_name] = sym_command_name,
  [ts_external_token_command_argument] = sym_command_argument,
  [ts_external_token__single_quote_string_start] = sym__single_quote_string_start,
  [ts_external_token__single_quote_string_end] = sym__single_quote_string_end,
  [ts_external_token__double_quote_string_start] = sym__double_quote_string_start,
  [ts_external_token__double_quote_string_end] = sym__double_quote_string_end,
  [ts_external_token_formatting_sequence] = sym_formatting_sequence,
  [ts_external_token_escape_sequence] = sym_escape_sequence,
  [ts_external_token_string_content] = sym_string_content,
  [ts_external_token__entry_delimiter] = sym__entry_delimiter,
  [ts_external_token__multioutput_variable_start] = sym__multioutput_variable_start,
  [ts_external_token_error_sentinel] = sym_error_sentinel,
};

static const bool ts_external_scanner_states[11][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_comment] = true,
    [ts_external_token_line_continuation] = true,
    [ts_external_token_command_name] = true,
    [ts_external_token_command_argument] = true,
    [ts_external_token__single_quote_string_start] = true,
    [ts_external_token__single_quote_string_end] = true,
    [ts_external_token__double_quote_string_start] = true,
    [ts_external_token__double_quote_string_end] = true,
    [ts_external_token_formatting_sequence] = true,
    [ts_external_token_escape_sequence] = true,
    [ts_external_token_string_content] = true,
    [ts_external_token__entry_delimiter] = true,
    [ts_external_token__multioutput_variable_start] = true,
    [ts_external_token_error_sentinel] = true,
  },
  [2] = {
    [ts_external_token_comment] = true,
    [ts_external_token_line_continuation] = true,
    [ts_external_token_command_name] = true,
    [ts_external_token__single_quote_string_start] = true,
    [ts_external_token__double_quote_string_start] = true,
    [ts_external_token__multioutput_variable_start] = true,
  },
  [3] = {
    [ts_external_token_comment] = true,
    [ts_external_token_line_continuation] = true,
    [ts_external_token__single_quote_string_start] = true,
    [ts_external_token__double_quote_string_start] = true,
  },
  [4] = {
    [ts_external_token_comment] = true,
    [ts_external_token_line_continuation] = true,
    [ts_external_token__single_quote_string_start] = true,
    [ts_external_token__double_quote_string_start] = true,
    [ts_external_token__entry_delimiter] = true,
  },
  [5] = {
    [ts_external_token_comment] = true,
    [ts_external_token_line_continuation] = true,
  },
  [6] = {
    [ts_external_token_comment] = true,
    [ts_external_token_line_continuation] = true,
    [ts_external_token__entry_delimiter] = true,
  },
  [7] = {
    [ts_external_token_comment] = true,
    [ts_external_token_line_continuation] = true,
    [ts_external_token__multioutput_variable_start] = true,
  },
  [8] = {
    [ts_external_token_comment] = true,
    [ts_external_token_line_continuation] = true,
    [ts_external_token_command_argument] = true,
  },
  [9] = {
    [ts_external_token_comment] = true,
    [ts_external_token_line_continuation] = true,
    [ts_external_token__single_quote_string_end] = true,
    [ts_external_token_formatting_sequence] = true,
    [ts_external_token_escape_sequence] = true,
    [ts_external_token_string_content] = true,
  },
  [10] = {
    [ts_external_token_comment] = true,
    [ts_external_token_line_continuation] = true,
    [ts_external_token__double_quote_string_end] = true,
    [ts_external_token_formatting_sequence] = true,
    [ts_external_token_escape_sequence] = true,
    [ts_external_token_string_content] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DOT_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DOT_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_DOT_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT_SLASH] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_DOT_BSLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_DOT_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_DOT_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_return_statement] = ACTIONS(1),
    [sym_continue_statement] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_parfor] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_otherwise] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_persistent] = ACTIONS(1),
    [anon_sym_arguments] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_get_DOT] = ACTIONS(1),
    [anon_sym_set_DOT] = ACTIONS(1),
    [anon_sym_endfunction] = ACTIONS(1),
    [anon_sym_properties] = ACTIONS(1),
    [anon_sym_methods] = ACTIONS(1),
    [anon_sym_events] = ACTIONS(1),
    [anon_sym_enumeration] = ACTIONS(1),
    [anon_sym_classdef] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(1),
    [sym_command_argument] = ACTIONS(1),
    [sym__single_quote_string_start] = ACTIONS(1),
    [sym__single_quote_string_end] = ACTIONS(1),
    [sym__double_quote_string_start] = ACTIONS(1),
    [sym__double_quote_string_end] = ACTIONS(1),
    [sym_formatting_sequence] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_string_content] = ACTIONS(1),
    [sym__entry_delimiter] = ACTIONS(1),
    [sym__multioutput_variable_start] = ACTIONS(1),
    [sym_error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1190),
    [aux_sym__block] = STATE(73),
    [sym__statement] = STATE(828),
    [sym__expression] = STATE(629),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(629),
    [sym_handle_operator] = STATE(629),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(828),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(828),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(629),
    [sym_if_statement] = STATE(828),
    [sym_for_statement] = STATE(828),
    [sym_while_statement] = STATE(828),
    [sym_switch_statement] = STATE(828),
    [sym_lambda] = STATE(629),
    [sym_global_operator] = STATE(828),
    [sym_persistent_operator] = STATE(828),
    [sym_function_definition] = STATE(891),
    [sym__function_definition_with_end] = STATE(882),
    [sym_class_definition] = STATE(828),
    [sym_try_statement] = STATE(828),
    [sym_boolean] = STATE(209),
    [aux_sym_source_file_repeat1] = STATE(891),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(23),
    [sym_continue_statement] = ACTIONS(23),
    [sym_break_statement] = ACTIONS(23),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(39),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [2] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(751),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_elseif_clause] = STATE(747),
    [sym_else_clause] = STATE(1206),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(5),
    [aux_sym_elseif_clause_repeat1] = STATE(5),
    [aux_sym_if_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(69),
    [anon_sym_LT_EQ] = ACTIONS(69),
    [anon_sym_EQ_EQ] = ACTIONS(69),
    [anon_sym_TILDE_EQ] = ACTIONS(69),
    [anon_sym_GT_EQ] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_elseif] = ACTIONS(81),
    [anon_sym_else] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(57),
    [anon_sym_CR] = ACTIONS(57),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [3] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1029),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(9),
    [aux_sym_elseif_clause_repeat1] = STATE(9),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_COMMA] = ACTIONS(91),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(69),
    [anon_sym_LT_EQ] = ACTIONS(69),
    [anon_sym_EQ_EQ] = ACTIONS(69),
    [anon_sym_TILDE_EQ] = ACTIONS(69),
    [anon_sym_GT_EQ] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_elseif] = ACTIONS(93),
    [anon_sym_else] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(93),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(91),
    [anon_sym_CR] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [4] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1214),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(17),
    [aux_sym_elseif_clause_repeat1] = STATE(17),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(95),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(69),
    [anon_sym_LT_EQ] = ACTIONS(69),
    [anon_sym_EQ_EQ] = ACTIONS(69),
    [anon_sym_TILDE_EQ] = ACTIONS(69),
    [anon_sym_GT_EQ] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(95),
    [anon_sym_CR] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [5] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(789),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_elseif_clause] = STATE(795),
    [sym_else_clause] = STATE(1191),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(157),
    [aux_sym_elseif_clause_repeat1] = STATE(157),
    [aux_sym_if_statement_repeat1] = STATE(795),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_elseif] = ACTIONS(81),
    [anon_sym_else] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [6] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1057),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_catch_clause] = STATE(1183),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(8),
    [aux_sym_elseif_clause_repeat1] = STATE(8),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(105),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_catch] = ACTIONS(107),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(103),
    [anon_sym_CR] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [7] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1054),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(157),
    [aux_sym_elseif_clause_repeat1] = STATE(157),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_case] = ACTIONS(109),
    [anon_sym_otherwise] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [8] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1006),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_catch_clause] = STATE(1133),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(157),
    [aux_sym_elseif_clause_repeat1] = STATE(157),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_catch] = ACTIONS(107),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [9] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1048),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(157),
    [aux_sym_elseif_clause_repeat1] = STATE(157),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_elseif] = ACTIONS(113),
    [anon_sym_else] = ACTIONS(113),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(113),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [10] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1216),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(157),
    [aux_sym_elseif_clause_repeat1] = STATE(157),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(115),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [11] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1202),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(157),
    [aux_sym_elseif_clause_repeat1] = STATE(157),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [12] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1218),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(157),
    [aux_sym_elseif_clause_repeat1] = STATE(157),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [13] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1175),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(157),
    [aux_sym_elseif_clause_repeat1] = STATE(157),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(121),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [14] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1152),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(157),
    [aux_sym_elseif_clause_repeat1] = STATE(157),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [15] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1182),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(14),
    [aux_sym_elseif_clause_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym_COMMA] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(127),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(125),
    [anon_sym_CR] = ACTIONS(125),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [16] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1145),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(157),
    [aux_sym_elseif_clause_repeat1] = STATE(157),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(129),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [17] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1160),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(157),
    [aux_sym_elseif_clause_repeat1] = STATE(157),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(131),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [18] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1184),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(12),
    [aux_sym_elseif_clause_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(133),
    [anon_sym_COMMA] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(135),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(133),
    [anon_sym_CR] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [19] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1211),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(10),
    [aux_sym_elseif_clause_repeat1] = STATE(10),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(137),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(137),
    [anon_sym_CR] = ACTIONS(137),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [20] = {
    [aux_sym__block] = STATE(57),
    [sym_block] = STATE(1171),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym__end_of_line] = STATE(16),
    [aux_sym_elseif_clause_repeat1] = STATE(16),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(141),
    [anon_sym_CR] = ACTIONS(141),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [21] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(979),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(42),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(42),
    [ts_builtin_sym_end] = ACTIONS(145),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_endfunction] = ACTIONS(149),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [22] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(969),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(156),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(158),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(160),
    [anon_sym_endfunction] = ACTIONS(158),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [23] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(899),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(32),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(32),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(167),
    [anon_sym_endfunction] = ACTIONS(165),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [24] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(899),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(167),
    [anon_sym_endfunction] = ACTIONS(165),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [25] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(901),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(170),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(172),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(174),
    [anon_sym_endfunction] = ACTIONS(172),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [26] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(962),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(35),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(35),
    [ts_builtin_sym_end] = ACTIONS(177),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(181),
    [anon_sym_endfunction] = ACTIONS(179),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [27] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(907),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(34),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(34),
    [ts_builtin_sym_end] = ACTIONS(145),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(184),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_endfunction] = ACTIONS(184),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [28] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(936),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(22),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(22),
    [ts_builtin_sym_end] = ACTIONS(177),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(186),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(181),
    [anon_sym_endfunction] = ACTIONS(186),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [29] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(888),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(43),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(43),
    [ts_builtin_sym_end] = ACTIONS(188),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(192),
    [anon_sym_endfunction] = ACTIONS(190),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [30] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(969),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(44),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(44),
    [ts_builtin_sym_end] = ACTIONS(156),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(158),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(160),
    [anon_sym_endfunction] = ACTIONS(158),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [31] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(898),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(195),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_endfunction] = ACTIONS(197),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [32] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(947),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(195),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(202),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_endfunction] = ACTIONS(202),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [33] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(952),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(36),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(36),
    [ts_builtin_sym_end] = ACTIONS(204),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(206),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(208),
    [anon_sym_endfunction] = ACTIONS(206),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [34] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(952),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(204),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(206),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(208),
    [anon_sym_endfunction] = ACTIONS(206),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [35] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(920),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(156),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(211),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(160),
    [anon_sym_endfunction] = ACTIONS(211),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [36] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(942),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(213),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(215),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(217),
    [anon_sym_endfunction] = ACTIONS(215),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [37] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(944),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(213),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(220),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(217),
    [anon_sym_endfunction] = ACTIONS(220),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [38] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(920),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(25),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(25),
    [ts_builtin_sym_end] = ACTIONS(156),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(211),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(160),
    [anon_sym_endfunction] = ACTIONS(211),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [39] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(923),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(24),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(24),
    [ts_builtin_sym_end] = ACTIONS(188),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(222),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(192),
    [anon_sym_endfunction] = ACTIONS(222),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [40] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(938),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(37),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(37),
    [ts_builtin_sym_end] = ACTIONS(204),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(224),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(208),
    [anon_sym_endfunction] = ACTIONS(224),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [41] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(972),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(31),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(31),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(226),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(167),
    [anon_sym_endfunction] = ACTIONS(226),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [42] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(938),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(204),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(224),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(208),
    [anon_sym_endfunction] = ACTIONS(224),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [43] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(972),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(226),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(167),
    [anon_sym_endfunction] = ACTIONS(226),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [44] = {
    [aux_sym__block] = STATE(71),
    [sym_block] = STATE(978),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [ts_builtin_sym_end] = ACTIONS(170),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(228),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(174),
    [anon_sym_endfunction] = ACTIONS(228),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [45] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1117),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(230),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(230),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [46] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1068),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(70),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(70),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(232),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(232),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [47] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1075),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(234),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(234),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [48] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1072),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(47),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(47),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(236),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(236),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [49] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1077),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(238),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(238),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [50] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1092),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(240),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(240),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [51] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1070),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(242),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(242),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [52] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1115),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(244),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [53] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1127),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(52),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(52),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(246),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(246),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [54] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1126),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(248),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(248),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [55] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1115),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(50),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(50),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(244),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [56] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1123),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(250),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(250),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [57] = {
    [aux_sym__block] = STATE(61),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_elseif] = ACTIONS(252),
    [anon_sym_else] = ACTIONS(252),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(252),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_case] = ACTIONS(252),
    [anon_sym_otherwise] = ACTIONS(252),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_catch] = ACTIONS(252),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [58] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1123),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(45),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(45),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(250),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(250),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [59] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1075),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(49),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(49),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(234),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(234),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [60] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1082),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(69),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(254),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [61] = {
    [aux_sym__block] = STATE(61),
    [sym__statement] = STATE(800),
    [sym__expression] = STATE(622),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(622),
    [sym_handle_operator] = STATE(622),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(800),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(800),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(622),
    [sym_if_statement] = STATE(800),
    [sym_for_statement] = STATE(800),
    [sym_while_statement] = STATE(800),
    [sym_switch_statement] = STATE(800),
    [sym_lambda] = STATE(622),
    [sym_global_operator] = STATE(800),
    [sym_persistent_operator] = STATE(800),
    [sym__function_definition_with_end] = STATE(831),
    [sym_class_definition] = STATE(800),
    [sym_try_statement] = STATE(800),
    [sym_boolean] = STATE(209),
    [sym_identifier] = ACTIONS(256),
    [anon_sym_LPAREN] = ACTIONS(259),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_TILDE] = ACTIONS(265),
    [anon_sym_QMARK] = ACTIONS(268),
    [anon_sym_AT] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(274),
    [anon_sym_LBRACE] = ACTIONS(277),
    [sym_return_statement] = ACTIONS(280),
    [sym_continue_statement] = ACTIONS(280),
    [sym_break_statement] = ACTIONS(280),
    [anon_sym_elseif] = ACTIONS(283),
    [anon_sym_else] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_end] = ACTIONS(283),
    [anon_sym_for] = ACTIONS(288),
    [anon_sym_parfor] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(294),
    [anon_sym_case] = ACTIONS(283),
    [anon_sym_otherwise] = ACTIONS(283),
    [anon_sym_switch] = ACTIONS(297),
    [anon_sym_global] = ACTIONS(300),
    [anon_sym_persistent] = ACTIONS(303),
    [anon_sym_function] = ACTIONS(306),
    [anon_sym_classdef] = ACTIONS(309),
    [anon_sym_catch] = ACTIONS(283),
    [anon_sym_try] = ACTIONS(312),
    [sym_number] = ACTIONS(315),
    [anon_sym_true] = ACTIONS(318),
    [anon_sym_false] = ACTIONS(318),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(321),
    [sym__single_quote_string_start] = ACTIONS(324),
    [sym__double_quote_string_start] = ACTIONS(327),
    [sym__multioutput_variable_start] = ACTIONS(330),
  },
  [62] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1063),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(63),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(63),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(333),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(333),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [63] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1068),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(232),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(232),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [64] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1065),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(335),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [65] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1093),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(56),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(56),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(337),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(337),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [66] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1095),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(54),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(54),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(339),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(339),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [67] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1105),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(64),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(64),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(341),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(341),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [68] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1065),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(51),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(51),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(335),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [69] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1095),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(339),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(339),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [70] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1074),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym_arguments_statement] = STATE(341),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [aux_sym_function_definition_repeat1] = STATE(341),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(343),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(343),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [71] = {
    [aux_sym__block] = STATE(72),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [ts_builtin_sym_end] = ACTIONS(345),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(252),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(347),
    [anon_sym_endfunction] = ACTIONS(252),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [72] = {
    [aux_sym__block] = STATE(72),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [ts_builtin_sym_end] = ACTIONS(350),
    [sym_identifier] = ACTIONS(256),
    [anon_sym_LPAREN] = ACTIONS(259),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_TILDE] = ACTIONS(265),
    [anon_sym_QMARK] = ACTIONS(268),
    [anon_sym_AT] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(274),
    [anon_sym_LBRACE] = ACTIONS(277),
    [sym_return_statement] = ACTIONS(352),
    [sym_continue_statement] = ACTIONS(352),
    [sym_break_statement] = ACTIONS(352),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_end] = ACTIONS(283),
    [anon_sym_for] = ACTIONS(288),
    [anon_sym_parfor] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(294),
    [anon_sym_switch] = ACTIONS(297),
    [anon_sym_global] = ACTIONS(300),
    [anon_sym_persistent] = ACTIONS(303),
    [anon_sym_function] = ACTIONS(306),
    [anon_sym_endfunction] = ACTIONS(283),
    [anon_sym_classdef] = ACTIONS(309),
    [anon_sym_try] = ACTIONS(312),
    [sym_number] = ACTIONS(315),
    [anon_sym_true] = ACTIONS(318),
    [anon_sym_false] = ACTIONS(318),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(321),
    [sym__single_quote_string_start] = ACTIONS(324),
    [sym__double_quote_string_start] = ACTIONS(327),
    [sym__multioutput_variable_start] = ACTIONS(330),
  },
  [73] = {
    [aux_sym__block] = STATE(75),
    [sym__statement] = STATE(828),
    [sym__expression] = STATE(629),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(629),
    [sym_handle_operator] = STATE(629),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(828),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(828),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(629),
    [sym_if_statement] = STATE(828),
    [sym_for_statement] = STATE(828),
    [sym_while_statement] = STATE(828),
    [sym_switch_statement] = STATE(828),
    [sym_lambda] = STATE(629),
    [sym_global_operator] = STATE(828),
    [sym_persistent_operator] = STATE(828),
    [sym_function_definition] = STATE(897),
    [sym__function_definition_with_end] = STATE(882),
    [sym_class_definition] = STATE(828),
    [sym_try_statement] = STATE(828),
    [sym_boolean] = STATE(209),
    [aux_sym_source_file_repeat1] = STATE(897),
    [ts_builtin_sym_end] = ACTIONS(355),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(23),
    [sym_continue_statement] = ACTIONS(23),
    [sym_break_statement] = ACTIONS(23),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(39),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [74] = {
    [aux_sym__block] = STATE(72),
    [sym__statement] = STATE(884),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(884),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(884),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(884),
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_switch_statement] = STATE(884),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(884),
    [sym_persistent_operator] = STATE(884),
    [sym__function_definition_with_end] = STATE(865),
    [sym_class_definition] = STATE(884),
    [sym_try_statement] = STATE(884),
    [sym_boolean] = STATE(209),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(252),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(252),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [75] = {
    [aux_sym__block] = STATE(75),
    [sym__statement] = STATE(828),
    [sym__expression] = STATE(629),
    [sym_parenthesis] = STATE(417),
    [sym__binary_expression] = STATE(612),
    [sym_binary_operator] = STATE(428),
    [sym_unary_operator] = STATE(430),
    [sym_indirect_access] = STATE(940),
    [sym_field_expression] = STATE(463),
    [sym_not_operator] = STATE(464),
    [sym_metaclass_operator] = STATE(629),
    [sym_handle_operator] = STATE(629),
    [sym_comparison_operator] = STATE(439),
    [sym_boolean_operator] = STATE(439),
    [sym_postfix_operator] = STATE(417),
    [sym_string] = STATE(417),
    [sym_matrix] = STATE(417),
    [sym_cell] = STATE(443),
    [sym_ignored_argument] = STATE(1187),
    [sym_assignment] = STATE(828),
    [sym_multioutput_variable] = STATE(1187),
    [sym_function_call] = STATE(211),
    [sym_command] = STATE(828),
    [sym__range_element] = STATE(1181),
    [sym_range] = STATE(629),
    [sym_if_statement] = STATE(828),
    [sym_for_statement] = STATE(828),
    [sym_while_statement] = STATE(828),
    [sym_switch_statement] = STATE(828),
    [sym_lambda] = STATE(629),
    [sym_global_operator] = STATE(828),
    [sym_persistent_operator] = STATE(828),
    [sym__function_definition_with_end] = STATE(882),
    [sym_class_definition] = STATE(828),
    [sym_try_statement] = STATE(828),
    [sym_boolean] = STATE(209),
    [ts_builtin_sym_end] = ACTIONS(350),
    [sym_identifier] = ACTIONS(256),
    [anon_sym_LPAREN] = ACTIONS(259),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_TILDE] = ACTIONS(265),
    [anon_sym_QMARK] = ACTIONS(268),
    [anon_sym_AT] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(274),
    [anon_sym_LBRACE] = ACTIONS(277),
    [sym_return_statement] = ACTIONS(357),
    [sym_continue_statement] = ACTIONS(357),
    [sym_break_statement] = ACTIONS(357),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_for] = ACTIONS(288),
    [anon_sym_parfor] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(294),
    [anon_sym_switch] = ACTIONS(297),
    [anon_sym_global] = ACTIONS(300),
    [anon_sym_persistent] = ACTIONS(303),
    [anon_sym_function] = ACTIONS(306),
    [anon_sym_classdef] = ACTIONS(309),
    [anon_sym_try] = ACTIONS(312),
    [sym_number] = ACTIONS(315),
    [anon_sym_true] = ACTIONS(318),
    [anon_sym_false] = ACTIONS(318),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(321),
    [sym__single_quote_string_start] = ACTIONS(324),
    [sym__double_quote_string_start] = ACTIONS(327),
    [sym__multioutput_variable_start] = ACTIONS(330),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 12,
    ACTIONS(362), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_DOT,
    ACTIONS(368), 1,
      anon_sym_AT,
    ACTIONS(372), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_COLON,
    STATE(85), 1,
      aux_sym_field_expression_repeat1,
    STATE(91), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 35,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [89] = 12,
    ACTIONS(362), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_DOT,
    ACTIONS(368), 1,
      anon_sym_AT,
    ACTIONS(372), 1,
      anon_sym_LBRACE,
    ACTIONS(378), 1,
      anon_sym_COLON,
    STATE(85), 1,
      aux_sym_field_expression_repeat1,
    STATE(91), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 35,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [178] = 12,
    ACTIONS(362), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_DOT,
    ACTIONS(368), 1,
      anon_sym_AT,
    ACTIONS(372), 1,
      anon_sym_LBRACE,
    STATE(85), 1,
      aux_sym_field_expression_repeat1,
    STATE(91), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(381), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(374), 28,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [267] = 10,
    ACTIONS(362), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_DOT,
    ACTIONS(368), 1,
      anon_sym_AT,
    ACTIONS(372), 1,
      anon_sym_LBRACE,
    STATE(85), 1,
      aux_sym_field_expression_repeat1,
    STATE(91), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(383), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 50,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [352] = 10,
    ACTIONS(362), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_DOT,
    ACTIONS(368), 1,
      anon_sym_AT,
    ACTIONS(372), 1,
      anon_sym_LBRACE,
    STATE(85), 1,
      aux_sym_field_expression_repeat1,
    STATE(91), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(387), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(385), 50,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [437] = 5,
    ACTIONS(391), 1,
      anon_sym_DOT,
    STATE(86), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(393), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(389), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [511] = 5,
    ACTIONS(391), 1,
      anon_sym_DOT,
    STATE(81), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(397), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(395), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [585] = 5,
    ACTIONS(401), 1,
      anon_sym_DOT,
    STATE(83), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(404), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(399), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [659] = 7,
    ACTIONS(362), 1,
      anon_sym_LPAREN,
    ACTIONS(368), 1,
      anon_sym_AT,
    ACTIONS(372), 1,
      anon_sym_LBRACE,
    STATE(91), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(408), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(406), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [737] = 5,
    ACTIONS(366), 1,
      anon_sym_DOT,
    STATE(83), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(412), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(410), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [811] = 5,
    ACTIONS(416), 1,
      anon_sym_DOT,
    STATE(86), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(419), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(414), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [885] = 8,
    ACTIONS(362), 1,
      anon_sym_LPAREN,
    ACTIONS(372), 1,
      anon_sym_LBRACE,
    ACTIONS(421), 1,
      anon_sym_AT,
    STATE(89), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(387), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(385), 50,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [964] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(425), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(423), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1033] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(429), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(427), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1102] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(419), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(414), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1171] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(433), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(431), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1240] = 10,
    ACTIONS(362), 1,
      anon_sym_LPAREN,
    ACTIONS(372), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(421), 1,
      anon_sym_AT,
    STATE(89), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 35,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1323] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(437), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(435), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1392] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(441), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(439), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1461] = 8,
    ACTIONS(362), 1,
      anon_sym_LPAREN,
    ACTIONS(372), 1,
      anon_sym_LBRACE,
    ACTIONS(421), 1,
      anon_sym_AT,
    STATE(89), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(383), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 50,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1540] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(445), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(443), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1609] = 10,
    ACTIONS(362), 1,
      anon_sym_LPAREN,
    ACTIONS(372), 1,
      anon_sym_LBRACE,
    ACTIONS(421), 1,
      anon_sym_AT,
    STATE(89), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(381), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(374), 28,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1692] = 10,
    ACTIONS(362), 1,
      anon_sym_LPAREN,
    ACTIONS(372), 1,
      anon_sym_LBRACE,
    ACTIONS(378), 1,
      anon_sym_COLON,
    ACTIONS(421), 1,
      anon_sym_AT,
    STATE(89), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 35,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1775] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(449), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(447), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1844] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(453), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(451), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1912] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(457), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(459), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(455), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1982] = 6,
    ACTIONS(378), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2056] = 6,
    ACTIONS(461), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2130] = 5,
    ACTIONS(378), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2202] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(387), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(385), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2272] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(387), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(385), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2340] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(387), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(385), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2410] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(468), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(466), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(464), 49,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2480] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(472), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(466), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 49,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2550] = 5,
    ACTIONS(474), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(472), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(466), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 48,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2622] = 6,
    ACTIONS(474), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(480), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(466), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(476), 47,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2696] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 39,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2768] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(484), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(482), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2836] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(488), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(486), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2904] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(492), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(490), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2972] = 6,
    ACTIONS(474), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(496), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(466), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(494), 47,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3046] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(383), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3116] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(500), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(498), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3184] = 6,
    ACTIONS(502), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3258] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(507), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(505), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3326] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(511), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(509), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3394] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 41,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3464] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(515), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(513), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3532] = 6,
    ACTIONS(517), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3606] = 6,
    ACTIONS(519), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3680] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(383), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3750] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(383), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3820] = 6,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3894] = 5,
    ACTIONS(526), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(528), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(523), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(521), 46,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3966] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(381), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(374), 31,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4040] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(530), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(461), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(519), 31,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4114] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(381), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(374), 33,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4186] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(534), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(532), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4254] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(387), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(385), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4324] = 6,
    ACTIONS(474), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(538), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(466), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(536), 47,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4398] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(383), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4468] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(540), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(502), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(517), 31,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4542] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(544), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(542), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4610] = 4,
    ACTIONS(548), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(550), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(546), 54,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4680] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(457), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(459), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(552), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(554), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(455), 43,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4754] = 7,
    ACTIONS(556), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(457), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(459), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(552), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(554), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(455), 42,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4830] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(560), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(558), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4898] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(564), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(562), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4966] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(457), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(459), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(455), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5036] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(457), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(459), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(554), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(455), 47,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5108] = 5,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5178] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(472), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(69), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 46,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5245] = 5,
    ACTIONS(71), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(472), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(69), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 45,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5314] = 6,
    ACTIONS(71), 1,
      anon_sym_AMP_AMP,
    ACTIONS(73), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(480), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(69), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(476), 44,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5385] = 6,
    ACTIONS(71), 1,
      anon_sym_AMP_AMP,
    ACTIONS(73), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(538), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(69), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(536), 44,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5456] = 6,
    ACTIONS(71), 1,
      anon_sym_AMP_AMP,
    ACTIONS(73), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(496), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(69), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(494), 44,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5527] = 5,
    ACTIONS(566), 1,
      anon_sym_DOT,
    STATE(153), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(397), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(395), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5586] = 5,
    ACTIONS(566), 1,
      anon_sym_DOT,
    STATE(154), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(393), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(389), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5645] = 5,
    ACTIONS(568), 1,
      anon_sym_DOT,
    STATE(154), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(419), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(414), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5704] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(419), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(414), 41,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5758] = 6,
    ACTIONS(71), 1,
      anon_sym_AMP_AMP,
    ACTIONS(73), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(573), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(69), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(571), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5815] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(157), 2,
      sym__end_of_line,
      aux_sym_elseif_clause_repeat1,
    ACTIONS(577), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(580), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(575), 31,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [5869] = 30,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(584), 1,
      anon_sym_COMMA,
    ACTIONS(586), 1,
      anon_sym_LPAREN,
    ACTIONS(590), 1,
      anon_sym_TILDE,
    ACTIONS(592), 1,
      anon_sym_QMARK,
    ACTIONS(594), 1,
      anon_sym_AT,
    ACTIONS(596), 1,
      anon_sym_LBRACK,
    ACTIONS(598), 1,
      aux_sym_matrix_token1,
    ACTIONS(602), 1,
      anon_sym_LBRACE,
    ACTIONS(604), 1,
      sym_number,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(806), 1,
      sym_ignored_argument,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1009), 1,
      sym_row,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(588), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(600), 2,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(630), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [5973] = 29,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(628), 1,
      anon_sym_RBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(983), 1,
      sym_spread_operator,
    STATE(1143), 1,
      sym_arguments,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(646), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6073] = 29,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(628), 1,
      anon_sym_RPAREN,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(983), 1,
      sym_spread_operator,
    STATE(1159), 1,
      sym__range_element,
    STATE(1177), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(646), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6173] = 29,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(640), 1,
      anon_sym_COMMA,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_TILDE,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(654), 1,
      anon_sym_RBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(806), 1,
      sym_ignored_argument,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1052), 1,
      sym_row,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(630), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6273] = 28,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(586), 1,
      anon_sym_LPAREN,
    ACTIONS(590), 1,
      anon_sym_TILDE,
    ACTIONS(592), 1,
      anon_sym_QMARK,
    ACTIONS(594), 1,
      anon_sym_AT,
    ACTIONS(596), 1,
      anon_sym_LBRACK,
    ACTIONS(602), 1,
      anon_sym_LBRACE,
    ACTIONS(604), 1,
      sym_number,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(660), 1,
      aux_sym_matrix_token1,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(977), 1,
      sym_ignored_argument,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(588), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(662), 2,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(647), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6371] = 27,
    ACTIONS(586), 1,
      anon_sym_LPAREN,
    ACTIONS(596), 1,
      anon_sym_LBRACK,
    ACTIONS(602), 1,
      anon_sym_LBRACE,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(664), 1,
      sym_identifier,
    ACTIONS(666), 1,
      anon_sym_TILDE,
    ACTIONS(668), 1,
      anon_sym_QMARK,
    ACTIONS(670), 1,
      anon_sym_AT,
    ACTIONS(676), 1,
      sym_number,
    STATE(338), 1,
      sym_function_call,
    STATE(380), 1,
      sym_boolean,
    STATE(470), 1,
      sym_unary_operator,
    STATE(482), 1,
      sym_not_operator,
    STATE(504), 1,
      sym_cell,
    STATE(507), 1,
      sym_binary_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(588), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(672), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(674), 2,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(474), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(478), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6467] = 5,
    STATE(184), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(682), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(678), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(680), 22,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [6519] = 28,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(586), 1,
      anon_sym_LPAREN,
    ACTIONS(590), 1,
      anon_sym_TILDE,
    ACTIONS(592), 1,
      anon_sym_QMARK,
    ACTIONS(594), 1,
      anon_sym_AT,
    ACTIONS(596), 1,
      anon_sym_LBRACK,
    ACTIONS(602), 1,
      anon_sym_LBRACE,
    ACTIONS(604), 1,
      sym_number,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(684), 1,
      aux_sym_matrix_token1,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(977), 1,
      sym_ignored_argument,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(588), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(686), 2,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(647), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6617] = 29,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(640), 1,
      anon_sym_COMMA,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_TILDE,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(688), 1,
      anon_sym_RBRACE,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(806), 1,
      sym_ignored_argument,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1055), 1,
      sym_row,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(630), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6717] = 29,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(690), 1,
      anon_sym_RPAREN,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(983), 1,
      sym_spread_operator,
    STATE(1159), 1,
      sym__range_element,
    STATE(1185), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(646), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6817] = 29,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(640), 1,
      anon_sym_COMMA,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_TILDE,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(692), 1,
      anon_sym_RBRACK,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(806), 1,
      sym_ignored_argument,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1018), 1,
      sym_row,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(630), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6917] = 29,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(640), 1,
      anon_sym_COMMA,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_TILDE,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(694), 1,
      anon_sym_RBRACE,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(806), 1,
      sym_ignored_argument,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1019), 1,
      sym_row,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(630), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7017] = 29,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(628), 1,
      anon_sym_RPAREN,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(696), 1,
      sym_identifier,
    STATE(379), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(565), 1,
      sym_binary_operator,
    STATE(566), 1,
      sym_unary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(983), 1,
      sym_spread_operator,
    STATE(1159), 1,
      sym__range_element,
    STATE(1177), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(564), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(646), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7117] = 28,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(586), 1,
      anon_sym_LPAREN,
    ACTIONS(590), 1,
      anon_sym_TILDE,
    ACTIONS(592), 1,
      anon_sym_QMARK,
    ACTIONS(594), 1,
      anon_sym_AT,
    ACTIONS(596), 1,
      anon_sym_LBRACK,
    ACTIONS(602), 1,
      anon_sym_LBRACE,
    ACTIONS(604), 1,
      sym_number,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(698), 1,
      aux_sym_matrix_token1,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(977), 1,
      sym_ignored_argument,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(588), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(700), 2,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(647), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7215] = 29,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(702), 1,
      anon_sym_RPAREN,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(983), 1,
      sym_spread_operator,
    STATE(1159), 1,
      sym__range_element,
    STATE(1173), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(646), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7315] = 5,
    STATE(164), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(708), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(704), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(706), 22,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [7367] = 29,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(710), 1,
      anon_sym_RBRACE,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(983), 1,
      sym_spread_operator,
    STATE(1151), 1,
      sym_arguments,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(646), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7467] = 29,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(640), 1,
      anon_sym_COMMA,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_TILDE,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(712), 1,
      anon_sym_RBRACK,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(806), 1,
      sym_ignored_argument,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1023), 1,
      sym_row,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(630), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7567] = 29,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(690), 1,
      anon_sym_RBRACE,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(983), 1,
      sym_spread_operator,
    STATE(1159), 1,
      sym__range_element,
    STATE(1196), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(646), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7667] = 5,
    STATE(184), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(682), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(714), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(716), 22,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [7719] = 29,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(640), 1,
      anon_sym_COMMA,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_TILDE,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(718), 1,
      anon_sym_RBRACE,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(806), 1,
      sym_ignored_argument,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1024), 1,
      sym_row,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(630), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7819] = 29,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(710), 1,
      anon_sym_RPAREN,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(983), 1,
      sym_spread_operator,
    STATE(1149), 1,
      sym_arguments,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(646), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7919] = 5,
    STATE(177), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(720), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(350), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(283), 22,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [7971] = 29,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(722), 1,
      anon_sym_RBRACE,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(983), 1,
      sym_spread_operator,
    STATE(1135), 1,
      sym_arguments,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(646), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8071] = 29,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(722), 1,
      anon_sym_RPAREN,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(983), 1,
      sym_spread_operator,
    STATE(1155), 1,
      sym_arguments,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(646), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8171] = 29,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(640), 1,
      anon_sym_COMMA,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_TILDE,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(724), 1,
      anon_sym_RBRACE,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(806), 1,
      sym_ignored_argument,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1031), 1,
      sym_row,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(630), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8271] = 5,
    STATE(184), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(730), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(726), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(728), 22,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [8323] = 29,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(702), 1,
      anon_sym_RBRACE,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(983), 1,
      sym_spread_operator,
    STATE(1159), 1,
      sym__range_element,
    STATE(1172), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(646), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8423] = 29,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(640), 1,
      anon_sym_COMMA,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_TILDE,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(733), 1,
      anon_sym_RBRACK,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(806), 1,
      sym_ignored_argument,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1036), 1,
      sym_row,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(630), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8523] = 6,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(737), 1,
      anon_sym_AT,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    STATE(196), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(406), 34,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [8576] = 11,
    ACTIONS(378), 1,
      anon_sym_COLON,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(737), 1,
      anon_sym_AT,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    ACTIONS(741), 1,
      anon_sym_DOT,
    STATE(196), 1,
      sym__args,
    STATE(306), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [8639] = 9,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(737), 1,
      anon_sym_AT,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    ACTIONS(741), 1,
      anon_sym_DOT,
    STATE(196), 1,
      sym__args,
    STATE(306), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [8698] = 11,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(737), 1,
      anon_sym_AT,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    ACTIONS(741), 1,
      anon_sym_DOT,
    STATE(196), 1,
      sym__args,
    STATE(306), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [8761] = 9,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(737), 1,
      anon_sym_AT,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    ACTIONS(741), 1,
      anon_sym_DOT,
    STATE(196), 1,
      sym__args,
    STATE(306), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [8820] = 11,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(737), 1,
      anon_sym_AT,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    ACTIONS(741), 1,
      anon_sym_DOT,
    STATE(196), 1,
      sym__args,
    STATE(306), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [8883] = 27,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1058), 1,
      sym_spread_operator,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(662), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8977] = 27,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(747), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1058), 1,
      sym_spread_operator,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(662), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [9071] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(427), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9115] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(431), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9159] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(435), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9203] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(423), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9247] = 27,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(749), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1058), 1,
      sym_spread_operator,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(662), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [9341] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(443), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9385] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(447), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9429] = 27,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_COLON,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(751), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1058), 1,
      sym_spread_operator,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(662), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [9523] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(439), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9567] = 26,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_TILDE,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(881), 1,
      sym_ignored_argument,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(627), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [9658] = 7,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    ACTIONS(753), 1,
      anon_sym_AT,
    STATE(195), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9711] = 7,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    ACTIONS(753), 1,
      anon_sym_AT,
    STATE(195), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9764] = 26,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_TILDE,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(977), 1,
      sym_ignored_argument,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(647), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [9855] = 9,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    ACTIONS(753), 1,
      anon_sym_AT,
    STATE(195), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [9912] = 9,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    ACTIONS(753), 1,
      anon_sym_AT,
    STATE(195), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9969] = 27,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(755), 1,
      sym_identifier,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(761), 1,
      sym_number,
    STATE(370), 1,
      sym_function_call,
    STATE(457), 1,
      sym_boolean,
    STATE(525), 1,
      sym_parenthesis,
    STATE(559), 1,
      sym_binary_operator,
    STATE(563), 1,
      sym_unary_operator,
    STATE(590), 1,
      sym_cell,
    STATE(593), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1008), 1,
      sym__enum_value,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(567), 4,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10062] = 12,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(737), 1,
      anon_sym_AT,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    ACTIONS(741), 1,
      anon_sym_DOT,
    ACTIONS(763), 1,
      anon_sym_EQ,
    STATE(196), 1,
      sym__args,
    STATE(306), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 12,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [10125] = 26,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(672), 1,
      anon_sym_EQ,
    ACTIONS(765), 1,
      sym_identifier,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(769), 1,
      anon_sym_QMARK,
    ACTIONS(771), 1,
      anon_sym_AT,
    ACTIONS(773), 1,
      sym_number,
    STATE(188), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(405), 1,
      sym_unary_operator,
    STATE(411), 1,
      sym_binary_operator,
    STATE(414), 1,
      sym_not_operator,
    STATE(443), 1,
      sym_cell,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(397), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(416), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10216] = 27,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(755), 1,
      sym_identifier,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(761), 1,
      sym_number,
    STATE(370), 1,
      sym_function_call,
    STATE(457), 1,
      sym_boolean,
    STATE(525), 1,
      sym_parenthesis,
    STATE(559), 1,
      sym_binary_operator,
    STATE(563), 1,
      sym_unary_operator,
    STATE(590), 1,
      sym_cell,
    STATE(593), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1084), 1,
      sym__enum_value,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(567), 4,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10309] = 9,
    ACTIONS(378), 1,
      anon_sym_COLON,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(739), 1,
      anon_sym_LBRACE,
    ACTIONS(753), 1,
      anon_sym_AT,
    STATE(195), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [10366] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(661), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10454] = 25,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(777), 1,
      anon_sym_QMARK,
    ACTIONS(779), 1,
      anon_sym_AT,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(589), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10542] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(781), 1,
      sym_identifier,
    ACTIONS(783), 1,
      sym_number,
    STATE(361), 1,
      sym_function_call,
    STATE(450), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(524), 1,
      sym__range_element,
    STATE(539), 1,
      sym_binary_operator,
    STATE(545), 1,
      sym_not_operator,
    STATE(546), 1,
      sym_unary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(551), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10630] = 5,
    STATE(218), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(785), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(726), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(728), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [10678] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(788), 1,
      sym_identifier,
    STATE(366), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(598), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10766] = 5,
    STATE(218), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(790), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(678), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(680), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [10814] = 5,
    STATE(218), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(790), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(714), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(716), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [10862] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(788), 1,
      sym_identifier,
    STATE(366), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(597), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10950] = 5,
    STATE(220), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(792), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(704), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(706), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [10998] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(515), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11086] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(781), 1,
      sym_identifier,
    ACTIONS(783), 1,
      sym_number,
    STATE(361), 1,
      sym_function_call,
    STATE(450), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(537), 1,
      sym__range_element,
    STATE(539), 1,
      sym_binary_operator,
    STATE(545), 1,
      sym_not_operator,
    STATE(546), 1,
      sym_unary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(551), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11174] = 23,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(796), 1,
      sym_identifier,
    ACTIONS(798), 1,
      sym_number,
    STATE(362), 1,
      sym_function_call,
    STATE(436), 1,
      sym_boolean,
    STATE(533), 1,
      sym_binary_operator,
    STATE(550), 1,
      sym_cell,
    STATE(555), 1,
      sym_unary_operator,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(538), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(557), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(695), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11258] = 23,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(796), 1,
      sym_identifier,
    ACTIONS(798), 1,
      sym_number,
    STATE(362), 1,
      sym_function_call,
    STATE(436), 1,
      sym_boolean,
    STATE(533), 1,
      sym_binary_operator,
    STATE(550), 1,
      sym_cell,
    STATE(555), 1,
      sym_unary_operator,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(541), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(557), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(695), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11342] = 23,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(796), 1,
      sym_identifier,
    ACTIONS(798), 1,
      sym_number,
    STATE(362), 1,
      sym_function_call,
    STATE(436), 1,
      sym_boolean,
    STATE(533), 1,
      sym_binary_operator,
    STATE(550), 1,
      sym_cell,
    STATE(555), 1,
      sym_unary_operator,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(542), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(557), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(695), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11426] = 23,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(796), 1,
      sym_identifier,
    ACTIONS(798), 1,
      sym_number,
    STATE(362), 1,
      sym_function_call,
    STATE(436), 1,
      sym_boolean,
    STATE(533), 1,
      sym_binary_operator,
    STATE(550), 1,
      sym_cell,
    STATE(555), 1,
      sym_unary_operator,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(543), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(557), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(695), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11510] = 23,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(796), 1,
      sym_identifier,
    ACTIONS(798), 1,
      sym_number,
    STATE(362), 1,
      sym_function_call,
    STATE(436), 1,
      sym_boolean,
    STATE(533), 1,
      sym_binary_operator,
    STATE(550), 1,
      sym_cell,
    STATE(555), 1,
      sym_unary_operator,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(544), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(557), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(695), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11594] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(800), 1,
      sym_identifier,
    STATE(404), 1,
      sym_boolean,
    STATE(426), 1,
      sym_function_call,
    STATE(521), 1,
      sym_cell,
    STATE(573), 1,
      sym_unary_operator,
    STATE(574), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(576), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11682] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(788), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_QMARK,
    ACTIONS(804), 1,
      anon_sym_AT,
    STATE(366), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(591), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11770] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(788), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_QMARK,
    ACTIONS(804), 1,
      anon_sym_AT,
    STATE(366), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(596), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11858] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(788), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_QMARK,
    ACTIONS(804), 1,
      anon_sym_AT,
    STATE(366), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(548), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11946] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(814), 1,
      anon_sym_QMARK,
    ACTIONS(816), 1,
      anon_sym_AT,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(149), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12034] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(508), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12122] = 5,
    STATE(221), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(830), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(350), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(283), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [12170] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(788), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_QMARK,
    ACTIONS(804), 1,
      anon_sym_AT,
    STATE(366), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(598), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12258] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(788), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_QMARK,
    ACTIONS(804), 1,
      anon_sym_AT,
    STATE(366), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(597), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12346] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AT,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(138), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12434] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(765), 1,
      sym_identifier,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(769), 1,
      anon_sym_QMARK,
    ACTIONS(771), 1,
      anon_sym_AT,
    ACTIONS(773), 1,
      sym_number,
    STATE(188), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(405), 1,
      sym_unary_operator,
    STATE(411), 1,
      sym_binary_operator,
    STATE(414), 1,
      sym_not_operator,
    STATE(443), 1,
      sym_cell,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(397), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(416), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12522] = 12,
    ACTIONS(836), 1,
      anon_sym_LPAREN,
    ACTIONS(838), 1,
      anon_sym_DOT,
    ACTIONS(840), 1,
      anon_sym_AT,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    STATE(377), 1,
      sym__args,
    STATE(453), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(381), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 3,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [12584] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(613), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12672] = 25,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(848), 1,
      anon_sym_QMARK,
    ACTIONS(850), 1,
      anon_sym_AT,
    ACTIONS(852), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(98), 1,
      sym_boolean,
    STATE(103), 1,
      sym_unary_operator,
    STATE(104), 1,
      sym_not_operator,
    STATE(112), 1,
      sym_cell,
    STATE(119), 1,
      sym_binary_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(102), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(135), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12760] = 10,
    ACTIONS(836), 1,
      anon_sym_LPAREN,
    ACTIONS(838), 1,
      anon_sym_DOT,
    ACTIONS(840), 1,
      anon_sym_AT,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    STATE(377), 1,
      sym__args,
    STATE(453), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(387), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [12818] = 25,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(854), 1,
      sym_identifier,
    ACTIONS(856), 1,
      sym_number,
    STATE(245), 1,
      sym_function_call,
    STATE(381), 1,
      sym_boolean,
    STATE(491), 1,
      sym_cell,
    STATE(495), 1,
      sym_not_operator,
    STATE(496), 1,
      sym_unary_operator,
    STATE(599), 1,
      sym_binary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(499), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12906] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym_identifier,
    STATE(404), 1,
      sym_boolean,
    STATE(423), 1,
      sym_function_call,
    STATE(521), 1,
      sym_cell,
    STATE(578), 1,
      sym_binary_operator,
    STATE(579), 1,
      sym_unary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(569), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12994] = 12,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(836), 1,
      anon_sym_LPAREN,
    ACTIONS(838), 1,
      anon_sym_DOT,
    ACTIONS(840), 1,
      anon_sym_AT,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    STATE(377), 1,
      sym__args,
    STATE(453), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [13056] = 25,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(860), 1,
      sym_identifier,
    ACTIONS(862), 1,
      sym_number,
    STATE(78), 1,
      sym_function_call,
    STATE(97), 1,
      sym_boolean,
    STATE(129), 1,
      sym__range_element,
    STATE(131), 1,
      sym_unary_operator,
    STATE(132), 1,
      sym_not_operator,
    STATE(137), 1,
      sym_binary_operator,
    STATE(601), 1,
      sym_cell,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(130), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13144] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(765), 1,
      sym_identifier,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(769), 1,
      anon_sym_QMARK,
    ACTIONS(771), 1,
      anon_sym_AT,
    ACTIONS(773), 1,
      sym_number,
    STATE(188), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(405), 1,
      sym_unary_operator,
    STATE(411), 1,
      sym_binary_operator,
    STATE(414), 1,
      sym_not_operator,
    STATE(443), 1,
      sym_cell,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(397), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(399), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13232] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(765), 1,
      sym_identifier,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(769), 1,
      anon_sym_QMARK,
    ACTIONS(771), 1,
      anon_sym_AT,
    ACTIONS(773), 1,
      sym_number,
    STATE(188), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(405), 1,
      sym_unary_operator,
    STATE(411), 1,
      sym_binary_operator,
    STATE(414), 1,
      sym_not_operator,
    STATE(443), 1,
      sym_cell,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(397), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(442), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13320] = 10,
    ACTIONS(836), 1,
      anon_sym_LPAREN,
    ACTIONS(838), 1,
      anon_sym_DOT,
    ACTIONS(840), 1,
      anon_sym_AT,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    STATE(377), 1,
      sym__args,
    STATE(453), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(383), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [13378] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AT,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(147), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13466] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(765), 1,
      sym_identifier,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(769), 1,
      anon_sym_QMARK,
    ACTIONS(771), 1,
      anon_sym_AT,
    ACTIONS(773), 1,
      sym_number,
    STATE(188), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(405), 1,
      sym_unary_operator,
    STATE(411), 1,
      sym_binary_operator,
    STATE(414), 1,
      sym_not_operator,
    STATE(443), 1,
      sym_cell,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(397), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(432), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13554] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(765), 1,
      sym_identifier,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(769), 1,
      anon_sym_QMARK,
    ACTIONS(771), 1,
      anon_sym_AT,
    ACTIONS(773), 1,
      sym_number,
    STATE(188), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(405), 1,
      sym_unary_operator,
    STATE(411), 1,
      sym_binary_operator,
    STATE(414), 1,
      sym_not_operator,
    STATE(443), 1,
      sym_cell,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(397), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(438), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13642] = 23,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(864), 1,
      sym_identifier,
    ACTIONS(866), 1,
      sym_number,
    STATE(252), 1,
      sym_function_call,
    STATE(378), 1,
      sym_boolean,
    STATE(469), 1,
      sym_unary_operator,
    STATE(506), 1,
      sym_cell,
    STATE(516), 1,
      sym_binary_operator,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(479), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(492), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(693), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13726] = 23,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(864), 1,
      sym_identifier,
    ACTIONS(866), 1,
      sym_number,
    STATE(252), 1,
      sym_function_call,
    STATE(378), 1,
      sym_boolean,
    STATE(469), 1,
      sym_unary_operator,
    STATE(506), 1,
      sym_cell,
    STATE(516), 1,
      sym_binary_operator,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(480), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(492), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(693), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13810] = 23,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(864), 1,
      sym_identifier,
    ACTIONS(866), 1,
      sym_number,
    STATE(252), 1,
      sym_function_call,
    STATE(378), 1,
      sym_boolean,
    STATE(469), 1,
      sym_unary_operator,
    STATE(506), 1,
      sym_cell,
    STATE(516), 1,
      sym_binary_operator,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(481), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(492), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(693), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13894] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AT,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(148), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13982] = 23,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(864), 1,
      sym_identifier,
    ACTIONS(866), 1,
      sym_number,
    STATE(252), 1,
      sym_function_call,
    STATE(378), 1,
      sym_boolean,
    STATE(469), 1,
      sym_unary_operator,
    STATE(506), 1,
      sym_cell,
    STATE(516), 1,
      sym_binary_operator,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(467), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(492), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(693), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14066] = 23,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(864), 1,
      sym_identifier,
    ACTIONS(866), 1,
      sym_number,
    STATE(252), 1,
      sym_function_call,
    STATE(378), 1,
      sym_boolean,
    STATE(469), 1,
      sym_unary_operator,
    STATE(506), 1,
      sym_cell,
    STATE(516), 1,
      sym_binary_operator,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(484), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(492), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(693), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14150] = 25,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(868), 1,
      sym_identifier,
    ACTIONS(870), 1,
      sym_number,
    STATE(242), 1,
      sym_function_call,
    STATE(382), 1,
      sym_boolean,
    STATE(486), 1,
      sym__range_element,
    STATE(489), 1,
      sym_unary_operator,
    STATE(498), 1,
      sym_not_operator,
    STATE(517), 1,
      sym_binary_operator,
    STATE(600), 1,
      sym_cell,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(472), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14238] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(872), 1,
      sym_identifier,
    STATE(404), 1,
      sym_boolean,
    STATE(440), 1,
      sym_function_call,
    STATE(521), 1,
      sym_cell,
    STATE(565), 1,
      sym_binary_operator,
    STATE(566), 1,
      sym_unary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(564), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(685), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14326] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(814), 1,
      anon_sym_QMARK,
    ACTIONS(816), 1,
      anon_sym_AT,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(2), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [14414] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(765), 1,
      sym_identifier,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(769), 1,
      anon_sym_QMARK,
    ACTIONS(771), 1,
      anon_sym_AT,
    ACTIONS(773), 1,
      sym_number,
    STATE(188), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(405), 1,
      sym_unary_operator,
    STATE(411), 1,
      sym_binary_operator,
    STATE(414), 1,
      sym_not_operator,
    STATE(443), 1,
      sym_cell,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(397), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(435), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14502] = 14,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(884), 1,
      anon_sym_EQ,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [14568] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(814), 1,
      anon_sym_QMARK,
    ACTIONS(816), 1,
      anon_sym_AT,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(150), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14656] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(814), 1,
      anon_sym_QMARK,
    ACTIONS(816), 1,
      anon_sym_AT,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(3), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [14744] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(886), 1,
      sym_identifier,
    ACTIONS(888), 1,
      sym_number,
    STATE(189), 1,
      sym_function_call,
    STATE(205), 1,
      sym_boolean,
    STATE(419), 1,
      sym_cell,
    STATE(420), 1,
      sym_not_operator,
    STATE(427), 1,
      sym_unary_operator,
    STATE(594), 1,
      sym_binary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(433), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14832] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(814), 1,
      anon_sym_QMARK,
    ACTIONS(816), 1,
      anon_sym_AT,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(151), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14920] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(890), 1,
      sym_identifier,
    STATE(404), 1,
      sym_boolean,
    STATE(421), 1,
      sym_function_call,
    STATE(521), 1,
      sym_cell,
    STATE(575), 1,
      sym_unary_operator,
    STATE(582), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(577), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15008] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(676), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15096] = 25,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(848), 1,
      anon_sym_QMARK,
    ACTIONS(850), 1,
      anon_sym_AT,
    ACTIONS(852), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(98), 1,
      sym_boolean,
    STATE(103), 1,
      sym_unary_operator,
    STATE(104), 1,
      sym_not_operator,
    STATE(112), 1,
      sym_cell,
    STATE(119), 1,
      sym_binary_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(102), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(108), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15184] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(765), 1,
      sym_identifier,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(769), 1,
      anon_sym_QMARK,
    ACTIONS(771), 1,
      anon_sym_AT,
    ACTIONS(773), 1,
      sym_number,
    STATE(188), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(405), 1,
      sym_unary_operator,
    STATE(411), 1,
      sym_binary_operator,
    STATE(414), 1,
      sym_not_operator,
    STATE(443), 1,
      sym_cell,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(397), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(413), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15272] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(894), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      anon_sym_AT,
    ACTIONS(898), 1,
      sym_number,
    STATE(364), 1,
      sym_function_call,
    STATE(390), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(523), 1,
      sym_not_operator,
    STATE(530), 1,
      sym_unary_operator,
    STATE(560), 1,
      sym_binary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(519), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(534), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15360] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(595), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15448] = 25,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(868), 1,
      sym_identifier,
    ACTIONS(870), 1,
      sym_number,
    STATE(242), 1,
      sym_function_call,
    STATE(382), 1,
      sym_boolean,
    STATE(489), 1,
      sym_unary_operator,
    STATE(498), 1,
      sym_not_operator,
    STATE(511), 1,
      sym__range_element,
    STATE(517), 1,
      sym_binary_operator,
    STATE(600), 1,
      sym_cell,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(472), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15536] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(900), 1,
      sym_identifier,
    ACTIONS(902), 1,
      sym_number,
    STATE(190), 1,
      sym_function_call,
    STATE(208), 1,
      sym_boolean,
    STATE(395), 1,
      sym__range_element,
    STATE(437), 1,
      sym_unary_operator,
    STATE(444), 1,
      sym_not_operator,
    STATE(446), 1,
      sym_binary_operator,
    STATE(602), 1,
      sym_cell,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(431), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15624] = 25,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(589), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15712] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(509), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15800] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(872), 1,
      sym_identifier,
    STATE(404), 1,
      sym_boolean,
    STATE(440), 1,
      sym_function_call,
    STATE(521), 1,
      sym_cell,
    STATE(565), 1,
      sym_binary_operator,
    STATE(566), 1,
      sym_unary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(564), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(681), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15888] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(814), 1,
      anon_sym_QMARK,
    ACTIONS(816), 1,
      anon_sym_AT,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(156), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15976] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_QMARK,
    ACTIONS(906), 1,
      anon_sym_AT,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(508), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16064] = 23,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(908), 1,
      sym_identifier,
    ACTIONS(910), 1,
      sym_number,
    STATE(191), 1,
      sym_function_call,
    STATE(206), 1,
      sym_boolean,
    STATE(388), 1,
      sym_binary_operator,
    STATE(418), 1,
      sym_unary_operator,
    STATE(429), 1,
      sym_cell,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(394), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(407), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(696), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16148] = 23,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(908), 1,
      sym_identifier,
    ACTIONS(910), 1,
      sym_number,
    STATE(191), 1,
      sym_function_call,
    STATE(206), 1,
      sym_boolean,
    STATE(388), 1,
      sym_binary_operator,
    STATE(418), 1,
      sym_unary_operator,
    STATE(429), 1,
      sym_cell,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(393), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(407), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(696), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16232] = 23,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(908), 1,
      sym_identifier,
    ACTIONS(910), 1,
      sym_number,
    STATE(191), 1,
      sym_function_call,
    STATE(206), 1,
      sym_boolean,
    STATE(388), 1,
      sym_binary_operator,
    STATE(418), 1,
      sym_unary_operator,
    STATE(429), 1,
      sym_cell,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(392), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(407), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(696), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16316] = 23,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(908), 1,
      sym_identifier,
    ACTIONS(910), 1,
      sym_number,
    STATE(191), 1,
      sym_function_call,
    STATE(206), 1,
      sym_boolean,
    STATE(388), 1,
      sym_binary_operator,
    STATE(418), 1,
      sym_unary_operator,
    STATE(429), 1,
      sym_cell,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(391), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(407), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(696), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16400] = 23,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(908), 1,
      sym_identifier,
    ACTIONS(910), 1,
      sym_number,
    STATE(191), 1,
      sym_function_call,
    STATE(206), 1,
      sym_boolean,
    STATE(388), 1,
      sym_binary_operator,
    STATE(418), 1,
      sym_unary_operator,
    STATE(429), 1,
      sym_cell,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(389), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(407), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(696), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16484] = 25,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(848), 1,
      anon_sym_QMARK,
    ACTIONS(850), 1,
      anon_sym_AT,
    ACTIONS(852), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(98), 1,
      sym_boolean,
    STATE(103), 1,
      sym_unary_operator,
    STATE(104), 1,
      sym_not_operator,
    STATE(112), 1,
      sym_cell,
    STATE(119), 1,
      sym_binary_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(102), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(116), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16572] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_QMARK,
    ACTIONS(906), 1,
      anon_sym_AT,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(501), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16660] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_QMARK,
    ACTIONS(906), 1,
      anon_sym_AT,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(468), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16748] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(636), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16836] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(872), 1,
      sym_identifier,
    STATE(404), 1,
      sym_boolean,
    STATE(440), 1,
      sym_function_call,
    STATE(521), 1,
      sym_cell,
    STATE(565), 1,
      sym_binary_operator,
    STATE(566), 1,
      sym_unary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(564), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(686), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16924] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_QMARK,
    ACTIONS(906), 1,
      anon_sym_AT,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(399), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [17012] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AT,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(150), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17100] = 4,
    ACTIONS(912), 1,
      anon_sym_DOT,
    STATE(296), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(399), 33,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [17146] = 25,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(915), 1,
      sym_identifier,
    ACTIONS(917), 1,
      sym_number,
    STATE(80), 1,
      sym_function_call,
    STATE(87), 1,
      sym_boolean,
    STATE(105), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_not_operator,
    STATE(107), 1,
      sym_cell,
    STATE(592), 1,
      sym_binary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(134), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17234] = 25,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(848), 1,
      anon_sym_QMARK,
    ACTIONS(850), 1,
      anon_sym_AT,
    ACTIONS(852), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(98), 1,
      sym_boolean,
    STATE(103), 1,
      sym_unary_operator,
    STATE(104), 1,
      sym_not_operator,
    STATE(112), 1,
      sym_cell,
    STATE(119), 1,
      sym_binary_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(102), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(111), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17322] = 25,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(848), 1,
      anon_sym_QMARK,
    ACTIONS(850), 1,
      anon_sym_AT,
    ACTIONS(852), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(98), 1,
      sym_boolean,
    STATE(103), 1,
      sym_unary_operator,
    STATE(104), 1,
      sym_not_operator,
    STATE(112), 1,
      sym_cell,
    STATE(119), 1,
      sym_binary_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(102), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(110), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17410] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(894), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      anon_sym_AT,
    ACTIONS(898), 1,
      sym_number,
    STATE(364), 1,
      sym_function_call,
    STATE(390), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(523), 1,
      sym_not_operator,
    STATE(530), 1,
      sym_unary_operator,
    STATE(560), 1,
      sym_binary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(519), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(548), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17498] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(635), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17586] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(900), 1,
      sym_identifier,
    ACTIONS(902), 1,
      sym_number,
    STATE(190), 1,
      sym_function_call,
    STATE(208), 1,
      sym_boolean,
    STATE(387), 1,
      sym__range_element,
    STATE(437), 1,
      sym_unary_operator,
    STATE(444), 1,
      sym_not_operator,
    STATE(446), 1,
      sym_binary_operator,
    STATE(602), 1,
      sym_cell,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(431), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17674] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(634), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17762] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(814), 1,
      anon_sym_QMARK,
    ACTIONS(816), 1,
      anon_sym_AT,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(4), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [17850] = 25,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(848), 1,
      anon_sym_QMARK,
    ACTIONS(850), 1,
      anon_sym_AT,
    ACTIONS(852), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(98), 1,
      sym_boolean,
    STATE(103), 1,
      sym_unary_operator,
    STATE(104), 1,
      sym_not_operator,
    STATE(112), 1,
      sym_cell,
    STATE(119), 1,
      sym_binary_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(102), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(109), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17938] = 4,
    ACTIONS(741), 1,
      anon_sym_DOT,
    STATE(296), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(410), 33,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [17984] = 25,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(848), 1,
      anon_sym_QMARK,
    ACTIONS(850), 1,
      anon_sym_AT,
    ACTIONS(852), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(98), 1,
      sym_boolean,
    STATE(103), 1,
      sym_unary_operator,
    STATE(104), 1,
      sym_not_operator,
    STATE(112), 1,
      sym_cell,
    STATE(119), 1,
      sym_binary_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(102), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(138), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18072] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(605), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18160] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(788), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_QMARK,
    ACTIONS(804), 1,
      anon_sym_AT,
    STATE(366), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(595), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18248] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(640), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18336] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AT,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(151), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18424] = 25,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(822), 1,
      sym_number,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AT,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(112), 1,
      sym_cell,
    STATE(124), 1,
      sym_binary_operator,
    STATE(125), 1,
      sym_unary_operator,
    STATE(146), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1164), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(128), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(149), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18512] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(919), 1,
      sym_identifier,
    ACTIONS(921), 1,
      sym_number,
    STATE(359), 1,
      sym_function_call,
    STATE(401), 1,
      sym_boolean,
    STATE(529), 1,
      sym_unary_operator,
    STATE(531), 1,
      sym_not_operator,
    STATE(532), 1,
      sym_cell,
    STATE(559), 1,
      sym_binary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(528), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18600] = 25,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(777), 1,
      anon_sym_QMARK,
    ACTIONS(779), 1,
      anon_sym_AT,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(584), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18688] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(558), 35,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [18730] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(923), 1,
      sym_identifier,
    STATE(400), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(585), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(588), 1,
      sym_unary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(581), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18818] = 25,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(664), 1,
      sym_identifier,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(925), 1,
      anon_sym_QMARK,
    ACTIONS(927), 1,
      anon_sym_AT,
    ACTIONS(929), 1,
      sym_number,
    STATE(338), 1,
      sym_function_call,
    STATE(380), 1,
      sym_boolean,
    STATE(470), 1,
      sym_unary_operator,
    STATE(482), 1,
      sym_not_operator,
    STATE(504), 1,
      sym_cell,
    STATE(507), 1,
      sym_binary_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(474), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(478), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18906] = 14,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(931), 1,
      anon_sym_EQ,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [18972] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(788), 1,
      sym_identifier,
    STATE(366), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(678), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19060] = 25,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(777), 1,
      anon_sym_QMARK,
    ACTIONS(779), 1,
      anon_sym_AT,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(586), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19148] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_QMARK,
    ACTIONS(906), 1,
      anon_sym_AT,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(515), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19236] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(598), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19324] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(894), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      anon_sym_AT,
    ACTIONS(898), 1,
      sym_number,
    STATE(364), 1,
      sym_function_call,
    STATE(390), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(523), 1,
      sym_not_operator,
    STATE(530), 1,
      sym_unary_operator,
    STATE(560), 1,
      sym_binary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(519), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(547), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19412] = 25,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(664), 1,
      sym_identifier,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(925), 1,
      anon_sym_QMARK,
    ACTIONS(927), 1,
      anon_sym_AT,
    ACTIONS(929), 1,
      sym_number,
    STATE(338), 1,
      sym_function_call,
    STATE(380), 1,
      sym_boolean,
    STATE(470), 1,
      sym_unary_operator,
    STATE(482), 1,
      sym_not_operator,
    STATE(504), 1,
      sym_cell,
    STATE(507), 1,
      sym_binary_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(474), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(502), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19500] = 25,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(777), 1,
      anon_sym_QMARK,
    ACTIONS(779), 1,
      anon_sym_AT,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(473), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [19588] = 25,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(777), 1,
      anon_sym_QMARK,
    ACTIONS(779), 1,
      anon_sym_AT,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(580), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19676] = 25,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(777), 1,
      anon_sym_QMARK,
    ACTIONS(779), 1,
      anon_sym_AT,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(572), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19764] = 23,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(933), 1,
      sym_identifier,
    ACTIONS(935), 1,
      sym_number,
    STATE(79), 1,
      sym_function_call,
    STATE(95), 1,
      sym_boolean,
    STATE(117), 1,
      sym_cell,
    STATE(127), 1,
      sym_unary_operator,
    STATE(136), 1,
      sym_binary_operator,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(145), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(126), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(698), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19848] = 23,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(933), 1,
      sym_identifier,
    ACTIONS(935), 1,
      sym_number,
    STATE(79), 1,
      sym_function_call,
    STATE(95), 1,
      sym_boolean,
    STATE(117), 1,
      sym_cell,
    STATE(127), 1,
      sym_unary_operator,
    STATE(136), 1,
      sym_binary_operator,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(144), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(126), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(698), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19932] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(597), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20020] = 25,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(664), 1,
      sym_identifier,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(925), 1,
      anon_sym_QMARK,
    ACTIONS(927), 1,
      anon_sym_AT,
    ACTIONS(929), 1,
      sym_number,
    STATE(338), 1,
      sym_function_call,
    STATE(380), 1,
      sym_boolean,
    STATE(470), 1,
      sym_unary_operator,
    STATE(482), 1,
      sym_not_operator,
    STATE(504), 1,
      sym_cell,
    STATE(507), 1,
      sym_binary_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(474), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(493), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20108] = 25,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(664), 1,
      sym_identifier,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(925), 1,
      anon_sym_QMARK,
    ACTIONS(927), 1,
      anon_sym_AT,
    ACTIONS(929), 1,
      sym_number,
    STATE(338), 1,
      sym_function_call,
    STATE(380), 1,
      sym_boolean,
    STATE(470), 1,
      sym_unary_operator,
    STATE(482), 1,
      sym_not_operator,
    STATE(504), 1,
      sym_cell,
    STATE(507), 1,
      sym_binary_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(474), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(490), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20196] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(788), 1,
      sym_identifier,
    STATE(366), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(595), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20284] = 25,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(664), 1,
      sym_identifier,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(925), 1,
      anon_sym_QMARK,
    ACTIONS(927), 1,
      anon_sym_AT,
    ACTIONS(929), 1,
      sym_number,
    STATE(338), 1,
      sym_function_call,
    STATE(380), 1,
      sym_boolean,
    STATE(470), 1,
      sym_unary_operator,
    STATE(482), 1,
      sym_not_operator,
    STATE(504), 1,
      sym_cell,
    STATE(507), 1,
      sym_binary_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(474), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(488), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20372] = 25,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(664), 1,
      sym_identifier,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(925), 1,
      anon_sym_QMARK,
    ACTIONS(927), 1,
      anon_sym_AT,
    ACTIONS(929), 1,
      sym_number,
    STATE(338), 1,
      sym_function_call,
    STATE(380), 1,
      sym_boolean,
    STATE(470), 1,
      sym_unary_operator,
    STATE(482), 1,
      sym_not_operator,
    STATE(504), 1,
      sym_cell,
    STATE(507), 1,
      sym_binary_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(473), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(474), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [20460] = 23,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(933), 1,
      sym_identifier,
    ACTIONS(935), 1,
      sym_number,
    STATE(79), 1,
      sym_function_call,
    STATE(95), 1,
      sym_boolean,
    STATE(117), 1,
      sym_cell,
    STATE(127), 1,
      sym_unary_operator,
    STATE(136), 1,
      sym_binary_operator,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(126), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(698), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20544] = 23,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(933), 1,
      sym_identifier,
    ACTIONS(935), 1,
      sym_number,
    STATE(79), 1,
      sym_function_call,
    STATE(95), 1,
      sym_boolean,
    STATE(117), 1,
      sym_cell,
    STATE(127), 1,
      sym_unary_operator,
    STATE(136), 1,
      sym_binary_operator,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(141), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(126), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(698), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20628] = 12,
    ACTIONS(378), 1,
      anon_sym_COLON,
    ACTIONS(836), 1,
      anon_sym_LPAREN,
    ACTIONS(838), 1,
      anon_sym_DOT,
    ACTIONS(840), 1,
      anon_sym_AT,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    STATE(377), 1,
      sym__args,
    STATE(453), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [20690] = 25,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(584), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20778] = 23,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(933), 1,
      sym_identifier,
    ACTIONS(935), 1,
      sym_number,
    STATE(79), 1,
      sym_function_call,
    STATE(95), 1,
      sym_boolean,
    STATE(117), 1,
      sym_cell,
    STATE(127), 1,
      sym_unary_operator,
    STATE(136), 1,
      sym_binary_operator,
    STATE(971), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(140), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(126), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(698), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20862] = 5,
    ACTIONS(941), 1,
      anon_sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(341), 2,
      sym_arguments_statement,
      aux_sym_function_definition_repeat1,
    ACTIONS(937), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(939), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [20910] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(620), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_AT,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(552), 1,
      sym_unary_operator,
    STATE(559), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(525), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(643), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20998] = 25,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_TILDE,
    ACTIONS(818), 1,
      anon_sym_LBRACK,
    ACTIONS(826), 1,
      sym__single_quote_string_start,
    ACTIONS(828), 1,
      sym__double_quote_string_start,
    ACTIONS(860), 1,
      sym_identifier,
    ACTIONS(862), 1,
      sym_number,
    STATE(78), 1,
      sym_function_call,
    STATE(97), 1,
      sym_boolean,
    STATE(131), 1,
      sym_unary_operator,
    STATE(132), 1,
      sym_not_operator,
    STATE(137), 1,
      sym_binary_operator,
    STATE(139), 1,
      sym__range_element,
    STATE(601), 1,
      sym_cell,
    STATE(616), 1,
      sym__binary_expression,
    STATE(971), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(810), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(824), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(130), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [21086] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(894), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      anon_sym_AT,
    ACTIONS(898), 1,
      sym_number,
    STATE(364), 1,
      sym_function_call,
    STATE(390), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(523), 1,
      sym_not_operator,
    STATE(530), 1,
      sym_unary_operator,
    STATE(560), 1,
      sym_binary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(519), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(553), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [21174] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(637), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [21262] = 25,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(648), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_AT,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(658), 1,
      sym_number,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    STATE(248), 1,
      sym_function_call,
    STATE(373), 1,
      sym_boolean,
    STATE(504), 1,
      sym_cell,
    STATE(510), 1,
      sym_unary_operator,
    STATE(513), 1,
      sym_binary_operator,
    STATE(568), 1,
      sym_not_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(586), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [21350] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(894), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      anon_sym_AT,
    ACTIONS(898), 1,
      sym_number,
    STATE(364), 1,
      sym_function_call,
    STATE(390), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(523), 1,
      sym_not_operator,
    STATE(530), 1,
      sym_unary_operator,
    STATE(560), 1,
      sym_binary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(519), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(522), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [21438] = 14,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(944), 1,
      anon_sym_EQ,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [21504] = 14,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(946), 1,
      anon_sym_EQ,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [21570] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(767), 1,
      anon_sym_TILDE,
    ACTIONS(794), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_QMARK,
    ACTIONS(906), 1,
      anon_sym_AT,
    STATE(192), 1,
      sym_function_call,
    STATE(209), 1,
      sym_boolean,
    STATE(428), 1,
      sym_binary_operator,
    STATE(430), 1,
      sym_unary_operator,
    STATE(443), 1,
      sym_cell,
    STATE(464), 1,
      sym_not_operator,
    STATE(612), 1,
      sym__binary_expression,
    STATE(940), 1,
      sym_indirect_access,
    STATE(1181), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(439), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(417), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(509), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [21658] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(872), 1,
      sym_identifier,
    STATE(404), 1,
      sym_boolean,
    STATE(440), 1,
      sym_function_call,
    STATE(521), 1,
      sym_cell,
    STATE(565), 1,
      sym_binary_operator,
    STATE(566), 1,
      sym_unary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(564), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(679), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [21746] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(894), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      anon_sym_AT,
    ACTIONS(898), 1,
      sym_number,
    STATE(364), 1,
      sym_function_call,
    STATE(390), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(523), 1,
      sym_not_operator,
    STATE(530), 1,
      sym_unary_operator,
    STATE(560), 1,
      sym_binary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(519), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(561), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [21834] = 25,
    ACTIONS(608), 1,
      sym__single_quote_string_start,
    ACTIONS(610), 1,
      sym__double_quote_string_start,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_LBRACK,
    ACTIONS(656), 1,
      anon_sym_LBRACE,
    ACTIONS(664), 1,
      sym_identifier,
    ACTIONS(775), 1,
      anon_sym_TILDE,
    ACTIONS(925), 1,
      anon_sym_QMARK,
    ACTIONS(927), 1,
      anon_sym_AT,
    ACTIONS(929), 1,
      sym_number,
    STATE(338), 1,
      sym_function_call,
    STATE(380), 1,
      sym_boolean,
    STATE(470), 1,
      sym_unary_operator,
    STATE(482), 1,
      sym_not_operator,
    STATE(504), 1,
      sym_cell,
    STATE(507), 1,
      sym_binary_operator,
    STATE(618), 1,
      sym__binary_expression,
    STATE(953), 1,
      sym_indirect_access,
    STATE(1189), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(606), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(644), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(505), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(474), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(500), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [21922] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(894), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      anon_sym_AT,
    ACTIONS(898), 1,
      sym_number,
    STATE(364), 1,
      sym_function_call,
    STATE(390), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(523), 1,
      sym_not_operator,
    STATE(530), 1,
      sym_unary_operator,
    STATE(560), 1,
      sym_binary_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(519), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(549), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [22010] = 25,
    ACTIONS(614), 1,
      anon_sym_LPAREN,
    ACTIONS(618), 1,
      anon_sym_TILDE,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LBRACE,
    ACTIONS(632), 1,
      sym_number,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(759), 1,
      anon_sym_AT,
    ACTIONS(948), 1,
      sym_identifier,
    STATE(402), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(521), 1,
      sym_cell,
    STATE(570), 1,
      sym_unary_operator,
    STATE(571), 1,
      sym_binary_operator,
    STATE(587), 1,
      sym_not_operator,
    STATE(619), 1,
      sym__binary_expression,
    STATE(911), 1,
      sym_indirect_access,
    STATE(1159), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(616), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(518), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(583), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [22098] = 4,
    ACTIONS(950), 1,
      anon_sym_DOT,
    STATE(356), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(414), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [22143] = 14,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(931), 1,
      anon_sym_EQ,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [22208] = 13,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym__args,
    STATE(459), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [22271] = 10,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(387), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22328] = 4,
    ACTIONS(953), 1,
      anon_sym_DOT,
    STATE(365), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [22373] = 13,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(378), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(381), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(955), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [22436] = 10,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(383), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22493] = 7,
    ACTIONS(836), 1,
      anon_sym_LPAREN,
    ACTIONS(840), 1,
      anon_sym_AT,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    STATE(377), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(408), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(406), 28,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22544] = 13,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_COLON,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [22607] = 4,
    ACTIONS(953), 1,
      anon_sym_DOT,
    STATE(356), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(389), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [22652] = 13,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [22715] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(449), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(447), 31,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22757] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(958), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(960), 19,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_arguments,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [22799] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(414), 33,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [22839] = 14,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(962), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [22903] = 7,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(406), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(408), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22953] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(441), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(439), 31,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22995] = 10,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(836), 1,
      anon_sym_LPAREN,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    ACTIONS(964), 1,
      anon_sym_AT,
    STATE(384), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [23051] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(966), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(968), 19,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_arguments,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [23093] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(437), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(435), 31,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23135] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(425), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(423), 31,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23177] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(433), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(431), 31,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23219] = 8,
    ACTIONS(836), 1,
      anon_sym_LPAREN,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    ACTIONS(964), 1,
      anon_sym_AT,
    STATE(384), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(383), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23271] = 13,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym__args,
    STATE(459), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [23333] = 10,
    ACTIONS(378), 1,
      anon_sym_COLON,
    ACTIONS(836), 1,
      anon_sym_LPAREN,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    ACTIONS(964), 1,
      anon_sym_AT,
    STATE(384), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [23389] = 8,
    ACTIONS(836), 1,
      anon_sym_LPAREN,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    ACTIONS(964), 1,
      anon_sym_AT,
    STATE(384), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(387), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23441] = 10,
    ACTIONS(836), 1,
      anon_sym_LPAREN,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    ACTIONS(964), 1,
      anon_sym_AT,
    STATE(384), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(381), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 3,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [23497] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(970), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(972), 19,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_arguments,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [23539] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(429), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(427), 31,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23581] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(974), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(976), 19,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_arguments,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [23623] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(445), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(443), 31,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23665] = 4,
    ACTIONS(526), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(521), 23,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23708] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23749] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(980), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(978), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(455), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23792] = 11,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_COLON,
    ACTIONS(982), 1,
      anon_sym_AT,
    STATE(449), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [23849] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(980), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(455), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23890] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(980), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(455), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23931] = 6,
    ACTIONS(986), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(980), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(984), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(978), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(455), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23978] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(980), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(984), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(978), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(455), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24023] = 3,
    ACTIONS(988), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(546), 31,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24064] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(513), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24103] = 5,
    ACTIONS(378), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24148] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(505), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24187] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(542), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24226] = 14,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(990), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [24289] = 8,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(982), 1,
      anon_sym_AT,
    STATE(449), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(387), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [24340] = 14,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(992), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [24403] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(451), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24442] = 11,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(982), 1,
      anon_sym_AT,
    STATE(449), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [24499] = 5,
    ACTIONS(461), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24544] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(486), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24583] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24624] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(532), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24663] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(482), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24702] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(560), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(558), 30,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [24743] = 5,
    ACTIONS(502), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24788] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(435), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(437), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [24829] = 5,
    ACTIONS(996), 1,
      anon_sym_AMP_AMP,
    ACTIONS(998), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(994), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(494), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24874] = 4,
    ACTIONS(378), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 17,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24917] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(423), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(425), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [24958] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(994), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(464), 26,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24999] = 5,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25044] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25085] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25126] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(385), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25165] = 14,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(1000), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [25228] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(490), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25267] = 14,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(1002), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [25330] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(443), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [25371] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(447), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(449), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [25412] = 14,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(1004), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [25475] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25516] = 5,
    ACTIONS(517), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25561] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25602] = 5,
    ACTIONS(519), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25647] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [25692] = 5,
    ACTIONS(996), 1,
      anon_sym_AMP_AMP,
    ACTIONS(998), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(994), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(536), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25737] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25778] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(498), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25817] = 5,
    ACTIONS(996), 1,
      anon_sym_AMP_AMP,
    ACTIONS(998), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(994), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(476), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25862] = 8,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(982), 1,
      anon_sym_AT,
    STATE(449), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(383), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [25913] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(461), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(519), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [25958] = 4,
    ACTIONS(996), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(994), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 25,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [26001] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [26042] = 13,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_DOT,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym__args,
    STATE(465), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 7,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [26103] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(431), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(433), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26144] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(994), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 26,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [26185] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [26228] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(374), 10,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [26271] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(509), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [26310] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(502), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(517), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [26355] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(439), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(441), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26396] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(562), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [26435] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(427), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(429), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26476] = 11,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(982), 1,
      anon_sym_AT,
    STATE(449), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(378), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(381), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(955), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [26533] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(558), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(560), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26573] = 5,
    ACTIONS(1006), 1,
      anon_sym_DOT,
    STATE(452), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(419), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(414), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26617] = 5,
    ACTIONS(838), 1,
      anon_sym_DOT,
    STATE(456), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(412), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(410), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26661] = 5,
    ACTIONS(1009), 1,
      anon_sym_DOT,
    STATE(452), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(393), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(389), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26705] = 5,
    ACTIONS(1009), 1,
      anon_sym_DOT,
    STATE(454), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(397), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(395), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26749] = 5,
    ACTIONS(1011), 1,
      anon_sym_DOT,
    STATE(456), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(404), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(399), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26793] = 12,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      anon_sym_LBRACE,
    ACTIONS(982), 1,
      anon_sym_AT,
    STATE(449), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(962), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [26851] = 5,
    ACTIONS(1014), 1,
      anon_sym_DOT,
    STATE(458), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(399), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(404), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26894] = 5,
    ACTIONS(876), 1,
      anon_sym_DOT,
    STATE(458), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(410), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(412), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26937] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(419), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(414), 28,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26976] = 5,
    ACTIONS(1017), 1,
      anon_sym_DOT,
    STATE(462), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(397), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27019] = 5,
    ACTIONS(1017), 1,
      anon_sym_DOT,
    STATE(466), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(389), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(393), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27062] = 6,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(763), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(743), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 12,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27107] = 4,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(360), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [27148] = 5,
    ACTIONS(876), 1,
      anon_sym_DOT,
    STATE(458), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(410), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(412), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27191] = 5,
    ACTIONS(1019), 1,
      anon_sym_DOT,
    STATE(466), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(414), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(419), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27234] = 7,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(459), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1026), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1022), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1024), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(455), 14,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27280] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1030), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 23,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [27318] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(383), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27358] = 6,
    ACTIONS(461), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27402] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(414), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(419), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27440] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(381), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 3,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27484] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(544), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(542), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27522] = 6,
    ACTIONS(378), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27566] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(492), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(490), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27604] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(488), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(486), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27642] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(484), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(482), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27680] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(468), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1032), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(464), 21,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27720] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(459), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1026), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1024), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(455), 19,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27762] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(459), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1026), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(455), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27802] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(459), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1026), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(455), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27842] = 5,
    ACTIONS(378), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(360), 12,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27884] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(500), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(498), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27922] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(459), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1026), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1022), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1024), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(455), 15,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27966] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(515), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(513), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28004] = 4,
    ACTIONS(1034), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(550), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(546), 26,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [28044] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(511), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(509), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28082] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(472), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1032), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 21,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28122] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(530), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(519), 3,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(461), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [28166] = 5,
    ACTIONS(1036), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(472), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1032), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 20,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28208] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(387), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28248] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(383), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28288] = 6,
    ACTIONS(1036), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1038), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(480), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1032), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(476), 19,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28332] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(453), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(451), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28370] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(387), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(385), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28408] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(387), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28448] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(534), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(532), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28486] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(381), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(374), 5,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(378), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [28528] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(387), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28568] = 6,
    ACTIONS(1036), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1038), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(538), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1032), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(536), 19,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28612] = 4,
    ACTIONS(1040), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1030), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 22,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [28652] = 6,
    ACTIONS(1036), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1038), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(496), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1032), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(494), 19,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28696] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(564), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(562), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28734] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 11,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [28776] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(360), 13,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [28816] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(383), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28856] = 6,
    ACTIONS(502), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [28900] = 5,
    ACTIONS(1040), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1042), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1030), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(494), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [28942] = 5,
    ACTIONS(1040), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1042), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1030), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(536), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [28984] = 6,
    ACTIONS(519), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [29028] = 5,
    ACTIONS(526), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(528), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(523), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(521), 18,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [29070] = 6,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [29114] = 6,
    ACTIONS(517), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [29158] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(507), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(505), 27,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29196] = 5,
    ACTIONS(1040), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1042), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1030), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(476), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [29238] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(383), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 25,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29278] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(540), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(842), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(517), 3,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(502), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [29322] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(376), 12,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [29363] = 7,
    ACTIONS(955), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [29408] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(562), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29445] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 10,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [29488] = 7,
    ACTIONS(1048), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1050), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(476), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1044), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1046), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 18,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29533] = 6,
    ACTIONS(955), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(376), 11,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [29576] = 6,
    ACTIONS(1055), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(521), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(523), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1052), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(528), 17,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
  [29619] = 7,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [29664] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(532), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(534), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29701] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(451), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(453), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29738] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(387), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29777] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(387), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29816] = 7,
    ACTIONS(1057), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [29861] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(385), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(387), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29898] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(385), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(387), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29937] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(383), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29976] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(464), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1044), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1046), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(468), 20,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30017] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(482), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30054] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(486), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(488), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30091] = 4,
    ACTIONS(1055), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(546), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(550), 23,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
  [30130] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1064), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(455), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1060), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1062), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(459), 12,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30173] = 7,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(502), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(540), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(1066), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30218] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(490), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(492), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30255] = 7,
    ACTIONS(1069), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1064), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(455), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1060), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1062), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(459), 12,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30300] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1064), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(455), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(459), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30339] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1064), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(455), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(459), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30378] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1064), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(455), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1062), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(459), 16,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30419] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(378), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(381), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(955), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30462] = 7,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(461), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(530), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(1057), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30507] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(470), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1044), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1046), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(472), 20,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30548] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(542), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(544), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30585] = 7,
    ACTIONS(1048), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1050), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(536), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1044), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1046), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(538), 18,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30630] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(383), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30669] = 7,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(378), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(381), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(955), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30714] = 7,
    ACTIONS(530), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30759] = 6,
    ACTIONS(1048), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(470), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1044), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1046), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(472), 19,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30802] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(513), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(515), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30839] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(383), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30878] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(498), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(500), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30915] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(383), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30954] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(509), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(511), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30991] = 7,
    ACTIONS(540), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31036] = 7,
    ACTIONS(1066), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31081] = 7,
    ACTIONS(1048), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1050), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(494), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1044), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1046), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(496), 18,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [31126] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(505), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(507), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [31163] = 8,
    ACTIONS(530), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(962), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31209] = 7,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31253] = 7,
    ACTIONS(540), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31297] = 7,
    ACTIONS(530), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31341] = 8,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(962), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31387] = 5,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(360), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(364), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [31427] = 8,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(1002), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31472] = 8,
    ACTIONS(530), 1,
      anon_sym_COLON,
    ACTIONS(992), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31517] = 8,
    ACTIONS(540), 1,
      anon_sym_COLON,
    ACTIONS(992), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31562] = 5,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(472), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1071), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 17,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [31601] = 8,
    ACTIONS(530), 1,
      anon_sym_COLON,
    ACTIONS(1004), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31646] = 8,
    ACTIONS(540), 1,
      anon_sym_COLON,
    ACTIONS(1004), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31691] = 8,
    ACTIONS(530), 1,
      anon_sym_COLON,
    ACTIONS(1000), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31736] = 8,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(1004), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31781] = 8,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(1000), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31826] = 8,
    ACTIONS(540), 1,
      anon_sym_COLON,
    ACTIONS(1002), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31871] = 8,
    ACTIONS(530), 1,
      anon_sym_COLON,
    ACTIONS(1002), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31916] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(472), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1071), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(470), 18,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [31953] = 8,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(990), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31998] = 8,
    ACTIONS(540), 1,
      anon_sym_COLON,
    ACTIONS(1000), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32043] = 8,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(992), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32088] = 6,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(496), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1071), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(494), 16,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [32129] = 8,
    ACTIONS(540), 1,
      anon_sym_COLON,
    ACTIONS(990), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32174] = 6,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(480), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1071), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(476), 16,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [32215] = 6,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(376), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32256] = 8,
    ACTIONS(530), 1,
      anon_sym_COLON,
    ACTIONS(990), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32301] = 6,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(538), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1071), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(536), 16,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [32342] = 7,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(962), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32385] = 6,
    ACTIONS(1081), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(470), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1077), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1079), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(472), 16,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
  [32425] = 7,
    ACTIONS(540), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1083), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32467] = 7,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(962), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32509] = 7,
    ACTIONS(540), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1085), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32551] = 7,
    ACTIONS(1081), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1087), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(536), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1077), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1079), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(538), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_RBRACE,
  [32593] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(470), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1077), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1079), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(472), 17,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
  [32631] = 7,
    ACTIONS(1081), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1087), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(476), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1077), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1079), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_RBRACE,
  [32673] = 7,
    ACTIONS(1081), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1087), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(494), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1077), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1079), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(496), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_RBRACE,
  [32715] = 7,
    ACTIONS(540), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1089), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32757] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1089), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32796] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1083), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32835] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(360), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1085), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(383), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [32874] = 4,
    ACTIONS(1091), 1,
      anon_sym_DOT,
    STATE(603), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(414), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [32907] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(414), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [32935] = 11,
    ACTIONS(1040), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1042), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1096), 1,
      anon_sym_end,
    ACTIONS(1098), 1,
      anon_sym_case,
    ACTIONS(1100), 1,
      anon_sym_otherwise,
    STATE(1178), 1,
      sym_otherwise_clause,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(642), 2,
      sym__end_of_line,
      aux_sym_elseif_clause_repeat1,
    STATE(753), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
    ACTIONS(1094), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1030), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [32980] = 16,
    ACTIONS(1102), 1,
      sym_identifier,
    ACTIONS(1104), 1,
      anon_sym_COMMA,
    ACTIONS(1106), 1,
      anon_sym_LPAREN,
    ACTIONS(1108), 1,
      anon_sym_DOT,
    ACTIONS(1110), 1,
      anon_sym_TILDE,
    ACTIONS(1112), 1,
      anon_sym_AT,
    ACTIONS(1114), 1,
      anon_sym_RBRACK,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    STATE(648), 1,
      sym_function_call,
    STATE(649), 1,
      sym__args,
    STATE(680), 1,
      aux_sym_field_expression_repeat1,
    STATE(960), 1,
      sym_indirect_access,
    STATE(984), 1,
      sym_boolean,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(620), 3,
      sym_field_expression,
      sym_ignored_argument,
      aux_sym_multioutput_variable_repeat1,
  [33033] = 4,
    ACTIONS(1118), 1,
      anon_sym_DOT,
    STATE(603), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(389), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [33061] = 4,
    ACTIONS(1118), 1,
      anon_sym_DOT,
    STATE(607), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [33089] = 13,
    ACTIONS(1120), 1,
      sym_identifier,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1126), 1,
      anon_sym_DOT,
    ACTIONS(1128), 1,
      anon_sym_LBRACE,
    ACTIONS(1130), 1,
      anon_sym_EQ,
    STATE(651), 1,
      aux_sym_handle_operator_repeat1,
    STATE(655), 1,
      sym_dimensions,
    STATE(688), 1,
      sym_property_name,
    STATE(706), 1,
      sym_validation_functions,
    STATE(830), 1,
      sym_default_value,
    STATE(1020), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1122), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
  [33133] = 5,
    ACTIONS(1132), 1,
      anon_sym_DOT,
    STATE(610), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(419), 11,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [33161] = 5,
    ACTIONS(1135), 1,
      anon_sym_DOT,
    STATE(614), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(397), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(395), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [33188] = 6,
    ACTIONS(1143), 1,
      anon_sym_PIPE,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1141), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1137), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1139), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
  [33217] = 6,
    ACTIONS(1040), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1042), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(7), 2,
      sym__end_of_line,
      aux_sym_elseif_clause_repeat1,
    ACTIONS(1147), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1030), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [33246] = 5,
    ACTIONS(1135), 1,
      anon_sym_DOT,
    STATE(615), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(393), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(389), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [33273] = 5,
    ACTIONS(1149), 1,
      anon_sym_DOT,
    STATE(615), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(419), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(414), 10,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [33300] = 6,
    ACTIONS(1158), 1,
      anon_sym_PIPE,
    ACTIONS(1160), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1156), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1152), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1154), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
  [33329] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(419), 12,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [33352] = 6,
    ACTIONS(1168), 1,
      anon_sym_PIPE,
    ACTIONS(1170), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1166), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1162), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1164), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
  [33381] = 6,
    ACTIONS(1172), 1,
      anon_sym_PIPE,
    ACTIONS(1174), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1064), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1060), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1062), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
  [33410] = 11,
    ACTIONS(1102), 1,
      sym_identifier,
    ACTIONS(1110), 1,
      anon_sym_TILDE,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    ACTIONS(1178), 1,
      anon_sym_LPAREN,
    ACTIONS(1180), 1,
      anon_sym_RBRACK,
    STATE(648), 1,
      sym_function_call,
    STATE(960), 1,
      sym_indirect_access,
    STATE(984), 1,
      sym_boolean,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(624), 3,
      sym_field_expression,
      sym_ignored_argument,
      aux_sym_multioutput_variable_repeat1,
  [33448] = 11,
    ACTIONS(1102), 1,
      sym_identifier,
    ACTIONS(1104), 1,
      anon_sym_COMMA,
    ACTIONS(1110), 1,
      anon_sym_TILDE,
    ACTIONS(1114), 1,
      anon_sym_RBRACK,
    ACTIONS(1178), 1,
      anon_sym_LPAREN,
    STATE(648), 1,
      sym_function_call,
    STATE(960), 1,
      sym_indirect_access,
    STATE(984), 1,
      sym_boolean,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(620), 3,
      sym_field_expression,
      sym_ignored_argument,
      aux_sym_multioutput_variable_repeat1,
  [33486] = 6,
    ACTIONS(1040), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1042), 1,
      anon_sym_PIPE_PIPE,
    STATE(180), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1182), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1030), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [33514] = 5,
    ACTIONS(1184), 1,
      anon_sym_DOT,
    STATE(610), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(389), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(393), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
  [33540] = 11,
    ACTIONS(1186), 1,
      sym_identifier,
    ACTIONS(1189), 1,
      anon_sym_COMMA,
    ACTIONS(1192), 1,
      anon_sym_LPAREN,
    ACTIONS(1195), 1,
      anon_sym_TILDE,
    ACTIONS(1198), 1,
      anon_sym_RBRACK,
    STATE(648), 1,
      sym_function_call,
    STATE(960), 1,
      sym_indirect_access,
    STATE(984), 1,
      sym_boolean,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1200), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(624), 3,
      sym_field_expression,
      sym_ignored_argument,
      aux_sym_multioutput_variable_repeat1,
  [33578] = 6,
    ACTIONS(1040), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1042), 1,
      anon_sym_PIPE_PIPE,
    STATE(237), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1203), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1030), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [33606] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(419), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(414), 11,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [33628] = 8,
    ACTIONS(684), 1,
      aux_sym_matrix_token1,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1205), 1,
      sym__entry_delimiter,
    STATE(807), 1,
      aux_sym_row_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(686), 2,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(1071), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [33660] = 5,
    ACTIONS(1184), 1,
      anon_sym_DOT,
    STATE(623), 1,
      aux_sym_handle_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(397), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
  [33686] = 6,
    ACTIONS(1040), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1042), 1,
      anon_sym_PIPE_PIPE,
    STATE(180), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1182), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1030), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [33714] = 8,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1207), 1,
      aux_sym_matrix_token1,
    ACTIONS(1211), 1,
      sym__entry_delimiter,
    STATE(876), 1,
      aux_sym_row_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1209), 2,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(1071), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [33746] = 11,
    ACTIONS(1120), 1,
      sym_identifier,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1128), 1,
      anon_sym_LBRACE,
    ACTIONS(1130), 1,
      anon_sym_EQ,
    STATE(655), 1,
      sym_dimensions,
    STATE(688), 1,
      sym_property_name,
    STATE(706), 1,
      sym_validation_functions,
    STATE(830), 1,
      sym_default_value,
    STATE(1020), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1122), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
  [33784] = 9,
    ACTIONS(1108), 1,
      anon_sym_DOT,
    ACTIONS(1112), 1,
      anon_sym_AT,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    STATE(649), 1,
      sym__args,
    STATE(680), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1198), 3,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_RBRACK,
    ACTIONS(1213), 3,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [33817] = 12,
    ACTIONS(636), 1,
      sym__single_quote_string_start,
    ACTIONS(638), 1,
      sym__double_quote_string_start,
    ACTIONS(1178), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      sym_number,
    STATE(850), 1,
      sym_function_call,
    STATE(960), 1,
      sym_indirect_access,
    STATE(984), 1,
      sym_boolean,
    STATE(1168), 1,
      sym_string,
    STATE(1170), 1,
      sym_parfor_options,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(634), 2,
      anon_sym_true,
      anon_sym_false,
  [33856] = 8,
    ACTIONS(1081), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1087), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1221), 1,
      anon_sym_COMMA,
    STATE(931), 1,
      aux_sym_arguments_repeat2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1077), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1223), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(1079), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33887] = 8,
    ACTIONS(1081), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1087), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1221), 1,
      anon_sym_COMMA,
    STATE(933), 1,
      aux_sym_arguments_repeat2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1077), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1223), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(1079), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33918] = 8,
    ACTIONS(1081), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1087), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1221), 1,
      anon_sym_COMMA,
    STATE(934), 1,
      aux_sym_arguments_repeat2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1077), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1225), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(1079), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33949] = 5,
    ACTIONS(1040), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1042), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1227), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1030), 6,
      ano