#include <laputa.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>

int main(int argc, char **argv){
  TCJDB *jdb;
  int ecode, rnum, i;
  uint64_t *result;
  char *text;

  /* create the object */
  jdb = tcjdbnew();

  /* open the database */
  if(!tcjdbopen(jdb, "casket", JDBOWRITER | JDBOCREAT)){
    ecode = tcjdbecode(jdb);
    fprintf(stderr, "open error: %s\n", tcjdberrmsg(ecode));
  }

  /* store records */
  if(!tcjdbput2(jdb, 1, "George Washington", NULL) ||
     !tcjdbput2(jdb, 2, "John Adams", NULL) ||
     !tcjdbput2(jdb, 3, "Thomas Jefferson", NULL)){
    ecode = tcjdbecode(jdb);
    fprintf(stderr, "put error: %s\n", tcjdberrmsg(ecode));
  }

  /* search records */
  result = tcjdbsearch2(jdb, "john || thomas", &rnum);
  if(result){
    for(i = 0; i < rnum; i++){
      text = tcjdbget2(jdb, result[i]);
      if(text){
        printf("%d\t%s\n", (int)result[i], text);
        free(text);
      }
    }
    free(result);
  } else {
    ecode = tcjdbecode(jdb);
    fprintf(stderr, "search error: %s\n", tcjdberrmsg(ecode));
  }

  /* close the database */
  if(!tcjdbclose(jdb)){
    ecode = tcjdbecode(jdb);
    fprintf(stderr, "close error: %s\n", tcjdberrmsg(ecode));
  }

  /* delete the object */
  tcjdbdel(jdb);

  return 0;
}
