/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef TN_5250
#define TN_5250
/*  
   Definitions for tn5250.c
   
   Copyright (c) 1997 by Michael Madore
   
*/

#define TELNET_PORT "23\0"

#define SEND 1
#define IS   0
   
#define TRANSMIT_BINARY 0
#define END_OF_RECORD 25

#define TERMINAL_TYPE 24


void Finish(int sig);
void Invite();
void CancelInvite();
void ProcessStream();
void WriteToDisplay();
void SaveScreen();
void WriteStructuredField();
void ReadMDTFields();
void ReadImmediate();
void ReadInputFields();
void ClearUnit();
void ClearFormatTable();
void InsertCursor();
void RepeatToAddress();
void SetBufferAddress();
void StartOfHeader();
void StartOfField();
void SetAttribute(unsigned char attribute);
void SystemRequest();
void SaveScreen();
void RestoreScreen();
void WriteErrorCode();
void OutputOnly();
void Roll();
void MessageOn();
void MessageOff();
void ReadScreenImmediate();
void HandleKey ();
void HandleReceive ();
void MainLoop ();
void SendFields (int cur_command, int aidcode);

#endif
