/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef PRINTSESSION_H
#define PRINTSESSION_H

//
// The Session class should be the "master class" which drives all of the
// now-modular elements.
//
class PrintSession {
protected:
   Stream5250 *strm;
   Record inpacket;
   int conn_fd;
   char outputcommand[80];
   FILE * printfile;
   
public:
   PrintSession ();
   virtual ~PrintSession ();

   void connection_fd (SOCKET_TYPE fd);

   void GetResponseCode(char * code);

   // Get/Set Stream object.
   Stream5250 *stream (void) const;
   Stream5250 *stream (Stream5250 *newstream);

   void OutputCommand(char * output);

   // Run the main loop.
   void MainLoop (void);

private:

   int waitevent() const;
   
};

#endif /* PRINTSESSION_H */
