#include "config.h"
#include <stdio.h>
#include "buffer.h"
#include "record.h"
#include "stream5250.h"
#include <sys/time.h>
#include "printsession.h"
#include "utility.h"

PrintSession::PrintSession()
{
}

PrintSession::~PrintSession()
{
}

void PrintSession::connection_fd (int fd)
{
   conn_fd = fd;
}

Stream5250 *PrintSession::stream () const
{
   return strm;
}

Stream5250 *PrintSession::stream (Stream5250 *newstream)
{
   Stream5250 *old = strm;
   if ((strm = newstream) != NULL) {
      strm->SetTerminalType ("IBM-3812-1");
   }
   return old;
}

void PrintSession::OutputCommand(char * output)
{
   strcpy(outputcommand, output);
}

void PrintSession::GetResponseCode(char * code)
{
   code[0] = ebcdic2ascii(inpacket[5]);
   code[1] = ebcdic2ascii(inpacket[6]);
   code[2] = ebcdic2ascii(inpacket[7]);
   code[3] = ebcdic2ascii(inpacket[8]);
   code[4] = '\0';
}

void PrintSession::MainLoop()
{
   int pcount;
   int loop;
   int newjob;
   char responsecode[5];

      while(1) {
         if(waitevent()) {
            strm->HandleReceive();
            pcount = strm->GetPacketCount();
            if(pcount > 0) {
               inpacket.Init();
               strm->GetPacket(&inpacket);
               GetResponseCode(responsecode);
               if(strcmp(responsecode, "I902")) {
                  printf("Could not establish printer session: %s\n", 
                         responsecode);
                  exit(1);
               }
               else {
                  printf("Printer session established.\n");
                  break;
               }
            }
         }
      }

      newjob = 1;
      while(1) {
         if(waitevent()) {
            strm->HandleReceive();
            pcount = strm->GetPacketCount();
            if(pcount > 0) {
               if(newjob) {
                  printfile = popen(outputcommand, "w");
                  newjob = 0;
               }
               inpacket.Init();
               strm->GetPacket(&inpacket);
               strm->PrintComplete();
               if(inpacket.length() == 0x11) {
                  printf("Job Complete\n");
                  pclose(printfile);
                  newjob = 1;
               }
               else
               {
                  while(!inpacket.IsChainEnd())
                  {
                     fprintf(printfile, "%c", inpacket.GetByte());
                  }
               }
            }
         }
      }

}

int PrintSession::waitevent() const
{
   fd_set fdr;
   int result = 0;
 
   FD_ZERO (&fdr);
   FD_SET (0, &fdr);
   FD_SET (conn_fd, &fdr);
   select (conn_fd+1, &fdr, NULL, NULL, NULL);

   if (FD_ISSET (conn_fd, &fdr))
      result = 1;
 
   return result;
}