/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef CURSESTERM_H
#define CURSESTERM_H

//
// The Terminal class is an abstract base class for programs wishing to
// implement a Tn5250 user interface.
//
class CursesTerminal: public Terminal {
private:
   int conn_fd;
   bool quit_flag;
   bool underscores;
   int get_esc_key (bool is_esc);

public:
   virtual void init (void);
   virtual void term (void);

   virtual void connection_fd (SOCKET_TYPE fd);
   virtual int width (void) const;
   virtual int height (void) const;
   virtual int flags (void) const;
   virtual void update (const DisplayBuffer& buffer);
   virtual void update_indicators (const DisplayBuffer& buffer);
   virtual int waitevent (void);
   virtual int getkey (void);

   bool use_underscores (bool v);
};

#endif /* CURSESTERM_H */
