#!/bin/bash

migrate=$HOME/Development/Tcl/Core.Tcl-Lang.Org/Migration/tcl9-migrate/migrate.tcl

for module in $(lsdir modules | sort)
do
    for severity in E W N
    do
	rm -f CHECK.$(basename $module).$severity
	(
	    echo
	    echo _____________________________ $module/$severity
	    echo

	    time tclsh9 $migrate check \
		 --sizelimit 400000 \
		 --severity $severity \
		 $(find $module -type f -name '*.tcl')
	    echo
	    echo
	) |& grep -v README | grep -v guidance | tee -a CHECK.$(basename $module).$severity
    done
done
exit

