# Copyright 2017 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the 'License');
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an 'AS IS' BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

load("@io_bazel_rules_closure//closure:defs.bzl", "filegroup_external")
load("@io_bazel_rules_closure//closure:defs.bzl", "web_library_external")

def tensorboard_fonts_workspace():
  """Downloads TensorBoard fonts."""

  # bazel run //tensorboard/tools:import_google_fonts -- --url='https://fonts.googleapis.com/css?family=Roboto:400,300,300italic,400italic,500,500italic,700,700italic;https://fonts.googleapis.com/css?family=Roboto+Mono:400,700'
  filegroup_external(
      name = "com_google_fonts_roboto",
      licenses = ["notice"],  # Apache 2.0
      sha256_urls = {
          # Roboto (cyrillic)
          "41720926981ffb6dc229f06fc0bbf0f43e45ba032d126726ebee481c2a6559e2": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/uYECMKoHcO9x1wdmbyHIm3-_kf6ByYO6CLYdB4HQE-Y.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/uYECMKoHcO9x1wdmbyHIm3-_kf6ByYO6CLYdB4HQE-Y.woff2",
          ],
          # Roboto (cyrillic-ext)
          "90a0ad0b48861588a6e33a5905b17e1219ea87ab6f07ccc41e7c2cddf38967a8": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/sTdaA6j0Psb920Vjv-mrzH-_kf6ByYO6CLYdB4HQE-Y.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/sTdaA6j0Psb920Vjv-mrzH-_kf6ByYO6CLYdB4HQE-Y.woff2",
          ],
          # Roboto (greek)
          "949e287846b0940817e4ea0f65accc4481a46b8733dc12aa0265293a4645c661": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/_VYFx-s824kXq_Ul2BHqYH-_kf6ByYO6CLYdB4HQE-Y.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/_VYFx-s824kXq_Ul2BHqYH-_kf6ByYO6CLYdB4HQE-Y.woff2",
          ],
          # Roboto (greek-ext)
          "e5b2e29a16d8ef4c5a123b40786af72da589c4aad634eab40d90eef8bb4418aa": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/tnj4SB6DNbdaQnsM8CFqBX-_kf6ByYO6CLYdB4HQE-Y.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/tnj4SB6DNbdaQnsM8CFqBX-_kf6ByYO6CLYdB4HQE-Y.woff2",
          ],
          # Roboto (latin)
          "4352380f92ce7f9a4a4a23306b992bed10055dbfffe90987cc72083e583fc280": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/oMMgfZMQthOryQo9n22dcuvvDin1pK8aKteLpeZ5c0A.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/oMMgfZMQthOryQo9n22dcuvvDin1pK8aKteLpeZ5c0A.woff2",
          ],
          # Roboto (latin-ext)
          "80fa23b4804621ce7f16b5c56d524dd90ea09d792622eeac9adf0ee6317b9e3a": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/Ks_cVxiCiwUWVsFWFA3Bjn-_kf6ByYO6CLYdB4HQE-Y.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/Ks_cVxiCiwUWVsFWFA3Bjn-_kf6ByYO6CLYdB4HQE-Y.woff2",
          ],
          # Roboto (vietnamese)
          "a0a893b2ff1c82d49ac0c09ace71cf8178c0830f6a988103c779b6fc12c0da78": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/NJ4vxlgWwWbEsv18dAhqnn-_kf6ByYO6CLYdB4HQE-Y.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/NJ4vxlgWwWbEsv18dAhqnn-_kf6ByYO6CLYdB4HQE-Y.woff2",
          ],
          # Roboto Bold (cyrillic)
          "6082aa2f5aab855120cd58f560f58975579097c484d23cc7854977a529f91bc4": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/isZ-wbCXNKAbnjo6_TwHToX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/isZ-wbCXNKAbnjo6_TwHToX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Bold (cyrillic-ext)
          "616eb767627d16bef2b9be2218bb5f1bbbb97cfbd06c4e5241c8b532b56467aa": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/77FXFjRbGzN4aCrSFhlh3oX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/77FXFjRbGzN4aCrSFhlh3oX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Bold (greek)
          "28959a3f1fea0c7f7feca26f92465f5263f2e8fdec17030e0e7a9e6a8cb321af": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/jSN2CGVDbcVyCnfJfjSdfIX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/jSN2CGVDbcVyCnfJfjSdfIX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Bold (greek-ext)
          "e94a5635cb68464d332cd374fd57b95913fc5b549f1967fbb73829b2084efd98": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/UX6i4JxQDm3fVTc1CPuwqoX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/UX6i4JxQDm3fVTc1CPuwqoX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Bold (latin)
          "1be216dbc059d96e288b0c1f399a1a80ee8c65e4c1272dbc4574bd6d23cf45d9": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/d-6IYplOFocCacKzxwXSOJBw1xU1rKptJj_0jans920.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/d-6IYplOFocCacKzxwXSOJBw1xU1rKptJj_0jans920.woff2",
          ],
          # Roboto Bold (latin-ext)
          "6c8be972381d4da037f47c33ef1e31b88f0130ded1432730d4d792331f983839": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/97uahxiqZRoncBaCEI3aW4X0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/97uahxiqZRoncBaCEI3aW4X0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Bold (vietnamese)
          "5f162f1ca2441cae368e97ed42b56332d7b68b1ffbbf9f7e4b648420667acee5": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/PwZc-YbIL414wB9rB1IAPYX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/PwZc-YbIL414wB9rB1IAPYX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Bold Italic (cyrillic)
          "bb4e478b0fe2ae7fbd6369c94d126060ffa697df189d7f3653f23f521f906cd8": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC14sYYdJg5dU2qzJEVSuta0.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC14sYYdJg5dU2qzJEVSuta0.woff2",
          ],
          # Roboto Bold Italic (cyrillic-ext)
          "9fc911647b05ecdbadfe6693d6ff306a0a34829999b2055ad2e474e3ad0b778d": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC_ZraR2Tg8w2lzm7kLNL0-w.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC_ZraR2Tg8w2lzm7kLNL0-w.woff2",
          ],
          # Roboto Bold Italic (greek)
          "62509e2b63168ae83848cb3f76d2c47177de8618ac918af119cc7ae90c71213b": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcCwt_Rm691LTebKfY2ZkKSmI.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcCwt_Rm691LTebKfY2ZkKSmI.woff2",
          ],
          # Roboto Bold Italic (greek-ext)
          "07a2e7b4a480176f0f0bc9f7ca757d8467bf41f86e3b1eed374be06ff1b51b56": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC1BW26QxpSj-_ZKm_xT4hWw.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC1BW26QxpSj-_ZKm_xT4hWw.woff2",
          ],
          # Roboto Bold Italic (latin)
          "556e09ad66d48078d2ea341eff36e93dafdb56fed15e9d92e052a7cb3910e2e9": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC4gp9Q8gbYrhqGlRav_IXfk.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC4gp9Q8gbYrhqGlRav_IXfk.woff2",
          ],
          # Roboto Bold Italic (latin-ext)
          "5f6115b8655a4e9e0bb6440956b2d7b7d52e90193c6be53731fcf97d1fc45ec3": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC6E8kM4xWR1_1bYURRojRGc.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC6E8kM4xWR1_1bYURRojRGc.woff2",
          ],
          # Roboto Bold Italic (vietnamese)
          "b75ce2f4333ea21c1d0aeb0061edcf81b7fffe022a732dae52834a8b62615c5f": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC9DiNsR5a-9Oe_Ivpu8XWlY.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/t6Nd4cfPRhZP44Q5QAjcC9DiNsR5a-9Oe_Ivpu8XWlY.woff2",
          ],
          # Roboto Italic (cyrillic)
          "38602b65e115ae1b267627d5533c2607f446aba939b9ca9143cc4373bd285b83": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/OpXUqTo0UgQQhGj_SFdLWBkAz4rYn47Zy2rvigWQf6w.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/OpXUqTo0UgQQhGj_SFdLWBkAz4rYn47Zy2rvigWQf6w.woff2",
          ],
          # Roboto Italic (cyrillic-ext)
          "d04ce842e235d3e6abfcd37d6598138007f56e391a035167d78edf9088d3035a": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/WxrXJa0C3KdtC7lMafG4dRkAz4rYn47Zy2rvigWQf6w.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/WxrXJa0C3KdtC7lMafG4dRkAz4rYn47Zy2rvigWQf6w.woff2",
          ],
          # Roboto Italic (greek)
          "aa9a8db3e6de8124291c3f2fd0bbd0aca8c796f365204d78414536067115be07": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/cDKhRaXnQTOVbaoxwdOr9xkAz4rYn47Zy2rvigWQf6w.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/cDKhRaXnQTOVbaoxwdOr9xkAz4rYn47Zy2rvigWQf6w.woff2",
          ],
          # Roboto Italic (greek-ext)
          "785896def5be5b35967d63f5589ce67fc8d3b452153a37323a4d9b886d828c60": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/1hZf02POANh32k2VkgEoUBkAz4rYn47Zy2rvigWQf6w.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/1hZf02POANh32k2VkgEoUBkAz4rYn47Zy2rvigWQf6w.woff2",
          ],
          # Roboto Italic (latin)
          "64565561ddb338a11ffce5b84aa53fa6e8fd203c34208e61eb5602cd08bf527f": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/vPcynSL0qHq_6dX7lKVByXYhjbSpvc47ee6xR_80Hnw.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/vPcynSL0qHq_6dX7lKVByXYhjbSpvc47ee6xR_80Hnw.woff2",
          ],
          # Roboto Italic (latin-ext)
          "d5b2d7e9efe90feef0c4507d90b2b4e464c6929efd05ad4294d3d5057db57b97": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/vSzulfKSK0LLjjfeaxcREhkAz4rYn47Zy2rvigWQf6w.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/vSzulfKSK0LLjjfeaxcREhkAz4rYn47Zy2rvigWQf6w.woff2",
          ],
          # Roboto Italic (vietnamese)
          "5d875731e35140f94bc4cb23944d104688d3c6d372833ddae8d22d3aa802beb4": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/K23cxWVTrIFD6DJsEVi07RkAz4rYn47Zy2rvigWQf6w.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/K23cxWVTrIFD6DJsEVi07RkAz4rYn47Zy2rvigWQf6w.woff2",
          ],
          # Roboto Light (cyrillic)
          "cb94537350a4c593515c0b9066a22f0d74284173b88521c50b894a3179402e46": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/Fl4y0QdOxyyTHEGMXX8kcYX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/Fl4y0QdOxyyTHEGMXX8kcYX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Light (cyrillic-ext)
          "66a095c96771a94d2772c7e19a32c6585d4bed3a989faa9e595bb270a2621608": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/0eC6fl06luXEYWpBSJvXCIX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/0eC6fl06luXEYWpBSJvXCIX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Light (greek)
          "f0e3a88ae70245bcac12d2640792e50a165ce618d3b5979b735913e582d204f7": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/I3S1wsgSg9YCurV6PUkTOYX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/I3S1wsgSg9YCurV6PUkTOYX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Light (greek-ext)
          "40a162d49fd25da223ea81454616f469270020fc186fe2f109534fb1f72e1bcb": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/-L14Jk06m6pUHB-5mXQQnYX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/-L14Jk06m6pUHB-5mXQQnYX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Light (latin)
          "f7c386915e39d8a925fe10d15744a9da95ac8f90423e12728e7fc3c5e34f4559": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/Hgo13k-tfSpn0qi1SFdUfZBw1xU1rKptJj_0jans920.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/Hgo13k-tfSpn0qi1SFdUfZBw1xU1rKptJj_0jans920.woff2",
          ],
          # Roboto Light (latin-ext)
          "bbeeb150a0f72cbd898ba36ed908bb95ef2386d41158c943aa3af4e0c8430639": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/Pru33qjShpZSmG3z6VYwnYX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/Pru33qjShpZSmG3z6VYwnYX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Light (vietnamese)
          "5a4e99d1db8c9fd38f6b1c92582c2351cf27075f5ccef89404a8d673fa8e7b26": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/NYDWBdD4gIq26G5XYbHsFIX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/NYDWBdD4gIq26G5XYbHsFIX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Light Italic (cyrillic)
          "4160dc56c5afc7320243a73cdf025d1c64ea19e035b98bad9c170e37c98ee5e2": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at14sYYdJg5dU2qzJEVSuta0.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at14sYYdJg5dU2qzJEVSuta0.woff2",
          ],
          # Roboto Light Italic (cyrillic-ext)
          "d95d953cff5e309f22a680e48981070d2cbebf75daba25b078834bf0c4f143e4": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at_ZraR2Tg8w2lzm7kLNL0-w.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at_ZraR2Tg8w2lzm7kLNL0-w.woff2",
          ],
          # Roboto Light Italic (greek)
          "8d649207dfd9e6f53614ee7ee8e0865789e38b39244ab1546ee5117ab6f6ed2f": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0atwt_Rm691LTebKfY2ZkKSmI.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0atwt_Rm691LTebKfY2ZkKSmI.woff2",
          ],
          # Roboto Light Italic (greek-ext)
          "a1153c52da99d21ed2f036e5849c3b2a5d7d3d5913d63ceac983d388288420b4": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at1BW26QxpSj-_ZKm_xT4hWw.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at1BW26QxpSj-_ZKm_xT4hWw.woff2",
          ],
          # Roboto Light Italic (latin)
          "c4fc2fd6457f67718ccff3434f39a84a83be98defa8e23ac1942580ea53a925e": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at4gp9Q8gbYrhqGlRav_IXfk.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at4gp9Q8gbYrhqGlRav_IXfk.woff2",
          ],
          # Roboto Light Italic (latin-ext)
          "fd5b96eb1adc32b3fd7823f6a9e3c14122a060d5665091c33d9243f2541b016c": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at6E8kM4xWR1_1bYURRojRGc.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at6E8kM4xWR1_1bYURRojRGc.woff2",
          ],
          # Roboto Light Italic (vietnamese)
          "ced9470e7e60d5edeccf4d3a0ab2f57ef653ec9de3097e6950bc06c64157aa5a": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at9DiNsR5a-9Oe_Ivpu8XWlY.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/7m8l7TlFO-S3VkhHuR0at9DiNsR5a-9Oe_Ivpu8XWlY.woff2",
          ],
          # Roboto Medium (cyrillic)
          "74f08a5b16db96fd23eeca2c2e6c354d08a95b3360aa2bb6ea0890517bb10469": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/oHi30kwQWvpCWqAhzHcCSIX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/oHi30kwQWvpCWqAhzHcCSIX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Medium (cyrillic-ext)
          "2aa57d00d0cac3b30aef28a19e9cfea12b45daf9562b4fa623750c8145c0767b": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/ZLqKeelYbATG60EpZBSDy4X0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/ZLqKeelYbATG60EpZBSDy4X0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Medium (greek)
          "b95a36dd1483f97002a0c8aba87106f7fefbd67f22bc25a2bf21352bb4f316ef": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/mx9Uck6uB63VIKFYnEMXrYX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/mx9Uck6uB63VIKFYnEMXrYX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Medium (greek-ext)
          "399cdbc9a94414d94fb15b0386888c6bc8ce4d6140cc3a9a571406a76cf47bb5": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/rGvHdJnr2l75qb0YND9NyIX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/rGvHdJnr2l75qb0YND9NyIX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Medium (latin)
          "b79781efede37903be212fcdf63955e41c8649e678b6b83adf824459d240a188": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/RxZJdnzeo3R5zSexge8UUZBw1xU1rKptJj_0jans920.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/RxZJdnzeo3R5zSexge8UUZBw1xU1rKptJj_0jans920.woff2",
          ],
          # Roboto Medium (latin-ext)
          "ba99e38768dd8358450dc363431400b1642c7cd7e5b47830e30aa8ec80fb4790": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/oOeFwZNlrTefzLYmlVV1UIX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/oOeFwZNlrTefzLYmlVV1UIX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Medium (vietnamese)
          "e785fcb2332a43e5f489c0e7457001a93800b459bdf5173cffbb880f350077eb": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/mbmhprMH69Zi6eEPBYVFhYX0hVgzZQUfRDuZrPvH3D8.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/mbmhprMH69Zi6eEPBYVFhYX0hVgzZQUfRDuZrPvH3D8.woff2",
          ],
          # Roboto Medium Italic (cyrillic)
          "e9f24fd84cfbdad488d4f05d97ca2e009af8248044def329f0c78c04e12c32cb": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0V4sYYdJg5dU2qzJEVSuta0.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0V4sYYdJg5dU2qzJEVSuta0.woff2",
          ],
          # Roboto Medium Italic (cyrillic-ext)
          "ecfda0e4317641a395971d71435ad1a3dce0499bccc9bcdcaaebffb714588a4e": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0fZraR2Tg8w2lzm7kLNL0-w.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0fZraR2Tg8w2lzm7kLNL0-w.woff2",
          ],
          # Roboto Medium Italic (greek)
          "510c1001aa3c1ae574eba6eaa5a404414dd0f5d5cd8c213fe0fac404c1fbbd7c": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0Qt_Rm691LTebKfY2ZkKSmI.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0Qt_Rm691LTebKfY2ZkKSmI.woff2",
          ],
          # Roboto Medium Italic (greek-ext)
          "e5343e5d46125f688c2f266369983a1f92dbefa8d16f131b09768cdd4a5cebd4": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0VBW26QxpSj-_ZKm_xT4hWw.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0VBW26QxpSj-_ZKm_xT4hWw.woff2",
          ],
          # Roboto Medium Italic (latin)
          "76d779c16f21b55a95fb182bf7552447ee340d15556e53a99dd789383f6d8c32": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0Ygp9Q8gbYrhqGlRav_IXfk.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0Ygp9Q8gbYrhqGlRav_IXfk.woff2",
          ],
          # Roboto Medium Italic (latin-ext)
          "a69b0c33d809b7aac3e9648bfc995bc38cd5e426efeb006dc3b31523f4867f73": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0aE8kM4xWR1_1bYURRojRGc.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0aE8kM4xWR1_1bYURRojRGc.woff2",
          ],
          # Roboto Medium Italic (vietnamese)
          "2c94704be76a8ec87995f3427911e50987cfcaa13c5749c770419559fe836509": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0dDiNsR5a-9Oe_Ivpu8XWlY.woff2",
              "https://fonts.gstatic.com/s/roboto/v18/OLffGBTaF0XFOW1gnuHF0dDiNsR5a-9Oe_Ivpu8XWlY.woff2",
          ],
          # Roboto Mono (cyrillic)
          "2c9fae8205ea404d8400b9731423d5f8261788efcb26b651ad1031c70c895824": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY14sYYdJg5dU2qzJEVSuta0.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY14sYYdJg5dU2qzJEVSuta0.woff2",
          ],
          # Roboto Mono (cyrillic-ext)
          "671d1df350d3ccfd9a5ebbc9e92810a274d6215a648099f0f6e3e256b2bdae02": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY_ZraR2Tg8w2lzm7kLNL0-w.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY_ZraR2Tg8w2lzm7kLNL0-w.woff2",
          ],
          # Roboto Mono (greek)
          "eb84188b287e62e965be53c788b6562554cefcc0a3520f792ba91bb60d40e607": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpYwt_Rm691LTebKfY2ZkKSmI.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpYwt_Rm691LTebKfY2ZkKSmI.woff2",
          ],
          # Roboto Mono (greek-ext)
          "978a5db5af1654146da5ec93980c273df7010a2d045f1360ac3b9d85bd890299": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY1BW26QxpSj-_ZKm_xT4hWw.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY1BW26QxpSj-_ZKm_xT4hWw.woff2",
          ],
          # Roboto Mono (latin)
          "ecc28128233f90171df8f8915d60cdc59ff70b9194e1d93061816d3e3cd1f320": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY4gp9Q8gbYrhqGlRav_IXfk.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY4gp9Q8gbYrhqGlRav_IXfk.woff2",
          ],
          # Roboto Mono (latin-ext)
          "9a7b6e1f38e9a47867ad5c2f403ff4f4477a03bbec300d4e345bf67d5d0da262": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY6E8kM4xWR1_1bYURRojRGc.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY6E8kM4xWR1_1bYURRojRGc.woff2",
          ],
          # Roboto Mono (vietnamese)
          "b568a2d630d5924e40b73489cc4a8720fb9fb0249b8117d6d45cfc95d249c1da": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY9DiNsR5a-9Oe_Ivpu8XWlY.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/hMqPNLsu_dywMa4C_DEpY9DiNsR5a-9Oe_Ivpu8XWlY.woff2",
          ],
          # Roboto Mono Bold (cyrillic)
          "656e4cb0b042d18f6b889948f3c9a1f87b70340bd20a38a0d738b0e32a7f00ee": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fz1x-M1I1w5OMiqnVF8xBLhU.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fz1x-M1I1w5OMiqnVF8xBLhU.woff2",
          ],
          # Roboto Mono Bold (cyrillic-ext)
          "0d5221a5f914d57a674049b718a37b8f09a0e79647af8b187273f35ab0d8376c": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59FzwXaAXup5mZlfK6xRLrhsco.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59FzwXaAXup5mZlfK6xRLrhsco.woff2",
          ],
          # Roboto Mono Bold (greek)
          "41553f58ea074adde7eaaefe9b220b49021128f6b68b8be384072c4db430603f": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fzwn6Wqxo-xwxilDXPU8chVU.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fzwn6Wqxo-xwxilDXPU8chVU.woff2",
          ],
          # Roboto Mono Bold (greek-ext)
          "27798d63b7fadca6c6a2d17ea7673855d44baf75e8172fa9749888898ce04125": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fz1T7aJLK6nKpn36IMwTcMMc.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fz1T7aJLK6nKpn36IMwTcMMc.woff2",
          ],
          # Roboto Mono Bold (latin)
          "8b827f046df0acf54d80954ae05f0b5e87fdf09bc4c1bf02e8edb0d928e259b7": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fz_79_ZuUxCigM2DespTnFaw.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fz_79_ZuUxCigM2DespTnFaw.woff2",
          ],
          # Roboto Mono Bold (latin-ext)
          "b38383e889863e1c25c2334087e6b00835cef283f8448c8b2a2d5d51489d202b": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fz4gd9OEPUCN3AdYW0e8tat4.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fz4gd9OEPUCN3AdYW0e8tat4.woff2",
          ],
          # Roboto Mono Bold (vietnamese)
          "03b9c55ee9bf53c57c9b9dcb739bc92ada5b97fc81deb5a57e4e8347c4eee8bb": [
              "https://mirror.bazel.build/fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fz8bIQSYZnWLaWC9QNCpTK_U.woff2",
              "https://fonts.gstatic.com/s/robotomono/v5/N4duVc9C58uwPiY8_59Fz8bIQSYZnWLaWC9QNCpTK_U.woff2",
          ],
      },
      generated_rule_name = "files",
      extra_build_file_content = "\n".join([
          'load("@io_bazel_rules_closure//closure:defs.bzl", "web_library")',
          '',
          'web_library(',
          '    name = "com_google_fonts_roboto",',
          '    path = "/font-roboto",',
          '    srcs = [',
          '        "roboto.html",',
          '        ":files",',
          '    ],',
          ')',
          '',
          'genrule(',
          '    name = "html",',
          '    outs = ["roboto.html"],',
          '    cmd = "\\n".join([',
          '        "cat <<\'EOF\' >$@",',
          "        '<!--',",
          "        '@license',",
          "        'Copyright 2017 Google Inc. All Rights Reserved.',",
          "        '',",
          '        \'Licensed under the Apache License, Version 2.0 (the "License");\',',
          "        'you may not use this file except in compliance with the License.',",
          "        'You may obtain a copy of the License at',",
          "        '',",
          "        '    http://www.apache.org/licenses/LICENSE-2.0',",
          "        '',",
          "        'Unless required by applicable law or agreed to in writing, software',",
          '        \'distributed under the License is distributed on an "AS IS" BASIS,\',',
          "        'WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.',",
          "        'See the License for the specific language governing permissions and',",
          "        'limitations under the License.',",
          "        '-->',",
          "        '',",
          "        '<style>',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto\'), local(\'Roboto-Regular\'), url(/font-roboto/uYECMKoHcO9x1wdmbyHIm3-_kf6ByYO6CLYdB4HQE-Y.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto\'), local(\'Roboto-Regular\'), url(/font-roboto/sTdaA6j0Psb920Vjv-mrzH-_kf6ByYO6CLYdB4HQE-Y.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0460-052F, U+20B4, U+2DE0-2DFF, U+A640-A69F;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto\'), local(\'Roboto-Regular\'), url(/font-roboto/_VYFx-s824kXq_Ul2BHqYH-_kf6ByYO6CLYdB4HQE-Y.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0370-03FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto\'), local(\'Roboto-Regular\'), url(/font-roboto/tnj4SB6DNbdaQnsM8CFqBX-_kf6ByYO6CLYdB4HQE-Y.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+1F00-1FFF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto\'), local(\'Roboto-Regular\'), url(/font-roboto/oMMgfZMQthOryQo9n22dcuvvDin1pK8aKteLpeZ5c0A.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2212, U+2215;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto\'), local(\'Roboto-Regular\'), url(/font-roboto/Ks_cVxiCiwUWVsFWFA3Bjn-_kf6ByYO6CLYdB4HQE-Y.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0100-024F, U+1E00-1EFF, U+20A0-20AB, U+20AD-20CF, U+2C60-2C7F, U+A720-A7FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto\'), local(\'Roboto-Regular\'), url(/font-roboto/NJ4vxlgWwWbEsv18dAhqnn-_kf6ByYO6CLYdB4HQE-Y.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0102-0103, U+1EA0-1EF9, U+20AB;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold\'), local(\'Roboto-Bold\'), url(/font-roboto/isZ-wbCXNKAbnjo6_TwHToX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold\'), local(\'Roboto-Bold\'), url(/font-roboto/77FXFjRbGzN4aCrSFhlh3oX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0460-052F, U+20B4, U+2DE0-2DFF, U+A640-A69F;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold\'), local(\'Roboto-Bold\'), url(/font-roboto/jSN2CGVDbcVyCnfJfjSdfIX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0370-03FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold\'), local(\'Roboto-Bold\'), url(/font-roboto/UX6i4JxQDm3fVTc1CPuwqoX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+1F00-1FFF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold\'), local(\'Roboto-Bold\'), url(/font-roboto/d-6IYplOFocCacKzxwXSOJBw1xU1rKptJj_0jans920.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2212, U+2215;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold\'), local(\'Roboto-Bold\'), url(/font-roboto/97uahxiqZRoncBaCEI3aW4X0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0100-024F, U+1E00-1EFF, U+20A0-20AB, U+20AD-20CF, U+2C60-2C7F, U+A720-A7FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold\'), local(\'Roboto-Bold\'), url(/font-roboto/PwZc-YbIL414wB9rB1IAPYX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0102-0103, U+1EA0-1EF9, U+20AB;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold Italic\'), local(\'Roboto-BoldItalic\'), url(/font-roboto/t6Nd4cfPRhZP44Q5QAjcC14sYYdJg5dU2qzJEVSuta0.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold Italic\'), local(\'Roboto-BoldItalic\'), url(/font-roboto/t6Nd4cfPRhZP44Q5QAjcC_ZraR2Tg8w2lzm7kLNL0-w.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0460-052F, U+20B4, U+2DE0-2DFF, U+A640-A69F;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold Italic\'), local(\'Roboto-BoldItalic\'), url(/font-roboto/t6Nd4cfPRhZP44Q5QAjcCwt_Rm691LTebKfY2ZkKSmI.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0370-03FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold Italic\'), local(\'Roboto-BoldItalic\'), url(/font-roboto/t6Nd4cfPRhZP44Q5QAjcC1BW26QxpSj-_ZKm_xT4hWw.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+1F00-1FFF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold Italic\'), local(\'Roboto-BoldItalic\'), url(/font-roboto/t6Nd4cfPRhZP44Q5QAjcC4gp9Q8gbYrhqGlRav_IXfk.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2212, U+2215;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold Italic\'), local(\'Roboto-BoldItalic\'), url(/font-roboto/t6Nd4cfPRhZP44Q5QAjcC6E8kM4xWR1_1bYURRojRGc.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0100-024F, U+1E00-1EFF, U+20A0-20AB, U+20AD-20CF, U+2C60-2C7F, U+A720-A7FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Bold Italic\'), local(\'Roboto-BoldItalic\'), url(/font-roboto/t6Nd4cfPRhZP44Q5QAjcC9DiNsR5a-9Oe_Ivpu8XWlY.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0102-0103, U+1EA0-1EF9, U+20AB;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Italic\'), local(\'Roboto-Italic\'), url(/font-roboto/OpXUqTo0UgQQhGj_SFdLWBkAz4rYn47Zy2rvigWQf6w.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Italic\'), local(\'Roboto-Italic\'), url(/font-roboto/WxrXJa0C3KdtC7lMafG4dRkAz4rYn47Zy2rvigWQf6w.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0460-052F, U+20B4, U+2DE0-2DFF, U+A640-A69F;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Italic\'), local(\'Roboto-Italic\'), url(/font-roboto/cDKhRaXnQTOVbaoxwdOr9xkAz4rYn47Zy2rvigWQf6w.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0370-03FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Italic\'), local(\'Roboto-Italic\'), url(/font-roboto/1hZf02POANh32k2VkgEoUBkAz4rYn47Zy2rvigWQf6w.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+1F00-1FFF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Italic\'), local(\'Roboto-Italic\'), url(/font-roboto/vPcynSL0qHq_6dX7lKVByXYhjbSpvc47ee6xR_80Hnw.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2212, U+2215;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Italic\'), local(\'Roboto-Italic\'), url(/font-roboto/vSzulfKSK0LLjjfeaxcREhkAz4rYn47Zy2rvigWQf6w.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0100-024F, U+1E00-1EFF, U+20A0-20AB, U+20AD-20CF, U+2C60-2C7F, U+A720-A7FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Italic\'), local(\'Roboto-Italic\'), url(/font-roboto/K23cxWVTrIFD6DJsEVi07RkAz4rYn47Zy2rvigWQf6w.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0102-0103, U+1EA0-1EF9, U+20AB;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light\'), local(\'Roboto-Light\'), url(/font-roboto/Fl4y0QdOxyyTHEGMXX8kcYX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light\'), local(\'Roboto-Light\'), url(/font-roboto/0eC6fl06luXEYWpBSJvXCIX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0460-052F, U+20B4, U+2DE0-2DFF, U+A640-A69F;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light\'), local(\'Roboto-Light\'), url(/font-roboto/I3S1wsgSg9YCurV6PUkTOYX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0370-03FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light\'), local(\'Roboto-Light\'), url(/font-roboto/-L14Jk06m6pUHB-5mXQQnYX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+1F00-1FFF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light\'), local(\'Roboto-Light\'), url(/font-roboto/Hgo13k-tfSpn0qi1SFdUfZBw1xU1rKptJj_0jans920.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2212, U+2215;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light\'), local(\'Roboto-Light\'), url(/font-roboto/Pru33qjShpZSmG3z6VYwnYX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0100-024F, U+1E00-1EFF, U+20A0-20AB, U+20AD-20CF, U+2C60-2C7F, U+A720-A7FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light\'), local(\'Roboto-Light\'), url(/font-roboto/NYDWBdD4gIq26G5XYbHsFIX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0102-0103, U+1EA0-1EF9, U+20AB;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light Italic\'), local(\'Roboto-LightItalic\'), url(/font-roboto/7m8l7TlFO-S3VkhHuR0at14sYYdJg5dU2qzJEVSuta0.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light Italic\'), local(\'Roboto-LightItalic\'), url(/font-roboto/7m8l7TlFO-S3VkhHuR0at_ZraR2Tg8w2lzm7kLNL0-w.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0460-052F, U+20B4, U+2DE0-2DFF, U+A640-A69F;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light Italic\'), local(\'Roboto-LightItalic\'), url(/font-roboto/7m8l7TlFO-S3VkhHuR0atwt_Rm691LTebKfY2ZkKSmI.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0370-03FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light Italic\'), local(\'Roboto-LightItalic\'), url(/font-roboto/7m8l7TlFO-S3VkhHuR0at1BW26QxpSj-_ZKm_xT4hWw.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+1F00-1FFF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light Italic\'), local(\'Roboto-LightItalic\'), url(/font-roboto/7m8l7TlFO-S3VkhHuR0at4gp9Q8gbYrhqGlRav_IXfk.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2212, U+2215;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light Italic\'), local(\'Roboto-LightItalic\'), url(/font-roboto/7m8l7TlFO-S3VkhHuR0at6E8kM4xWR1_1bYURRojRGc.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0100-024F, U+1E00-1EFF, U+20A0-20AB, U+20AD-20CF, U+2C60-2C7F, U+A720-A7FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 300;',",
          '        "  src: local(\'Roboto Light Italic\'), local(\'Roboto-LightItalic\'), url(/font-roboto/7m8l7TlFO-S3VkhHuR0at9DiNsR5a-9Oe_Ivpu8XWlY.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0102-0103, U+1EA0-1EF9, U+20AB;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium\'), local(\'Roboto-Medium\'), url(/font-roboto/oHi30kwQWvpCWqAhzHcCSIX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium\'), local(\'Roboto-Medium\'), url(/font-roboto/ZLqKeelYbATG60EpZBSDy4X0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0460-052F, U+20B4, U+2DE0-2DFF, U+A640-A69F;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium\'), local(\'Roboto-Medium\'), url(/font-roboto/mx9Uck6uB63VIKFYnEMXrYX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0370-03FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium\'), local(\'Roboto-Medium\'), url(/font-roboto/rGvHdJnr2l75qb0YND9NyIX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+1F00-1FFF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium\'), local(\'Roboto-Medium\'), url(/font-roboto/RxZJdnzeo3R5zSexge8UUZBw1xU1rKptJj_0jans920.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2212, U+2215;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium\'), local(\'Roboto-Medium\'), url(/font-roboto/oOeFwZNlrTefzLYmlVV1UIX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0100-024F, U+1E00-1EFF, U+20A0-20AB, U+20AD-20CF, U+2C60-2C7F, U+A720-A7FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium\'), local(\'Roboto-Medium\'), url(/font-roboto/mbmhprMH69Zi6eEPBYVFhYX0hVgzZQUfRDuZrPvH3D8.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0102-0103, U+1EA0-1EF9, U+20AB;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium Italic\'), local(\'Roboto-MediumItalic\'), url(/font-roboto/OLffGBTaF0XFOW1gnuHF0V4sYYdJg5dU2qzJEVSuta0.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium Italic\'), local(\'Roboto-MediumItalic\'), url(/font-roboto/OLffGBTaF0XFOW1gnuHF0fZraR2Tg8w2lzm7kLNL0-w.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0460-052F, U+20B4, U+2DE0-2DFF, U+A640-A69F;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium Italic\'), local(\'Roboto-MediumItalic\'), url(/font-roboto/OLffGBTaF0XFOW1gnuHF0Qt_Rm691LTebKfY2ZkKSmI.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0370-03FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium Italic\'), local(\'Roboto-MediumItalic\'), url(/font-roboto/OLffGBTaF0XFOW1gnuHF0VBW26QxpSj-_ZKm_xT4hWw.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+1F00-1FFF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium Italic\'), local(\'Roboto-MediumItalic\'), url(/font-roboto/OLffGBTaF0XFOW1gnuHF0Ygp9Q8gbYrhqGlRav_IXfk.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2212, U+2215;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium Italic\'), local(\'Roboto-MediumItalic\'), url(/font-roboto/OLffGBTaF0XFOW1gnuHF0aE8kM4xWR1_1bYURRojRGc.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0100-024F, U+1E00-1EFF, U+20A0-20AB, U+20AD-20CF, U+2C60-2C7F, U+A720-A7FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto\';",',
          "        '  font-style: italic;',",
          "        '  font-weight: 500;',",
          '        "  src: local(\'Roboto Medium Italic\'), local(\'Roboto-MediumItalic\'), url(/font-roboto/OLffGBTaF0XFOW1gnuHF0dDiNsR5a-9Oe_Ivpu8XWlY.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0102-0103, U+1EA0-1EF9, U+20AB;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Mono\'), local(\'RobotoMono-Regular\'), url(/font-roboto/hMqPNLsu_dywMa4C_DEpY14sYYdJg5dU2qzJEVSuta0.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Mono\'), local(\'RobotoMono-Regular\'), url(/font-roboto/hMqPNLsu_dywMa4C_DEpY_ZraR2Tg8w2lzm7kLNL0-w.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0460-052F, U+20B4, U+2DE0-2DFF, U+A640-A69F;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Mono\'), local(\'RobotoMono-Regular\'), url(/font-roboto/hMqPNLsu_dywMa4C_DEpYwt_Rm691LTebKfY2ZkKSmI.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0370-03FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Mono\'), local(\'RobotoMono-Regular\'), url(/font-roboto/hMqPNLsu_dywMa4C_DEpY1BW26QxpSj-_ZKm_xT4hWw.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+1F00-1FFF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Mono\'), local(\'RobotoMono-Regular\'), url(/font-roboto/hMqPNLsu_dywMa4C_DEpY4gp9Q8gbYrhqGlRav_IXfk.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2212, U+2215;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Mono\'), local(\'RobotoMono-Regular\'), url(/font-roboto/hMqPNLsu_dywMa4C_DEpY6E8kM4xWR1_1bYURRojRGc.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0100-024F, U+1E00-1EFF, U+20A0-20AB, U+20AD-20CF, U+2C60-2C7F, U+A720-A7FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 400;',",
          '        "  src: local(\'Roboto Mono\'), local(\'RobotoMono-Regular\'), url(/font-roboto/hMqPNLsu_dywMa4C_DEpY9DiNsR5a-9Oe_Ivpu8XWlY.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0102-0103, U+1EA0-1EF9, U+20AB;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Mono Bold\'), local(\'RobotoMono-Bold\'), url(/font-roboto/N4duVc9C58uwPiY8_59Fz1x-M1I1w5OMiqnVF8xBLhU.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Mono Bold\'), local(\'RobotoMono-Bold\'), url(/font-roboto/N4duVc9C58uwPiY8_59FzwXaAXup5mZlfK6xRLrhsco.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0460-052F, U+20B4, U+2DE0-2DFF, U+A640-A69F;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Mono Bold\'), local(\'RobotoMono-Bold\'), url(/font-roboto/N4duVc9C58uwPiY8_59Fzwn6Wqxo-xwxilDXPU8chVU.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0370-03FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Mono Bold\'), local(\'RobotoMono-Bold\'), url(/font-roboto/N4duVc9C58uwPiY8_59Fz1T7aJLK6nKpn36IMwTcMMc.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+1F00-1FFF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Mono Bold\'), local(\'RobotoMono-Bold\'), url(/font-roboto/N4duVc9C58uwPiY8_59Fz_79_ZuUxCigM2DespTnFaw.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2212, U+2215;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Mono Bold\'), local(\'RobotoMono-Bold\'), url(/font-roboto/N4duVc9C58uwPiY8_59Fz4gd9OEPUCN3AdYW0e8tat4.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0100-024F, U+1E00-1EFF, U+20A0-20AB, U+20AD-20CF, U+2C60-2C7F, U+A720-A7FF;',",
          "        '}',",
          "        '@font-face {',",
          '        "  font-family: \'Roboto Mono\';",',
          "        '  font-style: normal;',",
          "        '  font-weight: 700;',",
          '        "  src: local(\'Roboto Mono Bold\'), local(\'RobotoMono-Bold\'), url(/font-roboto/N4duVc9C58uwPiY8_59Fz8bIQSYZnWLaWC9QNCpTK_U.woff2) format(\'woff2\');",',
          "        '  unicode-range: U+0102-0103, U+1EA0-1EF9, U+20AB;',",
          "        '}',",
          "        '</style>',",
          '        "EOF",',
          '    ]),',
          ')',
      ]),
  )
