# Tensorboard client-server HTTP API

## Runs, tags, and plugins

TensorBoard data is organized around the concept of a _run_, which
represents all the related data thrown off by a single execution of
TensorFlow, a _tag_, which groups values of data that come from the same
source within a TensorFlow run, and the _plugin_ associated with a tag,
which identifies the type of data that the tag contains and the code
path on which it should be processed. For example, a "train" run may
have a scalar tag that represents the learning rate, another scalar tag
that represents the value of the objective function, a histogram tag
that reveals information on weights in a particular layer over time, and
an image tag that shows input images flowing into the system. The "eval"
run might have an entirely different set of tag names, or some
duplicated tag names. In this example, runs are "train" and "eval"; tags
are "learning_rate", "objective", "weights", and "input_image"; and
plugins are "scalar", "histogram", and "image".

All of the data provided comes from TensorFlow events files ('\*.tfevents\*'),
which are written using the 
[tf.summary.FileWriter](https://www.tensorflow.org/api_docs/python/tf/summary/FileWriter),
and the data is generated by summary ops.

## `data/logdir`

Returns a JSON object with a key "logdir" that maps to the `logdir` argument
(string) with which Tensorboard started up.

Example response:

    {"logdir": "/foo/logdir/argument"}

The `logdir` argument is the path of the directory that contains events files.

## `data/plugins_listing`

Returns a dict mapping from plugin name to a boolean indicating whether
the plugin is active. A plugin might be inactive, for instance, if it
lacks relevant data. Every plugin has a key. This route allows the
frontend to hide or deprioritize inactive plugins so that the user can
focus on the plugins that have data. Note that inactive plugins may
still be rendered if the user explicitly requests this.

## `data/runs`

Returns an array containing the names of all the runs known to the
TensorBoard backend at this time. Each entry is a string corresponding
to a single run.

We guarantee that as new runs are created in the log directory, they
will always appear at the end of the list returned by this route. That
is, the order of runs is persistent, and the result of this route is an
&ldquo;append-only&rdquo; list.

Example response:

    ["train_run", "eval"]

## `/data/plugin/scalars/...`

See the [scalar plugin documentation](https://github.com/tensorflow/tensorboard/blob/master/tensorboard/plugins/scalar/http_api.md).

## `/data/plugin/histograms/...`

See the [histogram plugin documentation](https://github.com/tensorflow/tensorboard/blob/master/tensorboard/plugins/histogram/http_api.md).

## `/data/plugin/distributions/...`

See the [distribution plugin documentation](https://github.com/tensorflow/tensorboard/blob/master/tensorboard/plugins/distribution/http_api.md).

## `/data/plugin/images/...`

See the [image plugin documentation](https://github.com/tensorflow/tensorboard/blob/master/tensorboard/plugins/image/http_api.md).

## `/data/plugin/audio/...`

See the [audio plugin documentation](https://github.com/tensorflow/tensorboard/blob/master/tensorboard/plugins/audio/http_api.md).

## `/data/plugin/graphs/...`

See the [graph plugin documentation](https://github.com/tensorflow/tensorboard/blob/master/tensorboard/plugins/graph/http_api.md).

## Notes

All values are returned in the order they were written by TensorFlow
(which should correspond to increasing `wall_time` order, but may not
necessarily correspond to increasing step count if the process had to
restart from a previous checkpoint).

The returned values may be downsampled using reservoir sampling, which
is configurable by the TensorBoard server. When downsampling occurs, the
server guarantees that different tags will all sample at the same
sequence of indices, so that if there are two tags `A` and `B` which are
related so that `A[i] ~ B[i]` for all `i`, then `D(A)[i] ~ D(B)[i]` for
all `i`, where `D` represents the downsampling operation.

The reservoir sampling puts an upper bound on the number of items that
will be returned for a given run-tag combination, and guarantees that
all items are equally likely to be in the final sample (i.e., it is a
uniform distribution over the values), with the proviso that the most
recent individual item is always included in the sample.

The reservoir sizes are configurable on a per–tag-type basis by modifying [`backend/application.py`][size guidance].

[size guidance]: https://github.com/tensorflow/tensorboard/blob/ee2af19e1c4aa7742d16dd8046c9b17262c91e3f/tensorboard/backend/application.py#L56
