.\" Copyright (C) 2000 WIDE Project.  All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. Neither the name of the project nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\" 
.\" THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\"	$Id: tcpillust.man,v 1.4 2000/04/21 10:15:10 nishida Exp $
.\"
.Dd April 2000
.Dt TCPILLUST 1
.Os
.\"
.Sh NAME
.Nm tcpillust
.Nd a graphical TCP connection analysis tool
.\"
.Sh SYNOPSIS
.Nm tcpillust
.Op Fl Vhv
.Op Fl d Ar data packets delay
.Op Fl s Ar syn packets delay
.Op Fl g Ar geometry
.Ar file 
.Op Ar file
.\"
.Sh DESCRIPTION
.Nm
takes tcpdump file(s) specified on the command line and draw pictures
like figures in the ``TCP/IP Illustrated'' series.

Tcpdump files used by 
.Nm
should contain only data for a single TCP connection. If other data are
contained in the tcpdump files, 
.Nm
can't generate results or the results 
will be inaccurate.

When 
.Nm 
takes a single tcpdump file, it guesses transmit time and receive time 
on the remote host. When 
.Nm 
takes two tcpdump files, it regards them as tcp-client side file and 
tcp-server side file, and generate the results from them.
If you want precise analysis, you should use two tcpdump files.
.Pp
.Sh Options
.Bl -tag -width indent
.It Fl d Ar data packets delay
Specify data packet delay. 
This value is used to guess transmit time and receive time for data packets
on the remote host. When  
.Nm
takes two tcpdump files, this value has no effect.
.It Fl s Ar SYN packets delay
Specify SYN or ACK packet delay. 
This value is used to guess transmit time and receive time for packets
which do not contain data(like SYN packets) on the remote host. When  
.Nm
takes two tcpdump files, this value has no effect.
.It Fl g Ar geometry
Set the size and location of the window.
.It Fl h
Display the usage and exit.
.It Fl v
Display the Tcpillust version and exit.
.It Fl V
Be verbose.
Generate debugging output to standard output.

.El
.\"
.Sh AUTHOR CONTACT
Yoshifumi Nishida <nishida@csl.sony.co.jp>
