/*
 * Copyright (C) 2000 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: tcpillust.c,v 1.2 2000/04/20 07:13:58 nishida Exp $
 */

#define MAIN
#include "tcpillust.h"

static int init_clib __P((ClientData, Tcl_Interp *, int, char **));
static void init_tk __P((void));
static void config_canvas __P((void));
static void config_loadedfile __P((void));

Tk_Window main_tkwin;
Tk_Window canvas_tkwin;
Tk_Window subcanvas_tkwin;
Tcl_Interp *interp;
struct tcppkt *pkt[2];
struct tcppkt *client;
struct tcppkt *server;
struct iltdata *ilt;
int appl_width;
int appl_height;
int appl_x;
int appl_y;
int canvas_width;
int canvas_height;
int subcanvas_width;
int subcanvas_height;
int texton;
int timeon;
int iltcnt;
int loaded;
int  pktcount[2];
float delay;
float ratio;
float baseratio;
float starttime;
float endtime;
float capendtime;
float subratio;
float basesubratio;
float substarttime;
float subendtime;

void
main(int argc, char* argv[]) 
{
	parser(argc, argv);
	init_tk();
}

void
init_tk()
{
	char cmd[256], filename[256]; 
	char dir[2][256] = {"./", ILTDIR};
	struct stat sb;
	int i;

	interp = Tcl_CreateInterp();
  
	if (Tcl_Init(interp) == TCL_ERROR) {
		fprintf(stderr, "Tcl_Init failed:  %s\n", interp->result);
		exit(-1);
	}
	if (Tk_Init(interp) == TCL_ERROR) {
		fprintf(stderr, "Tk_Init failed:  %s\n", interp->result);
		exit(-1);
	}
	main_tkwin = Tk_MainWindow(interp);
	if (main_tkwin == NULL) {
		fprintf(stderr, "%s\n", interp->result);
		exit(-1);
	}

	Tcl_CreateCommand(interp, "init_clib", init_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "zoomout_clib", zoomout_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "zoomin_clib", zoomin_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "movebar_clib", movebar_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "bpress_clib", bpress_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "subzoomout_clib", subzoomout_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "subzoomin_clib", subzoomin_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "scrlbar1_clib", scrlbar1_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "scrlbar2_clib", scrlbar2_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "forward_clib", forward_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "back_clib", back_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "time_clib", time_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "text_clib", text_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "openfile_clib", openfile_clib,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

	config_canvas();

	for (i = 0; i < 2; i ++){
		sprintf(filename, "%s/tcpillust.tcl", dir[i]);
		if (stat(filename, &sb) >= 0) break;
	}
	if (i == 3) {
		fprintf(stderr, "Fatal: can not find tcpillust.tcl\n");
		exit(-1);
	}

	Tcl_SetVar(interp, "tcldir", dir[i], TCL_GLOBAL_ONLY);
	sprintf(cmd, "source %s", filename);
	Tcl_Eval(interp, cmd);
	Tk_MainLoop();  
  
	sprintf(cmd, "exit");
	Tcl_Eval(interp, cmd);
	exit(0);
}

int 
init_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp;
	int argc;
	char *argv[];
{
	canvas_tkwin = Tk_NameToWindow(interp, ".subframe1.canvas", main_tkwin);
	if (canvas_tkwin == NULL) {
		fprintf(stderr, "%s\n", interp->result);
		exit(-1);
	}
	subcanvas_tkwin = Tk_NameToWindow(interp, ".subframe2.canvas", main_tkwin);
	if (subcanvas_tkwin == NULL) {
		fprintf(stderr, "%s\n", interp->result);
		exit(-1);
	}

	if (loaded) config_loadedfile();
	return TCL_OK;
}

void
config_loadedfile()
{
	initial_showregion();
	config_frame();
	config_subframe();
	config_lines();
	config_sublines();
	config_texts();
	config_times();
	config_rectangle();
	Tcl_Eval(interp, "drawframe");
	Tcl_Eval(interp, "drawsubframe");
	Tcl_Eval(interp, "drawlines");
	Tcl_Eval(interp, "drawsublines");
	Tcl_Eval(interp, "drawtexts");
	Tcl_Eval(interp, "drawtimes");
	Tcl_Eval(interp, "drawbox");
	Tcl_Eval(interp, ".subframe1.canvas yview moveto 0.25");

	/* set initial value for timeon and texton */
	Tcl_SetVar(interp, "texton", "1", TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "timeon", "1", TCL_GLOBAL_ONLY);
	texton = timeon = 1;
}

void
config_canvas()
{
	int	x, y, width, height;
	char str[20]; /* XXX */

	if (!appl_width){
		Tk_GetVRootGeometry(main_tkwin, &x, &y, &width, &height);
		appl_width = width * 0.7;
		appl_height = height * 0.7;
	}
	canvas_width = appl_width * 0.8;
	canvas_height = appl_height;
	subcanvas_width = appl_width * 0.2;
	subcanvas_height = appl_height;
	
	sprintf(str, "%d", canvas_width);
	Tcl_SetVar(interp, "canvas_width", str, TCL_GLOBAL_ONLY);
	sprintf(str, "%d", canvas_height);
	Tcl_SetVar(interp, "canvas_height", str, TCL_GLOBAL_ONLY);
	sprintf(str, "%d", subcanvas_width);
	Tcl_SetVar(interp, "subcanvas_width", str, TCL_GLOBAL_ONLY);
	sprintf(str, "%d", subcanvas_height);
	Tcl_SetVar(interp, "subcanvas_height", str, TCL_GLOBAL_ONLY);
	sprintf(str, "%d", appl_x);
	Tcl_SetVar(interp, "appl_x", str, TCL_GLOBAL_ONLY);
	sprintf(str, "%d", appl_y);
	Tcl_SetVar(interp, "appl_y", str, TCL_GLOBAL_ONLY);
}

int 
openfile_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp;
	int argc;
	char *argv[];
{
	char **p;

	if (loaded) {
		/* erase pre-loaded data */
		Tcl_Eval(interp, "eraselines");
		Tcl_Eval(interp, "erasesublines");
		Tcl_Eval(interp, "erasebox");
		if (texton) Tcl_Eval(interp, "erasetexts");
		if (timeon) Tcl_Eval(interp, "erasetimes");
		free(ilt);
		ilt = NULL;
		iltcnt = 0;
	}
	p = argv; p ++;
	load_file(1, p, 1);
	if (loaded) config_loadedfile();
	return TCL_OK;
}
