/*
 * Copyright (C) 2000 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: button.c,v 1.1.1.1 2000/04/20 05:47:19 nishida Exp $
 */

#define SCRL_LIMIT (delay * 3.0)
#define SUBMOVE_RATIO (32.0)
#define MOVE_RATIO (32.0)

#include "tcpillust.h"
static int ratio_cnt;
static int subratio_cnt;
static float barvalue;

int 
zoomout_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	ratio_cnt ++;
	ratio = baseratio * powf(0.875, (float)ratio_cnt);
	reset_showregion();

	draw_canvas();
	draw_rectangle();

	return TCL_OK;
}

int 
zoomin_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	ratio_cnt --;
	ratio = baseratio * powf(0.875, (float)ratio_cnt);
	reset_showregion();

	draw_canvas();
	draw_rectangle();

	return TCL_OK;
}

int 
subzoomin_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	subratio_cnt ++;
	subratio = basesubratio * powf(0.875, (float)subratio_cnt);
	reset_showregion();

	draw_subcanvas();
	draw_rectangle();

	return TCL_OK;
}


int 
subzoomout_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	subratio_cnt --;
	subratio = basesubratio * powf(0.875, (float)subratio_cnt);
	reset_showregion();

	draw_subcanvas();
	draw_rectangle();

	return TCL_OK;
}

int 
scrlbar1_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	if (atoi(argv[1]) > 0)
		forward_clib(cldata, interp, argc, argv);
	else
		back_clib(cldata, interp, argc, argv);

	return TCL_OK;
}


int 
scrlbar2_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	float delta;
	int	value;

	value = atoi(argv[1]);
	delta = (subendtime - substarttime) / SUBMOVE_RATIO;
	if (value < 0){
		if (substarttime - delta + SCRL_LIMIT < 0){
			delta = substarttime + SCRL_LIMIT;
			XBell(Tk_Display(main_tkwin), 0);
		}
		substarttime -= delta;
		subendtime -= delta;
	} else {
		if (substarttime + delta > capendtime + SCRL_LIMIT){
			delta = capendtime + SCRL_LIMIT - substarttime;
			XBell(Tk_Display(main_tkwin), 0);
		}
		substarttime += delta;
		subendtime += delta;
	}
	draw_subcanvas();
	draw_rectangle();
	return TCL_OK;
}

int 
movebar_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	char cmd[256];

	if (argc != 3) return TCL_OK;
	if (strcmp(argv[1], "moveto")) return TCL_OK;

	sprintf(cmd, ".subframe2.canvas yview moveto %s", argv[2]);
	barvalue = atof(argv[2]);
	if (barvalue > 1) barvalue = 1.0;
	if (barvalue < 0) barvalue = 0;

	Tcl_Eval(interp, cmd);
	return TCL_OK;
}

int 
bpress_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	int y, ty;
	float submiddle, tmp;

	y = atoi(argv[2]);
	ty = barvalue * canvas_height * 4 + y;
	submiddle = (float)(subendtime  - substarttime) 
					* ty / canvas_height / 4.0 + substarttime;
	tmp = submiddle - (endtime - starttime) / 2;
	endtime = submiddle + (endtime - starttime) / 2;
	starttime = tmp;

	draw_canvas();
	draw_rectangle();

	return TCL_OK;
}

int 
forward_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	float delta;	
	delta = (endtime - starttime) / MOVE_RATIO;
	if (starttime + delta > capendtime + SCRL_LIMIT){
		delta = capendtime + SCRL_LIMIT - starttime;
		XBell(Tk_Display(main_tkwin), 0);
	}
	starttime += delta;
	endtime += delta;
	draw_canvas();
	draw_rectangle();

	return TCL_OK;
}

int 
back_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	float delta;	
	delta = (endtime - starttime) / MOVE_RATIO;
	if (starttime - delta + SCRL_LIMIT < 0){
		delta = starttime + SCRL_LIMIT;
		XBell(Tk_Display(main_tkwin), 0);
	}
	starttime -= delta;
	endtime -= delta;
	draw_canvas();
	draw_rectangle();

	return TCL_OK;
}

int 
time_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	timeon = atoi(Tcl_GetVar(interp, "timeon", TCL_GLOBAL_ONLY));
	if (timeon){
		config_times();
		Tcl_Eval(interp, "drawtimes");
	} else
		Tcl_Eval(interp, "erasetimes");
	
	return TCL_OK;
}

int 
text_clib(cldata, interp, argc, argv)
	ClientData cldata; 
	Tcl_Interp *interp; 
	int argc;
	char *argv[];
{
	texton = atoi(Tcl_GetVar(interp, "texton", TCL_GLOBAL_ONLY));
	if (texton){
		config_texts();
		Tcl_Eval(interp, "drawtexts");
	} else
		Tcl_Eval(interp, "erasetexts");

	return TCL_OK;
}
