#!/usr/bin/perl -w
#
# $Id: mkhtml.pl,v 1.4 2000/06/29 05:48:45 kjc Exp $
#
# usage: mkhtml.pl < tcpdstat_output
#	mkhtml.pl reads the output of tcpdstat from stdin, and then,
#	create a html file.
#	the name of the output html file is "<id>.html", <id> is extracted
#	from the "Id:" field of the input file.
#	if there is file named a "<id>.dump" or "<id>.dump.gz", a reference
#	is created.
#
#	processing rules
#	 ### string ### --> <H3>string</H3>
#	 <<<< text >>>> --> <PRE>text</PRE>
#

$tmpfile = "tmp.html";

open(HOUT,"> $tmpfile");

print HOUT "<HTML><HEAD>\n";
print HOUT "<TITLE>Traffic Trace Info</TITLE>\n"; 
print HOUT "</HEAD>\n\n";
print HOUT "<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\" LINK=\"#330099\" ALINK=\"#FF9933\" VLINK=\"#6666CC\">\n";
print HOUT "<H3>Traffic Trace Info</H3>\n"; 

$dontformat = 0;
while (<>) {
    chop;

    #	processing rules
    #	 ### string ### --> <H3>string</H3>
    #	 <<<< text >>>> --> <PRE>text</PRE>
    if ($dontformat) {
	if (/^>>>>/) {
	    print HOUT "</PRE>";
	    $dontformat = 0;
	}
	else {
	    # if protocol info, strip level info 
	    if (/^\[\d+\](.*)/) {
		print HOUT $1 . "\n";
	    }
	    else {
		print HOUT $_ . "\n";
	    }
	}
    }
    elsif (/^<<<</) {
	print HOUT "<PRE>";
	$dontformat = 1;	# don't format after this line
    }
    elsif (s/^###\s+(.+)###/$1/) {
	#  if starts with "###", it is a heading
	print HOUT "<H3>" . $_ . "</H3>\n";

	#  special handling after "Protocol"
	if (/^Protocol/) {
	    print HOUT "<IMG SRC=$id.png ALT=\"[protocol breakdown chart]\">\n";
	    print HOUT "<p>";
	}
	#  special handling after "Packet Size Distribution"
	if (/^Packet Size Distribution/) {
	    print HOUT "<IMG SRC=$id.pktlen.png ALT=\"[packet size distribution]\"><br>\n";
	    print HOUT "<A HREF=$id.pktlen.txt>detailed numbers</A><br> \n";
	}
    }
    elsif (/([^:]+):(.*)/) {
	# if ":" exists, use bold typeface
	print HOUT "<b>" . $1 . ":</b>" . $2 . "<br>\n";

	# find Id field
	if (/^Id:\s*(\w+)/) {
	    $id = $1;
	    $outfile = $id . ".html";
	}
    }
    else {
	# just output the original line
	print HOUT $_ . "<br>\n";
    }
}

# if there is a dumpfile, create a link
$dumpfile = "";
if (-r $id . ".dump.gz") {
    $dumpfile = $id . ".dump.gz";
}
elsif (-r $id . ".dump") {
    $dumpfile = $id . ".dump";
}

if ($dumpfile) {
    ($dc, $dc, $dc, $dc, $dc, $dc, $dc, $size) = stat $dumpfile;
    $sizestr = sprintf "%.2f", $size / 1024 / 1024;

    # create anonymous ftp url
    # the path starts at "/pub/" for anon ftp
    chop($hostname = `hostname`);
    chop($cwd = `pwd`);
    if ($cwd =~ /.*(\/pub\/.*)/) {
	$cwd = $1;
    }
    $url = "ftp://" . $hostname . $cwd . "/" . $dumpfile;

    print HOUT "<b>tcpdump file:</b> <A HREF=$url>$dumpfile</A> ($sizestr MB)<br>\n";
}

print HOUT <<EOF;
<P>
</BODY>
</HTML>
EOF

close(HOUT);

rename $tmpfile, $outfile;

exit 0;
