{
(* SwiftSurf
 * Sebastien Ailleret *)

open Lexing
open Confpars

exception Unexpected_eof

let keyword_table = Hashtbl.create 149;;
let keys = [
  "logfile", LOGFILE;
  "port", PORT;
  "connectfrom", CONNECTFROM;
  "profile", PROFILE;
  "endprofile", ENDPROFILE;
  "timeout", TIMEOUT;
  "stats", STATS;
  "debug", DEBUG;
  "methods", METHODS;
  "noconnect", NOCONNECT;
  "allconnect", ALLCONNECT;
  "request", REQUEST;
  "answer", ANSWER;
  "maxconns", MAXCONNS;
  "nextproxy", NEXTPROXY;
  "noproxy", NOPROXY;
  "forbiddenurl", FORBIDDENURL;
  "forbiddenfile", FORBIDDENFILE;
  "allowedurl", ALLOWEDURL;
  "forbiddenreqheader", FORBIDDENREQHEADER;
  "forbiddenansheader", FORBIDDENANSHEADER;
  "addreqheader", ADDREQHEADER;
  "addansheader", ADDANSHEADER;
  "mimetype", MIMETYPE;
  "useragentoverride", USERAGENTOVERRIDE;
  "end", END
] in
List.iter (fun (x, y) -> Hashtbl.add keyword_table x y) keys

let find x =
  try
	Hashtbl.find keyword_table (String.lowercase x)
  with Not_found -> STRING x

let string_for_backslash = function
  | 'n' -> "\n"
  | c -> String.make 1 c
}

let idchar =
  ['A'-'Z' 'a'-'z' '_' '\192'-'\214' '\216'-'\246' '\248'-'\255' '\'' '!' '$' '%' '&' '*' '+' '-' '.' '/' ':' '<' '=' '>' '?' '@' '^' '|' '~']

rule token = parse
| [' ' '\009' '\010' '\012' '\013']
	{ token lexbuf }
| '#' [^'\n'] * '\n'
    { token lexbuf }
| ['0'-'9']+
	{ INT (int_of_string (lexeme lexbuf)) }
| ['0'-'9']+ ('.' ['0'-'9']* )? (['e' 'E'] ['+' '-']? ['0'-'9']+)?
    { FLOAT (float_of_string (lexeme lexbuf)) }
| [^' ' '\009' '\010' '\012' '\013' '"'] *
    { find (lexeme lexbuf) }
| '"'
    { STRING (string lexbuf) }
| eof
	{ EOF }

and string = parse
| '"'
    { "" }
| '\\' ['"' 'n' '\\']
    { let c = lexeme_char lexbuf 1 in
      (string_for_backslash c) ^ string lexbuf }
| eof
    { raise Unexpected_eof }
| _
    { let s = String.make 1 (lexeme_char lexbuf 0) in
      s ^ (string lexbuf) }
