open Types

(* cannot get an authentication *)
exception Auth_failed

(* headers to add to requests *)
val add_req_headers : string ref
val add_ans_headers : string ref

(* port on which the server is listening *)
val port : int ref

(* from where can we connect *)
val connect_from : Str.regexp option ref

(* read the configuration file *)
val init : string -> bool -> unit

(* do we need a proxy for this site *)
val need_proxy : string -> (Unix.sockaddr * string option) option

(* give the profile for this authentication (or raise an exception) *)
val get_profile : string -> profile

(* test if an url is allowed or not *)
val ok_url : string -> profile -> string option

(* test if this line of header is allowed *)
val ok_req_header : string -> bool
val ok_ans_header : string -> bool
