#!/bin/sh
##	
##	prepare.sh
##
##	Last modified: 01/02/02
##	
##	The script gathers various items to allow the installer to be 
##	compiled.
##
##	Remember to use "chmod +x prepare.sh" before running this
##	script. 
##
##	This script is distributed as part of the FreeCraft software package 
##	and is therefore subject to the GNU General Public License.

##	Welcome our user
printf "\nWelcome to the FreeCraft Installer Preparation script\n\n"

##	Make sure all the files required by this script exist
if  [ -e ../build/FreeCraft.app ]
then :
else 
	printf "The FreeCraft application cannot be found and as such this script cannot run.\n\n"
	exit 1
fi
if [ -f /usr/bin/gnutar ]  || [ -f /usr/bin/gunzip ]
then :
else 
	printf "Either gnutar or gunzip is not present in your \"/usr/bin\" directory and as such this script cannot run.\n\n"
	exit 1
fi
if [ -e ../frameworks/build/OggVorbis.framework ]  || [ -e ../frameworks/build/PNG.framework ]
then :
else 
	printf "Either the OggVorbis or PNG framework has not been compiled and placed in the \"build\" folder of the \"frameworks\" directory and as such this script cannot run.\n\n"
	exit 1
fi
if [ -e ../wartool/build/WarTool.app ]
then :
else 
	printf "The WarTool application cannot be found and as such this script cannot run.\n\n"
	exit 1
fi
if [ -e freecraft/data ]
then :
else 
	printf "A fresh copy of the FreeCraft's \"data\" folder cannot be found at \"freecraft/data\" and as such this script cannot run.\n\n"
	exit 1
fi


##	Move the tools into place
printf "Copying the tools into place...\n"
if [ -e tools ]
then :
else
	mkdir tools
fi
if [ -f tools/gnutar ]
then :
else
	cp /usr/bin/gnutar tools/gnutar
fi
if [ -f tools/gunzip ]
then :
else
	cp /usr/bin/gunzip tools/gunzip
fi

##	Move FreeCraft into place
printf "Copying FreeCraft into place...\n"
if [ -e resources ]
then :
else
	mkdir resources
fi
if [ -e resources/FreeCraft.app ]
then :
else
	mv ../build/FreeCraft.app/Contents/Resources/data /tmp/data
	cp -R ../build/FreeCraft.app resources
	mv /tmp/data ../build/FreeCraft.app/Contents/Resources/data
fi

##	Move data folder into place
printf "Copying data into place...\n"
if [ -e resources/data ]
then :
else
	cp -R freecraft/data resources/data
fi

##  Move WarTool into place
printf "Copying WarTool into place...\n"
if [ -e resources/WarTool.app ]
then :
else
	cp -R ../wartool/build/WarTool.app resources
fi

##	Move frameworks into place
printf "Copying frameworks into place...\n"
if [ -e resources/OggVorbis.framework ]
then :
else
	cp -R -P ../frameworks/build/OggVorbis.framework resources
	rm -r resources/OggVorbis.framework/Versions/A/Headers
	rm resources/OggVorbis.framework/Headers
fi
if [ -e resources/PNG.framework ]
then :
else
	cp -R -P ../frameworks/build/PNG.framework resources
	rm -r resources/PNG.framework/Versions/A/Headers
	rm resources/PNG.framework/Headers
fi

##	All done
printf "\nFreeCraft's Installer is now ready to be compiled.\n\n"
exit 0
