#define SIMDE_TEST_X86_AVX512_INSN bitshuffle

#include <test/x86/avx512/test-avx512.h>
#include <simde/x86/avx512/bitshuffle.h>

static int
test_simde_mm_bitshuffle_epi64_mask (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  static const struct {
    const int64_t b[2];
    const int64_t c[2];
    const simde__mmask16 r;
  } test_vec[] = {
    { { -INT64_C( 5804274169211770984),  INT64_C( 1811127749735916979) },
      { -INT64_C( 3307710871945461515), -INT64_C( 6257706525836889001) },
      UINT16_C(59753) },
    { {  INT64_C( 1685571549138473296), -INT64_C( 6831978591596756737) },
      {  INT64_C( 3061993457926679855), -INT64_C( 3435932602296084586) },
      UINT16_C(40744) },
    { { -INT64_C( 7932269877341570962), -INT64_C( 2992686315798481109) },
      { -INT64_C( 5115244597806448379), -INT64_C( 8887939532714805161) },
      UINT16_C(32071) },
    { {  INT64_C( 4831588449147825642), -INT64_C( 7893524209444735497) },
      {  INT64_C( 5561784970141955666),  INT64_C( 3242533743124320357) },
      UINT16_C(53889) },
    { { -INT64_C( 8262778660660423175),  INT64_C( 5875684581292338539) },
      { -INT64_C( 3974155768042097259), -INT64_C( 4470312149981070201) },
      UINT16_C(38645) },
    { { -INT64_C( 4559008054794609001),  INT64_C( 2009524104003643027) },
      {  INT64_C( 2837971042963008056),  INT64_C( 9152976798180550012) },
      UINT16_C(15722) },
    { { -INT64_C( 8026989045841340539), -INT64_C( 3607658635433192882) },
      { -INT64_C( 7892617624756382033), -INT64_C( 3037999764792252304) },
      UINT16_C(33764) },
    { {  INT64_C( 4053039461975425970),  INT64_C( 1729096827091575451) },
      { -INT64_C( 6828901580093823342), -INT64_C( 7103355376489721785) },
      UINT16_C(54687) },

  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m128i b = simde_x_mm_loadu_epi64(test_vec[i].b);
    simde__m128i c = simde_x_mm_loadu_epi64(test_vec[i].c);
    simde__mmask16 r = simde_mm_bitshuffle_epi64_mask(b, c);
    simde_assert_equal_mmask16(r, test_vec[i].r);
  }

  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    simde__m128i b = simde_test_x86_random_i64x2();
    simde__m128i c = simde_test_x86_random_i64x2();
    simde__mmask16 r = simde_mm_bitshuffle_epi64_mask(b, c);

    simde_test_x86_write_i64x2(2, b, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_x86_write_i64x2(2, c, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_x86_write_mmask16(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

static int
test_simde_mm_mask_bitshuffle_epi64_mask (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  static const struct {
    const simde__mmask16 k;
    const int64_t b[2];
    const int64_t c[2];
    const simde__mmask16 r;
  } test_vec[] = {
    { UINT16_C(30485),
      { -INT64_C( 8989397971717338499),  INT64_C( 8999825171446646890) },
      { -INT64_C( 4257227189317468078), -INT64_C( 6363315612271134672) },
      UINT16_C(29972) },
    { UINT16_C(56257),
      {  INT64_C( 2476562462042418647), -INT64_C( 4406137637422780940) },
      { -INT64_C( 1425040687483762795), -INT64_C( 2233323576689990794) },
      UINT16_C( 4928) },
    { UINT16_C( 7057),
      {  INT64_C( 1442159189481685751), -INT64_C(  247720041555612307) },
      {  INT64_C( 7640269389479713387), -INT64_C( 1444635185821904170) },
      UINT16_C( 5008) },
    { UINT16_C(37537),
      {  INT64_C( 3418677257318090305), -INT64_C( 7564492263328685605) },
      {  INT64_C(  307403617810746410),  INT64_C( 7168117773147781109) },
      UINT16_C(36865) },
    { UINT16_C(41227),
      {  INT64_C( 3421064545449665960), -INT64_C( 5256580995054446469) },
      { -INT64_C( 6229101680536583663), -INT64_C( 4913997757637808207) },
      UINT16_C( 8200) },
    { UINT16_C(  734),
      { -INT64_C( 2943228652968283180),  INT64_C( 2457778255130170893) },
      { -INT64_C( 5090582930717466339), -INT64_C(  245286576178631223) },
      UINT16_C(  206) },
    { UINT16_C(43652),
      {  INT64_C( 3749604569852192331),  INT64_C( 7249697505409783391) },
      { -INT64_C( 3203244470652803132), -INT64_C(  314432081966550176) },
      UINT16_C(  644) },
    { UINT16_C(55952),
      {  INT64_C( 4453355525670702445), -INT64_C( 6125990977961769479) },
      {  INT64_C( 6158625146005626169), -INT64_C( 8121732710478698804) },
      UINT16_C(  144) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m128i b = simde_x_mm_loadu_epi64(test_vec[i].b);
    simde__m128i c = simde_x_mm_loadu_epi64(test_vec[i].c);
    simde__mmask16 r = simde_mm_mask_bitshuffle_epi64_mask(test_vec[i].k, b, c);
    simde_assert_equal_mmask16(r, test_vec[i].r);
  }

  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    simde__mmask16 k = simde_test_x86_random_mmask16();
    simde__m128i b = simde_test_x86_random_i64x2();
    simde__m128i c = simde_test_x86_random_i64x2();
    simde__mmask16 r = simde_mm_mask_bitshuffle_epi64_mask(k, b, c);

    simde_test_x86_write_mmask16(2, k, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_x86_write_i64x2(2, b, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_x86_write_i64x2(2, c, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_x86_write_mmask16(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

static int
test_simde_mm256_bitshuffle_epi64_mask (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  static const struct {
    const int64_t b[4];
    const int64_t c[4];
    const simde__mmask32 r;
  } test_vec[] = {
    { { -INT64_C( 6416610632366285266), -INT64_C( 4296626462402829714), -INT64_C( 4822767955139551220),  INT64_C( 3196861934163039888) },
      {  INT64_C( 4246193833254006182),  INT64_C( 4172532472068824100),  INT64_C( 6036542875004087536), -INT64_C( 5270762907584395343) },
      UINT32_C(4130500528) },
    { {  INT64_C( 1130660703992834474), -INT64_C( 2221371989242535482),  INT64_C(  134175948871972294),  INT64_C( 2737496406304488759) },
      { -INT64_C( 6201936194761393677),  INT64_C(   17671601560232300),  INT64_C( 1174989631990081789),  INT64_C( 8863739963424374371) },
      UINT32_C(1429761394) },
    { {  INT64_C( 6113999230724644173),  INT64_C( 4298105571236738410), -INT64_C(  647999836657209832), -INT64_C(  443085953010673451) },
      { -INT64_C( 1823391066457754763),  INT64_C( 7850390236579980153),  INT64_C( 2948272620725697374),  INT64_C(  890410455133503414) },
      UINT32_C(3757435834) },
    { {  INT64_C(  213106832853009810),  INT64_C( 1098504135062945919), -INT64_C( 5790805614607033561),  INT64_C( 1895854395859478700) },
      {  INT64_C( 6015998575185082610),  INT64_C(  675087917305378463), -INT64_C(  457074345349259009),  INT64_C( 1868865373579557454) },
      UINT32_C(3031133573) },
    { { -INT64_C( 2996562574233495485), -INT64_C(  921965839473340343),  INT64_C( 3038405671577761764),  INT64_C( 3859567226025698895) },
      { -INT64_C( 9217259614430813176), -INT64_C( 6688162388460750265), -INT64_C(   27584889388524650), -INT64_C( 7742808658547466907) },
      UINT32_C(  54595726) },
    { { -INT64_C( 2963112852307322839),  INT64_C(   37225524712540963), -INT64_C( 4825027179950483109), -INT64_C( 5994959043501457492) },
      { -INT64_C( 5989808906089750151), -INT64_C( 8367386631525699465),  INT64_C( 1189408126946137195), -INT64_C( 5814404169988467425) },
      UINT32_C(2489305351) },
    { { -INT64_C( 4544811211862614857), -INT64_C(  485399685836473465), -INT64_C( 7401034342937536041),  INT64_C( 7041532679321064403) },
      { -INT64_C( 8218910963690999576), -INT64_C( 1399625432834928117),  INT64_C( 7022644052330172513),  INT64_C( 2670673326856974596) },
      UINT32_C(3049208170) },
    { {  INT64_C( 5631547110921253523),  INT64_C( 6258168349589990616),  INT64_C( 8483275853846872266), -INT64_C( 2541380078376049320) },
      {  INT64_C( 3492433033732428262), -INT64_C( 6677439831840301558), -INT64_C( 8872735388993812745),  INT64_C( 2089623176322089435) },
      UINT32_C(4228329355) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m256i b = simde_x_mm256_loadu_epi64(test_vec[i].b);
    simde__m256i c = simde_x_mm256_loadu_epi64(test_vec[i].c);
    simde__mmask32 r = simde_mm256_bitshuffle_epi64_mask(b, c);
    simde_assert_equal_mmask32(r, test_vec[i].r);
  }

  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    simde__m256i b = simde_test_x86_random_i64x4();
    simde__m256i c = simde_test_x86_random_i64x4();
    simde__mmask32 r = simde_mm256_bitshuffle_epi64_mask(b, c);

    simde_test_x86_write_i64x4(2, b, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_x86_write_i64x4(2, c, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_x86_write_mmask32(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

static int
test_simde_mm256_mask_bitshuffle_epi64_mask (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  static const struct {
    const simde__mmask32 k;
    const int64_t b[4];
    const int64_t c[4];
    const simde__mmask32 r;
  } test_vec[] = {
    { UINT32_C(2733643515),
      { -INT64_C( 6817691006235506789),  INT64_C( 5224206744940694077),  INT64_C( 6393274888083210630), -INT64_C( 4432178479373676320) },
      {  INT64_C( 7101028885072606148), -INT64_C( 7972527983419986249),  INT64_C( 6188378500900125669),  INT64_C( 3495829513595563674) },
      UINT32_C(2161116337) },
    { UINT32_C(1176112417),
      { -INT64_C( 6934685168461895943), -INT64_C( 8188106961562099984),  INT64_C( 6477606647801003914),  INT64_C( 7938055544941144258) },
      { -INT64_C( 3639503481303215799),  INT64_C( 4010457311144553728),  INT64_C( 7027656795956677441), -INT64_C(  176645665021751128) },
      UINT32_C(  33686561) },
    { UINT32_C( 484158271),
      { -INT64_C( 5501554839791183731),  INT64_C( 8790541428278840974),  INT64_C( 5353688786945148294),  INT64_C( 1218262748178667661) },
      { -INT64_C( 1282324816906562949), -INT64_C( 1448264190157578606),  INT64_C( 7863679540233158977),  INT64_C(  563832362005784639) },
      UINT32_C( 407577104) },
    { UINT32_C(1418227956),
      {  INT64_C( 4590293758184176820),  INT64_C( 4310864425892092347), -INT64_C( 1680719672231005014), -INT64_C( 6607774680702025980) },
      {  INT64_C( 5281770795954834995),  INT64_C( 7335546557653415480),  INT64_C( 6652091907240261132), -INT64_C( 1653487683351855239) },
      UINT32_C(1342177380) },
    { UINT32_C(3187144751),
      {  INT64_C( 8386067246833091478), -INT64_C(  227387094465958301),  INT64_C( 2163325860832618530), -INT64_C( 6900641583502716338) },
      { -INT64_C( 1120885523994427070), -INT64_C( 7665345975742870786), -INT64_C(  871667917216679840),  INT64_C( 3527070498258218824) },
      UINT32_C(3020947467) },
    { UINT32_C(2049794541),
      {  INT64_C( 6616855376130907697),  INT64_C( 1093004075394429442), -INT64_C( 1157017178457632169),  INT64_C( 8540317227312800542) },
      { -INT64_C( 4814777108290670357), -INT64_C( 7609311784995905812), -INT64_C(  410066317430396834), -INT64_C( 6357521658067718390) },
      UINT32_C( 403456109) },
    { UINT32_C( 897215611),
      {  INT64_C(  515682806764055013), -INT64_C( 3306816444693639586), -INT64_C( 7686850883966178567),  INT64_C( 7569908329854277724) },
      {  INT64_C( 8083507310795423584), -INT64_C( 7441838157149188879), -INT64_C( 5538884006917143118),  INT64_C( 8427528016708197638) },
      UINT32_C( 893013001) },
    { UINT32_C(2845585303),
      {  INT64_C( 3848965344288426642),  INT64_C(   56975220448044173),  INT64_C( 6767009499471735640), -INT64_C( 7054767816597905961) },
      {  INT64_C(  289510722262610232), -INT64_C( 7684815261307514192),  INT64_C( 2639071230567911161),  INT64_C( 1758280582637449659) },
      UINT32_C( 688926343) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m256i b = simde_x_mm256_loadu_epi64(test_vec[i].b);
    simde__m256i c = simde_x_mm256_loadu_epi64(test_vec[i].c);
    simde__mmask32 r = simde_mm256_mask_bitshuffle_epi64_mask(test_vec[i].k, b, c);
    simde_assert_equal_mmask32(r, test_vec[i].r);
  }

  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    simde__mmask32 k = simde_test_x86_random_mmask32();
    simde__m256i b = simde_test_x86_random_i64x4();
    simde__m256i c = simde_test_x86_random_i64x4();
    simde__mmask32 r = simde_mm256_mask_bitshuffle_epi64_mask(k, b, c);

    simde_test_x86_write_mmask32(2, k, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_x86_write_i64x4(2, b, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_x86_write_i64x4(2, c, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_x86_write_mmask32(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

static int
test_simde_mm512_bitshuffle_epi64_mask (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  static const struct {
    const int64_t b[8];
    const int64_t c[8];
    const simde__mmask64 r;
  } test_vec[] = {
    { {  INT64_C( 2471821034218299553), -INT64_C( 3684140258718499802), -INT64_C( 1192575525434803458), -INT64_C( 2845146627403216708),
         INT64_C( 4820972678489599907), -INT64_C( 7960568004213586491),  INT64_C(  246522908604574108), -INT64_C( 3680854691111622693) },
      {  INT64_C( 8486885821865076329),  INT64_C( 5180184843323918782), -INT64_C( 1069271668632632609),  INT64_C(  309884821705039958),
         INT64_C( 1529623357040483604), -INT64_C(  104909767672698471), -INT64_C( 3129352485292716148), -INT64_C( 7454407891633334546) },
      UINT64_C( 2001869299691501948) },
    { { -INT64_C(    6588935847471747),  INT64_C( 2602745886949986048),  INT64_C( 9182937022632182558), -INT64_C( 2302583629634092050),
        -INT64_C(   67944325069969239),  INT64_C( 4514926935798665707), -INT64_C( 5363423466641265023), -INT64_C( 3003564310021040114) },
      { -INT64_C( 8387404959898598246),  INT64_C( 8620936380602628164), -INT64_C( 2981353503071830491), -INT64_C( 7659047388018390861),
        -INT64_C( 3257853445995062627), -INT64_C( 5409145792726837120),  INT64_C( 5041569304238061400),  INT64_C( 8401424246871703304) },
      UINT64_C( 9973792270588985470) },
    { {  INT64_C(  996557263121598068),  INT64_C( 4509918408531512147),  INT64_C( 9061337512850437609),  INT64_C( 3738295276637578645),
         INT64_C( 7023373576417154013),  INT64_C( 6357069944701844500), -INT64_C( 9006472556930951409),  INT64_C( 8605201969036952185) },
      { -INT64_C( 4623689754290773659),  INT64_C(   80486393364158551), -INT64_C(   74160386579500664),  INT64_C( 2241281587544516617),
        -INT64_C( 5932252986103104446), -INT64_C( 2417429874006071936), -INT64_C( 8573643677860890495),  INT64_C( 2165464910537701940) },
      UINT64_C( 4518225354379621700) },
    { { -INT64_C( 8699064386959204286), -INT64_C( 3796415418860979940),  INT64_C( 2625271962939860069),  INT64_C( 2597205764826438417),
        -INT64_C( 1490968764970362944),  INT64_C( 1932799282631231933), -INT64_C( 8329848985091070894),  INT64_C( 6489269913981122825) },
      { -INT64_C( 8334629300214772837), -INT64_C( 5581255848315604293),  INT64_C(   76943791599421962), -INT64_C( 6140101677045478700),
         INT64_C( 1738786781795773382),  INT64_C( 2534985739952305179),  INT64_C( 5951710860931507102),  INT64_C( 5043057962202006595) },
      UINT64_C( 4722932875686266173) },
    { { -INT64_C( 7715797035905314699),  INT64_C( 2876744118687528111), -INT64_C( 7984224292596444062), -INT64_C(  891748471707274277),
         INT64_C( 2593424073967434223), -INT64_C( 5848531816718594778), -INT64_C( 4230074211088034964), -INT64_C(  133491645757837388) },
      { -INT64_C( 4409477460607440073), -INT64_C(  185695892866483855),  INT64_C( 8109015609539820250), -INT64_C( 7116031119213811663),
         INT64_C( 8723778178122294450), -INT64_C( 6747057685239790897),  INT64_C( 5244704649619313821), -INT64_C( 2046105162677196137) },
      UINT64_C(10301411299887729343) },
    { { -INT64_C( 3968722437256584597),  INT64_C( 7075303197633946309),  INT64_C( 2160183585808225946), -INT64_C( 5475614871269965075),
         INT64_C( 4348246844466738328), -INT64_C( 6819300823566483147), -INT64_C( 8704246855605479536), -INT64_C( 7148152673485303857) },
      {  INT64_C( 4364415776144094173), -INT64_C( 1824077330558592250),  INT64_C( 2218920358428017322), -INT64_C(  567450136331455873),
        -INT64_C( 2793955992225886729), -INT64_C( 5947401315836006342),  INT64_C( 2451572984330154648),  INT64_C( 3981964099476405294) },
      UINT64_C(18021963348947303291) },
    { { -INT64_C( 6214564588190134508), -INT64_C( 2986256818298574626),  INT64_C( 7703339249600134945),  INT64_C( 7599531163429080575),
        -INT64_C(  676647045153379707), -INT64_C( 6427369471419624007),  INT64_C( 5515310085366778596), -INT64_C( 5144235354944225825) },
      { -INT64_C( 5135712166004134485), -INT64_C( 2573668684502429155), -INT64_C( 2044486877662367225), -INT64_C( 2833130109880882237),
        -INT64_C( 4659441508022461792), -INT64_C( 8449692416983628056),  INT64_C(   91056323367516252), -INT64_C( 6003397204168386133) },
      UINT64_C( 1880413290879393199) },
    { { -INT64_C( 8475033828878234880), -INT64_C( 3912178450996477017), -INT64_C( 4747238127869258530), -INT64_C( 4792316276186409275),
         INT64_C( 1350448129448593809),  INT64_C( 3295493973237115013),  INT64_C( 1538092868613825670), -INT64_C( 4253818952810500483) },
      { -INT64_C( 7084807521500178897),  INT64_C( 7086496323151588061), -INT64_C( 8677500756762582482),  INT64_C( 1169168856762121025),
        -INT64_C( 4340527870340550386), -INT64_C( 3855002545169739198),  INT64_C( 1187222762470013929),  INT64_C(   92534839412341335) },
      UINT64_C( 4013128626473371619) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i b = simde_mm512_loadu_epi64(test_vec[i].b);
    simde__m512i c = simde_mm512_loadu_epi64(test_vec[i].c);
    simde__mmask64 r = simde_mm512_bitshuffle_epi64_mask(b, c);
    simde_assert_equal_mmask64(r, test_vec[i].r);
  }

  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    simde__m512i b = simde_test_x86_random_i64x8();
    simde__m512i c = simde_test_x86_random_i64x8();
    simde__mmask64 r = simde_mm512_bitshuffle_epi64_mask(b, c);

    simde_test_x86_write_i64x8(2, b, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_x86_write_i64x8(2, c, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_x86_write_mmask64(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

static int
test_simde_mm512_mask_bitshuffle_epi64_mask (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  static const struct {
    const simde__mmask64 k;
    const int64_t b[8];
    const int64_t c[8];
    const simde__mmask64 r;
  } test_vec[] = {
    { UINT64_C(10625095675512826195),
      {  INT64_C(  719931985869742341), -INT64_C( 4697165564092759362), -INT64_C( 3042309628981968547),  INT64_C( 3855445425231774644),
         INT64_C( 3083236680050521708), -INT64_C( 8923222789645085027),  INT64_C( 3472326424347013593), -INT64_C( 4623333885426726799) },
      {  INT64_C( 3164702941110055764), -INT64_C( 6572509102380453090), -INT64_C( 3432253784447831886),  INT64_C( 7946961196789365559),
         INT64_C( 3509458672246835706), -INT64_C( 4684801289627546739),  INT64_C( 7033578265733036910),  INT64_C( 5714562516335136198) },
      UINT64_C( 1247510325305223427) },
    { UINT64_C( 2611960889331973629),
      {  INT64_C( 6963542433455715544), -INT64_C( 6845812442779578509),  INT64_C( 1980121615156963798), -INT64_C( 5329893752978124212),
         INT64_C( 8101763511272309789),  INT64_C( 4271396402318187725), -INT64_C( 2148251562040440842), -INT64_C( 2177545657109882318) },
      {  INT64_C( 7980203306375995986), -INT64_C( 3414751224940605956),  INT64_C( 1629199034015286052), -INT64_C( 9145986006780517779),
         INT64_C( 6800312716990874193), -INT64_C(  718503557594122915),  INT64_C( 7807075712777710431), -INT64_C( 4656529123968188497) },
      UINT64_C( 2313865144952708237) },
    { UINT64_C( 2194115864921387442),
      { -INT64_C( 1347317847581904251), -INT64_C(  309472613171659191), -INT64_C( 5533451689679760888),  INT64_C( 8812203020101674348),
         INT64_C( 5253765624623112557), -INT64_C( 6168448650267584227), -INT64_C( 1852292836706205802), -INT64_C( 4851960859119643846) },
      { -INT64_C( 5167984356002071552), -INT64_C( 5618373454230005829), -INT64_C( 5321118974299461690), -INT64_C( 7299049001273902167),
        -INT64_C( 4007956219580224499), -INT64_C( 3420716971222269255),  INT64_C( 1262758768325808723),  INT64_C(  768072631009766515) },
      UINT64_C( 1589771497729163680) },
    { UINT64_C(15924467849384575529),
      { -INT64_C( 6525934312302238315),  INT64_C( 3207964504712577035),  INT64_C( 8462229938772741735), -INT64_C( 3881070212834123485),
         INT64_C( 1857690926532122064), -INT64_C( 7116795486760322216),  INT64_C( 8889947712343078558), -INT64_C( 8678183908761531502) },
      {  INT64_C( 3017817271632001466),  INT64_C( 2053208767444184491), -INT64_C( 9025383045619351316),  INT64_C( 2427116281968296304),
         INT64_C( 8272773623851866067),  INT64_C( 7769785223810910264), -INT64_C( 5781093328662570670), -INT64_C( 4938613807957799185) },
      UINT64_C( 1452977133207028265) },
    { UINT64_C( 7139662449696792795),
      { -INT64_C( 8205579155365271243),  INT64_C( 3149588698955370182), -INT64_C( 1492671626007770203),  INT64_C(  785213847459768151),
        -INT64_C( 5488236563995361524), -INT64_C( 2156541158908975445), -INT64_C( 2164903717366688775),  INT64_C( 3548352881027678814) },
      { -INT64_C( 8797976647954727864),  INT64_C(  438114758419128565), -INT64_C( 7458800758082796782),  INT64_C( 8204725270247956614),
        -INT64_C( 7321008400666110458),  INT64_C( 7296359515095356205), -INT64_C( 2651072804249579421),  INT64_C( 1367233962581623135) },
      UINT64_C(  144433084950134937) },
    { UINT64_C( 6483591561181568955),
      {  INT64_C(  712646977607943723), -INT64_C( 4371628117980683227), -INT64_C(  289843080934466595),  INT64_C( 8172156753956040164),
        -INT64_C(  663486196739998693),  INT64_C( 2944725558215274678),  INT64_C( 5898039228516870303), -INT64_C( 6507760241426221576) },
      {  INT64_C( 2778211280285507271),  INT64_C( 6995248839942798752),  INT64_C( 2955798630713271622), -INT64_C(  540407551894264240),
        -INT64_C( 5167003062730954828), -INT64_C( 1207324610381182181), -INT64_C( 1569320194304475426),  INT64_C( 7725720334833655822) },
      UINT64_C( 5211227908339698994) },
    { UINT64_C(   71172372363724588),
      {  INT64_C( 3962634787169869926),  INT64_C( 6205254710149357722),  INT64_C( 6070795298456068638),  INT64_C( 1114804363367862163),
         INT64_C(  847552428900242996), -INT64_C( 6531525099592414787),  INT64_C( 5745389968482234431),  INT64_C( 2108036367086212232) },
      {  INT64_C( 4112469789214662549), -INT64_C( 1323326363641425546),  INT64_C( 6743031950746066057),  INT64_C( 3488547647991470947),
        -INT64_C(  584261234674166993),  INT64_C( 4915282873976890011), -INT64_C(  151682467189126477),  INT64_C( 8233339069926044536) },
      UINT64_C(   31739481967526912) },
    { UINT64_C( 6790304276357675461),
      {  INT64_C( 8872898070671995171),  INT64_C( 4683155133226527591), -INT64_C( 4823190305873181093),  INT64_C( 5849963911285255438),
         INT64_C( 1923971296000988784), -INT64_C(  431192594146674948), -INT64_C(  426247757169666209), -INT64_C( 4010742066948859690) },
      { -INT64_C( 3125299303652751662),  INT64_C( 3603897656551193450),  INT64_C( 2007091702120750068),  INT64_C( 8419046991809521335),
        -INT64_C(  745176912477169668), -INT64_C( 3361372122491502508),  INT64_C( 4250426646386042013), -INT64_C( 8122207208180474830) },
      UINT64_C( 1166434231930652677) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i b = simde_mm512_loadu_epi64(test_vec[i].b);
    simde__m512i c = simde_mm512_loadu_epi64(test_vec[i].c);
    simde__mmask64 r = simde_mm512_mask_bitshuffle_epi64_mask(test_vec[i].k, b, c);
    simde_assert_equal_mmask64(r, test_vec[i].r);
  }

  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    simde__mmask64 k = simde_test_x86_random_mmask64();
    simde__m512i b = simde_test_x86_random_i64x8();
    simde__m512i c = simde_test_x86_random_i64x8();
    simde__mmask64 r = simde_mm512_mask_bitshuffle_epi64_mask(k, b, c);

    simde_test_x86_write_mmask64(2, k, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_x86_write_i64x8(2, b, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_x86_write_i64x8(2, c, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_x86_write_mmask64(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

SIMDE_TEST_FUNC_LIST_BEGIN
  SIMDE_TEST_FUNC_LIST_ENTRY(mm_bitshuffle_epi64_mask)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm_mask_bitshuffle_epi64_mask)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm256_bitshuffle_epi64_mask)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm256_mask_bitshuffle_epi64_mask)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_bitshuffle_epi64_mask)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_bitshuffle_epi64_mask)
SIMDE_TEST_FUNC_LIST_END

#include <test/x86/avx512/test-avx512-footer.h>
