# $NetBSD$

# PROVIDE: screws
# REQUIRE: DAEMON LOGIN

. /etc/rc.subr

name="screws"
stop_cmd="screws_stop"
rcvar=$name
command="/usr/pkg/sbin/screwsd"
required_files="/usr/pkg/etc/screws.conf"
command_args=" -d > /dev/null"

#extracted from screwsctl
screws_stop()
{
	printf "Stopping screws."
	if [ -e "/proc/1/status" ]; then
		cd /proc
		for A in * ; do
			if [ -e "$A/status" ]; then
				if [ ! "" = "`cat $A/status | grep screwsd`" ]; then
					PIDS="$PIDS $A" ; 
				fi
			fi
		done
		cd -
	else
		PIDS="`ps -cax | grep screwsd | awk '{print $1}'`"
	fi
	for A in ${PIDS} ; do
		kill -2 $A > /dev/null 2>&1
	done
}

load_rc_config $name
run_rc_command "$1"
