/*	BSDI $Id: rune.h,v 1.1 1998/06/11 09:56:47 itojun Exp $	*/

/*-
 * Copyright (c) 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Paul Borman at Krystal Technologies.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)rune.h	8.1 (Berkeley) 6/27/93
 */

#ifndef	_RUNE_H_
#define	_RUNE_H_

#include <runetype.h>
#include <stdio.h>

#ifndef __bsdi__
# ifdef  _BSD_RUNE_T_
typedef _BSD_RUNE_T_	rune_t;
#  undef  _BSD_RUNE_T_
# endif
#else
# ifdef _BSD_WCHAR_T_
typedef _BSD_WCHAR_T_	wchar_t;
typedef _BSD_RUNE_T_	rune_t;
#  undef _BSD_WCHAR_T_
# endif
#endif

#ifdef _BSD_MBSTATE_T_
struct _mbstate_t {
	u_char hoge[32];
};
typedef	_BSD_MBSTATE_T_	mbstate_t;
#undef _BSD_MBSTATE_T_
#endif

#define _INVALID_RUNE   _CurrentRuneLocale->invalid_rune

#define __sgetrune      _CurrentRuneLocale->sgetrune
#define __sputrune      _CurrentRuneLocale->sputrune
#define __rune_initstate	_CurrentRuneLocale->initstate
#define __rune_sizestate	_CurrentRuneLocale->sizestate
#define __rune_packstate	_CurrentRuneLocale->packstate
#define __rune_unpackstate	_CurrentRuneLocale->unpackstate

#define sgetrune(s, n, r, st)       (*__sgetrune)((s), (n), (r), (st))
#define sputrune(c, s, n, r, st)    (*__sputrune)((c), (s), (n), (r), (st))

__BEGIN_DECLS
char	*mbrune __P((const char *, rune_t));
char	*mbrrune __P((const char *, rune_t));
char	*mbmb __P((const char *, char *));
long	 fgetrune __P((FILE *));
int	 fputrune __P((rune_t, FILE *));
int	 fungetrune __P((rune_t, FILE *));
int	 setrunelocale __P((char *));
void	 setinvalidrune __P((rune_t));

extern int __mb_cur_max;
__END_DECLS

#endif	/*! _RUNE_H_ */
