/*--------------------------------------------------------
  simplib.h - Set of functions for hashes, doubly linked-lists,
                     and memory malloc'ing.  See simplib.c.

--------------------------------------------------------*/


/*--------------------------------------------------------

REALNETWORKS LICENSE AGREEMENT AND WARRANTY 
             DISCLAIMER

_____________________________________________

Free Real-Time Streaming Protocol (RTSP) Firewall 
             Proxy License

IMPORTANT -- READ CAREFULLY: This RealNetworks 
License Agreement ("License Agreement") is a legal 
agreement between you (either an individual or an 
entity) and RealNetworks, Inc.  and its suppliers and 
licensors collectively ("RN") for the software product 
listed above, which includes computer software and 
associated media and printed material, whether provided 
in a physical form or received on-line form ("Software").  
By clicking on the "Accept" button or opening the 
package, you are consenting to be bound by this Agreement.  
If you do not agree to all of the terms of this agreement, 
click the "Do Not Accept" button and, if you received the 
Software by package, return the product to the place of 
purchase.

__________________________________________________________

1. GRANT OF LICENSE.

Subject to the provisions contained in this License Agreement, 
RN hereby grants you a non-exclusive, non-transferable, 
perpetual, worldwide license to use, modify or redistribute the 
Software subject to the following terms and conditions:

(a) The copyright notice (" 1998 RealNetworks, 
Inc.") and this copy of  this License Agreement shall 
appear on all copies and/or any derivative versions 
of the Software you create or distribute.

(b)	You acknowledge and agree that RN is and shall be 
the exclusive owner of all right, title and interest, 
including copyright, in the Software.

All rights not expressly granted to you are reserved to RN.

2.  SOFTWARE MAINTENANCE AND UPGRADES. 

RN is not obligated to provide maintenance or updates to you 
for the Software. However, any maintenance or updates 
provided by RN shall be covered by this Agreement.

3.  DISCLAIMER OF WARRANTY.

The Software is deemed accepted by you.  Because RN is 
providing you the Software for free, the Software is provided 
to you AS IS, WITHOUT WARRANTY OF ANY KIND. TO 
THE MAXIMUM EXTENT PERMITTED BY 
APPLICABLE LAW, REALNETWORKS FURTHER 
DISCLAIMS ALL
WARRANTIES, INCLUDING WITHOUT LIMITATION 
ANY IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE, AND NONINFRINGEMENT. THE ENTIRE 
RISK ARISING OUT OF THE USE OR PERFORMANCE 
OF THE SOFTWARE REMAINS WITH YOU. TO THE 
MAXIMUM EXTENT PERMITTED BY APPLICABLE 
LAW, IN NO
EVENT SHALL REALNETWORKS OR ITS SUPPLIERS 
BE LIABLE FOR ANY CONSEQUENTIAL, INCIDENTAL, 
DIRECT, INDIRECT, SPECIAL, PUNITIVE, OR OTHER 
DAMAGES WHATSOEVER (INCLUDING, WITHOUT 
LIMITATION, DAMAGES FOR LOSS OF BUSINESS 
PROFITS, BUSINESS INTERRUPTION, LOSS OF 
BUSINESS INFORMATION, OR OTHER PECUNIARY 
LOSS) ARISING OUT OF THIS AGREEMENT OR THE 
USE OF OR INABILITY TO USE THE SOFTWARE, EVEN 
IF REALNETWORKS HAS BEEN ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGES. BECAUSE SOME 
STATES/JURISDICTIONS DO NOT ALLOW THE 
EXCLUSION OR LIMITATION OF LIABILITY FOR 
CONSEQUENTIAL OR INCIDENTAL DAMAGES, THE 
ABOVE LIMITATION MAY NOT APPLY TO YOU.

4. INDEMNIFICATION. 

You hereby agree to defend, indemnify, and hold RN, its 
directors, officers, employees and agents, harmless from any 
and all claims, damages, and expenses (including attorneys 
fees and costs) of any nature arising out of the use, 
modification, or redistribution the Software or any derivative 
versions thereof.

5. U.S. GOVERNMENT RESTRICTED RIGHTS AND 
EXPORT RESTRICTIONS. 

The Software is provided with RESTRICTED RIGHTS. Use, 
duplication, or disclosure by the Government is subject to 
restrictions as set forth in subparagraph (a) through (d) of the 
of the Commercial Computer Software-Restricted Rights at 
FAR 52.227-19, as applicable, or subparagraph (c)(1)(ii) of 
The Rights in Technical Data and Computer Software clause 
of DFARS 252.227-7013, and in similar clauses in the NASA 
FAR supplement, as applicable.  Manufacturer is 
RealNetworks, Inc., 1111 Third Avenue, Suite 500, Seattle, 
Washington 98101.  You acknowledge that none of the 
Software or underlying information or technology may be 
downloaded or otherwise exported or re-exported (i) into (or 
to a national or resident of) Cuba, Iraq, Libya, Yugoslavia, 
North Korea, Iran, Syria, Sudan or Angola or any other 
country to which the U.S. has embargoed goods; or (ii) to 
anyone on the U.S. Treasury Department's list of Specially 
Designated Nationals or the U.S. Commerce Department's 
Table of Denial Orders.  By using the Software, you are 
agreeing to the foregoing and you are representing and 
warranting that you are not located in, under the control of, or 
a national or resident or resident of any such country or on any 
such list.

6. GOVERNING LAW; ATTORNEYS FEES. 

This agreement shall be governed by the laws of the State of 
Washington and you further consent to jurisdiction by the state 
and federal courts sitting in the State of Washington. If either 
RN or you employs
attorneys to enforce any rights arising out of or relating to this 
Agreement, the prevailing party shall be entitled to recover 
reasonable attorneys' fees.

8.  ENTIRE AGREEMENT. 

This agreement constitutes the complete and exclusive 
agreement between RN and you with respect to the subject 
matter hereof, and supersedes all prior oral or written 
understandings, communications or agreements not 
specifically incorporated herein.  This agreement may not be 
modified except in a writing duly signed by an authorized 
representative of RN and you.    

Copyright  1997-1998 RealNetworks, Inc. and or its 
suppliers.  1111 Third Avenue, Suite 2900, Seattle, 
Washington 98101 U.S.A.  All rights are reserved.



RTSP Proxy License Agreement 8-98

--------------------------------------------------------*/



#ifndef __simplib_h__
#define __simplib_h__


/*======================================================================

	HASHES

======================================================================*/

/* The default number of items in a hash table (will increase as needed).
   This should hopfully be much larger than we need for our purposes.
 **/
#ifndef HT_DEF_SIZE
#define HT_DEF_SIZE 512
#endif /* HT_DEF_SIZE */

/* "2" means if the table is 1/2 full, resize it, 3 means 1/3, etc...
   Resizing is handled automatically.
 */
#ifndef HT_THRESHOLD
#define HT_THRESHOLD 2
#endif /* HT_THRESHOLD */

/* "2" here means double the table when resizing, 3 means triple it, etc. */
#ifndef HT_FACTOR
#define HT_FACTOR 2
#endif /* HT_FACTOR */



typedef struct _HashTable HashTable;
typedef struct _HashItem  HashItem;

typedef int (*HashFunc)    (void *key);
typedef int (*CompareFunc) (void *a, void *b);
typedef void (*HTblFunc)   (void *key, void *value, void *user_data);

struct _HashTable
{
	int size;		/* total number of items in this hash table */
	HashItem *items;	/* the key->value pairs */
	int used;		/* number of used key->value pairs */
	int rsz_threshold;	/* resize when/iff hash table is 1/n full */ 
	int rsz_factor;		/* resize table by this multiple (2x, 4x, etc.) */
	HashFunc hash_func;	/* a routine for used in creating hashes */
	CompareFunc key_compare_func;	/* a routine for comparing keys */
};


struct _HashItem
{
	void * key;	/* -1 means unused, only non-negative keys valid */
	void * value;
};

#define EMPTY_ITEM        ((void *)(-1))
#define DELETED_ITEM      ((void *)(-2))
#define hash_key(ht,key)  (((HashFunc)(ht->hash_func)) (key) % ht->size)

HashTable * hash_table_new (unsigned int size, int thresh, int fact,
			    HashFunc hash_func, CompareFunc key_compare_func);

HashTable * hash_table_resize (HashTable *ht, int factor);
HashTable * hash_table_insert_item (HashTable *ht, void *key, void *value);
HashTable * hash_table_destroy (HashTable *ht);
int         default_hash_function (HashTable *ht, void *key);
void *      hash_table_lookup (HashTable *ht, void *key);
HashTable * hash_table_delete (HashTable *ht, void *key);
HashTable * hash_table_delete_item (HashTable *ht, void *key);
void        hash_table_foreach (HashTable *ht, HTblFunc func, void *user_data);
int         int_hash_func (void *x);
int         str_hash_func (void *str);
int         int_equal_func (void *a, void *b);
int         str_equal_func (void *a, void *b);



/*======================================================================

	DOUBLY LINKED LISTS

======================================================================*/


typedef struct _List List;

struct _List
{
	void *data;
	List *next;
	List *prev;
};


List * list_init (void *data);
int    list_delete (List *list);
List * list_append (List *list, void *data);
List * list_remove (List *list, void *data);
List * list_remove_item (List *item);



/*======================================================================

	MEMORY ALLOCATION

======================================================================*/

void *mem_malloc (size_t size);




/*======================================================================

	GLIB COMPATABILITY WRAPPER

	Makes the above routines look like similar GLIB routines.

======================================================================*/

/*
 * HASHES
 */
#define GHashTable	HashTable
#define GHashFunc	HashFunc
#define GCompareFunc	CompareFunc
#define GMemChunk	void

#define g_hash_table_new(hfn,cfn)       hash_table_new (0, 0, 0, (HashFunc)(hfn), (CompareFunc)(cfn))
#define g_hash_table_destroy(ht)        hash_table_destroy (ht)
#define g_hash_table_insert(ht,key,val) hash_table_insert_item (ht, key, val)
#define g_hash_table_lookup(ht,key)     hash_table_lookup (ht, key)
#define g_hash_table_remove(ht,key)     hash_table_delete_item (ht, key)
#define g_hash_table_foreach(ht,fn,d)	hash_table_foreach (ht,(HTblFunc)(fn),d)
#define g_int_hash    	int_hash_func
#define g_int_equal 	int_equal_func
#define g_str_hash    	str_hash_func
#define g_str_equal 	str_equal_func
    

/*
 * LINKED LISTS
 */
#define GList List

#define g_list_append(list,data)	list_append (list, data)
#define g_list_free(list)		list_delete (list)
#define g_list_remove(list,data)	list_remove (list, data)
#define g_list_remove_link(list,item)	list_remove_item (item)


/*
 * MEMORY
 *
 * We do not really provide memory "chunks", just malloc/free wrappers.
 */
#define g_free(x)			free(x)
#define g_malloc(x)			mem_malloc(x)
#define g_chunk_free(x,y)		free(x)
#define g_chunk_new(x,y)		mem_malloc(sizeof(x))
#define g_mem_chunk_new(a,b,c,d)	NULL


/*
 * OTHER
 */
#ifndef MAX
#define MAX(x,y) (((x) > (y)) ? (x) : (y))
#endif /* MAX */
#ifndef MIN
#define MIN(x,y) (((x) < (y)) ? (x) : (y))
#endif /* MIN */


#endif /* __simplib_h__ */
