
#ifndef __SETTINGS_H
#define __SETTINGS_H

#define PLACEMENT_MOUSE			0
#define PLACEMENT_ROOT			1


typedef enum {
	KEY_MOVE_UP,
	KEY_MOVE_DOWN,
	KEY_MOVE_LEFT,
	KEY_MOVE_RIGHT,
	KEY_RESIZE_UP,
	KEY_RESIZE_DOWN,
	KEY_RESIZE_LEFT,
	KEY_RESIZE_RIGHT,
	KEY_CYCLE_WINDOWS,
	KEY_CYCLE_APP,
	KEY_CLOSE_WINDOW,
	KEY_HIDE_WINDOW,
	KEY_TOGGLE_FULLSCREEN_WINDOW,
	KEY_MAXIMIZE_WINDOW,
	KEY_MAXIMIZE_VERT,
	KEY_MAXIMIZE_HORIZ,
	KEY_TOGGLE_FULLSCREEN_WINDOW_ALL,
	KEY_MAXIMIZE_WINDOW_ALL,
	KEY_MAXIMIZE_VERT_ALL,
	KEY_MAXIMIZE_HORIZ_ALL,
	KEY_SHADE_WINDOW,
	KEY_RAISE_WINDOW_LAYER,
	KEY_LOWER_WINDOW_LAYER,
	KEY_NEXT_WORKSPACE,
	KEY_PREV_WORKSPACE,
	KEY_ADD_WORKSPACE,
	KEY_DEL_WORKSPACE,
	KEY_STICK_WINDOW,
	KEY_WORKSPACE_1,
	KEY_WORKSPACE_2,
	KEY_WORKSPACE_3,
	KEY_WORKSPACE_4,
	KEY_WORKSPACE_5,
	KEY_WORKSPACE_6,
	KEY_WORKSPACE_7,
	KEY_WORKSPACE_8,
	KEY_WORKSPACE_9,
	KEY_MOVE_NEXT_WORKSPACE,
	KEY_MOVE_PREV_WORKSPACE,
	KEY_MOVE_WORKSPACE_1,
	KEY_MOVE_WORKSPACE_2,
	KEY_MOVE_WORKSPACE_3,
	KEY_MOVE_WORKSPACE_4,
	KEY_MOVE_WORKSPACE_5,
	KEY_MOVE_WORKSPACE_6,
	KEY_MOVE_WORKSPACE_7,
	KEY_MOVE_WORKSPACE_8,
	KEY_MOVE_WORKSPACE_9,
	KEY_TOP_LEFT,
	KEY_TOP_RIGHT,
	KEY_BOTTOM_LEFT,
	KEY_BOTTOM_RIGHT,
	KEY_WINDOW_OPS,
	KEY_TOGGLE_BORDERS,
	KEY_RAISE_WINDOW,
	KEY_SHOW_DESKTOP,
	KEY_QUIT,

	KEY_COUNT
} KeySettings;

typedef enum {
	WINDOW_ACTION_NONE,
	WINDOW_ACTION_MAXIMIZE,
	WINDOW_ACTION_SHADE,
	WINDOW_ACTION_HIDE
} WindowActions;

typedef enum {
	ALIGN_LEFT,
	ALIGN_RIGHT,
	ALIGN_CENTER
} TitleAlign;

typedef enum {
	FOCUS_UNIX = 1,
	FOCUS_WINDOWS = 2,
	FOCUS_RISCOS = 4
} FocusPolicies;

typedef enum {
	RAISE_UNIX = 1,
	RAISE_WINDOWS = 2,
	RAISE_RISCOS = 4
} RaisePolicies;


typedef enum {
	LOCK_SIZE = 0,
	UNLOCK_SIZE = 1,
	REMAX_SIZE = 2
} MaximizeState;

typedef enum {
	LAYER_LOWER = 1,
	LAYER_RAISE = 2,
} LayerActions;

typedef enum {
	DRAG_MOVE = 1,
	DRAG_RESIZE = 2,
} DragActions;

typedef enum {
	ACTIVE,
	INACTIVE,
	PRESSED,
	ACTIVE_DISABLED,
	INACTIVE_DISABLED,
	ACTIVE_TOGGLED,
	INACTIVE_TOGGLED
} ButtonStates;

MyKey keys[KEY_COUNT];

GC title_gc[2];
GC box_gc;
MyPixmap sides[3][2], corners[4][2], buttons[BUTTON_COUNT][7], title[5][2];
char button_layout[BUTTON_COUNT + 2];	//buttons + title '|' + '\0'
char button_filter[BUTTON_COUNT + 2];

/* X.h: */
/* Bit Gravity */
/*
#define ForgetGravity		0
#define NorthWestGravity	1
#define NorthGravity		2
#define NorthEastGravity	3
#define WestGravity			4
#define CenterGravity		5
#define EastGravity			6
#define SouthWestGravity	7
#define SouthGravity		8
#define SouthEastGravity	9
#define StaticGravity		10
*/

/*int gravitate_x[11], gravitate_y[11];*/

int title_alignment, full_width_title, button_spacing, button_offset;
int double_click_action;
int box_move, box_resize;
int focus_policy, raise_policy, focus_new;
guint raise_delay;
int window_placement, snap_to_border, snap_to_windows, snap_width;
int maximize_state;	// terry blunt 7/3/5 now can change maximize behaviour
int warp_mouse;
int border_drag;
int button2_frame_click, button3_frame_click;
int button2_frame_drag, button3_frame_drag;

int switch_to_active_win;
int buttons_show_state;
int button_cursors;
int cycle_infobox;
int geometry_infobox;
int warp_after_cycle;

extern char *borderless_windows, *sticky_windows, *iconic_windows, *ontop_windows;

void loadSettings(void);
void unloadSettings(void);
void reloadSettings(void);

#endif
