

#ifndef __CLIENT_H
#define __CLIENT_H

typedef enum {
	HIDE_BUTTON,
	SHADE_BUTTON,
	MAXIMIZE_BUTTON,
	CLOSE_BUTTON,
	STICK_BUTTON,

	BUTTON_COUNT
} TitleButton;

#define APPLY				1
#define REMOVE				-1


typedef struct _Point Point;

struct _Point {
	int x;
	int y;
};

typedef struct _Geometry Geometry;

struct _Geometry {
	int x;
	int y;
	int width;
	int height;
};


typedef struct _Client Client;

/**
 * Client structure.
 * This structure represents a client with all its attributes.
 */
struct _Client {
	Window window,	/**< pointer to the window itself. */
	 *cmap_windows, frame,
				/**< pointer to the frame window. */
	  title,	/**< pointer to the title window. */
	  sides[3],	/**< pointer to the left, bottom and right side window. */
	  corners[4],	/**< pointer to each corner window */
	  buttons[BUTTON_COUNT];
			/**< pointer to the button windows in the title bar */
	Geometry geometry;
	Geometry unmax_geometry; /**< remember the old dimensions (when maximizing). */
	Geometry fs_geometry; /**< remember the old position (when switching to fullscreen). */
	int border_width;	/**< the width of the border */
	int gravity;
				
	WindowState fs_state;	/**< remember the old layer (when switching to fullscreen). */
	AllowedActions fs_actions;

	gulong margins[12];	/**< the space, the client wants to "reserve" at the desktop border,
			  for example the gnome panel does this. */
	int button_pressed[BUTTON_COUNT];
			/**< to indicate if a button was pressed (and which). */
	gchar *title_string; 	/* net_wm_name||wm_name||"" */
	gchar *net_wm_name;		/**< the clients name (EWMH) */
	gchar *wm_name;		/**< the clients name */
	gchar *net_wm_icon_name;
	gchar *wm_icon_name;
	XSizeHints *size;
					/**< client size hints, see man XSizeHints. */

	MWMHints mwm_hints;			/* sane set of mwm hints we handle */
	AllowedActions actions;		/* _NET_WM_ALLOWED_ACTIONS */
	WindowState state;			/* _NET_WM_STATE_* */
	WindowType type;			/* _NET_WM_TYPE_* */
	gulong wm_protocols;
	Atom type_atom;
	XClassHint class;
	Bool classless;

	XWMHints *wmhints;
	Window client_leader;
	Window group_leader;
	Colormap cmap;
	int ncmap;

	Time ping_time;
	guint ping_timeout_id;
	Bool ping_moribund;

	int has_decor,	/**< has the client a decor (can be forced to none with the borderless list). */
	  had_decor;
	int decor_state;  // if decor is drawn as active or inactive
	Bool was_iconified; // reiconify (unshowing desktop)

	long win_workspace;	/**< the current workspace of the client */


	int ignore_unmap,
					/**< ignore the unmap request. */
	  non_focusing,	/**< client is non-focusing, like it does not want the focus. */
	  not_warp_to_next;
			/**< do not warp to the next client, (warp the mouse) when closing this client. */
	Window transientFor;/**< pointer to the client, for which the current client is transient, ie its a dialog or popup window. */

	char legacy_fullscreen;
	char always_sticky;

#ifdef HAVE_STARTUP_NOTIFICATION
	char *startup_id;
#endif
	XftDraw *xftdraw;
};
void client_toggle_sticky(Client *);
void client_sync_client_list(void);
void client_configure_xy(Client * c);
void client_configure_xywh(Client * c);
void client_configure_fullscreen(XWindowChanges * wc, int all_monitors);
void clientShow(Client * c, gboolean change_state);
void clientButtonPress(Client *, Window, XButtonEvent *);
void clientGrabKeys(Client * c);
Client *client_of_window(Window w);
gboolean client_exists(Client * c);
void cleanUp();

gint grab_server(Display * dpy, gboolean grab);
void gravitation(Client * c, Point * p);
void client_gravitate(Client * c);
void client_ungravitate(Client * c);

void clientConfigure(Client *, XWindowChanges *, int);
Client *client_new(Window);
int map_state(Window window);
gboolean client_is_viewable(Client * c);
gboolean client_is_viewable_or_obscured(Client * c);
Client *clientFrame(Window w, XWindowAttributes * attr);
void clientFrameAll();
void clientUnframeAll();
void clientUngrabKeys(Client *);
Client *client_of_decor(Window);
void clientKill(Client * c);
void clientHide(Client *, int);
void client_destroy(Client *);
void clientClose(Client *, Time);

void clientSetWorkspace(Client *, int);
void clientToggleShaded(Client *);
void clientToggleFullscreen(Client *, int);
void clientToggleMaximized(Client *, int, int);


void clientMove(Client *, XEvent *);
void clientResize(Client *, XEvent *);
void clientCycle(int mode);

void send_icccm_message(Window window, Atom atom, Time timestamp);

#endif
