/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import java.util.WeakHashMap;
import javax.crypto.BadPaddingException;
import sun.security.jca.JCAUtil;

public final class RSACore {
    private static final boolean ENABLE_BLINDING = true;
    private static final Map<BigInteger, BlindingParameters> blindingCache = new WeakHashMap<BigInteger, BlindingParameters>();

    private RSACore() {
    }

    public static int getByteLength(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        return n + 7 >> 3;
    }

    public static int getByteLength(RSAKey rSAKey) {
        return RSACore.getByteLength(rSAKey.getModulus());
    }

    public static byte[] convert(byte[] byArray, int n, int n2) {
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static byte[] rsa(byte[] byArray, RSAPublicKey rSAPublicKey) throws BadPaddingException {
        return RSACore.crypt(byArray, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
    }

    public static byte[] rsa(byte[] byArray, RSAPrivateKey rSAPrivateKey) throws BadPaddingException {
        if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
            return RSACore.crtCrypt(byArray, (RSAPrivateCrtKey)rSAPrivateKey);
        }
        return RSACore.priCrypt(byArray, rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
    }

    private static byte[] crypt(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) throws BadPaddingException {
        BigInteger bigInteger3 = RSACore.parseMsg(byArray, bigInteger);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        return RSACore.toByteArray(bigInteger4, RSACore.getByteLength(bigInteger));
    }

    private static byte[] priCrypt(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) throws BadPaddingException {
        BigInteger bigInteger3 = RSACore.parseMsg(byArray, bigInteger);
        BlindingRandomPair blindingRandomPair = null;
        blindingRandomPair = RSACore.getBlindingRandomPair(null, bigInteger2, bigInteger);
        bigInteger3 = bigInteger3.multiply(blindingRandomPair.u).mod(bigInteger);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        bigInteger4 = bigInteger4.multiply(blindingRandomPair.v).mod(bigInteger);
        return RSACore.toByteArray(bigInteger4, RSACore.getByteLength(bigInteger));
    }

    private static byte[] crtCrypt(byte[] byArray, RSAPrivateCrtKey rSAPrivateCrtKey) throws BadPaddingException {
        BigInteger bigInteger;
        BigInteger bigInteger2 = rSAPrivateCrtKey.getModulus();
        BigInteger bigInteger3 = RSACore.parseMsg(byArray, bigInteger2);
        BigInteger bigInteger4 = rSAPrivateCrtKey.getPrimeP();
        BigInteger bigInteger5 = rSAPrivateCrtKey.getPrimeQ();
        BigInteger bigInteger6 = rSAPrivateCrtKey.getPrimeExponentP();
        BigInteger bigInteger7 = rSAPrivateCrtKey.getPrimeExponentQ();
        BigInteger bigInteger8 = rSAPrivateCrtKey.getCrtCoefficient();
        BigInteger bigInteger9 = rSAPrivateCrtKey.getPublicExponent();
        BigInteger bigInteger10 = rSAPrivateCrtKey.getPrivateExponent();
        BlindingRandomPair blindingRandomPair = RSACore.getBlindingRandomPair(bigInteger9, bigInteger10, bigInteger2);
        BigInteger bigInteger11 = (bigInteger3 = bigInteger3.multiply(blindingRandomPair.u).mod(bigInteger2)).modPow(bigInteger6, bigInteger4);
        BigInteger bigInteger12 = bigInteger11.subtract(bigInteger = bigInteger3.modPow(bigInteger7, bigInteger5));
        if (bigInteger12.signum() < 0) {
            bigInteger12 = bigInteger12.add(bigInteger4);
        }
        BigInteger bigInteger13 = bigInteger12.multiply(bigInteger8).mod(bigInteger4);
        BigInteger bigInteger14 = bigInteger13.multiply(bigInteger5).add(bigInteger);
        bigInteger14 = bigInteger14.multiply(blindingRandomPair.v).mod(bigInteger2);
        return RSACore.toByteArray(bigInteger14, RSACore.getByteLength(bigInteger2));
    }

    private static BigInteger parseMsg(byte[] byArray, BigInteger bigInteger) throws BadPaddingException {
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        if (bigInteger2.compareTo(bigInteger) >= 0) {
            throw new BadPaddingException("Message is larger than modulus");
        }
        return bigInteger2;
    }

    private static byte[] toByteArray(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        int n2 = byArray.length;
        if (n2 == n) {
            return byArray;
        }
        if (n2 == n + 1 && byArray[0] == 0) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 1, byArray2, 0, n);
            return byArray2;
        }
        assert (n2 < n);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, n - n2, n2);
        return byArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlindingRandomPair getBlindingRandomPair(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BlindingParameters blindingParameters = null;
        Object object = blindingCache;
        synchronized (object) {
            blindingParameters = blindingCache.get(bigInteger3);
        }
        if (blindingParameters == null) {
            blindingParameters = new BlindingParameters(bigInteger, bigInteger2, bigInteger3);
            object = blindingCache;
            synchronized (object) {
                if (blindingCache.get(bigInteger3) == null) {
                    blindingCache.put(bigInteger3, blindingParameters);
                }
            }
        }
        if ((object = blindingParameters.getBlindingRandomPair(bigInteger, bigInteger2, bigInteger3)) == null) {
            blindingParameters = new BlindingParameters(bigInteger, bigInteger2, bigInteger3);
            Map<BigInteger, BlindingParameters> map = blindingCache;
            synchronized (map) {
                if (blindingCache.get(bigInteger3) != null) {
                    blindingCache.put(bigInteger3, blindingParameters);
                }
            }
            object = blindingParameters.getBlindingRandomPair(bigInteger, bigInteger2, bigInteger3);
        }
        return object;
    }

    private static final class BlindingParameters {
        private static final BigInteger BIG_TWO = BigInteger.valueOf(2L);
        private final BigInteger e;
        private final BigInteger d;
        private BigInteger u = null;
        private BigInteger v = null;

        BlindingParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            this.e = bigInteger;
            this.d = bigInteger2;
            int n = bigInteger3.bitLength();
            SecureRandom secureRandom = JCAUtil.getSecureRandom();
            this.u = new BigInteger(n, secureRandom).mod(bigInteger3);
            if (this.u.equals(BigInteger.ZERO)) {
                this.u = BigInteger.ONE;
            }
            try {
                this.v = this.u.modInverse(bigInteger3);
            }
            catch (ArithmeticException arithmeticException) {
                this.u = BigInteger.ONE;
                this.v = BigInteger.ONE;
            }
            if (bigInteger != null) {
                this.u = this.u.modPow(bigInteger, bigInteger3);
            } else {
                this.v = this.v.modPow(bigInteger2, bigInteger3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        BlindingRandomPair getBlindingRandomPair(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            if (this.e != null && this.e.equals(bigInteger) || this.d != null && this.d.equals(bigInteger2)) {
                BlindingRandomPair blindingRandomPair = null;
                BlindingParameters blindingParameters = this;
                synchronized (blindingParameters) {
                    if (!this.u.equals(BigInteger.ZERO) && !this.v.equals(BigInteger.ZERO)) {
                        blindingRandomPair = new BlindingRandomPair(this.u, this.v);
                        if (this.u.compareTo(BigInteger.ONE) <= 0 || this.v.compareTo(BigInteger.ONE) <= 0) {
                            this.u = BigInteger.ZERO;
                            this.v = BigInteger.ZERO;
                        } else {
                            this.u = this.u.modPow(BIG_TWO, bigInteger3);
                            this.v = this.v.modPow(BIG_TWO, bigInteger3);
                        }
                    }
                }
                return blindingRandomPair;
            }
            return null;
        }
    }

    private static final class BlindingRandomPair {
        final BigInteger u;
        final BigInteger v;

        BlindingRandomPair(BigInteger bigInteger, BigInteger bigInteger2) {
            this.u = bigInteger;
            this.v = bigInteger2;
        }
    }
}

