if (CMAKE_SYSTEM_NAME STREQUAL "iOS")
    option(ENABLE_SYNC "Turns on sync functionality" OFF)
    option(ENABLE_CHAT "Turns on chat management functionality" ON)
    option(USE_MEDIAINFO "Used to determine media properties and set those as node attributes" OFF)
    option(USE_FREEIMAGE "Used to create previews/thumbnails for photos/pictures" OFF)
    option(USE_FFMPEG "Used to create previews/thumbnails for video files" OFF)
    option(USE_LIBUV "Includes the library and turns on internal web and ftp server functionality" ON)
    option(USE_PDFIUM "Used to create previews/thumbnails for PDF files" OFF)
    option(USE_C_ARES "If set, the SDK will manage DNS lookups and ipv4/ipv6 itself, using the c-ares library.  Otherwise we rely on cURL" OFF)
    option(USE_READLINE "Use the readline library for the console" OFF)
    option(USE_OPENSSL "Use the OpenSSL library or a compatible one" ON)
else()
    option(ENABLE_SYNC "Turns on sync functionality" ON)
    option(ENABLE_CHAT "Turns on chat management functionality" OFF)
    option(USE_MEDIAINFO "Used to determine media properties and set those as node attributes" ON)
    option(USE_FREEIMAGE "Used to create previews/thumbnails for photos/pictures" ON)
    option(USE_FFMPEG "Used to create previews/thumbnails for video files" ON)
    option(USE_LIBUV "Includes the library and turns on internal web and ftp server functionality" OFF)
    option(USE_PDFIUM "Used to create previews/thumbnails for PDF files" ON)
    option(USE_C_ARES "If set, the SDK will manage DNS lookups and ipv4/ipv6 itself, using the c-ares library.  Otherwise we rely on cURL" ON)
    if (WIN32)
        option(USE_READLINE "Use the readline library for the console" OFF)
    else()
        option(USE_READLINE "Use the readline library for the console" ON)
    endif()
    if (APPLE) # AND NOT iOS
        option(USE_OPENSSL "Use the OpenSSL library or a compatible one" OFF)
    else()
        option(USE_OPENSSL "Use the OpenSSL library or a compatible one" ON)
    endif()
endif()
option(ENABLE_LOG_PERFORMANCE "Faster log message generation" OFF)
option(ENABLE_DRIVE_NOTIFICATIONS "Allows to monitor (external) drives being [dis]connected to the computer" OFF)
option(ENABLE_QT_BINDINGS "Enable the target to build the Qt Bindings" OFF)
option(ENABLE_JAVA_BINDINGS "Enable the target to build the Java Bindings" OFF)
if (USE_FREEIMAGE)
    option(ENABLE_ISOLATED_GFX "Turns on isolated GFX processor" ON)
else()
    option(ENABLE_ISOLATED_GFX "Turns on isolated GFX processor" OFF)
endif()
