/*
 * bw_tcp.c - simple TCP bandwidth test
 *
 * Three programs in one -
 *	server usage:	bw_tcp -s
 *	client usage:	bw_tcp hostname
 *	shutdown:	bw_tcp -hostname
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: bw_tcp.c,v 1.15 1997/10/20 06:40:11 lm Exp $\n";
#include "bench.h"
#define	BLOCK	(1<<18)

int	server_main(int ac, char **av);
int	client_main(int ac, char **av);
void	source(int data);

char	*buf;

struct	xfer {
	uint64	offset;
	double	bw;
	struct	xfer *next;
};

void
transfer(uint64 move, char *server, int print)
{
	int	data, c;
	int	block = 0;
	uint64	todo, offset = 0;
	struct	xfer *list = 0, *x;
	double	usecs;

	todo = move;
	/* printf("Move %lu MB\n", (unsigned long)(move>>20));
	 */
	data = tcp_connect(server, TCP_DATA, SOCKOPT_READ);
	(void)sprintf(buf, "%lu", (unsigned long)move);
	if (write(data, buf, strlen(buf)) != strlen(buf)) {
		perror("control write");
		exit(1);
	}
	start(0);
	while (todo > 0 && (c = read(data, buf, XFERSIZE)) > 0) {
		todo -= c;
		block += c;
		if (block >= BLOCK) {
			usecs = stop(0,0);
			x = malloc(sizeof(*x));
			x->next = list;
			list = x;
			usecs /= 1000000.;
			offset += block;
			x->bw = block / usecs;
			x->offset = offset;
			block = 0;
			start(0);
		}
	}
	(void)close(data);
	if (!print) return;
    	p(list);
}

p(struct xfer *x)
{
	if (!x) return;
	p(x->next);
	fprintf(stderr, "%.4f %.4f\n", x->offset/1000000., x->bw/1000000.);
}


/* ARGSUSED */
int
client_main(int ac, char **av)
{
	uint64	move;
	char   *server;
	uint64	usecs;

	if (ac != 2 && ac != 3) {
		(void)fprintf(stderr, "usage: %s remotehost [bytes]\n",
		    av[0]);
		exit(0);
	}
	if (!buf) {
		perror("valloc");
		exit(1);
	}
	if (ac == 3) {
		move = bytes(av[2]);
	} else {
		move = 10*1024*1024;
	}

	/*
	 * Disabler message to other side.
	 */
	if (av[1][0] == '-') {
		int	data;

		move = 0;
		server = &av[1][1];
		data = tcp_connect(server, TCP_DATA, SOCKOPT_NONE);
		write(data, "0", 1);
		exit(0);
	} else {
		server = av[1];
	}
	transfer(move, server, 1);
	exit(0);
	/*NOTREACHED*/
}

void
child()
{
	wait(0);
	signal(SIGCHLD, child);
}

/* ARGSUSED */
int
server_main(int ac, char **av)
{
	int	data, newdata;

	GO_AWAY;

	signal(SIGCHLD, child);
	data = tcp_server(TCP_DATA, SOCKOPT_WRITE);

	for ( ;; ) {
		newdata = tcp_accept(data, SOCKOPT_WRITE);
		switch (fork()) {
		    case -1:
			perror("fork");
			break;
		    case 0:
			source(newdata);
			exit(0);
		    default:
			close(newdata);
			break;
		}
	}
}

/*
 * Read the number of bytes to be transfered.
 * Write that many bytes on the data socket.
 */
void
source(int data)
{
	int	n, nbytes;

	if (!buf) {
		perror("valloc");
		exit(1);
	}
	bzero((void*)buf, XFERSIZE);
	if (read(data, buf, XFERSIZE) <= 0) {
		perror("control nbytes");
		exit(7);
	}
	nbytes = atoi(buf);

	/*
	 * A hack to allow turning off the absorb daemon.
	 */
     	if (nbytes == 0) {
		tcp_done(TCP_DATA);
		kill(getppid(), SIGTERM);
		exit(0);
	}
	while (nbytes > 0) {
#ifdef	TOUCH
		touch(buf, XFERSIZE);
#endif
		n = write(data, buf, XFERSIZE);
		if (n <= 0) break;
		nbytes -= n;
	}
}


int
main(int ac, char **av)
{
	if (ac != 2 && ac != 3) {
		fprintf(stderr, "Usage: %s -s OR %s [-]serverhost\n",
		    av[0], av[0]);
		exit(1);
	}
	buf = valloc(XFERSIZE);
	touch(buf, XFERSIZE);
	if (!strcmp(av[1], "-s")) {
		if (fork() == 0) {
			server_main(ac, av);
		}
		exit(0);
	} else {
		client_main(ac, av);
	}
	return(0);
}
