char	*id = "$Id: seek.c,v 1.1 1996/09/05 19:32:37 lm Exp lm $\n";
/*
 * zone - calculate zone bandwidths
 *
 * Usage: zone device [blocksize]
 *
 * Copyright (c) 1994,1995,1996 Larry McVoy.  All rights reserved.
 */

#include "timing.h"
#include "bench.h"
#define	uint64	unsigned long long
#define	IO(a,b,c)	(oflag == 0 ? (n = read(a,b,c)) : (n = write(a,b,c)))
#define	STRIDE	16*1024*1024
#define	BSIZE	4*1024*1024

main(ac, av)
	int	ac;
	char	*av[];
{
	char	buf[BSIZE];
	int	disk;
	int	usecs;
	int	oflag;
	int	error;
	int	bsize;
	int	n, moved;

	if (ac != 2 && ac != 3) {
		fprintf(stderr, "Usage: %s device [bsize]\n", av[0]);
		exit(1);
	}
	if (strcmp(av[0], "zonewr") == 0) {
		oflag = 1;
	} else {
		oflag = 0;
	}
	if ((disk = open(av[1], oflag)) == -1) {
		perror(av[1]);
		exit(errno);
	}
	bsize = ac == 3 ? getsize(av[2]) : BSIZE;
	if (bsize > BSIZE) {
		fprintf(stderr, "Bsize must be <= %u\n", BSIZE);
		exit(1);
	}

	/*
	 * Read buf's worth of data every STRIDE and time it.
	 * Don't include the rotational delay.
	 * This first I/O outside the loop is to catch read/write permissions.
	 */
	error = IO(disk, buf, 512);
	if (error == -1) {
		perror(av[1]);
		exit(1);
	}
	for ( ;; ) {
		if (IO(disk, buf, 1024) == -1) {
			exit(0);
		}
		start();
		for (moved = 0; (moved + bsize) <= BSIZE; moved += n) {
			if (IO(disk, buf, bsize) == -1) {
				exit(0);
			}
		}
		usecs = stop();
		printf("%.04f %.04f\n",
		    (lseek64(disk, (off64_t)0, 1) - moved) / 1000000.,
		    (double)moved/usecs);
		lseek(disk, STRIDE, 1);
	}
	exit(0);
}

int
getsize(char *s)
{
	int	size = atol(s);

	switch (s[strlen(s) - 1]) {
	    case 'k':	size <<= 10;		break;
	    case 'K':	size *= 1000;		break;
	    case 'm':	size <<= 20;		break;
	    case 'M':	size *= 1000000;	break;
	    case 'g':	size <<= 30;		break;
	    case 'G':	size *= 1000000000L;	break;
	}
	return (size);
}
