/*
 * xlv.c - simulate what xlv does at user level.
 *
 * usage: xlv n=#processes bs=blocksize move=size
 */

#include "timing.h"
#include "bench.h"
#include <ulocks.h>
#include <fcntl.h>
#include <sys/prctl.h>

#define	uint64	unsigned long long

char   *cmds[] = {
	"bs",			/* block size */
	"move",			/* instead of count, limit transfer to this */
	0,
};

usema_t	*sem;
int	n;
uint64	bsize;
uint64	move;
char	*buf;
uint64	getarg(char *s, int ac, char **av);
int	oflags = 0;

main(int ac, char **av)
{
	int     i;
	int	devstart = 1;
	usptr_t	*locks;
	void	io(int, char *);

	if (!strcmp(av[0], "xlvwr"))
		oflags = 1;
	n = ac - 1;
	for (i = 1; i < 3; ++i ) {
		if (!strncmp(av[i], "bs=", 3))
			n--, devstart++;
		if (!strncmp(av[i], "move=", 5))
			n--, devstart++;
	}
	bsize = getarg("bs=", ac, av);
	if (bsize < 0) {
		bsize = 8192;
	}
	move = getarg("move=", ac, av);
	move /= (n * bsize);
	move *= (n * bsize);
	if (move == -1) {
		fprintf(stderr, "ya gotta say how much.\n");
		exit(1);
	}
	if (!(buf = valloc((size_t) bsize))) {
		perror("VALLOC");
		exit(1);
	}
	usconfig(CONF_INITUSERS, n);
	unlink("/tmp/xlv_locks");
	locks = usinit("/tmp/xlv_locks");
	sem = usnewsema(locks, 0);
	if (!locks || !sem) {
		perror("locks");
		exit(1);
	}
	for (i = 1; i < n; ++i) {
		switch (fork()) {
		    case -1:
			perror("sproc");
			kill(-getpgrp(), 15);
			exit(1);
		    case 0:
			io(i, av[devstart+i]);
			exit(0);
		}
	}
	start();
	io(0, av[devstart]);
	stop();
	bandwidth((int)move, 1);
}

void
io(int id, char *file)
{
	off64_t	offset = id * bsize;
	int	fd, i;

	fd = open(file, oflags);
	if (fd == -1) {
		perror(file);
	}
	bzero(buf, (unsigned)bsize);
	for (;;) {
		int	x;

		if (id) {
			uspsema(sem);
		} else {
			while (ustestsema(sem) > -(n-1)) {
				/*printf("waiting %d\n", ustestsema(sem));*/
				sginap(0L);
			}
			for (i = 1; i < n; ++i) {
				usvsema(sem);
			}
		}
		/*
		printf("%d off = %u\n", id, (unsigned)offset >> 20);
		*/
		if (lseek64(fd, offset, 0) != offset) {
			perror("lseek64");
		}
		if (oflags) {
			x = write(fd, buf, bsize);
		} else {
			x = read(fd, buf, bsize);
		}
		if (x != bsize) {
			perror("io");
			printf("id %d wanted %u got %i at offset %u\n",
			    id, (unsigned)bsize, x, (unsigned)offset);
			break;
		}
		offset += n * bsize;
		if (offset >= move) {
			break;
		}
	}
	if (id) {
		exit(0);
	}
}

uint64 
getarg(char *s, int ac, char **av)
{
	register uint64 len, i;

	len = strlen(s);

	for (i = 1; i < ac; ++i) {
		if (!strncmp(av[i], s, len)) {
			register uint64 bs = atol(&av[i][len]);

			switch (av[i][strlen(av[i]) - 1]) {
			    case 'K': bs *= 1000; break;
			    case 'k': bs <<= 10; break;
			    case 'M': bs *= 1000000; break;
			    case 'm': bs <<= 20; break;
			    case 'G': bs *= 1000000000L; break;
			    case 'g': bs <<= 30; break;
			}
			return (bs);
		}
	}
	return ((uint64)-1);
}
