/*
 * lat_pipe.c - pipe transaction test
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_pipe.c,v 1.5 1996/11/14 00:09:37 lm Exp lm $\n";

#include "timing.h"
#include "bench.h"
#include        <sys/types.h>
#include        <sys/mman.h>
#include        <sys/sysmp.h>

int
main()
{
	int	want, i, N, pid, fd;
	register volatile int *p;
	char	buf[16*1024];

	fd = creat("/tmp/lat_shm", 0666);
	write(fd, buf, sizeof(buf));
	close(fd);
	fd = open("/tmp/lat_shm", 2);
	p = mmap(0, sizeof(buf), PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
	if ((int)p == -1) {
		perror("mmap");
		exit(1);
	}
	*p = 0;
	pid = fork();
	if (pid == -1) {
		perror("fork");
		exit(1);
	}
	N = 1000000;
	if (!pid) {
		sysmp(MP_MUSTRUN, 0);
		want = 0;
		LOOP_FIRST(N, i, ENOUGH);
		while (*p != want)
			;
		*p = want + 1;
		want += 2;
		LOOP_LAST(N, i, ENOUGH);
		micro("Shared memory latency", N);
		kill(getppid(), 15);
	} else {
		sysmp(MP_MUSTRUN, 1);
		want = 1;
		for ( ;; ) {
			while (*p != want)
				;
			*p = want + 1;
			want += 2;
		}
	}
	return (0);
}
