/*
 * lat_pipe.c - pipe transaction test
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_pipe.c,v 1.5 1996/11/14 00:09:37 lm Exp $\n";

#include "timing.h"
#include "bench.h"
#include <sched.h>

int
main()
{
	int	p1[2], p2[2];
	int	i, N, pid;
	char	c;

     	if (pipe(p1) == -1 || pipe(p2) == -1) {
		perror("pipe");
		exit(1);
	}
	{struct sched_param sparams;
	sparams.sched_priority = sched_get_priority_max(SCHED_FIFO);
	if (sched_setscheduler(0, SCHED_FIFO, &sparams) < 0) {
	perror("sched_bench: ERROR - sched_setscheduler");
	exit(1);
	}
	}


	pid = fork();
	if (pid == -1) {
		perror("fork");
		exit(1);
	}
	if (pid > 0) {
		/*
		 * One time around to make sure both processes are started.
		 */
		if (write(p1[1], &c, 1) != 1 ||
		    read(p2[0], &c, 1) != 1 ||
		    write(p1[1], &c, 1) != 1) {
			perror("read/write on pipe");
			exit(1);
		}
		LOOP_FIRST(N, i, ENOUGH);
		if (read(p2[0], &c, 1) != 1 || write(p1[1], &c, 1) != 1) {
			perror("read/write on pipe");
			exit(1);
		}
		LOOP_LAST(N, i, ENOUGH);
		micro("Pipe latency", N);
		kill(pid, 15);
	} else {
		for ( ;; ) {
			if (read(p1[0], &c, 1) != 1 ||
			    write(p2[1], &c, 1) != 1) {
				perror("read/write on pipe");
				exit(1);
			}
		}
	}
	return (0);
}
